# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ParameterTemplateArgs', 'ParameterTemplate']

@pulumi.input_type
class ParameterTemplateArgs:
    def __init__(__self__, *,
                 template_name: pulumi.Input[str],
                 template_params: pulumi.Input[Sequence[pulumi.Input['ParameterTemplateTemplateParamArgs']]],
                 template_desc: Optional[pulumi.Input[str]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 template_type_version: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ParameterTemplate resource.
        :param pulumi.Input[str] template_name: Parameter template name.
        :param pulumi.Input[Sequence[pulumi.Input['ParameterTemplateTemplateParamArgs']]] template_params: Template parameters. InstanceParam only needs to pass Name and RunningValue.
        :param pulumi.Input[str] template_desc: Parameter template description.
        :param pulumi.Input[str] template_type: Parameter template database type, range of values:
               MySQL - MySQL database. (Defaults).
        :param pulumi.Input[str] template_type_version: Parameter template database version, value range:
               MySQL_Community_5_7 - MySQL 5.7 (default)
               MySQL_8_0 - MySQL 8.0.
        """
        pulumi.set(__self__, "template_name", template_name)
        pulumi.set(__self__, "template_params", template_params)
        if template_desc is not None:
            pulumi.set(__self__, "template_desc", template_desc)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if template_type_version is not None:
            pulumi.set(__self__, "template_type_version", template_type_version)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Input[str]:
        """
        Parameter template name.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="templateParams")
    def template_params(self) -> pulumi.Input[Sequence[pulumi.Input['ParameterTemplateTemplateParamArgs']]]:
        """
        Template parameters. InstanceParam only needs to pass Name and RunningValue.
        """
        return pulumi.get(self, "template_params")

    @template_params.setter
    def template_params(self, value: pulumi.Input[Sequence[pulumi.Input['ParameterTemplateTemplateParamArgs']]]):
        pulumi.set(self, "template_params", value)

    @property
    @pulumi.getter(name="templateDesc")
    def template_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter template description.
        """
        return pulumi.get(self, "template_desc")

    @template_desc.setter
    def template_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_desc", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter template database type, range of values:
        MySQL - MySQL database. (Defaults).
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="templateTypeVersion")
    def template_type_version(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter template database version, value range:
        MySQL_Community_5_7 - MySQL 5.7 (default)
        MySQL_8_0 - MySQL 8.0.
        """
        return pulumi.get(self, "template_type_version")

    @template_type_version.setter
    def template_type_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type_version", value)


@pulumi.input_type
class _ParameterTemplateState:
    def __init__(__self__, *,
                 template_desc: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 template_params: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterTemplateTemplateParamArgs']]]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 template_type_version: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering ParameterTemplate resources.
        :param pulumi.Input[str] template_desc: Parameter template description.
        :param pulumi.Input[str] template_name: Parameter template name.
        :param pulumi.Input[Sequence[pulumi.Input['ParameterTemplateTemplateParamArgs']]] template_params: Template parameters. InstanceParam only needs to pass Name and RunningValue.
        :param pulumi.Input[str] template_type: Parameter template database type, range of values:
               MySQL - MySQL database. (Defaults).
        :param pulumi.Input[str] template_type_version: Parameter template database version, value range:
               MySQL_Community_5_7 - MySQL 5.7 (default)
               MySQL_8_0 - MySQL 8.0.
        """
        if template_desc is not None:
            pulumi.set(__self__, "template_desc", template_desc)
        if template_name is not None:
            pulumi.set(__self__, "template_name", template_name)
        if template_params is not None:
            pulumi.set(__self__, "template_params", template_params)
        if template_type is not None:
            pulumi.set(__self__, "template_type", template_type)
        if template_type_version is not None:
            pulumi.set(__self__, "template_type_version", template_type_version)

    @property
    @pulumi.getter(name="templateDesc")
    def template_desc(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter template description.
        """
        return pulumi.get(self, "template_desc")

    @template_desc.setter
    def template_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_desc", value)

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter template name.
        """
        return pulumi.get(self, "template_name")

    @template_name.setter
    def template_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_name", value)

    @property
    @pulumi.getter(name="templateParams")
    def template_params(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ParameterTemplateTemplateParamArgs']]]]:
        """
        Template parameters. InstanceParam only needs to pass Name and RunningValue.
        """
        return pulumi.get(self, "template_params")

    @template_params.setter
    def template_params(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ParameterTemplateTemplateParamArgs']]]]):
        pulumi.set(self, "template_params", value)

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter template database type, range of values:
        MySQL - MySQL database. (Defaults).
        """
        return pulumi.get(self, "template_type")

    @template_type.setter
    def template_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type", value)

    @property
    @pulumi.getter(name="templateTypeVersion")
    def template_type_version(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter template database version, value range:
        MySQL_Community_5_7 - MySQL 5.7 (default)
        MySQL_8_0 - MySQL 8.0.
        """
        return pulumi.get(self, "template_type_version")

    @template_type_version.setter
    def template_type_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "template_type_version", value)


class ParameterTemplate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 template_desc: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 template_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ParameterTemplateTemplateParamArgs']]]]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 template_type_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Provides a resource to manage rds parameter template
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.rds.ParameterTemplate("foo",
            template_desc="created by terraform",
            template_name="tf-template",
            template_params=[
                volcengine.rds.ParameterTemplateTemplateParamArgs(
                    name="auto_increment_increment",
                    running_value="2",
                ),
                volcengine.rds.ParameterTemplateTemplateParamArgs(
                    name="slow_query_log",
                    running_value="ON",
                ),
                volcengine.rds.ParameterTemplateTemplateParamArgs(
                    name="net_retry_count",
                    running_value="33",
                ),
            ],
            template_type="MySQL",
            template_type_version="MySQL_Community_5_7")
        ```

        ## Import

        RDS Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds/parameterTemplate:ParameterTemplate default mysql-sys-80bb93aa14be22d0
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] template_desc: Parameter template description.
        :param pulumi.Input[str] template_name: Parameter template name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ParameterTemplateTemplateParamArgs']]]] template_params: Template parameters. InstanceParam only needs to pass Name and RunningValue.
        :param pulumi.Input[str] template_type: Parameter template database type, range of values:
               MySQL - MySQL database. (Defaults).
        :param pulumi.Input[str] template_type_version: Parameter template database version, value range:
               MySQL_Community_5_7 - MySQL 5.7 (default)
               MySQL_8_0 - MySQL 8.0.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ParameterTemplateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Provides a resource to manage rds parameter template
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.rds.ParameterTemplate("foo",
            template_desc="created by terraform",
            template_name="tf-template",
            template_params=[
                volcengine.rds.ParameterTemplateTemplateParamArgs(
                    name="auto_increment_increment",
                    running_value="2",
                ),
                volcengine.rds.ParameterTemplateTemplateParamArgs(
                    name="slow_query_log",
                    running_value="ON",
                ),
                volcengine.rds.ParameterTemplateTemplateParamArgs(
                    name="net_retry_count",
                    running_value="33",
                ),
            ],
            template_type="MySQL",
            template_type_version="MySQL_Community_5_7")
        ```

        ## Import

        RDS Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds/parameterTemplate:ParameterTemplate default mysql-sys-80bb93aa14be22d0
        ```

        :param str resource_name: The name of the resource.
        :param ParameterTemplateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ParameterTemplateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 template_desc: Optional[pulumi.Input[str]] = None,
                 template_name: Optional[pulumi.Input[str]] = None,
                 template_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ParameterTemplateTemplateParamArgs']]]]] = None,
                 template_type: Optional[pulumi.Input[str]] = None,
                 template_type_version: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ParameterTemplateArgs.__new__(ParameterTemplateArgs)

            __props__.__dict__["template_desc"] = template_desc
            if template_name is None and not opts.urn:
                raise TypeError("Missing required property 'template_name'")
            __props__.__dict__["template_name"] = template_name
            if template_params is None and not opts.urn:
                raise TypeError("Missing required property 'template_params'")
            __props__.__dict__["template_params"] = template_params
            __props__.__dict__["template_type"] = template_type
            __props__.__dict__["template_type_version"] = template_type_version
        super(ParameterTemplate, __self__).__init__(
            'volcengine:rds/parameterTemplate:ParameterTemplate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            template_desc: Optional[pulumi.Input[str]] = None,
            template_name: Optional[pulumi.Input[str]] = None,
            template_params: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ParameterTemplateTemplateParamArgs']]]]] = None,
            template_type: Optional[pulumi.Input[str]] = None,
            template_type_version: Optional[pulumi.Input[str]] = None) -> 'ParameterTemplate':
        """
        Get an existing ParameterTemplate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] template_desc: Parameter template description.
        :param pulumi.Input[str] template_name: Parameter template name.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ParameterTemplateTemplateParamArgs']]]] template_params: Template parameters. InstanceParam only needs to pass Name and RunningValue.
        :param pulumi.Input[str] template_type: Parameter template database type, range of values:
               MySQL - MySQL database. (Defaults).
        :param pulumi.Input[str] template_type_version: Parameter template database version, value range:
               MySQL_Community_5_7 - MySQL 5.7 (default)
               MySQL_8_0 - MySQL 8.0.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ParameterTemplateState.__new__(_ParameterTemplateState)

        __props__.__dict__["template_desc"] = template_desc
        __props__.__dict__["template_name"] = template_name
        __props__.__dict__["template_params"] = template_params
        __props__.__dict__["template_type"] = template_type
        __props__.__dict__["template_type_version"] = template_type_version
        return ParameterTemplate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="templateDesc")
    def template_desc(self) -> pulumi.Output[Optional[str]]:
        """
        Parameter template description.
        """
        return pulumi.get(self, "template_desc")

    @property
    @pulumi.getter(name="templateName")
    def template_name(self) -> pulumi.Output[str]:
        """
        Parameter template name.
        """
        return pulumi.get(self, "template_name")

    @property
    @pulumi.getter(name="templateParams")
    def template_params(self) -> pulumi.Output[Sequence['outputs.ParameterTemplateTemplateParam']]:
        """
        Template parameters. InstanceParam only needs to pass Name and RunningValue.
        """
        return pulumi.get(self, "template_params")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> pulumi.Output[Optional[str]]:
        """
        Parameter template database type, range of values:
        MySQL - MySQL database. (Defaults).
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="templateTypeVersion")
    def template_type_version(self) -> pulumi.Output[Optional[str]]:
        """
        Parameter template database version, value range:
        MySQL_Community_5_7 - MySQL 5.7 (default)
        MySQL_8_0 - MySQL 8.0.
        """
        return pulumi.get(self, "template_type_version")

