# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ParameterTemplatesResult',
    'AwaitableParameterTemplatesResult',
    'parameter_templates',
    'parameter_templates_output',
]

@pulumi.output_type
class ParameterTemplatesResult:
    """
    A collection of values returned by ParameterTemplates.
    """
    def __init__(__self__, id=None, name_regex=None, output_file=None, rds_parameter_templates=None, template_category=None, template_source=None, template_type=None, template_type_version=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rds_parameter_templates and not isinstance(rds_parameter_templates, list):
            raise TypeError("Expected argument 'rds_parameter_templates' to be a list")
        pulumi.set(__self__, "rds_parameter_templates", rds_parameter_templates)
        if template_category and not isinstance(template_category, str):
            raise TypeError("Expected argument 'template_category' to be a str")
        pulumi.set(__self__, "template_category", template_category)
        if template_source and not isinstance(template_source, str):
            raise TypeError("Expected argument 'template_source' to be a str")
        pulumi.set(__self__, "template_source", template_source)
        if template_type and not isinstance(template_type, str):
            raise TypeError("Expected argument 'template_type' to be a str")
        pulumi.set(__self__, "template_type", template_type)
        if template_type_version and not isinstance(template_type_version, str):
            raise TypeError("Expected argument 'template_type_version' to be a str")
        pulumi.set(__self__, "template_type_version", template_type_version)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="rdsParameterTemplates")
    def rds_parameter_templates(self) -> Sequence['outputs.ParameterTemplatesRdsParameterTemplateResult']:
        """
        The collection of RDS parameter templates query.
        """
        return pulumi.get(self, "rds_parameter_templates")

    @property
    @pulumi.getter(name="templateCategory")
    def template_category(self) -> Optional[str]:
        return pulumi.get(self, "template_category")

    @property
    @pulumi.getter(name="templateSource")
    def template_source(self) -> Optional[str]:
        return pulumi.get(self, "template_source")

    @property
    @pulumi.getter(name="templateType")
    def template_type(self) -> Optional[str]:
        """
        Parameter template database type, range of values:
        MySQL - MySQL database.
        """
        return pulumi.get(self, "template_type")

    @property
    @pulumi.getter(name="templateTypeVersion")
    def template_type_version(self) -> Optional[str]:
        """
        Parameter template database version, value range:
        MySQL_Community_5_7 - MySQL 5.7
        MySQL_8_0 - MySQL 8.0.
        """
        return pulumi.get(self, "template_type_version")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of RDS parameter templates query.
        """
        return pulumi.get(self, "total_count")


class AwaitableParameterTemplatesResult(ParameterTemplatesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ParameterTemplatesResult(
            id=self.id,
            name_regex=self.name_regex,
            output_file=self.output_file,
            rds_parameter_templates=self.rds_parameter_templates,
            template_category=self.template_category,
            template_source=self.template_source,
            template_type=self.template_type,
            template_type_version=self.template_type_version,
            total_count=self.total_count)


def parameter_templates(name_regex: Optional[str] = None,
                        output_file: Optional[str] = None,
                        template_category: Optional[str] = None,
                        template_source: Optional[str] = None,
                        template_type: Optional[str] = None,
                        template_type_version: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableParameterTemplatesResult:
    """
    (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Use this data source to query detailed information of rds parameter templates
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.rds.parameter_templates()
    ```


    :param str name_regex: A Name Regex of RDS parameter template.
    :param str output_file: File name where to save data source results.
    :param str template_category: Parameter template type, range of values:
           DBEngine - Engine parameters.
    :param str template_source: Template source, value range:
           System - System
           User - the user.
    :param str template_type: Parameter template database type, range of values:
           MySQL - MySQL database.
    :param str template_type_version: Parameter template database version, value range:
           MySQL_Community_5_7 - MySQL 5.7
           MySQL_8_0 - MySQL 8.0.
    """
    __args__ = dict()
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['templateCategory'] = template_category
    __args__['templateSource'] = template_source
    __args__['templateType'] = template_type
    __args__['templateTypeVersion'] = template_type_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:rds/parameterTemplates:ParameterTemplates', __args__, opts=opts, typ=ParameterTemplatesResult).value

    return AwaitableParameterTemplatesResult(
        id=pulumi.get(__ret__, 'id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rds_parameter_templates=pulumi.get(__ret__, 'rds_parameter_templates'),
        template_category=pulumi.get(__ret__, 'template_category'),
        template_source=pulumi.get(__ret__, 'template_source'),
        template_type=pulumi.get(__ret__, 'template_type'),
        template_type_version=pulumi.get(__ret__, 'template_type_version'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(parameter_templates)
def parameter_templates_output(name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                               output_file: Optional[pulumi.Input[Optional[str]]] = None,
                               template_category: Optional[pulumi.Input[Optional[str]]] = None,
                               template_source: Optional[pulumi.Input[Optional[str]]] = None,
                               template_type: Optional[pulumi.Input[Optional[str]]] = None,
                               template_type_version: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ParameterTemplatesResult]:
    """
    (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Use this data source to query detailed information of rds parameter templates
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.rds.parameter_templates()
    ```


    :param str name_regex: A Name Regex of RDS parameter template.
    :param str output_file: File name where to save data source results.
    :param str template_category: Parameter template type, range of values:
           DBEngine - Engine parameters.
    :param str template_source: Template source, value range:
           System - System
           User - the user.
    :param str template_type: Parameter template database type, range of values:
           MySQL - MySQL database.
    :param str template_type_version: Parameter template database version, value range:
           MySQL_Community_5_7 - MySQL 5.7
           MySQL_8_0 - MySQL 8.0.
    """
    ...
