# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AllowlistArgs', 'Allowlist']

@pulumi.input_type
class AllowlistArgs:
    def __init__(__self__, *,
                 allow_list_name: pulumi.Input[str],
                 allow_lists: pulumi.Input[Sequence[pulumi.Input[str]]],
                 allow_list_desc: Optional[pulumi.Input[str]] = None,
                 allow_list_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Allowlist resource.
        :param pulumi.Input[str] allow_list_name: The name of the allow list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_lists: Enter an IP address or a range of IP addresses in CIDR format.
        :param pulumi.Input[str] allow_list_desc: The description of the allow list.
        :param pulumi.Input[str] allow_list_type: The type of IP address in the whitelist. Currently only IPv4 addresses are supported.
        """
        pulumi.set(__self__, "allow_list_name", allow_list_name)
        pulumi.set(__self__, "allow_lists", allow_lists)
        if allow_list_desc is not None:
            pulumi.set(__self__, "allow_list_desc", allow_list_desc)
        if allow_list_type is not None:
            pulumi.set(__self__, "allow_list_type", allow_list_type)

    @property
    @pulumi.getter(name="allowListName")
    def allow_list_name(self) -> pulumi.Input[str]:
        """
        The name of the allow list.
        """
        return pulumi.get(self, "allow_list_name")

    @allow_list_name.setter
    def allow_list_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "allow_list_name", value)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Enter an IP address or a range of IP addresses in CIDR format.
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "allow_lists", value)

    @property
    @pulumi.getter(name="allowListDesc")
    def allow_list_desc(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the allow list.
        """
        return pulumi.get(self, "allow_list_desc")

    @allow_list_desc.setter
    def allow_list_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_list_desc", value)

    @property
    @pulumi.getter(name="allowListType")
    def allow_list_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP address in the whitelist. Currently only IPv4 addresses are supported.
        """
        return pulumi.get(self, "allow_list_type")

    @allow_list_type.setter
    def allow_list_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_list_type", value)


@pulumi.input_type
class _AllowlistState:
    def __init__(__self__, *,
                 allow_list_desc: Optional[pulumi.Input[str]] = None,
                 allow_list_id: Optional[pulumi.Input[str]] = None,
                 allow_list_name: Optional[pulumi.Input[str]] = None,
                 allow_list_type: Optional[pulumi.Input[str]] = None,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Allowlist resources.
        :param pulumi.Input[str] allow_list_desc: The description of the allow list.
        :param pulumi.Input[str] allow_list_id: The id of the allow list.
        :param pulumi.Input[str] allow_list_name: The name of the allow list.
        :param pulumi.Input[str] allow_list_type: The type of IP address in the whitelist. Currently only IPv4 addresses are supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_lists: Enter an IP address or a range of IP addresses in CIDR format.
        """
        if allow_list_desc is not None:
            pulumi.set(__self__, "allow_list_desc", allow_list_desc)
        if allow_list_id is not None:
            pulumi.set(__self__, "allow_list_id", allow_list_id)
        if allow_list_name is not None:
            pulumi.set(__self__, "allow_list_name", allow_list_name)
        if allow_list_type is not None:
            pulumi.set(__self__, "allow_list_type", allow_list_type)
        if allow_lists is not None:
            pulumi.set(__self__, "allow_lists", allow_lists)

    @property
    @pulumi.getter(name="allowListDesc")
    def allow_list_desc(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the allow list.
        """
        return pulumi.get(self, "allow_list_desc")

    @allow_list_desc.setter
    def allow_list_desc(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_list_desc", value)

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the allow list.
        """
        return pulumi.get(self, "allow_list_id")

    @allow_list_id.setter
    def allow_list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_list_id", value)

    @property
    @pulumi.getter(name="allowListName")
    def allow_list_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the allow list.
        """
        return pulumi.get(self, "allow_list_name")

    @allow_list_name.setter
    def allow_list_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_list_name", value)

    @property
    @pulumi.getter(name="allowListType")
    def allow_list_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of IP address in the whitelist. Currently only IPv4 addresses are supported.
        """
        return pulumi.get(self, "allow_list_type")

    @allow_list_type.setter
    def allow_list_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_list_type", value)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Enter an IP address or a range of IP addresses in CIDR format.
        """
        return pulumi.get(self, "allow_lists")

    @allow_lists.setter
    def allow_lists(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_lists", value)


class Allowlist(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_list_desc: Optional[pulumi.Input[str]] = None,
                 allow_list_name: Optional[pulumi.Input[str]] = None,
                 allow_list_type: Optional[pulumi.Input[str]] = None,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage rds mysql allowlist
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.rds_mysql.Allowlist("foo",
            allow_lists=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ],
            allow_list_desc="acc-test",
            allow_list_name="acc-test-allowlist",
            allow_list_type="IPv4")
        ```

        ## Import

        RDS AllowList can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds_mysql/allowlist:Allowlist default acl-d1fd76693bd54e658912e7337d5b****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allow_list_desc: The description of the allow list.
        :param pulumi.Input[str] allow_list_name: The name of the allow list.
        :param pulumi.Input[str] allow_list_type: The type of IP address in the whitelist. Currently only IPv4 addresses are supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_lists: Enter an IP address or a range of IP addresses in CIDR format.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AllowlistArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage rds mysql allowlist
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.rds_mysql.Allowlist("foo",
            allow_lists=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ],
            allow_list_desc="acc-test",
            allow_list_name="acc-test-allowlist",
            allow_list_type="IPv4")
        ```

        ## Import

        RDS AllowList can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds_mysql/allowlist:Allowlist default acl-d1fd76693bd54e658912e7337d5b****
        ```

        :param str resource_name: The name of the resource.
        :param AllowlistArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AllowlistArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_list_desc: Optional[pulumi.Input[str]] = None,
                 allow_list_name: Optional[pulumi.Input[str]] = None,
                 allow_list_type: Optional[pulumi.Input[str]] = None,
                 allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AllowlistArgs.__new__(AllowlistArgs)

            __props__.__dict__["allow_list_desc"] = allow_list_desc
            if allow_list_name is None and not opts.urn:
                raise TypeError("Missing required property 'allow_list_name'")
            __props__.__dict__["allow_list_name"] = allow_list_name
            __props__.__dict__["allow_list_type"] = allow_list_type
            if allow_lists is None and not opts.urn:
                raise TypeError("Missing required property 'allow_lists'")
            __props__.__dict__["allow_lists"] = allow_lists
            __props__.__dict__["allow_list_id"] = None
        super(Allowlist, __self__).__init__(
            'volcengine:rds_mysql/allowlist:Allowlist',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_list_desc: Optional[pulumi.Input[str]] = None,
            allow_list_id: Optional[pulumi.Input[str]] = None,
            allow_list_name: Optional[pulumi.Input[str]] = None,
            allow_list_type: Optional[pulumi.Input[str]] = None,
            allow_lists: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Allowlist':
        """
        Get an existing Allowlist resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allow_list_desc: The description of the allow list.
        :param pulumi.Input[str] allow_list_id: The id of the allow list.
        :param pulumi.Input[str] allow_list_name: The name of the allow list.
        :param pulumi.Input[str] allow_list_type: The type of IP address in the whitelist. Currently only IPv4 addresses are supported.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_lists: Enter an IP address or a range of IP addresses in CIDR format.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AllowlistState.__new__(_AllowlistState)

        __props__.__dict__["allow_list_desc"] = allow_list_desc
        __props__.__dict__["allow_list_id"] = allow_list_id
        __props__.__dict__["allow_list_name"] = allow_list_name
        __props__.__dict__["allow_list_type"] = allow_list_type
        __props__.__dict__["allow_lists"] = allow_lists
        return Allowlist(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowListDesc")
    def allow_list_desc(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the allow list.
        """
        return pulumi.get(self, "allow_list_desc")

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> pulumi.Output[str]:
        """
        The id of the allow list.
        """
        return pulumi.get(self, "allow_list_id")

    @property
    @pulumi.getter(name="allowListName")
    def allow_list_name(self) -> pulumi.Output[str]:
        """
        The name of the allow list.
        """
        return pulumi.get(self, "allow_list_name")

    @property
    @pulumi.getter(name="allowListType")
    def allow_list_type(self) -> pulumi.Output[str]:
        """
        The type of IP address in the whitelist. Currently only IPv4 addresses are supported.
        """
        return pulumi.get(self, "allow_list_type")

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> pulumi.Output[Sequence[str]]:
        """
        Enter an IP address or a range of IP addresses in CIDR format.
        """
        return pulumi.get(self, "allow_lists")

