# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AllowlistAssociateArgs', 'AllowlistAssociate']

@pulumi.input_type
class AllowlistAssociateArgs:
    def __init__(__self__, *,
                 allow_list_id: pulumi.Input[str],
                 instance_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AllowlistAssociate resource.
        :param pulumi.Input[str] allow_list_id: The id of the allow list.
        :param pulumi.Input[str] instance_id: The id of the mysql instance.
        """
        pulumi.set(__self__, "allow_list_id", allow_list_id)
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> pulumi.Input[str]:
        """
        The id of the allow list.
        """
        return pulumi.get(self, "allow_list_id")

    @allow_list_id.setter
    def allow_list_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "allow_list_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        The id of the mysql instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _AllowlistAssociateState:
    def __init__(__self__, *,
                 allow_list_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AllowlistAssociate resources.
        :param pulumi.Input[str] allow_list_id: The id of the allow list.
        :param pulumi.Input[str] instance_id: The id of the mysql instance.
        """
        if allow_list_id is not None:
            pulumi.set(__self__, "allow_list_id", allow_list_id)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the allow list.
        """
        return pulumi.get(self, "allow_list_id")

    @allow_list_id.setter
    def allow_list_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_list_id", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the mysql instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)


class AllowlistAssociate(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_list_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage rds mysql allowlist associate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.rds_mysql.Instance("fooInstance",
            instance_name="acc-test-rds-mysql",
            db_engine_version="MySQL_5_7",
            node_spec="rds.mysql.1c2g",
            primary_zone_id=foo_zones.zones[0].id,
            secondary_zone_id=foo_zones.zones[0].id,
            storage_space=80,
            subnet_id=foo_subnet.id,
            lower_case_table_names="1",
            charge_info=volcengine.rds_mysql.InstanceChargeInfoArgs(
                charge_type="PostPaid",
            ),
            parameters=[
                volcengine.rds_mysql.InstanceParameterArgs(
                    parameter_name="auto_increment_increment",
                    parameter_value="2",
                ),
                volcengine.rds_mysql.InstanceParameterArgs(
                    parameter_name="auto_increment_offset",
                    parameter_value="4",
                ),
            ])
        foo_allowlist = volcengine.rds_mysql.Allowlist("fooAllowlist",
            allow_list_name="acc-test-allowlist",
            allow_list_desc="acc-test",
            allow_list_type="IPv4",
            allow_lists=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ])
        foo_allowlist_associate = volcengine.rds_mysql.AllowlistAssociate("fooAllowlistAssociate",
            allow_list_id=foo_allowlist.id,
            instance_id=foo_instance.id)
        ```

        ## Import

        RDS AllowList Associate can be imported using the instance id and allow list id, e.g.

        ```sh
         $ pulumi import volcengine:rds_mysql/allowlistAssociate:AllowlistAssociate default rds-mysql-h441603c68aaa:acl-d1fd76693bd54e658912e7337d5b****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allow_list_id: The id of the allow list.
        :param pulumi.Input[str] instance_id: The id of the mysql instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AllowlistAssociateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage rds mysql allowlist associate
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.rds_mysql.Instance("fooInstance",
            instance_name="acc-test-rds-mysql",
            db_engine_version="MySQL_5_7",
            node_spec="rds.mysql.1c2g",
            primary_zone_id=foo_zones.zones[0].id,
            secondary_zone_id=foo_zones.zones[0].id,
            storage_space=80,
            subnet_id=foo_subnet.id,
            lower_case_table_names="1",
            charge_info=volcengine.rds_mysql.InstanceChargeInfoArgs(
                charge_type="PostPaid",
            ),
            parameters=[
                volcengine.rds_mysql.InstanceParameterArgs(
                    parameter_name="auto_increment_increment",
                    parameter_value="2",
                ),
                volcengine.rds_mysql.InstanceParameterArgs(
                    parameter_name="auto_increment_offset",
                    parameter_value="4",
                ),
            ])
        foo_allowlist = volcengine.rds_mysql.Allowlist("fooAllowlist",
            allow_list_name="acc-test-allowlist",
            allow_list_desc="acc-test",
            allow_list_type="IPv4",
            allow_lists=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ])
        foo_allowlist_associate = volcengine.rds_mysql.AllowlistAssociate("fooAllowlistAssociate",
            allow_list_id=foo_allowlist.id,
            instance_id=foo_instance.id)
        ```

        ## Import

        RDS AllowList Associate can be imported using the instance id and allow list id, e.g.

        ```sh
         $ pulumi import volcengine:rds_mysql/allowlistAssociate:AllowlistAssociate default rds-mysql-h441603c68aaa:acl-d1fd76693bd54e658912e7337d5b****
        ```

        :param str resource_name: The name of the resource.
        :param AllowlistAssociateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AllowlistAssociateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_list_id: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AllowlistAssociateArgs.__new__(AllowlistAssociateArgs)

            if allow_list_id is None and not opts.urn:
                raise TypeError("Missing required property 'allow_list_id'")
            __props__.__dict__["allow_list_id"] = allow_list_id
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
        super(AllowlistAssociate, __self__).__init__(
            'volcengine:rds_mysql/allowlistAssociate:AllowlistAssociate',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_list_id: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None) -> 'AllowlistAssociate':
        """
        Get an existing AllowlistAssociate resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] allow_list_id: The id of the allow list.
        :param pulumi.Input[str] instance_id: The id of the mysql instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AllowlistAssociateState.__new__(_AllowlistAssociateState)

        __props__.__dict__["allow_list_id"] = allow_list_id
        __props__.__dict__["instance_id"] = instance_id
        return AllowlistAssociate(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> pulumi.Output[str]:
        """
        The id of the allow list.
        """
        return pulumi.get(self, "allow_list_id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        The id of the mysql instance.
        """
        return pulumi.get(self, "instance_id")

