# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AllowlistsResult',
    'AwaitableAllowlistsResult',
    'allowlists',
    'allowlists_output',
]

@pulumi.output_type
class AllowlistsResult:
    """
    A collection of values returned by Allowlists.
    """
    def __init__(__self__, allow_lists=None, id=None, instance_id=None, output_file=None, region_id=None, total_count=None):
        if allow_lists and not isinstance(allow_lists, list):
            raise TypeError("Expected argument 'allow_lists' to be a list")
        pulumi.set(__self__, "allow_lists", allow_lists)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if region_id and not isinstance(region_id, str):
            raise TypeError("Expected argument 'region_id' to be a str")
        pulumi.set(__self__, "region_id", region_id)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="allowLists")
    def allow_lists(self) -> Sequence['outputs.AllowlistsAllowListResult']:
        """
        The list of allowed list.
        """
        return pulumi.get(self, "allow_lists")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The id of the instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Scaling Activity query.
        """
        return pulumi.get(self, "total_count")


class AwaitableAllowlistsResult(AllowlistsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return AllowlistsResult(
            allow_lists=self.allow_lists,
            id=self.id,
            instance_id=self.instance_id,
            output_file=self.output_file,
            region_id=self.region_id,
            total_count=self.total_count)


def allowlists(instance_id: Optional[str] = None,
               output_file: Optional[str] = None,
               region_id: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableAllowlistsResult:
    """
    Use this data source to query detailed information of rds mysql allowlists
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_allowlist = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_allowlist.append(volcengine.rds_mysql.Allowlist(f"fooAllowlist-{range['value']}",
            allow_list_name=f"acc-test-allowlist-{range['value']}",
            allow_list_desc="acc-test",
            allow_list_type="IPv4",
            allow_lists=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ]))
    foo_instance = volcengine.rds_mysql.Instance("fooInstance",
        instance_name="acc-test-rds-mysql",
        db_engine_version="MySQL_5_7",
        node_spec="rds.mysql.1c2g",
        primary_zone_id=foo_zones.zones[0].id,
        secondary_zone_id=foo_zones.zones[0].id,
        storage_space=80,
        subnet_id=foo_subnet.id,
        lower_case_table_names="1",
        charge_info=volcengine.rds_mysql.InstanceChargeInfoArgs(
            charge_type="PostPaid",
        ),
        parameters=[
            volcengine.rds_mysql.InstanceParameterArgs(
                parameter_name="auto_increment_increment",
                parameter_value="2",
            ),
            volcengine.rds_mysql.InstanceParameterArgs(
                parameter_name="auto_increment_offset",
                parameter_value="4",
            ),
        ],
        allow_list_ids=[__item.id for __item in foo_allowlist])
    foo_allowlists = volcengine.rds_mysql.allowlists_output(instance_id=foo_instance.id,
        region_id="cn-beijing")
    ```


    :param str instance_id: Instance ID. When an InstanceId is specified, the DescribeAllowLists interface will return the whitelist bound to the specified instance.
    :param str output_file: File name where to save data source results.
    :param str region_id: The region of the allow lists.
    """
    __args__ = dict()
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    __args__['regionId'] = region_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:rds_mysql/allowlists:Allowlists', __args__, opts=opts, typ=AllowlistsResult).value

    return AwaitableAllowlistsResult(
        allow_lists=pulumi.get(__ret__, 'allow_lists'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        region_id=pulumi.get(__ret__, 'region_id'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(allowlists)
def allowlists_output(instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                      output_file: Optional[pulumi.Input[Optional[str]]] = None,
                      region_id: Optional[pulumi.Input[str]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[AllowlistsResult]:
    """
    Use this data source to query detailed information of rds mysql allowlists
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_allowlist = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_allowlist.append(volcengine.rds_mysql.Allowlist(f"fooAllowlist-{range['value']}",
            allow_list_name=f"acc-test-allowlist-{range['value']}",
            allow_list_desc="acc-test",
            allow_list_type="IPv4",
            allow_lists=[
                "192.168.0.0/24",
                "192.168.1.0/24",
            ]))
    foo_instance = volcengine.rds_mysql.Instance("fooInstance",
        instance_name="acc-test-rds-mysql",
        db_engine_version="MySQL_5_7",
        node_spec="rds.mysql.1c2g",
        primary_zone_id=foo_zones.zones[0].id,
        secondary_zone_id=foo_zones.zones[0].id,
        storage_space=80,
        subnet_id=foo_subnet.id,
        lower_case_table_names="1",
        charge_info=volcengine.rds_mysql.InstanceChargeInfoArgs(
            charge_type="PostPaid",
        ),
        parameters=[
            volcengine.rds_mysql.InstanceParameterArgs(
                parameter_name="auto_increment_increment",
                parameter_value="2",
            ),
            volcengine.rds_mysql.InstanceParameterArgs(
                parameter_name="auto_increment_offset",
                parameter_value="4",
            ),
        ],
        allow_list_ids=[__item.id for __item in foo_allowlist])
    foo_allowlists = volcengine.rds_mysql.allowlists_output(instance_id=foo_instance.id,
        region_id="cn-beijing")
    ```


    :param str instance_id: Instance ID. When an InstanceId is specified, the DescribeAllowLists interface will return the whitelist bound to the specified instance.
    :param str output_file: File name where to save data source results.
    :param str region_id: The region of the allow lists.
    """
    ...
