# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 charge_info: pulumi.Input['InstanceChargeInfoArgs'],
                 db_engine_version: pulumi.Input[str],
                 node_spec: pulumi.Input[str],
                 primary_zone_id: pulumi.Input[str],
                 secondary_zone_id: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 allow_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 db_time_zone: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input['InstanceChargeInfoArgs'] charge_info: Payment methods.
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_5_7
               MySQL_8_0.
        :param pulumi.Input[str] node_spec: The specification of primary node and secondary node.
        :param pulumi.Input[str] primary_zone_id: The available zone of primary node.
        :param pulumi.Input[str] secondary_zone_id: The available zone of secondary node.
        :param pulumi.Input[str] subnet_id: Subnet ID of the RDS instance.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_list_ids: Allow list Ids of the RDS instance.
        :param pulumi.Input[str] db_time_zone: Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] instance_name: Instance name. Cannot start with a number or a dash
               Can only contain Chinese characters, letters, numbers, underscores and dashes
               The length is limited between 1 ~ 128.
        :param pulumi.Input[str] lower_case_table_names: Whether the table name is case sensitive, the default value is 1.
               Ranges:
               0: Table names are stored as fixed and table names are case-sensitive.
               1: Table names will be stored in lowercase and table names are not case sensitive.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: Parameter of the RDS instance. This field can only be added or modified. Deleting this field is invalid.
        :param pulumi.Input[int] storage_space: Instance storage space. Value range: [20, 3000], unit: GB, increments every 100GB. Default value: 100.
        """
        pulumi.set(__self__, "charge_info", charge_info)
        pulumi.set(__self__, "db_engine_version", db_engine_version)
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "primary_zone_id", primary_zone_id)
        pulumi.set(__self__, "secondary_zone_id", secondary_zone_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        if allow_list_ids is not None:
            pulumi.set(__self__, "allow_list_ids", allow_list_ids)
        if db_time_zone is not None:
            pulumi.set(__self__, "db_time_zone", db_time_zone)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if lower_case_table_names is not None:
            pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)

    @property
    @pulumi.getter(name="chargeInfo")
    def charge_info(self) -> pulumi.Input['InstanceChargeInfoArgs']:
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_info")

    @charge_info.setter
    def charge_info(self, value: pulumi.Input['InstanceChargeInfoArgs']):
        pulumi.set(self, "charge_info", value)

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> pulumi.Input[str]:
        """
        Instance type. Value:
        MySQL_5_7
        MySQL_8_0.
        """
        return pulumi.get(self, "db_engine_version")

    @db_engine_version.setter
    def db_engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_engine_version", value)

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> pulumi.Input[str]:
        """
        The specification of primary node and secondary node.
        """
        return pulumi.get(self, "node_spec")

    @node_spec.setter
    def node_spec(self, value: pulumi.Input[str]):
        pulumi.set(self, "node_spec", value)

    @property
    @pulumi.getter(name="primaryZoneId")
    def primary_zone_id(self) -> pulumi.Input[str]:
        """
        The available zone of primary node.
        """
        return pulumi.get(self, "primary_zone_id")

    @primary_zone_id.setter
    def primary_zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "primary_zone_id", value)

    @property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> pulumi.Input[str]:
        """
        The available zone of secondary node.
        """
        return pulumi.get(self, "secondary_zone_id")

    @secondary_zone_id.setter
    def secondary_zone_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "secondary_zone_id", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Subnet ID of the RDS instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="allowListIds")
    def allow_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allow list Ids of the RDS instance.
        """
        return pulumi.get(self, "allow_list_ids")

    @allow_list_ids.setter
    def allow_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_list_ids", value)

    @property
    @pulumi.getter(name="dbTimeZone")
    def db_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "db_time_zone")

    @db_time_zone.setter
    def db_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_time_zone", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance name. Cannot start with a number or a dash
        Can only contain Chinese characters, letters, numbers, underscores and dashes
        The length is limited between 1 ~ 128.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the table name is case sensitive, the default value is 1.
        Ranges:
        0: Table names are stored as fixed and table names are case-sensitive.
        1: Table names will be stored in lowercase and table names are not case sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @lower_case_table_names.setter
    def lower_case_table_names(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lower_case_table_names", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        Parameter of the RDS instance. This field can only be added or modified. Deleting this field is invalid.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Instance storage space. Value range: [20, 3000], unit: GB, increments every 100GB. Default value: 100.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 allow_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 allow_list_version: Optional[pulumi.Input[str]] = None,
                 backup_use: Optional[pulumi.Input[int]] = None,
                 charge_details: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceChargeDetailArgs']]]] = None,
                 charge_info: Optional[pulumi.Input['InstanceChargeInfoArgs']] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 data_sync_mode: Optional[pulumi.Input[str]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 db_time_zone: Optional[pulumi.Input[str]] = None,
                 endpoints: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_status: Optional[pulumi.Input[str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[str]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceWindowArgs']]]] = None,
                 memory: Optional[pulumi.Input[int]] = None,
                 node_number: Optional[pulumi.Input[int]] = None,
                 node_spec: Optional[pulumi.Input[str]] = None,
                 nodes: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]] = None,
                 primary_zone_id: Optional[pulumi.Input[str]] = None,
                 region_id: Optional[pulumi.Input[str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 storage_use: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None,
                 v_cpu: Optional[pulumi.Input[int]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_list_ids: Allow list Ids of the RDS instance.
        :param pulumi.Input[str] allow_list_version: The version of allow list.
        :param pulumi.Input[int] backup_use: The instance has used backup space. Unit: GB.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceChargeDetailArgs']]] charge_details: Payment methods.
        :param pulumi.Input['InstanceChargeInfoArgs'] charge_info: Payment methods.
        :param pulumi.Input[str] create_time: Node creation local time.
        :param pulumi.Input[str] data_sync_mode: Data synchronization mode.
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_5_7
               MySQL_8_0.
        :param pulumi.Input[str] db_time_zone: Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]] endpoints: The endpoint info of the RDS instance.
        :param pulumi.Input[str] instance_id: Instance ID.
        :param pulumi.Input[str] instance_name: Instance name. Cannot start with a number or a dash
               Can only contain Chinese characters, letters, numbers, underscores and dashes
               The length is limited between 1 ~ 128.
        :param pulumi.Input[str] instance_status: The status of the RDS instance.
        :param pulumi.Input[str] lower_case_table_names: Whether the table name is case sensitive, the default value is 1.
               Ranges:
               0: Table names are stored as fixed and table names are case-sensitive.
               1: Table names will be stored in lowercase and table names are not case sensitive.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceWindowArgs']]] maintenance_windows: Maintenance Window.
        :param pulumi.Input[int] memory: Memory size in GB.
        :param pulumi.Input[int] node_number: The number of nodes.
        :param pulumi.Input[str] node_spec: The specification of primary node and secondary node.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]] nodes: Instance node information.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]] parameters: Parameter of the RDS instance. This field can only be added or modified. Deleting this field is invalid.
        :param pulumi.Input[str] primary_zone_id: The available zone of primary node.
        :param pulumi.Input[str] region_id: The region of the RDS instance.
        :param pulumi.Input[str] secondary_zone_id: The available zone of secondary node.
        :param pulumi.Input[int] storage_space: Instance storage space. Value range: [20, 3000], unit: GB, increments every 100GB. Default value: 100.
        :param pulumi.Input[str] storage_type: Instance storage type.
        :param pulumi.Input[int] storage_use: The instance has used storage space. Unit: GB.
        :param pulumi.Input[str] subnet_id: Subnet ID of the RDS instance.
        :param pulumi.Input[str] time_zone: Time zone.
        :param pulumi.Input[str] update_time: The update time of the RDS instance.
        :param pulumi.Input[int] v_cpu: CPU size.
        :param pulumi.Input[str] vpc_id: The vpc ID of the RDS instance.
        :param pulumi.Input[str] zone_id: The available zone of the RDS instance.
        """
        if allow_list_ids is not None:
            pulumi.set(__self__, "allow_list_ids", allow_list_ids)
        if allow_list_version is not None:
            pulumi.set(__self__, "allow_list_version", allow_list_version)
        if backup_use is not None:
            pulumi.set(__self__, "backup_use", backup_use)
        if charge_details is not None:
            pulumi.set(__self__, "charge_details", charge_details)
        if charge_info is not None:
            pulumi.set(__self__, "charge_info", charge_info)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if data_sync_mode is not None:
            pulumi.set(__self__, "data_sync_mode", data_sync_mode)
        if db_engine_version is not None:
            pulumi.set(__self__, "db_engine_version", db_engine_version)
        if db_time_zone is not None:
            pulumi.set(__self__, "db_time_zone", db_time_zone)
        if endpoints is not None:
            pulumi.set(__self__, "endpoints", endpoints)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_status is not None:
            pulumi.set(__self__, "instance_status", instance_status)
        if lower_case_table_names is not None:
            pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if node_number is not None:
            pulumi.set(__self__, "node_number", node_number)
        if node_spec is not None:
            pulumi.set(__self__, "node_spec", node_spec)
        if nodes is not None:
            pulumi.set(__self__, "nodes", nodes)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if primary_zone_id is not None:
            pulumi.set(__self__, "primary_zone_id", primary_zone_id)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if secondary_zone_id is not None:
            pulumi.set(__self__, "secondary_zone_id", secondary_zone_id)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if storage_use is not None:
            pulumi.set(__self__, "storage_use", storage_use)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if v_cpu is not None:
            pulumi.set(__self__, "v_cpu", v_cpu)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="allowListIds")
    def allow_list_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Allow list Ids of the RDS instance.
        """
        return pulumi.get(self, "allow_list_ids")

    @allow_list_ids.setter
    def allow_list_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "allow_list_ids", value)

    @property
    @pulumi.getter(name="allowListVersion")
    def allow_list_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of allow list.
        """
        return pulumi.get(self, "allow_list_version")

    @allow_list_version.setter
    def allow_list_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "allow_list_version", value)

    @property
    @pulumi.getter(name="backupUse")
    def backup_use(self) -> Optional[pulumi.Input[int]]:
        """
        The instance has used backup space. Unit: GB.
        """
        return pulumi.get(self, "backup_use")

    @backup_use.setter
    def backup_use(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_use", value)

    @property
    @pulumi.getter(name="chargeDetails")
    def charge_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceChargeDetailArgs']]]]:
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_details")

    @charge_details.setter
    def charge_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceChargeDetailArgs']]]]):
        pulumi.set(self, "charge_details", value)

    @property
    @pulumi.getter(name="chargeInfo")
    def charge_info(self) -> Optional[pulumi.Input['InstanceChargeInfoArgs']]:
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_info")

    @charge_info.setter
    def charge_info(self, value: Optional[pulumi.Input['InstanceChargeInfoArgs']]):
        pulumi.set(self, "charge_info", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Node creation local time.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="dataSyncMode")
    def data_sync_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Data synchronization mode.
        """
        return pulumi.get(self, "data_sync_mode")

    @data_sync_mode.setter
    def data_sync_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "data_sync_mode", value)

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type. Value:
        MySQL_5_7
        MySQL_8_0.
        """
        return pulumi.get(self, "db_engine_version")

    @db_engine_version.setter
    def db_engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_engine_version", value)

    @property
    @pulumi.getter(name="dbTimeZone")
    def db_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "db_time_zone")

    @db_time_zone.setter
    def db_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_time_zone", value)

    @property
    @pulumi.getter
    def endpoints(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]:
        """
        The endpoint info of the RDS instance.
        """
        return pulumi.get(self, "endpoints")

    @endpoints.setter
    def endpoints(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceEndpointArgs']]]]):
        pulumi.set(self, "endpoints", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance name. Cannot start with a number or a dash
        Can only contain Chinese characters, letters, numbers, underscores and dashes
        The length is limited between 1 ~ 128.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the RDS instance.
        """
        return pulumi.get(self, "instance_status")

    @instance_status.setter
    def instance_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_status", value)

    @property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the table name is case sensitive, the default value is 1.
        Ranges:
        0: Table names are stored as fixed and table names are case-sensitive.
        1: Table names will be stored in lowercase and table names are not case sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @lower_case_table_names.setter
    def lower_case_table_names(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lower_case_table_names", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceWindowArgs']]]]:
        """
        Maintenance Window.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter
    def memory(self) -> Optional[pulumi.Input[int]]:
        """
        Memory size in GB.
        """
        return pulumi.get(self, "memory")

    @memory.setter
    def memory(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "memory", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> Optional[pulumi.Input[str]]:
        """
        The specification of primary node and secondary node.
        """
        return pulumi.get(self, "node_spec")

    @node_spec.setter
    def node_spec(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node_spec", value)

    @property
    @pulumi.getter
    def nodes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]:
        """
        Instance node information.
        """
        return pulumi.get(self, "nodes")

    @nodes.setter
    def nodes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceNodeArgs']]]]):
        pulumi.set(self, "nodes", value)

    @property
    @pulumi.getter
    def parameters(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]:
        """
        Parameter of the RDS instance. This field can only be added or modified. Deleting this field is invalid.
        """
        return pulumi.get(self, "parameters")

    @parameters.setter
    def parameters(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParameterArgs']]]]):
        pulumi.set(self, "parameters", value)

    @property
    @pulumi.getter(name="primaryZoneId")
    def primary_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The available zone of primary node.
        """
        return pulumi.get(self, "primary_zone_id")

    @primary_zone_id.setter
    def primary_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "primary_zone_id", value)

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region_id")

    @region_id.setter
    def region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "region_id", value)

    @property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The available zone of secondary node.
        """
        return pulumi.get(self, "secondary_zone_id")

    @secondary_zone_id.setter
    def secondary_zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secondary_zone_id", value)

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Instance storage space. Value range: [20, 3000], unit: GB, increments every 100GB. Default value: 100.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance storage type.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="storageUse")
    def storage_use(self) -> Optional[pulumi.Input[int]]:
        """
        The instance has used storage space. Unit: GB.
        """
        return pulumi.get(self, "storage_use")

    @storage_use.setter
    def storage_use(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_use", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet ID of the RDS instance.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Time zone.
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the RDS instance.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)

    @property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> Optional[pulumi.Input[int]]:
        """
        CPU size.
        """
        return pulumi.get(self, "v_cpu")

    @v_cpu.setter
    def v_cpu(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "v_cpu", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc ID of the RDS instance.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 charge_info: Optional[pulumi.Input[pulumi.InputType['InstanceChargeInfoArgs']]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 db_time_zone: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[str]] = None,
                 node_spec: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParameterArgs']]]]] = None,
                 primary_zone_id: Optional[pulumi.Input[str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage rds mysql instance
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-project1",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-subnet-test-2",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.rds_mysql.Instance("fooInstance",
            db_engine_version="MySQL_5_7",
            node_spec="rds.mysql.1c2g",
            primary_zone_id=foo_zones.zones[0].id,
            secondary_zone_id=foo_zones.zones[0].id,
            storage_space=80,
            subnet_id=foo_subnet.id,
            instance_name="acc-test",
            lower_case_table_names="1",
            charge_info=volcengine.rds_mysql.InstanceChargeInfoArgs(
                charge_type="PostPaid",
            ),
            parameters=[
                volcengine.rds_mysql.InstanceParameterArgs(
                    parameter_name="auto_increment_increment",
                    parameter_value="2",
                ),
                volcengine.rds_mysql.InstanceParameterArgs(
                    parameter_name="auto_increment_offset",
                    parameter_value="4",
                ),
            ])
        ```

        ## Import

        Rds Mysql Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds_mysql/instance:Instance default mysql-72da4258c2c7
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_list_ids: Allow list Ids of the RDS instance.
        :param pulumi.Input[pulumi.InputType['InstanceChargeInfoArgs']] charge_info: Payment methods.
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_5_7
               MySQL_8_0.
        :param pulumi.Input[str] db_time_zone: Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] instance_name: Instance name. Cannot start with a number or a dash
               Can only contain Chinese characters, letters, numbers, underscores and dashes
               The length is limited between 1 ~ 128.
        :param pulumi.Input[str] lower_case_table_names: Whether the table name is case sensitive, the default value is 1.
               Ranges:
               0: Table names are stored as fixed and table names are case-sensitive.
               1: Table names will be stored in lowercase and table names are not case sensitive.
        :param pulumi.Input[str] node_spec: The specification of primary node and secondary node.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParameterArgs']]]] parameters: Parameter of the RDS instance. This field can only be added or modified. Deleting this field is invalid.
        :param pulumi.Input[str] primary_zone_id: The available zone of primary node.
        :param pulumi.Input[str] secondary_zone_id: The available zone of secondary node.
        :param pulumi.Input[int] storage_space: Instance storage space. Value range: [20, 3000], unit: GB, increments every 100GB. Default value: 100.
        :param pulumi.Input[str] subnet_id: Subnet ID of the RDS instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage rds mysql instance
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-project1",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-subnet-test-2",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.rds_mysql.Instance("fooInstance",
            db_engine_version="MySQL_5_7",
            node_spec="rds.mysql.1c2g",
            primary_zone_id=foo_zones.zones[0].id,
            secondary_zone_id=foo_zones.zones[0].id,
            storage_space=80,
            subnet_id=foo_subnet.id,
            instance_name="acc-test",
            lower_case_table_names="1",
            charge_info=volcengine.rds_mysql.InstanceChargeInfoArgs(
                charge_type="PostPaid",
            ),
            parameters=[
                volcengine.rds_mysql.InstanceParameterArgs(
                    parameter_name="auto_increment_increment",
                    parameter_value="2",
                ),
                volcengine.rds_mysql.InstanceParameterArgs(
                    parameter_name="auto_increment_offset",
                    parameter_value="4",
                ),
            ])
        ```

        ## Import

        Rds Mysql Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds_mysql/instance:Instance default mysql-72da4258c2c7
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allow_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 charge_info: Optional[pulumi.Input[pulumi.InputType['InstanceChargeInfoArgs']]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 db_time_zone: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[str]] = None,
                 node_spec: Optional[pulumi.Input[str]] = None,
                 parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParameterArgs']]]]] = None,
                 primary_zone_id: Optional[pulumi.Input[str]] = None,
                 secondary_zone_id: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["allow_list_ids"] = allow_list_ids
            if charge_info is None and not opts.urn:
                raise TypeError("Missing required property 'charge_info'")
            __props__.__dict__["charge_info"] = charge_info
            if db_engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_engine_version'")
            __props__.__dict__["db_engine_version"] = db_engine_version
            __props__.__dict__["db_time_zone"] = db_time_zone
            __props__.__dict__["instance_name"] = instance_name
            __props__.__dict__["lower_case_table_names"] = lower_case_table_names
            if node_spec is None and not opts.urn:
                raise TypeError("Missing required property 'node_spec'")
            __props__.__dict__["node_spec"] = node_spec
            __props__.__dict__["parameters"] = parameters
            if primary_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'primary_zone_id'")
            __props__.__dict__["primary_zone_id"] = primary_zone_id
            if secondary_zone_id is None and not opts.urn:
                raise TypeError("Missing required property 'secondary_zone_id'")
            __props__.__dict__["secondary_zone_id"] = secondary_zone_id
            __props__.__dict__["storage_space"] = storage_space
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["allow_list_version"] = None
            __props__.__dict__["backup_use"] = None
            __props__.__dict__["charge_details"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["data_sync_mode"] = None
            __props__.__dict__["endpoints"] = None
            __props__.__dict__["instance_id"] = None
            __props__.__dict__["instance_status"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["memory"] = None
            __props__.__dict__["node_number"] = None
            __props__.__dict__["nodes"] = None
            __props__.__dict__["region_id"] = None
            __props__.__dict__["storage_type"] = None
            __props__.__dict__["storage_use"] = None
            __props__.__dict__["time_zone"] = None
            __props__.__dict__["update_time"] = None
            __props__.__dict__["v_cpu"] = None
            __props__.__dict__["vpc_id"] = None
            __props__.__dict__["zone_id"] = None
        super(Instance, __self__).__init__(
            'volcengine:rds_mysql/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_list_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            allow_list_version: Optional[pulumi.Input[str]] = None,
            backup_use: Optional[pulumi.Input[int]] = None,
            charge_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceChargeDetailArgs']]]]] = None,
            charge_info: Optional[pulumi.Input[pulumi.InputType['InstanceChargeInfoArgs']]] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            data_sync_mode: Optional[pulumi.Input[str]] = None,
            db_engine_version: Optional[pulumi.Input[str]] = None,
            db_time_zone: Optional[pulumi.Input[str]] = None,
            endpoints: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEndpointArgs']]]]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_status: Optional[pulumi.Input[str]] = None,
            lower_case_table_names: Optional[pulumi.Input[str]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceMaintenanceWindowArgs']]]]] = None,
            memory: Optional[pulumi.Input[int]] = None,
            node_number: Optional[pulumi.Input[int]] = None,
            node_spec: Optional[pulumi.Input[str]] = None,
            nodes: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNodeArgs']]]]] = None,
            parameters: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParameterArgs']]]]] = None,
            primary_zone_id: Optional[pulumi.Input[str]] = None,
            region_id: Optional[pulumi.Input[str]] = None,
            secondary_zone_id: Optional[pulumi.Input[str]] = None,
            storage_space: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            storage_use: Optional[pulumi.Input[int]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None,
            v_cpu: Optional[pulumi.Input[int]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] allow_list_ids: Allow list Ids of the RDS instance.
        :param pulumi.Input[str] allow_list_version: The version of allow list.
        :param pulumi.Input[int] backup_use: The instance has used backup space. Unit: GB.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceChargeDetailArgs']]]] charge_details: Payment methods.
        :param pulumi.Input[pulumi.InputType['InstanceChargeInfoArgs']] charge_info: Payment methods.
        :param pulumi.Input[str] create_time: Node creation local time.
        :param pulumi.Input[str] data_sync_mode: Data synchronization mode.
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_5_7
               MySQL_8_0.
        :param pulumi.Input[str] db_time_zone: Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceEndpointArgs']]]] endpoints: The endpoint info of the RDS instance.
        :param pulumi.Input[str] instance_id: Instance ID.
        :param pulumi.Input[str] instance_name: Instance name. Cannot start with a number or a dash
               Can only contain Chinese characters, letters, numbers, underscores and dashes
               The length is limited between 1 ~ 128.
        :param pulumi.Input[str] instance_status: The status of the RDS instance.
        :param pulumi.Input[str] lower_case_table_names: Whether the table name is case sensitive, the default value is 1.
               Ranges:
               0: Table names are stored as fixed and table names are case-sensitive.
               1: Table names will be stored in lowercase and table names are not case sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceMaintenanceWindowArgs']]]] maintenance_windows: Maintenance Window.
        :param pulumi.Input[int] memory: Memory size in GB.
        :param pulumi.Input[int] node_number: The number of nodes.
        :param pulumi.Input[str] node_spec: The specification of primary node and secondary node.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceNodeArgs']]]] nodes: Instance node information.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParameterArgs']]]] parameters: Parameter of the RDS instance. This field can only be added or modified. Deleting this field is invalid.
        :param pulumi.Input[str] primary_zone_id: The available zone of primary node.
        :param pulumi.Input[str] region_id: The region of the RDS instance.
        :param pulumi.Input[str] secondary_zone_id: The available zone of secondary node.
        :param pulumi.Input[int] storage_space: Instance storage space. Value range: [20, 3000], unit: GB, increments every 100GB. Default value: 100.
        :param pulumi.Input[str] storage_type: Instance storage type.
        :param pulumi.Input[int] storage_use: The instance has used storage space. Unit: GB.
        :param pulumi.Input[str] subnet_id: Subnet ID of the RDS instance.
        :param pulumi.Input[str] time_zone: Time zone.
        :param pulumi.Input[str] update_time: The update time of the RDS instance.
        :param pulumi.Input[int] v_cpu: CPU size.
        :param pulumi.Input[str] vpc_id: The vpc ID of the RDS instance.
        :param pulumi.Input[str] zone_id: The available zone of the RDS instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["allow_list_ids"] = allow_list_ids
        __props__.__dict__["allow_list_version"] = allow_list_version
        __props__.__dict__["backup_use"] = backup_use
        __props__.__dict__["charge_details"] = charge_details
        __props__.__dict__["charge_info"] = charge_info
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["data_sync_mode"] = data_sync_mode
        __props__.__dict__["db_engine_version"] = db_engine_version
        __props__.__dict__["db_time_zone"] = db_time_zone
        __props__.__dict__["endpoints"] = endpoints
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_status"] = instance_status
        __props__.__dict__["lower_case_table_names"] = lower_case_table_names
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["memory"] = memory
        __props__.__dict__["node_number"] = node_number
        __props__.__dict__["node_spec"] = node_spec
        __props__.__dict__["nodes"] = nodes
        __props__.__dict__["parameters"] = parameters
        __props__.__dict__["primary_zone_id"] = primary_zone_id
        __props__.__dict__["region_id"] = region_id
        __props__.__dict__["secondary_zone_id"] = secondary_zone_id
        __props__.__dict__["storage_space"] = storage_space
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["storage_use"] = storage_use
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["update_time"] = update_time
        __props__.__dict__["v_cpu"] = v_cpu
        __props__.__dict__["vpc_id"] = vpc_id
        __props__.__dict__["zone_id"] = zone_id
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowListIds")
    def allow_list_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        Allow list Ids of the RDS instance.
        """
        return pulumi.get(self, "allow_list_ids")

    @property
    @pulumi.getter(name="allowListVersion")
    def allow_list_version(self) -> pulumi.Output[str]:
        """
        The version of allow list.
        """
        return pulumi.get(self, "allow_list_version")

    @property
    @pulumi.getter(name="backupUse")
    def backup_use(self) -> pulumi.Output[int]:
        """
        The instance has used backup space. Unit: GB.
        """
        return pulumi.get(self, "backup_use")

    @property
    @pulumi.getter(name="chargeDetails")
    def charge_details(self) -> pulumi.Output[Sequence['outputs.InstanceChargeDetail']]:
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_details")

    @property
    @pulumi.getter(name="chargeInfo")
    def charge_info(self) -> pulumi.Output['outputs.InstanceChargeInfo']:
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_info")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        Node creation local time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataSyncMode")
    def data_sync_mode(self) -> pulumi.Output[str]:
        """
        Data synchronization mode.
        """
        return pulumi.get(self, "data_sync_mode")

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> pulumi.Output[str]:
        """
        Instance type. Value:
        MySQL_5_7
        MySQL_8_0.
        """
        return pulumi.get(self, "db_engine_version")

    @property
    @pulumi.getter(name="dbTimeZone")
    def db_time_zone(self) -> pulumi.Output[str]:
        """
        Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "db_time_zone")

    @property
    @pulumi.getter
    def endpoints(self) -> pulumi.Output[Sequence['outputs.InstanceEndpoint']]:
        """
        The endpoint info of the RDS instance.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        Instance name. Cannot start with a number or a dash
        Can only contain Chinese characters, letters, numbers, underscores and dashes
        The length is limited between 1 ~ 128.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> pulumi.Output[str]:
        """
        The status of the RDS instance.
        """
        return pulumi.get(self, "instance_status")

    @property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> pulumi.Output[Optional[str]]:
        """
        Whether the table name is case sensitive, the default value is 1.
        Ranges:
        0: Table names are stored as fixed and table names are case-sensitive.
        1: Table names will be stored in lowercase and table names are not case sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.InstanceMaintenanceWindow']]:
        """
        Maintenance Window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter
    def memory(self) -> pulumi.Output[int]:
        """
        Memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Output[int]:
        """
        The number of nodes.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> pulumi.Output[str]:
        """
        The specification of primary node and secondary node.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter
    def nodes(self) -> pulumi.Output[Sequence['outputs.InstanceNode']]:
        """
        Instance node information.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter
    def parameters(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceParameter']]]:
        """
        Parameter of the RDS instance. This field can only be added or modified. Deleting this field is invalid.
        """
        return pulumi.get(self, "parameters")

    @property
    @pulumi.getter(name="primaryZoneId")
    def primary_zone_id(self) -> pulumi.Output[str]:
        """
        The available zone of primary node.
        """
        return pulumi.get(self, "primary_zone_id")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> pulumi.Output[str]:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="secondaryZoneId")
    def secondary_zone_id(self) -> pulumi.Output[str]:
        """
        The available zone of secondary node.
        """
        return pulumi.get(self, "secondary_zone_id")

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> pulumi.Output[Optional[int]]:
        """
        Instance storage space. Value range: [20, 3000], unit: GB, increments every 100GB. Default value: 100.
        """
        return pulumi.get(self, "storage_space")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        Instance storage type.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="storageUse")
    def storage_use(self) -> pulumi.Output[int]:
        """
        The instance has used storage space. Unit: GB.
        """
        return pulumi.get(self, "storage_use")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Subnet ID of the RDS instance.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        Time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of the RDS instance.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> pulumi.Output[int]:
        """
        CPU size.
        """
        return pulumi.get(self, "v_cpu")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc ID of the RDS instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone_id")

