# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AccountAccountPrivilege',
    'AccountsAccountResult',
    'AccountsAccountAccountPrivilegeResult',
    'AllowlistsAllowListResult',
    'AllowlistsAllowListAssociatedInstanceResult',
    'DatabasesDatabaseResult',
    'DatabasesDatabaseDatabasePrivilegeResult',
    'InstanceChargeDetail',
    'InstanceChargeInfo',
    'InstanceEndpoint',
    'InstanceEndpointAddress',
    'InstanceEndpointNodeWeight',
    'InstanceMaintenanceWindow',
    'InstanceNode',
    'InstanceParameter',
    'InstancesRdsMysqlInstanceResult',
    'InstancesRdsMysqlInstanceChargeDetailResult',
    'InstancesRdsMysqlInstanceEndpointResult',
    'InstancesRdsMysqlInstanceEndpointAddressResult',
    'InstancesRdsMysqlInstanceEndpointNodeWeightResult',
    'InstancesRdsMysqlInstanceMaintenanceWindowResult',
    'InstancesRdsMysqlInstanceNodeResult',
]

@pulumi.output_type
class AccountAccountPrivilege(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "accountPrivilege":
            suggest = "account_privilege"
        elif key == "dbName":
            suggest = "db_name"
        elif key == "accountPrivilegeDetail":
            suggest = "account_privilege_detail"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AccountAccountPrivilege. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AccountAccountPrivilege.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AccountAccountPrivilege.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 account_privilege: str,
                 db_name: str,
                 account_privilege_detail: Optional[str] = None):
        """
        :param str account_privilege: The privilege type of the account.
        :param str db_name: The name of database.
        :param str account_privilege_detail: The privilege detail of the account.
        """
        pulumi.set(__self__, "account_privilege", account_privilege)
        pulumi.set(__self__, "db_name", db_name)
        if account_privilege_detail is not None:
            pulumi.set(__self__, "account_privilege_detail", account_privilege_detail)

    @property
    @pulumi.getter(name="accountPrivilege")
    def account_privilege(self) -> str:
        """
        The privilege type of the account.
        """
        return pulumi.get(self, "account_privilege")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> str:
        """
        The name of database.
        """
        return pulumi.get(self, "db_name")

    @property
    @pulumi.getter(name="accountPrivilegeDetail")
    def account_privilege_detail(self) -> Optional[str]:
        """
        The privilege detail of the account.
        """
        return pulumi.get(self, "account_privilege_detail")


@pulumi.output_type
class AccountsAccountResult(dict):
    def __init__(__self__, *,
                 account_name: str,
                 account_privileges: Sequence['outputs.AccountsAccountAccountPrivilegeResult'],
                 account_status: str,
                 account_type: str):
        """
        :param str account_name: The name of the database account. This field supports fuzzy query.
        :param Sequence['AccountsAccountAccountPrivilegeArgs'] account_privileges: The privilege detail list of RDS mysql instance account.
        :param str account_status: The status of the database account.
        :param str account_type: The type of the database account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_privileges", account_privileges)
        pulumi.set(__self__, "account_status", account_status)
        pulumi.set(__self__, "account_type", account_type)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The name of the database account. This field supports fuzzy query.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountPrivileges")
    def account_privileges(self) -> Sequence['outputs.AccountsAccountAccountPrivilegeResult']:
        """
        The privilege detail list of RDS mysql instance account.
        """
        return pulumi.get(self, "account_privileges")

    @property
    @pulumi.getter(name="accountStatus")
    def account_status(self) -> str:
        """
        The status of the database account.
        """
        return pulumi.get(self, "account_status")

    @property
    @pulumi.getter(name="accountType")
    def account_type(self) -> str:
        """
        The type of the database account.
        """
        return pulumi.get(self, "account_type")


@pulumi.output_type
class AccountsAccountAccountPrivilegeResult(dict):
    def __init__(__self__, *,
                 account_privilege: str,
                 account_privilege_detail: str,
                 db_name: str):
        """
        :param str account_privilege: The privilege type of the account.
        :param str account_privilege_detail: The privilege detail of the account.
        :param str db_name: The name of database.
        """
        pulumi.set(__self__, "account_privilege", account_privilege)
        pulumi.set(__self__, "account_privilege_detail", account_privilege_detail)
        pulumi.set(__self__, "db_name", db_name)

    @property
    @pulumi.getter(name="accountPrivilege")
    def account_privilege(self) -> str:
        """
        The privilege type of the account.
        """
        return pulumi.get(self, "account_privilege")

    @property
    @pulumi.getter(name="accountPrivilegeDetail")
    def account_privilege_detail(self) -> str:
        """
        The privilege detail of the account.
        """
        return pulumi.get(self, "account_privilege_detail")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> str:
        """
        The name of database.
        """
        return pulumi.get(self, "db_name")


@pulumi.output_type
class AllowlistsAllowListResult(dict):
    def __init__(__self__, *,
                 allow_list_desc: str,
                 allow_list_id: str,
                 allow_list_ip_num: int,
                 allow_list_name: str,
                 allow_list_type: str,
                 associated_instance_num: int,
                 associated_instances: Sequence['outputs.AllowlistsAllowListAssociatedInstanceResult']):
        """
        :param str allow_list_desc: The description of the allow list.
        :param str allow_list_id: The id of the allow list.
        :param int allow_list_ip_num: The total number of IP addresses (or address ranges) in the whitelist.
        :param str allow_list_name: The name of the allow list.
        :param str allow_list_type: The type of the allow list.
        :param int associated_instance_num: The total number of instances bound under the whitelist.
        :param Sequence['AllowlistsAllowListAssociatedInstanceArgs'] associated_instances: The list of instances.
        """
        pulumi.set(__self__, "allow_list_desc", allow_list_desc)
        pulumi.set(__self__, "allow_list_id", allow_list_id)
        pulumi.set(__self__, "allow_list_ip_num", allow_list_ip_num)
        pulumi.set(__self__, "allow_list_name", allow_list_name)
        pulumi.set(__self__, "allow_list_type", allow_list_type)
        pulumi.set(__self__, "associated_instance_num", associated_instance_num)
        pulumi.set(__self__, "associated_instances", associated_instances)

    @property
    @pulumi.getter(name="allowListDesc")
    def allow_list_desc(self) -> str:
        """
        The description of the allow list.
        """
        return pulumi.get(self, "allow_list_desc")

    @property
    @pulumi.getter(name="allowListId")
    def allow_list_id(self) -> str:
        """
        The id of the allow list.
        """
        return pulumi.get(self, "allow_list_id")

    @property
    @pulumi.getter(name="allowListIpNum")
    def allow_list_ip_num(self) -> int:
        """
        The total number of IP addresses (or address ranges) in the whitelist.
        """
        return pulumi.get(self, "allow_list_ip_num")

    @property
    @pulumi.getter(name="allowListName")
    def allow_list_name(self) -> str:
        """
        The name of the allow list.
        """
        return pulumi.get(self, "allow_list_name")

    @property
    @pulumi.getter(name="allowListType")
    def allow_list_type(self) -> str:
        """
        The type of the allow list.
        """
        return pulumi.get(self, "allow_list_type")

    @property
    @pulumi.getter(name="associatedInstanceNum")
    def associated_instance_num(self) -> int:
        """
        The total number of instances bound under the whitelist.
        """
        return pulumi.get(self, "associated_instance_num")

    @property
    @pulumi.getter(name="associatedInstances")
    def associated_instances(self) -> Sequence['outputs.AllowlistsAllowListAssociatedInstanceResult']:
        """
        The list of instances.
        """
        return pulumi.get(self, "associated_instances")


@pulumi.output_type
class AllowlistsAllowListAssociatedInstanceResult(dict):
    def __init__(__self__, *,
                 instance_id: str,
                 instance_name: str,
                 vpc: str):
        """
        :param str instance_id: Instance ID. When an InstanceId is specified, the DescribeAllowLists interface will return the whitelist bound to the specified instance.
        :param str instance_name: The name of the instance.
        :param str vpc: The id of the vpc.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "vpc", vpc)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Instance ID. When an InstanceId is specified, the DescribeAllowLists interface will return the whitelist bound to the specified instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def vpc(self) -> str:
        """
        The id of the vpc.
        """
        return pulumi.get(self, "vpc")


@pulumi.output_type
class DatabasesDatabaseResult(dict):
    def __init__(__self__, *,
                 character_set_name: str,
                 database_privileges: Sequence['outputs.DatabasesDatabaseDatabasePrivilegeResult'],
                 db_name: str):
        """
        :param str character_set_name: The character set of the RDS database.
        :param Sequence['DatabasesDatabaseDatabasePrivilegeArgs'] database_privileges: The privilege detail list of RDS mysql instance database.
        :param str db_name: The name of the RDS database.
        """
        pulumi.set(__self__, "character_set_name", character_set_name)
        pulumi.set(__self__, "database_privileges", database_privileges)
        pulumi.set(__self__, "db_name", db_name)

    @property
    @pulumi.getter(name="characterSetName")
    def character_set_name(self) -> str:
        """
        The character set of the RDS database.
        """
        return pulumi.get(self, "character_set_name")

    @property
    @pulumi.getter(name="databasePrivileges")
    def database_privileges(self) -> Sequence['outputs.DatabasesDatabaseDatabasePrivilegeResult']:
        """
        The privilege detail list of RDS mysql instance database.
        """
        return pulumi.get(self, "database_privileges")

    @property
    @pulumi.getter(name="dbName")
    def db_name(self) -> str:
        """
        The name of the RDS database.
        """
        return pulumi.get(self, "db_name")


@pulumi.output_type
class DatabasesDatabaseDatabasePrivilegeResult(dict):
    def __init__(__self__, *,
                 account_name: str,
                 account_privilege: str,
                 account_privilege_detail: str):
        """
        :param str account_name: The name of account.
        :param str account_privilege: The privilege type of the account.
        :param str account_privilege_detail: The privilege detail of the account.
        """
        pulumi.set(__self__, "account_name", account_name)
        pulumi.set(__self__, "account_privilege", account_privilege)
        pulumi.set(__self__, "account_privilege_detail", account_privilege_detail)

    @property
    @pulumi.getter(name="accountName")
    def account_name(self) -> str:
        """
        The name of account.
        """
        return pulumi.get(self, "account_name")

    @property
    @pulumi.getter(name="accountPrivilege")
    def account_privilege(self) -> str:
        """
        The privilege type of the account.
        """
        return pulumi.get(self, "account_privilege")

    @property
    @pulumi.getter(name="accountPrivilegeDetail")
    def account_privilege_detail(self) -> str:
        """
        The privilege detail of the account.
        """
        return pulumi.get(self, "account_privilege_detail")


@pulumi.output_type
class InstanceChargeDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoRenew":
            suggest = "auto_renew"
        elif key == "chargeEndTime":
            suggest = "charge_end_time"
        elif key == "chargeStartTime":
            suggest = "charge_start_time"
        elif key == "chargeStatus":
            suggest = "charge_status"
        elif key == "chargeType":
            suggest = "charge_type"
        elif key == "overdueReclaimTime":
            suggest = "overdue_reclaim_time"
        elif key == "overdueTime":
            suggest = "overdue_time"
        elif key == "periodUnit":
            suggest = "period_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceChargeDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceChargeDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceChargeDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_renew: Optional[bool] = None,
                 charge_end_time: Optional[str] = None,
                 charge_start_time: Optional[str] = None,
                 charge_status: Optional[str] = None,
                 charge_type: Optional[str] = None,
                 overdue_reclaim_time: Optional[str] = None,
                 overdue_time: Optional[str] = None,
                 period: Optional[int] = None,
                 period_unit: Optional[str] = None):
        """
        :param bool auto_renew: Whether to automatically renew in prepaid scenarios.
        :param str charge_end_time: Billing expiry time (yearly and monthly only).
        :param str charge_start_time: Billing start time (pay-as-you-go & monthly subscription).
        :param str charge_status: Pay status. Value:
               normal - normal
               overdue - overdue
               .
        :param str charge_type: Payment type. Value:
               PostPaid - Pay-As-You-Go
               PrePaid - Yearly and monthly (default).
        :param str overdue_reclaim_time: Estimated release time when arrears are closed (pay-as-you-go & monthly subscription).
        :param str overdue_time: Shutdown time in arrears (pay-as-you-go & monthly subscription).
        :param int period: Purchase duration in prepaid scenarios. Default: 1.
        :param str period_unit: The purchase cycle in the prepaid scenario.
               Month - monthly subscription (default)
               Year - Package year.
        """
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if charge_end_time is not None:
            pulumi.set(__self__, "charge_end_time", charge_end_time)
        if charge_start_time is not None:
            pulumi.set(__self__, "charge_start_time", charge_start_time)
        if charge_status is not None:
            pulumi.set(__self__, "charge_status", charge_status)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if overdue_reclaim_time is not None:
            pulumi.set(__self__, "overdue_reclaim_time", overdue_reclaim_time)
        if overdue_time is not None:
            pulumi.set(__self__, "overdue_time", overdue_time)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[bool]:
        """
        Whether to automatically renew in prepaid scenarios.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="chargeEndTime")
    def charge_end_time(self) -> Optional[str]:
        """
        Billing expiry time (yearly and monthly only).
        """
        return pulumi.get(self, "charge_end_time")

    @property
    @pulumi.getter(name="chargeStartTime")
    def charge_start_time(self) -> Optional[str]:
        """
        Billing start time (pay-as-you-go & monthly subscription).
        """
        return pulumi.get(self, "charge_start_time")

    @property
    @pulumi.getter(name="chargeStatus")
    def charge_status(self) -> Optional[str]:
        """
        Pay status. Value:
        normal - normal
        overdue - overdue
        .
        """
        return pulumi.get(self, "charge_status")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[str]:
        """
        Payment type. Value:
        PostPaid - Pay-As-You-Go
        PrePaid - Yearly and monthly (default).
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="overdueReclaimTime")
    def overdue_reclaim_time(self) -> Optional[str]:
        """
        Estimated release time when arrears are closed (pay-as-you-go & monthly subscription).
        """
        return pulumi.get(self, "overdue_reclaim_time")

    @property
    @pulumi.getter(name="overdueTime")
    def overdue_time(self) -> Optional[str]:
        """
        Shutdown time in arrears (pay-as-you-go & monthly subscription).
        """
        return pulumi.get(self, "overdue_time")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        Purchase duration in prepaid scenarios. Default: 1.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[str]:
        """
        The purchase cycle in the prepaid scenario.
        Month - monthly subscription (default)
        Year - Package year.
        """
        return pulumi.get(self, "period_unit")


@pulumi.output_type
class InstanceChargeInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chargeType":
            suggest = "charge_type"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "periodUnit":
            suggest = "period_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceChargeInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceChargeInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceChargeInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 charge_type: str,
                 auto_renew: Optional[bool] = None,
                 period: Optional[int] = None,
                 period_unit: Optional[str] = None):
        """
        :param str charge_type: Payment type. Value:
               PostPaid - Pay-As-You-Go
               PrePaid - Yearly and monthly (default).
        :param bool auto_renew: Whether to automatically renew in prepaid scenarios.
        :param int period: Purchase duration in prepaid scenarios. Default: 1.
        :param str period_unit: The purchase cycle in the prepaid scenario.
               Month - monthly subscription (default)
               Year - Package year.
        """
        pulumi.set(__self__, "charge_type", charge_type)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> str:
        """
        Payment type. Value:
        PostPaid - Pay-As-You-Go
        PrePaid - Yearly and monthly (default).
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[bool]:
        """
        Whether to automatically renew in prepaid scenarios.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        Purchase duration in prepaid scenarios. Default: 1.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[str]:
        """
        The purchase cycle in the prepaid scenario.
        Month - monthly subscription (default)
        Year - Package year.
        """
        return pulumi.get(self, "period_unit")


@pulumi.output_type
class InstanceEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoAddNewNodes":
            suggest = "auto_add_new_nodes"
        elif key == "enableReadOnly":
            suggest = "enable_read_only"
        elif key == "enableReadWriteSplitting":
            suggest = "enable_read_write_splitting"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "endpointName":
            suggest = "endpoint_name"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "nodeWeights":
            suggest = "node_weights"
        elif key == "readWriteMode":
            suggest = "read_write_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addresses: Optional[Sequence['outputs.InstanceEndpointAddress']] = None,
                 auto_add_new_nodes: Optional[str] = None,
                 description: Optional[str] = None,
                 enable_read_only: Optional[str] = None,
                 enable_read_write_splitting: Optional[str] = None,
                 endpoint_id: Optional[str] = None,
                 endpoint_name: Optional[str] = None,
                 endpoint_type: Optional[str] = None,
                 node_weights: Optional[Sequence['outputs.InstanceEndpointNodeWeight']] = None,
                 read_write_mode: Optional[str] = None):
        """
        :param Sequence['InstanceEndpointAddressArgs'] addresses: Address list.
        :param str auto_add_new_nodes: When the terminal type is read-write terminal or read-only terminal, it supports setting whether new nodes are automatically added.
        :param str description: Address description.
        :param str enable_read_only: Whether global read-only is enabled, value: Enable: Enable. Disable: Disabled.
        :param str enable_read_write_splitting: Whether read-write separation is enabled, value: Enable: Enable. Disable: Disabled.
        :param str endpoint_id: Instance connection terminal ID.
        :param str endpoint_name: The instance connection terminal name.
        :param str endpoint_type: Terminal type:
               Cluster: The default terminal. (created by default)
               Primary: Primary node terminal.
               Custom: Custom terminal.
               Direct: Direct connection to the terminal. (Only the operation and maintenance side)
               AllNode: All node terminals. (Only the operation and maintenance side).
        :param Sequence['InstanceEndpointNodeWeightArgs'] node_weights: The list of nodes configured by the connection terminal and the corresponding read-only weights.
        :param str read_write_mode: Read and write mode:
               ReadWrite: read and write
               ReadOnly: read only (default).
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if auto_add_new_nodes is not None:
            pulumi.set(__self__, "auto_add_new_nodes", auto_add_new_nodes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_read_only is not None:
            pulumi.set(__self__, "enable_read_only", enable_read_only)
        if enable_read_write_splitting is not None:
            pulumi.set(__self__, "enable_read_write_splitting", enable_read_write_splitting)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if node_weights is not None:
            pulumi.set(__self__, "node_weights", node_weights)
        if read_write_mode is not None:
            pulumi.set(__self__, "read_write_mode", read_write_mode)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence['outputs.InstanceEndpointAddress']]:
        """
        Address list.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="autoAddNewNodes")
    def auto_add_new_nodes(self) -> Optional[str]:
        """
        When the terminal type is read-write terminal or read-only terminal, it supports setting whether new nodes are automatically added.
        """
        return pulumi.get(self, "auto_add_new_nodes")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Address description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableReadOnly")
    def enable_read_only(self) -> Optional[str]:
        """
        Whether global read-only is enabled, value: Enable: Enable. Disable: Disabled.
        """
        return pulumi.get(self, "enable_read_only")

    @property
    @pulumi.getter(name="enableReadWriteSplitting")
    def enable_read_write_splitting(self) -> Optional[str]:
        """
        Whether read-write separation is enabled, value: Enable: Enable. Disable: Disabled.
        """
        return pulumi.get(self, "enable_read_write_splitting")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[str]:
        """
        Instance connection terminal ID.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[str]:
        """
        The instance connection terminal name.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[str]:
        """
        Terminal type:
        Cluster: The default terminal. (created by default)
        Primary: Primary node terminal.
        Custom: Custom terminal.
        Direct: Direct connection to the terminal. (Only the operation and maintenance side)
        AllNode: All node terminals. (Only the operation and maintenance side).
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="nodeWeights")
    def node_weights(self) -> Optional[Sequence['outputs.InstanceEndpointNodeWeight']]:
        """
        The list of nodes configured by the connection terminal and the corresponding read-only weights.
        """
        return pulumi.get(self, "node_weights")

    @property
    @pulumi.getter(name="readWriteMode")
    def read_write_mode(self) -> Optional[str]:
        """
        Read and write mode:
        ReadWrite: read and write
        ReadOnly: read only (default).
        """
        return pulumi.get(self, "read_write_mode")


@pulumi.output_type
class InstanceEndpointAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dnsVisibility":
            suggest = "dns_visibility"
        elif key == "eipId":
            suggest = "eip_id"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEndpointAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEndpointAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEndpointAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dns_visibility: Optional[bool] = None,
                 domain: Optional[str] = None,
                 eip_id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 network_type: Optional[str] = None,
                 port: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        :param bool dns_visibility: DNS Visibility.
        :param str domain: Connect domain name.
        :param str eip_id: The ID of the EIP, only valid for Public addresses.
        :param str ip_address: The IP Address.
        :param str network_type: Network address type, temporarily Private, Public, PublicService.
        :param str port: The Port.
        :param str subnet_id: Subnet ID of the RDS instance.
        """
        if dns_visibility is not None:
            pulumi.set(__self__, "dns_visibility", dns_visibility)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsVisibility")
    def dns_visibility(self) -> Optional[bool]:
        """
        DNS Visibility.
        """
        return pulumi.get(self, "dns_visibility")

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Connect domain name.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[str]:
        """
        The ID of the EIP, only valid for Public addresses.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[str]:
        """
        Network address type, temporarily Private, Public, PublicService.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The Port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Subnet ID of the RDS instance.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class InstanceEndpointNodeWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"
        elif key == "nodeType":
            suggest = "node_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceEndpointNodeWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceEndpointNodeWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceEndpointNodeWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_id: Optional[str] = None,
                 node_type: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        :param str node_id: Node ID.
        :param str node_type: Node type. Value: Primary: Primary node.
               Secondary: Standby node.
               ReadOnly: Read-only node.
        :param int weight: The weight of the node.
        """
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        """
        Node ID.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[str]:
        """
        Node type. Value: Primary: Primary node.
        Secondary: Standby node.
        ReadOnly: Read-only node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The weight of the node.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class InstanceMaintenanceWindow(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dayKind":
            suggest = "day_kind"
        elif key == "dayOfMonths":
            suggest = "day_of_months"
        elif key == "dayOfWeeks":
            suggest = "day_of_weeks"
        elif key == "maintenanceTime":
            suggest = "maintenance_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceMaintenanceWindow. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceMaintenanceWindow.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceMaintenanceWindow.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 day_kind: Optional[str] = None,
                 day_of_months: Optional[Sequence[int]] = None,
                 day_of_weeks: Optional[Sequence[str]] = None,
                 maintenance_time: Optional[str] = None):
        """
        :param str day_kind: DayKind of maintainable window. Value: Week. Month.
        :param Sequence[int] day_of_months: Days of maintainable window of the month.
        :param Sequence[str] day_of_weeks: Days of maintainable window of the week.
        :param str maintenance_time: The maintainable time of the RDS instance.
        """
        if day_kind is not None:
            pulumi.set(__self__, "day_kind", day_kind)
        if day_of_months is not None:
            pulumi.set(__self__, "day_of_months", day_of_months)
        if day_of_weeks is not None:
            pulumi.set(__self__, "day_of_weeks", day_of_weeks)
        if maintenance_time is not None:
            pulumi.set(__self__, "maintenance_time", maintenance_time)

    @property
    @pulumi.getter(name="dayKind")
    def day_kind(self) -> Optional[str]:
        """
        DayKind of maintainable window. Value: Week. Month.
        """
        return pulumi.get(self, "day_kind")

    @property
    @pulumi.getter(name="dayOfMonths")
    def day_of_months(self) -> Optional[Sequence[int]]:
        """
        Days of maintainable window of the month.
        """
        return pulumi.get(self, "day_of_months")

    @property
    @pulumi.getter(name="dayOfWeeks")
    def day_of_weeks(self) -> Optional[Sequence[str]]:
        """
        Days of maintainable window of the week.
        """
        return pulumi.get(self, "day_of_weeks")

    @property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> Optional[str]:
        """
        The maintainable time of the RDS instance.
        """
        return pulumi.get(self, "maintenance_time")


@pulumi.output_type
class InstanceNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createTime":
            suggest = "create_time"
        elif key == "instanceId":
            suggest = "instance_id"
        elif key == "nodeId":
            suggest = "node_id"
        elif key == "nodeSpec":
            suggest = "node_spec"
        elif key == "nodeStatus":
            suggest = "node_status"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "regionId":
            suggest = "region_id"
        elif key == "updateTime":
            suggest = "update_time"
        elif key == "vCpu":
            suggest = "v_cpu"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 create_time: Optional[str] = None,
                 instance_id: Optional[str] = None,
                 memory: Optional[int] = None,
                 node_id: Optional[str] = None,
                 node_spec: Optional[str] = None,
                 node_status: Optional[str] = None,
                 node_type: Optional[str] = None,
                 region_id: Optional[str] = None,
                 update_time: Optional[str] = None,
                 v_cpu: Optional[int] = None,
                 zone_id: Optional[str] = None):
        """
        :param str create_time: Node creation local time.
        :param str instance_id: Instance ID.
        :param int memory: Memory size in GB.
        :param str node_id: Node ID.
        :param str node_spec: The specification of primary node and secondary node.
        :param str node_status: Node state, value: aligned with instance state.
        :param str node_type: Node type. Value: Primary: Primary node.
               Secondary: Standby node.
               ReadOnly: Read-only node.
        :param str region_id: The region of the RDS instance.
        :param str update_time: The update time of the RDS instance.
        :param int v_cpu: CPU size.
        :param str zone_id: The available zone of the RDS instance.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if memory is not None:
            pulumi.set(__self__, "memory", memory)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_spec is not None:
            pulumi.set(__self__, "node_spec", node_spec)
        if node_status is not None:
            pulumi.set(__self__, "node_status", node_status)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if region_id is not None:
            pulumi.set(__self__, "region_id", region_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)
        if v_cpu is not None:
            pulumi.set(__self__, "v_cpu", v_cpu)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[str]:
        """
        Node creation local time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        Instance ID.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def memory(self) -> Optional[int]:
        """
        Memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        """
        Node ID.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> Optional[str]:
        """
        The specification of primary node and secondary node.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter(name="nodeStatus")
    def node_status(self) -> Optional[str]:
        """
        Node state, value: aligned with instance state.
        """
        return pulumi.get(self, "node_status")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[str]:
        """
        Node type. Value: Primary: Primary node.
        Secondary: Standby node.
        ReadOnly: Read-only node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> Optional[str]:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        The update time of the RDS instance.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> Optional[int]:
        """
        CPU size.
        """
        return pulumi.get(self, "v_cpu")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class InstanceParameter(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "parameterName":
            suggest = "parameter_name"
        elif key == "parameterValue":
            suggest = "parameter_value"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceParameter. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceParameter.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceParameter.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameter_name: str,
                 parameter_value: str):
        """
        :param str parameter_name: Parameter name.
        :param str parameter_value: Parameter value.
        """
        pulumi.set(__self__, "parameter_name", parameter_name)
        pulumi.set(__self__, "parameter_value", parameter_value)

    @property
    @pulumi.getter(name="parameterName")
    def parameter_name(self) -> str:
        """
        Parameter name.
        """
        return pulumi.get(self, "parameter_name")

    @property
    @pulumi.getter(name="parameterValue")
    def parameter_value(self) -> str:
        """
        Parameter value.
        """
        return pulumi.get(self, "parameter_value")


@pulumi.output_type
class InstancesRdsMysqlInstanceResult(dict):
    def __init__(__self__, *,
                 allow_list_version: str,
                 backup_use: int,
                 charge_detail: 'outputs.InstancesRdsMysqlInstanceChargeDetailResult',
                 create_time: str,
                 data_sync_mode: str,
                 db_engine_version: str,
                 endpoints: Sequence['outputs.InstancesRdsMysqlInstanceEndpointResult'],
                 id: str,
                 instance_id: str,
                 instance_name: str,
                 instance_status: str,
                 lower_case_table_names: str,
                 maintenance_windows: Sequence['outputs.InstancesRdsMysqlInstanceMaintenanceWindowResult'],
                 memory: int,
                 node_number: int,
                 node_spec: str,
                 nodes: Sequence['outputs.InstancesRdsMysqlInstanceNodeResult'],
                 region_id: str,
                 storage_space: int,
                 storage_type: str,
                 storage_use: int,
                 subnet_id: str,
                 time_zone: str,
                 update_time: str,
                 v_cpu: int,
                 vpc_id: str,
                 zone_id: str):
        """
        :param str allow_list_version: The version of allow list.
        :param int backup_use: The instance has used backup space. Unit: GB.
        :param 'InstancesRdsMysqlInstanceChargeDetailArgs' charge_detail: Payment methods.
        :param str create_time: Node creation local time.
        :param str data_sync_mode: Data synchronization mode.
        :param str db_engine_version: The version of the RDS instance.
        :param Sequence['InstancesRdsMysqlInstanceEndpointArgs'] endpoints: The endpoint info of the RDS instance.
        :param str id: The ID of the RDS instance.
        :param str instance_id: The id of the RDS instance.
        :param str instance_name: The name of the RDS instance.
        :param str instance_status: The status of the RDS instance.
        :param str lower_case_table_names: Whether the table name is case sensitive, the default value is 1.
               Ranges:
               0: Table names are stored as fixed and table names are case-sensitive.
               1: Table names will be stored in lowercase and table names are not case sensitive.
        :param Sequence['InstancesRdsMysqlInstanceMaintenanceWindowArgs'] maintenance_windows: Maintenance Window.
        :param int memory: Memory size in GB.
        :param int node_number: The number of nodes.
        :param str node_spec: General instance type, different from Custom instance type.
        :param Sequence['InstancesRdsMysqlInstanceNodeArgs'] nodes: Instance node information.
        :param str region_id: The region of the RDS instance.
        :param int storage_space: Total instance storage space. Unit: GB.
        :param str storage_type: Instance storage type.
        :param int storage_use: The instance has used storage space. Unit: GB.
        :param str subnet_id: The subnet ID of the RDS instance.
        :param str time_zone: Time zone.
        :param str update_time: The update time of the RDS instance.
        :param int v_cpu: CPU size.
        :param str vpc_id: The vpc ID of the RDS instance.
        :param str zone_id: The available zone of the RDS instance.
        """
        pulumi.set(__self__, "allow_list_version", allow_list_version)
        pulumi.set(__self__, "backup_use", backup_use)
        pulumi.set(__self__, "charge_detail", charge_detail)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "data_sync_mode", data_sync_mode)
        pulumi.set(__self__, "db_engine_version", db_engine_version)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_status", instance_status)
        pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)
        pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "nodes", nodes)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "storage_space", storage_space)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "storage_use", storage_use)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "v_cpu", v_cpu)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="allowListVersion")
    def allow_list_version(self) -> str:
        """
        The version of allow list.
        """
        return pulumi.get(self, "allow_list_version")

    @property
    @pulumi.getter(name="backupUse")
    def backup_use(self) -> int:
        """
        The instance has used backup space. Unit: GB.
        """
        return pulumi.get(self, "backup_use")

    @property
    @pulumi.getter(name="chargeDetail")
    def charge_detail(self) -> 'outputs.InstancesRdsMysqlInstanceChargeDetailResult':
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_detail")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Node creation local time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dataSyncMode")
    def data_sync_mode(self) -> str:
        """
        Data synchronization mode.
        """
        return pulumi.get(self, "data_sync_mode")

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> str:
        """
        The version of the RDS instance.
        """
        return pulumi.get(self, "db_engine_version")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.InstancesRdsMysqlInstanceEndpointResult']:
        """
        The endpoint info of the RDS instance.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The id of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the RDS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> str:
        """
        The status of the RDS instance.
        """
        return pulumi.get(self, "instance_status")

    @property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> str:
        """
        Whether the table name is case sensitive, the default value is 1.
        Ranges:
        0: Table names are stored as fixed and table names are case-sensitive.
        1: Table names will be stored in lowercase and table names are not case sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Sequence['outputs.InstancesRdsMysqlInstanceMaintenanceWindowResult']:
        """
        Maintenance Window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        Memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> int:
        """
        The number of nodes.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> str:
        """
        General instance type, different from Custom instance type.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.InstancesRdsMysqlInstanceNodeResult']:
        """
        Instance node information.
        """
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> int:
        """
        Total instance storage space. Unit: GB.
        """
        return pulumi.get(self, "storage_space")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        Instance storage type.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="storageUse")
    def storage_use(self) -> int:
        """
        The instance has used storage space. Unit: GB.
        """
        return pulumi.get(self, "storage_use")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet ID of the RDS instance.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time of the RDS instance.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> int:
        """
        CPU size.
        """
        return pulumi.get(self, "v_cpu")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The vpc ID of the RDS instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class InstancesRdsMysqlInstanceChargeDetailResult(dict):
    def __init__(__self__, *,
                 auto_renew: bool,
                 charge_end_time: str,
                 charge_start_time: str,
                 charge_status: str,
                 charge_type: str,
                 overdue_reclaim_time: str,
                 overdue_time: str,
                 period: int,
                 period_unit: str):
        """
        :param bool auto_renew: Whether to automatically renew in prepaid scenarios.
               Autorenew_Enable
               Autorenew_Disable (default).
        :param str charge_end_time: Billing expiry time (yearly and monthly only).
        :param str charge_start_time: Billing start time (pay-as-you-go & monthly subscription).
        :param str charge_status: Pay status. Value:
               normal - normal
               overdue - overdue
               .
        :param str charge_type: The charge type of the RDS instance.
        :param str overdue_reclaim_time: Estimated release time when arrears are closed (pay-as-you-go & monthly subscription).
        :param str overdue_time: Shutdown time in arrears (pay-as-you-go & monthly subscription).
        :param int period: Purchase duration in prepaid scenarios. Default: 1.
        :param str period_unit: The purchase cycle in the prepaid scenario.
               Month - monthly subscription (default)
               Year - Package year.
        """
        pulumi.set(__self__, "auto_renew", auto_renew)
        pulumi.set(__self__, "charge_end_time", charge_end_time)
        pulumi.set(__self__, "charge_start_time", charge_start_time)
        pulumi.set(__self__, "charge_status", charge_status)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "overdue_reclaim_time", overdue_reclaim_time)
        pulumi.set(__self__, "overdue_time", overdue_time)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "period_unit", period_unit)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> bool:
        """
        Whether to automatically renew in prepaid scenarios.
        Autorenew_Enable
        Autorenew_Disable (default).
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="chargeEndTime")
    def charge_end_time(self) -> str:
        """
        Billing expiry time (yearly and monthly only).
        """
        return pulumi.get(self, "charge_end_time")

    @property
    @pulumi.getter(name="chargeStartTime")
    def charge_start_time(self) -> str:
        """
        Billing start time (pay-as-you-go & monthly subscription).
        """
        return pulumi.get(self, "charge_start_time")

    @property
    @pulumi.getter(name="chargeStatus")
    def charge_status(self) -> str:
        """
        Pay status. Value:
        normal - normal
        overdue - overdue
        .
        """
        return pulumi.get(self, "charge_status")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> str:
        """
        The charge type of the RDS instance.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="overdueReclaimTime")
    def overdue_reclaim_time(self) -> str:
        """
        Estimated release time when arrears are closed (pay-as-you-go & monthly subscription).
        """
        return pulumi.get(self, "overdue_reclaim_time")

    @property
    @pulumi.getter(name="overdueTime")
    def overdue_time(self) -> str:
        """
        Shutdown time in arrears (pay-as-you-go & monthly subscription).
        """
        return pulumi.get(self, "overdue_time")

    @property
    @pulumi.getter
    def period(self) -> int:
        """
        Purchase duration in prepaid scenarios. Default: 1.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> str:
        """
        The purchase cycle in the prepaid scenario.
        Month - monthly subscription (default)
        Year - Package year.
        """
        return pulumi.get(self, "period_unit")


@pulumi.output_type
class InstancesRdsMysqlInstanceEndpointResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence['outputs.InstancesRdsMysqlInstanceEndpointAddressResult'],
                 auto_add_new_nodes: str,
                 description: str,
                 enable_read_only: str,
                 enable_read_write_splitting: str,
                 endpoint_id: str,
                 endpoint_name: str,
                 endpoint_type: str,
                 node_weights: Sequence['outputs.InstancesRdsMysqlInstanceEndpointNodeWeightResult'],
                 read_write_mode: str):
        """
        :param Sequence['InstancesRdsMysqlInstanceEndpointAddressArgs'] addresses: Address list.
        :param str auto_add_new_nodes: When the terminal type is read-write terminal or read-only terminal, it supports setting whether new nodes are automatically added.
        :param str description: Address description.
        :param str enable_read_only: Whether global read-only is enabled, value: Enable: Enable. Disable: Disabled.
        :param str enable_read_write_splitting: Whether read-write separation is enabled, value: Enable: Enable. Disable: Disabled.
        :param str endpoint_id: Instance connection terminal ID.
        :param str endpoint_name: The instance connection terminal name.
        :param str endpoint_type: Terminal type:
               Cluster: The default terminal. (created by default)
               Primary: Primary node terminal.
               Custom: Custom terminal.
               Direct: Direct connection to the terminal. (Only the operation and maintenance side)
               AllNode: All node terminals. (Only the operation and maintenance side).
        :param Sequence['InstancesRdsMysqlInstanceEndpointNodeWeightArgs'] node_weights: The list of nodes configured by the connection terminal and the corresponding read-only weights.
        :param str read_write_mode: Read and write mode:
               ReadWrite: read and write
               ReadOnly: read only (default).
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "auto_add_new_nodes", auto_add_new_nodes)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_read_only", enable_read_only)
        pulumi.set(__self__, "enable_read_write_splitting", enable_read_write_splitting)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "node_weights", node_weights)
        pulumi.set(__self__, "read_write_mode", read_write_mode)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.InstancesRdsMysqlInstanceEndpointAddressResult']:
        """
        Address list.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="autoAddNewNodes")
    def auto_add_new_nodes(self) -> str:
        """
        When the terminal type is read-write terminal or read-only terminal, it supports setting whether new nodes are automatically added.
        """
        return pulumi.get(self, "auto_add_new_nodes")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Address description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableReadOnly")
    def enable_read_only(self) -> str:
        """
        Whether global read-only is enabled, value: Enable: Enable. Disable: Disabled.
        """
        return pulumi.get(self, "enable_read_only")

    @property
    @pulumi.getter(name="enableReadWriteSplitting")
    def enable_read_write_splitting(self) -> str:
        """
        Whether read-write separation is enabled, value: Enable: Enable. Disable: Disabled.
        """
        return pulumi.get(self, "enable_read_write_splitting")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> str:
        """
        Instance connection terminal ID.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        The instance connection terminal name.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Terminal type:
        Cluster: The default terminal. (created by default)
        Primary: Primary node terminal.
        Custom: Custom terminal.
        Direct: Direct connection to the terminal. (Only the operation and maintenance side)
        AllNode: All node terminals. (Only the operation and maintenance side).
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="nodeWeights")
    def node_weights(self) -> Sequence['outputs.InstancesRdsMysqlInstanceEndpointNodeWeightResult']:
        """
        The list of nodes configured by the connection terminal and the corresponding read-only weights.
        """
        return pulumi.get(self, "node_weights")

    @property
    @pulumi.getter(name="readWriteMode")
    def read_write_mode(self) -> str:
        """
        Read and write mode:
        ReadWrite: read and write
        ReadOnly: read only (default).
        """
        return pulumi.get(self, "read_write_mode")


@pulumi.output_type
class InstancesRdsMysqlInstanceEndpointAddressResult(dict):
    def __init__(__self__, *,
                 dns_visibility: bool,
                 domain: str,
                 eip_id: str,
                 ip_address: str,
                 network_type: str,
                 port: str,
                 subnet_id: str):
        """
        :param bool dns_visibility: DNS Visibility.
        :param str domain: Connect domain name.
        :param str eip_id: The ID of the EIP, only valid for Public addresses.
        :param str ip_address: The IP Address.
        :param str network_type: Network address type, temporarily Private, Public, PublicService.
        :param str port: The Port.
        :param str subnet_id: The subnet ID of the RDS instance.
        """
        pulumi.set(__self__, "dns_visibility", dns_visibility)
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "eip_id", eip_id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter(name="dnsVisibility")
    def dns_visibility(self) -> bool:
        """
        DNS Visibility.
        """
        return pulumi.get(self, "dns_visibility")

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Connect domain name.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> str:
        """
        The ID of the EIP, only valid for Public addresses.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Network address type, temporarily Private, Public, PublicService.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        The Port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet ID of the RDS instance.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class InstancesRdsMysqlInstanceEndpointNodeWeightResult(dict):
    def __init__(__self__, *,
                 node_id: str,
                 node_type: str,
                 weight: int):
        """
        :param str node_id: Node ID.
        :param str node_type: Node type. Value: Primary: Primary node.
               Secondary: Standby node.
               ReadOnly: Read-only node.
        :param int weight: The weight of the node.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Node ID.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        Node type. Value: Primary: Primary node.
        Secondary: Standby node.
        ReadOnly: Read-only node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight of the node.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class InstancesRdsMysqlInstanceMaintenanceWindowResult(dict):
    def __init__(__self__, *,
                 day_kind: str,
                 day_of_months: Sequence[int],
                 day_of_weeks: Sequence[str],
                 maintenance_time: str):
        """
        :param str day_kind: DayKind of maintainable window. Value: Week. Month.
        :param Sequence[int] day_of_months: Days of maintainable window of the month.
        :param Sequence[str] day_of_weeks: Days of maintainable window of the week.
        :param str maintenance_time: The maintainable time of the RDS instance.
        """
        pulumi.set(__self__, "day_kind", day_kind)
        pulumi.set(__self__, "day_of_months", day_of_months)
        pulumi.set(__self__, "day_of_weeks", day_of_weeks)
        pulumi.set(__self__, "maintenance_time", maintenance_time)

    @property
    @pulumi.getter(name="dayKind")
    def day_kind(self) -> str:
        """
        DayKind of maintainable window. Value: Week. Month.
        """
        return pulumi.get(self, "day_kind")

    @property
    @pulumi.getter(name="dayOfMonths")
    def day_of_months(self) -> Sequence[int]:
        """
        Days of maintainable window of the month.
        """
        return pulumi.get(self, "day_of_months")

    @property
    @pulumi.getter(name="dayOfWeeks")
    def day_of_weeks(self) -> Sequence[str]:
        """
        Days of maintainable window of the week.
        """
        return pulumi.get(self, "day_of_weeks")

    @property
    @pulumi.getter(name="maintenanceTime")
    def maintenance_time(self) -> str:
        """
        The maintainable time of the RDS instance.
        """
        return pulumi.get(self, "maintenance_time")


@pulumi.output_type
class InstancesRdsMysqlInstanceNodeResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 instance_id: str,
                 memory: int,
                 node_id: str,
                 node_spec: str,
                 node_status: str,
                 node_type: str,
                 region_id: str,
                 update_time: str,
                 v_cpu: int,
                 zone_id: str):
        """
        :param str create_time: Node creation local time.
        :param str instance_id: The id of the RDS instance.
        :param int memory: Memory size in GB.
        :param str node_id: Node ID.
        :param str node_spec: General instance type, different from Custom instance type.
        :param str node_status: Node state, value: aligned with instance state.
        :param str node_type: Node type. Value: Primary: Primary node.
               Secondary: Standby node.
               ReadOnly: Read-only node.
        :param str region_id: The region of the RDS instance.
        :param str update_time: The update time of the RDS instance.
        :param int v_cpu: CPU size.
        :param str zone_id: The available zone of the RDS instance.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "node_status", node_status)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "v_cpu", v_cpu)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Node creation local time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The id of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        Memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Node ID.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> str:
        """
        General instance type, different from Custom instance type.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter(name="nodeStatus")
    def node_status(self) -> str:
        """
        Node state, value: aligned with instance state.
        """
        return pulumi.get(self, "node_status")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        Node type. Value: Primary: Primary node.
        Secondary: Standby node.
        ReadOnly: Read-only node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time of the RDS instance.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> int:
        """
        CPU size.
        """
        return pulumi.get(self, "v_cpu")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone_id")


