# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'RdsInstanceV2ChargeInfo',
    'RdsInstanceV2ConnectionInfo',
    'RdsInstanceV2ConnectionInfoAddress',
    'RdsInstanceV2ConnectionInfoReadOnlyNodeWeight',
    'RdsInstanceV2NodeInfo',
    'RdsInstancesV2RdsInstanceResult',
    'RdsInstancesV2RdsInstanceChargeDetailResult',
    'RdsInstancesV2RdsInstanceConnectionInfoResult',
    'RdsInstancesV2RdsInstanceConnectionInfoAddressResult',
    'RdsInstancesV2RdsInstanceConnectionInfoReadOnlyNodeWeightResult',
    'RdsInstancesV2RdsInstanceNodeDetailInfoResult',
]

@pulumi.output_type
class RdsInstanceV2ChargeInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "chargeType":
            suggest = "charge_type"
        elif key == "autoRenew":
            suggest = "auto_renew"
        elif key == "periodUnit":
            suggest = "period_unit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsInstanceV2ChargeInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsInstanceV2ChargeInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsInstanceV2ChargeInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 charge_type: str,
                 auto_renew: Optional[bool] = None,
                 period: Optional[int] = None,
                 period_unit: Optional[str] = None):
        """
        :param str charge_type: Payment type. Value:
               PostPaid - Pay-As-You-Go
               PrePaid - Yearly and monthly (default).
        :param bool auto_renew: Whether to automatically renew in prepaid scenarios.
        :param int period: Purchase duration in prepaid scenarios. Default: 1.
        :param str period_unit: The purchase cycle in the prepaid scenario.
               Month - monthly subscription (default)
               Year - Package year.
        """
        pulumi.set(__self__, "charge_type", charge_type)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if period_unit is not None:
            pulumi.set(__self__, "period_unit", period_unit)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> str:
        """
        Payment type. Value:
        PostPaid - Pay-As-You-Go
        PrePaid - Yearly and monthly (default).
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[bool]:
        """
        Whether to automatically renew in prepaid scenarios.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter
    def period(self) -> Optional[int]:
        """
        Purchase duration in prepaid scenarios. Default: 1.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> Optional[str]:
        """
        The purchase cycle in the prepaid scenario.
        Month - monthly subscription (default)
        Year - Package year.
        """
        return pulumi.get(self, "period_unit")


@pulumi.output_type
class RdsInstanceV2ConnectionInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoAddNewNodes":
            suggest = "auto_add_new_nodes"
        elif key == "enableReadOnly":
            suggest = "enable_read_only"
        elif key == "enableReadWriteSplitting":
            suggest = "enable_read_write_splitting"
        elif key == "endpointId":
            suggest = "endpoint_id"
        elif key == "endpointName":
            suggest = "endpoint_name"
        elif key == "endpointType":
            suggest = "endpoint_type"
        elif key == "readOnlyNodeWeights":
            suggest = "read_only_node_weights"
        elif key == "readWriteMode":
            suggest = "read_write_mode"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsInstanceV2ConnectionInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsInstanceV2ConnectionInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsInstanceV2ConnectionInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 addresses: Optional[Sequence['outputs.RdsInstanceV2ConnectionInfoAddress']] = None,
                 auto_add_new_nodes: Optional[str] = None,
                 description: Optional[str] = None,
                 enable_read_only: Optional[str] = None,
                 enable_read_write_splitting: Optional[str] = None,
                 endpoint_id: Optional[str] = None,
                 endpoint_name: Optional[str] = None,
                 endpoint_type: Optional[str] = None,
                 read_only_node_weights: Optional[Sequence['outputs.RdsInstanceV2ConnectionInfoReadOnlyNodeWeight']] = None,
                 read_write_mode: Optional[str] = None):
        """
        :param Sequence['RdsInstanceV2ConnectionInfoAddressArgs'] addresses: Address list.
        :param str auto_add_new_nodes: When the terminal type is read-write terminal or read-only terminal, it supports setting whether new nodes are automatically added.
        :param str description: Address description.
        :param str enable_read_only: Whether global read-only is enabled, value: Enable: Enable. Disable: Disabled.
        :param str enable_read_write_splitting: Whether read-write separation is enabled, value: Enable: Enable. Disable: Disabled.
        :param str endpoint_id: Instance connection terminal ID.
        :param str endpoint_name: The instance connection terminal name.
        :param str endpoint_type: Terminal type:
               Cluster: The default terminal. (created by default)
               Primary: Primary node terminal.
               Custom: Custom terminal.
               Direct: Direct connection to the terminal. (Only the operation and maintenance side)
               AllNode: All node terminals. (Only the operation and maintenance side).
        :param Sequence['RdsInstanceV2ConnectionInfoReadOnlyNodeWeightArgs'] read_only_node_weights: The list of nodes configured by the connection terminal and the corresponding read-only weights.
        :param str read_write_mode: Read and write mode:
               ReadWrite: read and write
               ReadOnly: read only (default).
        """
        if addresses is not None:
            pulumi.set(__self__, "addresses", addresses)
        if auto_add_new_nodes is not None:
            pulumi.set(__self__, "auto_add_new_nodes", auto_add_new_nodes)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if enable_read_only is not None:
            pulumi.set(__self__, "enable_read_only", enable_read_only)
        if enable_read_write_splitting is not None:
            pulumi.set(__self__, "enable_read_write_splitting", enable_read_write_splitting)
        if endpoint_id is not None:
            pulumi.set(__self__, "endpoint_id", endpoint_id)
        if endpoint_name is not None:
            pulumi.set(__self__, "endpoint_name", endpoint_name)
        if endpoint_type is not None:
            pulumi.set(__self__, "endpoint_type", endpoint_type)
        if read_only_node_weights is not None:
            pulumi.set(__self__, "read_only_node_weights", read_only_node_weights)
        if read_write_mode is not None:
            pulumi.set(__self__, "read_write_mode", read_write_mode)

    @property
    @pulumi.getter
    def addresses(self) -> Optional[Sequence['outputs.RdsInstanceV2ConnectionInfoAddress']]:
        """
        Address list.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="autoAddNewNodes")
    def auto_add_new_nodes(self) -> Optional[str]:
        """
        When the terminal type is read-write terminal or read-only terminal, it supports setting whether new nodes are automatically added.
        """
        return pulumi.get(self, "auto_add_new_nodes")

    @property
    @pulumi.getter
    def description(self) -> Optional[str]:
        """
        Address description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableReadOnly")
    def enable_read_only(self) -> Optional[str]:
        """
        Whether global read-only is enabled, value: Enable: Enable. Disable: Disabled.
        """
        return pulumi.get(self, "enable_read_only")

    @property
    @pulumi.getter(name="enableReadWriteSplitting")
    def enable_read_write_splitting(self) -> Optional[str]:
        """
        Whether read-write separation is enabled, value: Enable: Enable. Disable: Disabled.
        """
        return pulumi.get(self, "enable_read_write_splitting")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> Optional[str]:
        """
        Instance connection terminal ID.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> Optional[str]:
        """
        The instance connection terminal name.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> Optional[str]:
        """
        Terminal type:
        Cluster: The default terminal. (created by default)
        Primary: Primary node terminal.
        Custom: Custom terminal.
        Direct: Direct connection to the terminal. (Only the operation and maintenance side)
        AllNode: All node terminals. (Only the operation and maintenance side).
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="readOnlyNodeWeights")
    def read_only_node_weights(self) -> Optional[Sequence['outputs.RdsInstanceV2ConnectionInfoReadOnlyNodeWeight']]:
        """
        The list of nodes configured by the connection terminal and the corresponding read-only weights.
        """
        return pulumi.get(self, "read_only_node_weights")

    @property
    @pulumi.getter(name="readWriteMode")
    def read_write_mode(self) -> Optional[str]:
        """
        Read and write mode:
        ReadWrite: read and write
        ReadOnly: read only (default).
        """
        return pulumi.get(self, "read_write_mode")


@pulumi.output_type
class RdsInstanceV2ConnectionInfoAddress(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "eipId":
            suggest = "eip_id"
        elif key == "ipAddress":
            suggest = "ip_address"
        elif key == "networkType":
            suggest = "network_type"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsInstanceV2ConnectionInfoAddress. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsInstanceV2ConnectionInfoAddress.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsInstanceV2ConnectionInfoAddress.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 domain: Optional[str] = None,
                 eip_id: Optional[str] = None,
                 ip_address: Optional[str] = None,
                 network_type: Optional[str] = None,
                 port: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        :param str domain: Connect domain name.
        :param str eip_id: The ID of the EIP, only valid for Public addresses.
        :param str ip_address: The IP Address.
        :param str network_type: Network address type, temporarily Private, Public, PublicService.
        :param str port: The Port.
        :param str subnet_id: Subnet ID.
        """
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if eip_id is not None:
            pulumi.set(__self__, "eip_id", eip_id)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if network_type is not None:
            pulumi.set(__self__, "network_type", network_type)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def domain(self) -> Optional[str]:
        """
        Connect domain name.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> Optional[str]:
        """
        The ID of the EIP, only valid for Public addresses.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[str]:
        """
        The IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> Optional[str]:
        """
        Network address type, temporarily Private, Public, PublicService.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def port(self) -> Optional[str]:
        """
        The Port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        Subnet ID.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class RdsInstanceV2ConnectionInfoReadOnlyNodeWeight(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeId":
            suggest = "node_id"
        elif key == "nodeType":
            suggest = "node_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsInstanceV2ConnectionInfoReadOnlyNodeWeight. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsInstanceV2ConnectionInfoReadOnlyNodeWeight.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsInstanceV2ConnectionInfoReadOnlyNodeWeight.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_id: Optional[str] = None,
                 node_type: Optional[str] = None,
                 weight: Optional[int] = None):
        """
        :param str node_id: The ID of the node.
        :param str node_type: Node type, the value is "Primary", "Secondary", "ReadOnly".
        :param int weight: The weight of the node.
        """
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)
        if node_type is not None:
            pulumi.set(__self__, "node_type", node_type)
        if weight is not None:
            pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        """
        The ID of the node.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> Optional[str]:
        """
        Node type, the value is "Primary", "Secondary", "ReadOnly".
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def weight(self) -> Optional[int]:
        """
        The weight of the node.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class RdsInstanceV2NodeInfo(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeSpec":
            suggest = "node_spec"
        elif key == "nodeType":
            suggest = "node_type"
        elif key == "zoneId":
            suggest = "zone_id"
        elif key == "nodeId":
            suggest = "node_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RdsInstanceV2NodeInfo. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RdsInstanceV2NodeInfo.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RdsInstanceV2NodeInfo.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_spec: str,
                 node_type: str,
                 zone_id: str,
                 node_id: Optional[str] = None):
        """
        :param str node_spec: Masternode specs. Pass
               DescribeDBInstanceSpecs Query the instance specifications that can be sold.
        :param str node_type: Node type, the value is "Primary", "Secondary", "ReadOnly".
        :param str zone_id: Zone ID.
        :param str node_id: The ID of the node.
        """
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "zone_id", zone_id)
        if node_id is not None:
            pulumi.set(__self__, "node_id", node_id)

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> str:
        """
        Masternode specs. Pass
        DescribeDBInstanceSpecs Query the instance specifications that can be sold.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        Node type, the value is "Primary", "Secondary", "ReadOnly".
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        Zone ID.
        """
        return pulumi.get(self, "zone_id")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> Optional[str]:
        """
        The ID of the node.
        """
        return pulumi.get(self, "node_id")


@pulumi.output_type
class RdsInstancesV2RdsInstanceResult(dict):
    def __init__(__self__, *,
                 charge_detail: 'outputs.RdsInstancesV2RdsInstanceChargeDetailResult',
                 connection_infos: Sequence['outputs.RdsInstancesV2RdsInstanceConnectionInfoResult'],
                 create_time: str,
                 db_engine: str,
                 db_engine_version: str,
                 id: str,
                 instance_id: str,
                 instance_name: str,
                 instance_status: str,
                 instance_type: str,
                 node_detail_infos: Sequence['outputs.RdsInstancesV2RdsInstanceNodeDetailInfoResult'],
                 node_number: int,
                 node_spec: str,
                 port: str,
                 project_name: str,
                 region_id: str,
                 shard_number: int,
                 storage_space: int,
                 storage_type: str,
                 storage_use: int,
                 subnet_id: str,
                 time_zone: str,
                 vpc_id: str,
                 zone_id: str):
        """
        :param 'RdsInstancesV2RdsInstanceChargeDetailArgs' charge_detail: Payment methods.
        :param Sequence['RdsInstancesV2RdsInstanceConnectionInfoArgs'] connection_infos: The connection info ot the RDS instance.
        :param str create_time: Node creation local time.
        :param str db_engine: The engine of the RDS instance.
        :param str db_engine_version: The version of the RDS instance, Value:
               MySQL Community:
               MySQL_5.7 - MySQL 5.7
               MySQL_8_0 - MySQL 8.0
               PostgreSQL Community:
               PostgreSQL_11 - PostgreSQL 11
               PostgreSQL_12 - PostgreSQL 12
               Microsoft SQL Server: Not available at this time
               SQLServer_2019 - SQL Server 2019
               veDB for MySQL:
               MySQL_8_0 - MySQL 8.0
               veDB for PostgreSQL:
               PostgreSQL_13 - PostgreSQL 13.
        :param str id: The ID of the RDS instance.
        :param str instance_id: The id of the RDS instance.
        :param str instance_name: The name of the RDS instance.
        :param str instance_status: The status of the RDS instance, Value:
               Running - running
               Creating - Creating
               Deleting - Deleting
               Restarting - Restarting
               Restoring - Restoring
               Updating - changing
               Upgrading - Upgrading
               Error - the error.
        :param str instance_type: The type of the RDS instance, Value:
               Value:
               RDS for MySQL:
               HA - high availability version;
               RDS for PostgreSQL:
               HA - high availability version;
               Microsoft SQL Server: Not available at this time
               Enterprise - Enterprise Edition
               Standard - Standard Edition
               Web - Web version
               veDB for MySQL:
               Cluster - Cluster Edition
               veDB for PostgreSQL:
               Cluster - Cluster Edition
               MySQL Sharding:
               HA - high availability version;.
        :param Sequence['RdsInstancesV2RdsInstanceNodeDetailInfoArgs'] node_detail_infos: Instance node information.
        :param int node_number: The number of nodes.
        :param str node_spec: General instance type, different from Custom instance type.
        :param str port: Instance intranet port.
        :param str project_name: Subordinate to the project.
        :param str region_id: The region of the RDS instance.
        :param int shard_number: The number of shards.
        :param int storage_space: Total instance storage space. Unit: GB.
        :param str storage_type: Instance storage type. When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, the value is:
               LocalSSD - local SSD disk
               When the database type is veDB_MySQL/veDB_PostgreSQL, the value is:
               DistributedStorage - Distributed Storage.
        :param int storage_use: The instance has used storage space. Unit: GB.
        :param str subnet_id: The subnet ID of the RDS instance.
        :param str time_zone: Time zone.
        :param str vpc_id: The vpc ID of the RDS instance.
        :param str zone_id: The available zone of the RDS instance.
        """
        pulumi.set(__self__, "charge_detail", charge_detail)
        pulumi.set(__self__, "connection_infos", connection_infos)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "db_engine", db_engine)
        pulumi.set(__self__, "db_engine_version", db_engine_version)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "instance_status", instance_status)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "node_detail_infos", node_detail_infos)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "shard_number", shard_number)
        pulumi.set(__self__, "storage_space", storage_space)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "storage_use", storage_use)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "time_zone", time_zone)
        pulumi.set(__self__, "vpc_id", vpc_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="chargeDetail")
    def charge_detail(self) -> 'outputs.RdsInstancesV2RdsInstanceChargeDetailResult':
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_detail")

    @property
    @pulumi.getter(name="connectionInfos")
    def connection_infos(self) -> Sequence['outputs.RdsInstancesV2RdsInstanceConnectionInfoResult']:
        """
        The connection info ot the RDS instance.
        """
        return pulumi.get(self, "connection_infos")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Node creation local time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="dbEngine")
    def db_engine(self) -> str:
        """
        The engine of the RDS instance.
        """
        return pulumi.get(self, "db_engine")

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> str:
        """
        The version of the RDS instance, Value:
        MySQL Community:
        MySQL_5.7 - MySQL 5.7
        MySQL_8_0 - MySQL 8.0
        PostgreSQL Community:
        PostgreSQL_11 - PostgreSQL 11
        PostgreSQL_12 - PostgreSQL 12
        Microsoft SQL Server: Not available at this time
        SQLServer_2019 - SQL Server 2019
        veDB for MySQL:
        MySQL_8_0 - MySQL 8.0
        veDB for PostgreSQL:
        PostgreSQL_13 - PostgreSQL 13.
        """
        return pulumi.get(self, "db_engine_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the RDS instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The id of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of the RDS instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceStatus")
    def instance_status(self) -> str:
        """
        The status of the RDS instance, Value:
        Running - running
        Creating - Creating
        Deleting - Deleting
        Restarting - Restarting
        Restoring - Restoring
        Updating - changing
        Upgrading - Upgrading
        Error - the error.
        """
        return pulumi.get(self, "instance_status")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The type of the RDS instance, Value:
        Value:
        RDS for MySQL:
        HA - high availability version;
        RDS for PostgreSQL:
        HA - high availability version;
        Microsoft SQL Server: Not available at this time
        Enterprise - Enterprise Edition
        Standard - Standard Edition
        Web - Web version
        veDB for MySQL:
        Cluster - Cluster Edition
        veDB for PostgreSQL:
        Cluster - Cluster Edition
        MySQL Sharding:
        HA - high availability version;.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="nodeDetailInfos")
    def node_detail_infos(self) -> Sequence['outputs.RdsInstancesV2RdsInstanceNodeDetailInfoResult']:
        """
        Instance node information.
        """
        return pulumi.get(self, "node_detail_infos")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> int:
        """
        The number of nodes.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> str:
        """
        General instance type, different from Custom instance type.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        Instance intranet port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> str:
        """
        Subordinate to the project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="shardNumber")
    def shard_number(self) -> int:
        """
        The number of shards.
        """
        return pulumi.get(self, "shard_number")

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> int:
        """
        Total instance storage space. Unit: GB.
        """
        return pulumi.get(self, "storage_space")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        Instance storage type. When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, the value is:
        LocalSSD - local SSD disk
        When the database type is veDB_MySQL/veDB_PostgreSQL, the value is:
        DistributedStorage - Distributed Storage.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="storageUse")
    def storage_use(self) -> int:
        """
        The instance has used storage space. Unit: GB.
        """
        return pulumi.get(self, "storage_use")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet ID of the RDS instance.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> str:
        """
        Time zone.
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The vpc ID of the RDS instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class RdsInstancesV2RdsInstanceChargeDetailResult(dict):
    def __init__(__self__, *,
                 auto_renew: bool,
                 charge_end_time: str,
                 charge_start_time: str,
                 charge_status: str,
                 charge_type: str,
                 overdue_reclaim_time: str,
                 overdue_time: str,
                 period: int,
                 period_unit: str):
        """
        :param bool auto_renew: Whether to automatically renew in prepaid scenarios.
               Autorenew_Enable
               Autorenew_Disable (default).
        :param str charge_end_time: Billing expiry time (yearly and monthly only).
        :param str charge_start_time: Billing start time (pay-as-you-go & monthly subscription).
        :param str charge_status: Pay status. Value:
               normal - normal
               overdue - overdue
               .
        :param str charge_type: The charge type of the RDS instance.
        :param str overdue_reclaim_time: Estimated release time when arrears are closed (pay-as-you-go & monthly subscription).
        :param str overdue_time: Shutdown time in arrears (pay-as-you-go & monthly subscription).
        :param int period: Purchase duration in prepaid scenarios. Default: 1.
        :param str period_unit: The purchase cycle in the prepaid scenario.
               Month - monthly subscription (default)
               Year - Package year.
        """
        pulumi.set(__self__, "auto_renew", auto_renew)
        pulumi.set(__self__, "charge_end_time", charge_end_time)
        pulumi.set(__self__, "charge_start_time", charge_start_time)
        pulumi.set(__self__, "charge_status", charge_status)
        pulumi.set(__self__, "charge_type", charge_type)
        pulumi.set(__self__, "overdue_reclaim_time", overdue_reclaim_time)
        pulumi.set(__self__, "overdue_time", overdue_time)
        pulumi.set(__self__, "period", period)
        pulumi.set(__self__, "period_unit", period_unit)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> bool:
        """
        Whether to automatically renew in prepaid scenarios.
        Autorenew_Enable
        Autorenew_Disable (default).
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="chargeEndTime")
    def charge_end_time(self) -> str:
        """
        Billing expiry time (yearly and monthly only).
        """
        return pulumi.get(self, "charge_end_time")

    @property
    @pulumi.getter(name="chargeStartTime")
    def charge_start_time(self) -> str:
        """
        Billing start time (pay-as-you-go & monthly subscription).
        """
        return pulumi.get(self, "charge_start_time")

    @property
    @pulumi.getter(name="chargeStatus")
    def charge_status(self) -> str:
        """
        Pay status. Value:
        normal - normal
        overdue - overdue
        .
        """
        return pulumi.get(self, "charge_status")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> str:
        """
        The charge type of the RDS instance.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="overdueReclaimTime")
    def overdue_reclaim_time(self) -> str:
        """
        Estimated release time when arrears are closed (pay-as-you-go & monthly subscription).
        """
        return pulumi.get(self, "overdue_reclaim_time")

    @property
    @pulumi.getter(name="overdueTime")
    def overdue_time(self) -> str:
        """
        Shutdown time in arrears (pay-as-you-go & monthly subscription).
        """
        return pulumi.get(self, "overdue_time")

    @property
    @pulumi.getter
    def period(self) -> int:
        """
        Purchase duration in prepaid scenarios. Default: 1.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="periodUnit")
    def period_unit(self) -> str:
        """
        The purchase cycle in the prepaid scenario.
        Month - monthly subscription (default)
        Year - Package year.
        """
        return pulumi.get(self, "period_unit")


@pulumi.output_type
class RdsInstancesV2RdsInstanceConnectionInfoResult(dict):
    def __init__(__self__, *,
                 addresses: Sequence['outputs.RdsInstancesV2RdsInstanceConnectionInfoAddressResult'],
                 auto_add_new_nodes: str,
                 description: str,
                 enable_read_only: str,
                 enable_read_write_splitting: str,
                 endpoint_id: str,
                 endpoint_name: str,
                 endpoint_type: str,
                 read_only_node_weights: Sequence['outputs.RdsInstancesV2RdsInstanceConnectionInfoReadOnlyNodeWeightResult'],
                 read_write_mode: str):
        """
        :param Sequence['RdsInstancesV2RdsInstanceConnectionInfoAddressArgs'] addresses: Address list.
        :param str auto_add_new_nodes: When the terminal type is read-write terminal or read-only terminal, it supports setting whether new nodes are automatically added.
        :param str description: Address description.
        :param str enable_read_only: Whether global read-only is enabled, value: Enable: Enable. Disable: Disabled.
        :param str enable_read_write_splitting: Whether read-write separation is enabled, value: Enable: Enable. Disable: Disabled.
        :param str endpoint_id: Instance connection terminal ID.
        :param str endpoint_name: The instance connection terminal name.
        :param str endpoint_type: Terminal type:
               Cluster: The default terminal. (created by default)
               Primary: Primary node terminal.
               Custom: Custom terminal.
               Direct: Direct connection to the terminal. (Only the operation and maintenance side)
               AllNode: All node terminals. (Only the operation and maintenance side).
        :param Sequence['RdsInstancesV2RdsInstanceConnectionInfoReadOnlyNodeWeightArgs'] read_only_node_weights: The list of nodes configured by the connection terminal and the corresponding read-only weights.
        :param str read_write_mode: Read and write mode:
               ReadWrite: read and write
               ReadOnly: read only (default).
        """
        pulumi.set(__self__, "addresses", addresses)
        pulumi.set(__self__, "auto_add_new_nodes", auto_add_new_nodes)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_read_only", enable_read_only)
        pulumi.set(__self__, "enable_read_write_splitting", enable_read_write_splitting)
        pulumi.set(__self__, "endpoint_id", endpoint_id)
        pulumi.set(__self__, "endpoint_name", endpoint_name)
        pulumi.set(__self__, "endpoint_type", endpoint_type)
        pulumi.set(__self__, "read_only_node_weights", read_only_node_weights)
        pulumi.set(__self__, "read_write_mode", read_write_mode)

    @property
    @pulumi.getter
    def addresses(self) -> Sequence['outputs.RdsInstancesV2RdsInstanceConnectionInfoAddressResult']:
        """
        Address list.
        """
        return pulumi.get(self, "addresses")

    @property
    @pulumi.getter(name="autoAddNewNodes")
    def auto_add_new_nodes(self) -> str:
        """
        When the terminal type is read-write terminal or read-only terminal, it supports setting whether new nodes are automatically added.
        """
        return pulumi.get(self, "auto_add_new_nodes")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Address description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableReadOnly")
    def enable_read_only(self) -> str:
        """
        Whether global read-only is enabled, value: Enable: Enable. Disable: Disabled.
        """
        return pulumi.get(self, "enable_read_only")

    @property
    @pulumi.getter(name="enableReadWriteSplitting")
    def enable_read_write_splitting(self) -> str:
        """
        Whether read-write separation is enabled, value: Enable: Enable. Disable: Disabled.
        """
        return pulumi.get(self, "enable_read_write_splitting")

    @property
    @pulumi.getter(name="endpointId")
    def endpoint_id(self) -> str:
        """
        Instance connection terminal ID.
        """
        return pulumi.get(self, "endpoint_id")

    @property
    @pulumi.getter(name="endpointName")
    def endpoint_name(self) -> str:
        """
        The instance connection terminal name.
        """
        return pulumi.get(self, "endpoint_name")

    @property
    @pulumi.getter(name="endpointType")
    def endpoint_type(self) -> str:
        """
        Terminal type:
        Cluster: The default terminal. (created by default)
        Primary: Primary node terminal.
        Custom: Custom terminal.
        Direct: Direct connection to the terminal. (Only the operation and maintenance side)
        AllNode: All node terminals. (Only the operation and maintenance side).
        """
        return pulumi.get(self, "endpoint_type")

    @property
    @pulumi.getter(name="readOnlyNodeWeights")
    def read_only_node_weights(self) -> Sequence['outputs.RdsInstancesV2RdsInstanceConnectionInfoReadOnlyNodeWeightResult']:
        """
        The list of nodes configured by the connection terminal and the corresponding read-only weights.
        """
        return pulumi.get(self, "read_only_node_weights")

    @property
    @pulumi.getter(name="readWriteMode")
    def read_write_mode(self) -> str:
        """
        Read and write mode:
        ReadWrite: read and write
        ReadOnly: read only (default).
        """
        return pulumi.get(self, "read_write_mode")


@pulumi.output_type
class RdsInstancesV2RdsInstanceConnectionInfoAddressResult(dict):
    def __init__(__self__, *,
                 domain: str,
                 eip_id: str,
                 ip_address: str,
                 network_type: str,
                 port: str,
                 subnet_id: str):
        """
        :param str domain: Connect domain name.
        :param str eip_id: The ID of the EIP, only valid for Public addresses.
        :param str ip_address: The IP Address.
        :param str network_type: Network address type, temporarily Private, Public, PublicService.
        :param str port: Instance intranet port.
        :param str subnet_id: The subnet ID of the RDS instance.
        """
        pulumi.set(__self__, "domain", domain)
        pulumi.set(__self__, "eip_id", eip_id)
        pulumi.set(__self__, "ip_address", ip_address)
        pulumi.set(__self__, "network_type", network_type)
        pulumi.set(__self__, "port", port)
        pulumi.set(__self__, "subnet_id", subnet_id)

    @property
    @pulumi.getter
    def domain(self) -> str:
        """
        Connect domain name.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="eipId")
    def eip_id(self) -> str:
        """
        The ID of the EIP, only valid for Public addresses.
        """
        return pulumi.get(self, "eip_id")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> str:
        """
        The IP Address.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="networkType")
    def network_type(self) -> str:
        """
        Network address type, temporarily Private, Public, PublicService.
        """
        return pulumi.get(self, "network_type")

    @property
    @pulumi.getter
    def port(self) -> str:
        """
        Instance intranet port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The subnet ID of the RDS instance.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class RdsInstancesV2RdsInstanceConnectionInfoReadOnlyNodeWeightResult(dict):
    def __init__(__self__, *,
                 node_id: str,
                 node_type: str,
                 weight: int):
        """
        :param str node_id: Node ID.
        :param str node_type: Node type. Value: Primary: Primary node.
               Secondary: Standby node.
               ReadOnly: Read-only node.
        :param int weight: The weight of the node.
        """
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Node ID.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        Node type. Value: Primary: Primary node.
        Secondary: Standby node.
        ReadOnly: Read-only node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        The weight of the node.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class RdsInstancesV2RdsInstanceNodeDetailInfoResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 instance_id: str,
                 memory: int,
                 node_id: str,
                 node_spec: str,
                 node_status: str,
                 node_type: str,
                 region_id: str,
                 update_time: str,
                 v_cpu: int,
                 zone_id: str):
        """
        :param str create_time: Node creation local time.
        :param str instance_id: The id of the RDS instance.
        :param int memory: Memory size in GB.
        :param str node_id: Node ID.
        :param str node_spec: General instance type, different from Custom instance type.
        :param str node_status: Node state, value: aligned with instance state.
        :param str node_type: Node type. Value: Primary: Primary node.
               Secondary: Standby node.
               ReadOnly: Read-only node.
        :param str region_id: The region of the RDS instance.
        :param str update_time: Node updates local time.
        :param int v_cpu: CPU size. For example: 1 means 1U.
        :param str zone_id: The available zone of the RDS instance.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "node_id", node_id)
        pulumi.set(__self__, "node_spec", node_spec)
        pulumi.set(__self__, "node_status", node_status)
        pulumi.set(__self__, "node_type", node_type)
        pulumi.set(__self__, "region_id", region_id)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "v_cpu", v_cpu)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        Node creation local time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The id of the RDS instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        Memory size in GB.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        Node ID.
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeSpec")
    def node_spec(self) -> str:
        """
        General instance type, different from Custom instance type.
        """
        return pulumi.get(self, "node_spec")

    @property
    @pulumi.getter(name="nodeStatus")
    def node_status(self) -> str:
        """
        Node state, value: aligned with instance state.
        """
        return pulumi.get(self, "node_status")

    @property
    @pulumi.getter(name="nodeType")
    def node_type(self) -> str:
        """
        Node type. Value: Primary: Primary node.
        Secondary: Standby node.
        ReadOnly: Read-only node.
        """
        return pulumi.get(self, "node_type")

    @property
    @pulumi.getter(name="regionId")
    def region_id(self) -> str:
        """
        The region of the RDS instance.
        """
        return pulumi.get(self, "region_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        Node updates local time.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vCpu")
    def v_cpu(self) -> int:
        """
        CPU size. For example: 1 means 1U.
        """
        return pulumi.get(self, "v_cpu")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The available zone of the RDS instance.
        """
        return pulumi.get(self, "zone_id")


