# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RdsInstanceV2Args', 'RdsInstanceV2']

@pulumi.input_type
class RdsInstanceV2Args:
    def __init__(__self__, *,
                 charge_info: pulumi.Input['RdsInstanceV2ChargeInfoArgs'],
                 db_engine_version: pulumi.Input[str],
                 node_infos: pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2NodeInfoArgs']]],
                 storage_type: pulumi.Input[str],
                 subnet_id: pulumi.Input[str],
                 vpc_id: pulumi.Input[str],
                 db_param_group_id: Optional[pulumi.Input[str]] = None,
                 db_time_zone: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a RdsInstanceV2 resource.
        :param pulumi.Input['RdsInstanceV2ChargeInfoArgs'] charge_info: Payment methods.
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_5_7
               MySQL_8_0.
        :param pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2NodeInfoArgs']]] node_infos: Instance specification configuration. This parameter is required for RDS for MySQL, RDS for PostgreSQL and MySQL Sharding. There is one and only one Primary node, one and only one Secondary node, and 0-10 Read-Only nodes.
        :param pulumi.Input[str] storage_type: Instance storage type. When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, the value is:
               LocalSSD - local SSD disk
               When the database type is veDB_MySQL/veDB_PostgreSQL, the value is:
               DistributedStorage - Distributed Storage.
        :param pulumi.Input[str] subnet_id: Subnet ID.
        :param pulumi.Input[str] vpc_id: Private network (VPC) ID. You can call the DescribeVpcs query and use this parameter to specify the VPC where the instance is to be created.
        :param pulumi.Input[str] db_param_group_id: Parameter template ID. It only takes effect when the database type is MySQL/PostgreSQL/SQL_Server. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] db_time_zone: Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] instance_name: Instance name. Cannot start with a number or a dash
               Can only contain Chinese characters, letters, numbers, underscores and dashes
               The length is limited between 1 ~ 128.
        :param pulumi.Input[str] instance_type: The field instance_type is no longer support. The type of Instance.
        :param pulumi.Input[str] lower_case_table_names: Whether the table name is case sensitive, the default value is 1.
               Ranges:
               0: Table names are stored as fixed and table names are case-sensitive.
               1: Table names will be stored in lowercase and table names are not case sensitive.
        :param pulumi.Input[str] project_name: Subordinate to the project.
        :param pulumi.Input[int] storage_space: Instance storage space.
               When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, value range: [20, 3000], unit: GB, increments every 100GB.
               When the database type is veDB_MySQL/veDB_PostgreSQL, this parameter does not need to be passed.
        """
        pulumi.set(__self__, "charge_info", charge_info)
        pulumi.set(__self__, "db_engine_version", db_engine_version)
        pulumi.set(__self__, "node_infos", node_infos)
        pulumi.set(__self__, "storage_type", storage_type)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "vpc_id", vpc_id)
        if db_param_group_id is not None:
            pulumi.set(__self__, "db_param_group_id", db_param_group_id)
        if db_time_zone is not None:
            pulumi.set(__self__, "db_time_zone", db_time_zone)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            warnings.warn("""The field instance_type is no longer support.""", DeprecationWarning)
            pulumi.log.warn("""instance_type is deprecated: The field instance_type is no longer support.""")
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if lower_case_table_names is not None:
            pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)

    @property
    @pulumi.getter(name="chargeInfo")
    def charge_info(self) -> pulumi.Input['RdsInstanceV2ChargeInfoArgs']:
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_info")

    @charge_info.setter
    def charge_info(self, value: pulumi.Input['RdsInstanceV2ChargeInfoArgs']):
        pulumi.set(self, "charge_info", value)

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> pulumi.Input[str]:
        """
        Instance type. Value:
        MySQL_5_7
        MySQL_8_0.
        """
        return pulumi.get(self, "db_engine_version")

    @db_engine_version.setter
    def db_engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_engine_version", value)

    @property
    @pulumi.getter(name="nodeInfos")
    def node_infos(self) -> pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2NodeInfoArgs']]]:
        """
        Instance specification configuration. This parameter is required for RDS for MySQL, RDS for PostgreSQL and MySQL Sharding. There is one and only one Primary node, one and only one Secondary node, and 0-10 Read-Only nodes.
        """
        return pulumi.get(self, "node_infos")

    @node_infos.setter
    def node_infos(self, value: pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2NodeInfoArgs']]]):
        pulumi.set(self, "node_infos", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Input[str]:
        """
        Instance storage type. When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, the value is:
        LocalSSD - local SSD disk
        When the database type is veDB_MySQL/veDB_PostgreSQL, the value is:
        DistributedStorage - Distributed Storage.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        Subnet ID.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Input[str]:
        """
        Private network (VPC) ID. You can call the DescribeVpcs query and use this parameter to specify the VPC where the instance is to be created.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "vpc_id", value)

    @property
    @pulumi.getter(name="dbParamGroupId")
    def db_param_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter template ID. It only takes effect when the database type is MySQL/PostgreSQL/SQL_Server. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "db_param_group_id")

    @db_param_group_id.setter
    def db_param_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_param_group_id", value)

    @property
    @pulumi.getter(name="dbTimeZone")
    def db_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "db_time_zone")

    @db_time_zone.setter
    def db_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_time_zone", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance name. Cannot start with a number or a dash
        Can only contain Chinese characters, letters, numbers, underscores and dashes
        The length is limited between 1 ~ 128.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The field instance_type is no longer support. The type of Instance.
        """
        warnings.warn("""The field instance_type is no longer support.""", DeprecationWarning)
        pulumi.log.warn("""instance_type is deprecated: The field instance_type is no longer support.""")

        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the table name is case sensitive, the default value is 1.
        Ranges:
        0: Table names are stored as fixed and table names are case-sensitive.
        1: Table names will be stored in lowercase and table names are not case sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @lower_case_table_names.setter
    def lower_case_table_names(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lower_case_table_names", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        Subordinate to the project.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Instance storage space.
        When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, value range: [20, 3000], unit: GB, increments every 100GB.
        When the database type is veDB_MySQL/veDB_PostgreSQL, this parameter does not need to be passed.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space", value)


@pulumi.input_type
class _RdsInstanceV2State:
    def __init__(__self__, *,
                 charge_info: Optional[pulumi.Input['RdsInstanceV2ChargeInfoArgs']] = None,
                 connection_infos: Optional[pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2ConnectionInfoArgs']]]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 db_param_group_id: Optional[pulumi.Input[str]] = None,
                 db_time_zone: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[str]] = None,
                 node_infos: Optional[pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2NodeInfoArgs']]]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RdsInstanceV2 resources.
        :param pulumi.Input['RdsInstanceV2ChargeInfoArgs'] charge_info: Payment methods.
        :param pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2ConnectionInfoArgs']]] connection_infos: The connection info ot the RDS instance.
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_5_7
               MySQL_8_0.
        :param pulumi.Input[str] db_param_group_id: Parameter template ID. It only takes effect when the database type is MySQL/PostgreSQL/SQL_Server. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] db_time_zone: Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] instance_name: Instance name. Cannot start with a number or a dash
               Can only contain Chinese characters, letters, numbers, underscores and dashes
               The length is limited between 1 ~ 128.
        :param pulumi.Input[str] instance_type: The field instance_type is no longer support. The type of Instance.
        :param pulumi.Input[str] lower_case_table_names: Whether the table name is case sensitive, the default value is 1.
               Ranges:
               0: Table names are stored as fixed and table names are case-sensitive.
               1: Table names will be stored in lowercase and table names are not case sensitive.
        :param pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2NodeInfoArgs']]] node_infos: Instance specification configuration. This parameter is required for RDS for MySQL, RDS for PostgreSQL and MySQL Sharding. There is one and only one Primary node, one and only one Secondary node, and 0-10 Read-Only nodes.
        :param pulumi.Input[str] project_name: Subordinate to the project.
        :param pulumi.Input[int] storage_space: Instance storage space.
               When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, value range: [20, 3000], unit: GB, increments every 100GB.
               When the database type is veDB_MySQL/veDB_PostgreSQL, this parameter does not need to be passed.
        :param pulumi.Input[str] storage_type: Instance storage type. When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, the value is:
               LocalSSD - local SSD disk
               When the database type is veDB_MySQL/veDB_PostgreSQL, the value is:
               DistributedStorage - Distributed Storage.
        :param pulumi.Input[str] subnet_id: Subnet ID.
        :param pulumi.Input[str] vpc_id: Private network (VPC) ID. You can call the DescribeVpcs query and use this parameter to specify the VPC where the instance is to be created.
        """
        if charge_info is not None:
            pulumi.set(__self__, "charge_info", charge_info)
        if connection_infos is not None:
            pulumi.set(__self__, "connection_infos", connection_infos)
        if db_engine_version is not None:
            pulumi.set(__self__, "db_engine_version", db_engine_version)
        if db_param_group_id is not None:
            pulumi.set(__self__, "db_param_group_id", db_param_group_id)
        if db_time_zone is not None:
            pulumi.set(__self__, "db_time_zone", db_time_zone)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if instance_type is not None:
            warnings.warn("""The field instance_type is no longer support.""", DeprecationWarning)
            pulumi.log.warn("""instance_type is deprecated: The field instance_type is no longer support.""")
        if instance_type is not None:
            pulumi.set(__self__, "instance_type", instance_type)
        if lower_case_table_names is not None:
            pulumi.set(__self__, "lower_case_table_names", lower_case_table_names)
        if node_infos is not None:
            pulumi.set(__self__, "node_infos", node_infos)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if storage_space is not None:
            pulumi.set(__self__, "storage_space", storage_space)
        if storage_type is not None:
            pulumi.set(__self__, "storage_type", storage_type)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="chargeInfo")
    def charge_info(self) -> Optional[pulumi.Input['RdsInstanceV2ChargeInfoArgs']]:
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_info")

    @charge_info.setter
    def charge_info(self, value: Optional[pulumi.Input['RdsInstanceV2ChargeInfoArgs']]):
        pulumi.set(self, "charge_info", value)

    @property
    @pulumi.getter(name="connectionInfos")
    def connection_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2ConnectionInfoArgs']]]]:
        """
        The connection info ot the RDS instance.
        """
        return pulumi.get(self, "connection_infos")

    @connection_infos.setter
    def connection_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2ConnectionInfoArgs']]]]):
        pulumi.set(self, "connection_infos", value)

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        Instance type. Value:
        MySQL_5_7
        MySQL_8_0.
        """
        return pulumi.get(self, "db_engine_version")

    @db_engine_version.setter
    def db_engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_engine_version", value)

    @property
    @pulumi.getter(name="dbParamGroupId")
    def db_param_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        Parameter template ID. It only takes effect when the database type is MySQL/PostgreSQL/SQL_Server. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "db_param_group_id")

    @db_param_group_id.setter
    def db_param_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_param_group_id", value)

    @property
    @pulumi.getter(name="dbTimeZone")
    def db_time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "db_time_zone")

    @db_time_zone.setter
    def db_time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_time_zone", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        Instance name. Cannot start with a number or a dash
        Can only contain Chinese characters, letters, numbers, underscores and dashes
        The length is limited between 1 ~ 128.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The field instance_type is no longer support. The type of Instance.
        """
        warnings.warn("""The field instance_type is no longer support.""", DeprecationWarning)
        pulumi.log.warn("""instance_type is deprecated: The field instance_type is no longer support.""")

        return pulumi.get(self, "instance_type")

    @instance_type.setter
    def instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_type", value)

    @property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> Optional[pulumi.Input[str]]:
        """
        Whether the table name is case sensitive, the default value is 1.
        Ranges:
        0: Table names are stored as fixed and table names are case-sensitive.
        1: Table names will be stored in lowercase and table names are not case sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @lower_case_table_names.setter
    def lower_case_table_names(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lower_case_table_names", value)

    @property
    @pulumi.getter(name="nodeInfos")
    def node_infos(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2NodeInfoArgs']]]]:
        """
        Instance specification configuration. This parameter is required for RDS for MySQL, RDS for PostgreSQL and MySQL Sharding. There is one and only one Primary node, one and only one Secondary node, and 0-10 Read-Only nodes.
        """
        return pulumi.get(self, "node_infos")

    @node_infos.setter
    def node_infos(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RdsInstanceV2NodeInfoArgs']]]]):
        pulumi.set(self, "node_infos", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        Subordinate to the project.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> Optional[pulumi.Input[int]]:
        """
        Instance storage space.
        When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, value range: [20, 3000], unit: GB, increments every 100GB.
        When the database type is veDB_MySQL/veDB_PostgreSQL, this parameter does not need to be passed.
        """
        return pulumi.get(self, "storage_space")

    @storage_space.setter
    def storage_space(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "storage_space", value)

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> Optional[pulumi.Input[str]]:
        """
        Instance storage type. When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, the value is:
        LocalSSD - local SSD disk
        When the database type is veDB_MySQL/veDB_PostgreSQL, the value is:
        DistributedStorage - Distributed Storage.
        """
        return pulumi.get(self, "storage_type")

    @storage_type.setter
    def storage_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_type", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        Subnet ID.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        Private network (VPC) ID. You can call the DescribeVpcs query and use this parameter to specify the VPC where the instance is to be created.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class RdsInstanceV2(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 charge_info: Optional[pulumi.Input[pulumi.InputType['RdsInstanceV2ChargeInfoArgs']]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 db_param_group_id: Optional[pulumi.Input[str]] = None,
                 db_time_zone: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[str]] = None,
                 node_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RdsInstanceV2NodeInfoArgs']]]]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Provides a resource to manage rds instance v2
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_rds_instance_v2 = volcengine.rds_v2.RdsInstanceV2("fooRdsInstanceV2",
            db_engine_version="MySQL_5_7",
            node_infos=[
                volcengine.rds_v2.RdsInstanceV2NodeInfoArgs(
                    node_type="Primary",
                    node_spec="rds.mysql.2c4g",
                    zone_id=foo_zones.zones[0].id,
                ),
                volcengine.rds_v2.RdsInstanceV2NodeInfoArgs(
                    node_type="Secondary",
                    node_spec="rds.mysql.2c4g",
                    zone_id=foo_zones.zones[0].id,
                ),
            ],
            storage_type="LocalSSD",
            storage_space=100,
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            instance_name="tf-test-v2",
            lower_case_table_names="1",
            charge_info=volcengine.rds_v2.RdsInstanceV2ChargeInfoArgs(
                charge_type="PostPaid",
            ))
        ```

        ## Import

        RDS Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds_v2/rdsInstanceV2:RdsInstanceV2 default mysql-42b38c769c4b
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['RdsInstanceV2ChargeInfoArgs']] charge_info: Payment methods.
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_5_7
               MySQL_8_0.
        :param pulumi.Input[str] db_param_group_id: Parameter template ID. It only takes effect when the database type is MySQL/PostgreSQL/SQL_Server. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] db_time_zone: Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] instance_name: Instance name. Cannot start with a number or a dash
               Can only contain Chinese characters, letters, numbers, underscores and dashes
               The length is limited between 1 ~ 128.
        :param pulumi.Input[str] instance_type: The field instance_type is no longer support. The type of Instance.
        :param pulumi.Input[str] lower_case_table_names: Whether the table name is case sensitive, the default value is 1.
               Ranges:
               0: Table names are stored as fixed and table names are case-sensitive.
               1: Table names will be stored in lowercase and table names are not case sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RdsInstanceV2NodeInfoArgs']]]] node_infos: Instance specification configuration. This parameter is required for RDS for MySQL, RDS for PostgreSQL and MySQL Sharding. There is one and only one Primary node, one and only one Secondary node, and 0-10 Read-Only nodes.
        :param pulumi.Input[str] project_name: Subordinate to the project.
        :param pulumi.Input[int] storage_space: Instance storage space.
               When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, value range: [20, 3000], unit: GB, increments every 100GB.
               When the database type is veDB_MySQL/veDB_PostgreSQL, this parameter does not need to be passed.
        :param pulumi.Input[str] storage_type: Instance storage type. When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, the value is:
               LocalSSD - local SSD disk
               When the database type is veDB_MySQL/veDB_PostgreSQL, the value is:
               DistributedStorage - Distributed Storage.
        :param pulumi.Input[str] subnet_id: Subnet ID.
        :param pulumi.Input[str] vpc_id: Private network (VPC) ID. You can call the DescribeVpcs query and use this parameter to specify the VPC where the instance is to be created.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RdsInstanceV2Args,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        (Deprecated! Recommend use volcengine_rds_mysql_*** replace) Provides a resource to manage rds instance v2
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_rds_instance_v2 = volcengine.rds_v2.RdsInstanceV2("fooRdsInstanceV2",
            db_engine_version="MySQL_5_7",
            node_infos=[
                volcengine.rds_v2.RdsInstanceV2NodeInfoArgs(
                    node_type="Primary",
                    node_spec="rds.mysql.2c4g",
                    zone_id=foo_zones.zones[0].id,
                ),
                volcengine.rds_v2.RdsInstanceV2NodeInfoArgs(
                    node_type="Secondary",
                    node_spec="rds.mysql.2c4g",
                    zone_id=foo_zones.zones[0].id,
                ),
            ],
            storage_type="LocalSSD",
            storage_space=100,
            vpc_id=foo_vpc.id,
            subnet_id=foo_subnet.id,
            instance_name="tf-test-v2",
            lower_case_table_names="1",
            charge_info=volcengine.rds_v2.RdsInstanceV2ChargeInfoArgs(
                charge_type="PostPaid",
            ))
        ```

        ## Import

        RDS Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:rds_v2/rdsInstanceV2:RdsInstanceV2 default mysql-42b38c769c4b
        ```

        :param str resource_name: The name of the resource.
        :param RdsInstanceV2Args args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RdsInstanceV2Args, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 charge_info: Optional[pulumi.Input[pulumi.InputType['RdsInstanceV2ChargeInfoArgs']]] = None,
                 db_engine_version: Optional[pulumi.Input[str]] = None,
                 db_param_group_id: Optional[pulumi.Input[str]] = None,
                 db_time_zone: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 instance_type: Optional[pulumi.Input[str]] = None,
                 lower_case_table_names: Optional[pulumi.Input[str]] = None,
                 node_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RdsInstanceV2NodeInfoArgs']]]]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 storage_space: Optional[pulumi.Input[int]] = None,
                 storage_type: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RdsInstanceV2Args.__new__(RdsInstanceV2Args)

            if charge_info is None and not opts.urn:
                raise TypeError("Missing required property 'charge_info'")
            __props__.__dict__["charge_info"] = charge_info
            if db_engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'db_engine_version'")
            __props__.__dict__["db_engine_version"] = db_engine_version
            __props__.__dict__["db_param_group_id"] = db_param_group_id
            __props__.__dict__["db_time_zone"] = db_time_zone
            __props__.__dict__["instance_name"] = instance_name
            if instance_type is not None and not opts.urn:
                warnings.warn("""The field instance_type is no longer support.""", DeprecationWarning)
                pulumi.log.warn("""instance_type is deprecated: The field instance_type is no longer support.""")
            __props__.__dict__["instance_type"] = instance_type
            __props__.__dict__["lower_case_table_names"] = lower_case_table_names
            if node_infos is None and not opts.urn:
                raise TypeError("Missing required property 'node_infos'")
            __props__.__dict__["node_infos"] = node_infos
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["storage_space"] = storage_space
            if storage_type is None and not opts.urn:
                raise TypeError("Missing required property 'storage_type'")
            __props__.__dict__["storage_type"] = storage_type
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            if vpc_id is None and not opts.urn:
                raise TypeError("Missing required property 'vpc_id'")
            __props__.__dict__["vpc_id"] = vpc_id
            __props__.__dict__["connection_infos"] = None
        super(RdsInstanceV2, __self__).__init__(
            'volcengine:rds_v2/rdsInstanceV2:RdsInstanceV2',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            charge_info: Optional[pulumi.Input[pulumi.InputType['RdsInstanceV2ChargeInfoArgs']]] = None,
            connection_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RdsInstanceV2ConnectionInfoArgs']]]]] = None,
            db_engine_version: Optional[pulumi.Input[str]] = None,
            db_param_group_id: Optional[pulumi.Input[str]] = None,
            db_time_zone: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            instance_type: Optional[pulumi.Input[str]] = None,
            lower_case_table_names: Optional[pulumi.Input[str]] = None,
            node_infos: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RdsInstanceV2NodeInfoArgs']]]]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            storage_space: Optional[pulumi.Input[int]] = None,
            storage_type: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'RdsInstanceV2':
        """
        Get an existing RdsInstanceV2 resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['RdsInstanceV2ChargeInfoArgs']] charge_info: Payment methods.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RdsInstanceV2ConnectionInfoArgs']]]] connection_infos: The connection info ot the RDS instance.
        :param pulumi.Input[str] db_engine_version: Instance type. Value:
               MySQL_5_7
               MySQL_8_0.
        :param pulumi.Input[str] db_param_group_id: Parameter template ID. It only takes effect when the database type is MySQL/PostgreSQL/SQL_Server. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] db_time_zone: Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] instance_name: Instance name. Cannot start with a number or a dash
               Can only contain Chinese characters, letters, numbers, underscores and dashes
               The length is limited between 1 ~ 128.
        :param pulumi.Input[str] instance_type: The field instance_type is no longer support. The type of Instance.
        :param pulumi.Input[str] lower_case_table_names: Whether the table name is case sensitive, the default value is 1.
               Ranges:
               0: Table names are stored as fixed and table names are case-sensitive.
               1: Table names will be stored in lowercase and table names are not case sensitive.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RdsInstanceV2NodeInfoArgs']]]] node_infos: Instance specification configuration. This parameter is required for RDS for MySQL, RDS for PostgreSQL and MySQL Sharding. There is one and only one Primary node, one and only one Secondary node, and 0-10 Read-Only nodes.
        :param pulumi.Input[str] project_name: Subordinate to the project.
        :param pulumi.Input[int] storage_space: Instance storage space.
               When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, value range: [20, 3000], unit: GB, increments every 100GB.
               When the database type is veDB_MySQL/veDB_PostgreSQL, this parameter does not need to be passed.
        :param pulumi.Input[str] storage_type: Instance storage type. When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, the value is:
               LocalSSD - local SSD disk
               When the database type is veDB_MySQL/veDB_PostgreSQL, the value is:
               DistributedStorage - Distributed Storage.
        :param pulumi.Input[str] subnet_id: Subnet ID.
        :param pulumi.Input[str] vpc_id: Private network (VPC) ID. You can call the DescribeVpcs query and use this parameter to specify the VPC where the instance is to be created.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RdsInstanceV2State.__new__(_RdsInstanceV2State)

        __props__.__dict__["charge_info"] = charge_info
        __props__.__dict__["connection_infos"] = connection_infos
        __props__.__dict__["db_engine_version"] = db_engine_version
        __props__.__dict__["db_param_group_id"] = db_param_group_id
        __props__.__dict__["db_time_zone"] = db_time_zone
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["instance_type"] = instance_type
        __props__.__dict__["lower_case_table_names"] = lower_case_table_names
        __props__.__dict__["node_infos"] = node_infos
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["storage_space"] = storage_space
        __props__.__dict__["storage_type"] = storage_type
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["vpc_id"] = vpc_id
        return RdsInstanceV2(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="chargeInfo")
    def charge_info(self) -> pulumi.Output['outputs.RdsInstanceV2ChargeInfo']:
        """
        Payment methods.
        """
        return pulumi.get(self, "charge_info")

    @property
    @pulumi.getter(name="connectionInfos")
    def connection_infos(self) -> pulumi.Output[Sequence['outputs.RdsInstanceV2ConnectionInfo']]:
        """
        The connection info ot the RDS instance.
        """
        return pulumi.get(self, "connection_infos")

    @property
    @pulumi.getter(name="dbEngineVersion")
    def db_engine_version(self) -> pulumi.Output[str]:
        """
        Instance type. Value:
        MySQL_5_7
        MySQL_8_0.
        """
        return pulumi.get(self, "db_engine_version")

    @property
    @pulumi.getter(name="dbParamGroupId")
    def db_param_group_id(self) -> pulumi.Output[Optional[str]]:
        """
        Parameter template ID. It only takes effect when the database type is MySQL/PostgreSQL/SQL_Server. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "db_param_group_id")

    @property
    @pulumi.getter(name="dbTimeZone")
    def db_time_zone(self) -> pulumi.Output[Optional[str]]:
        """
        Time zone. Support UTC -12:00 ~ +13:00. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "db_time_zone")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        Instance name. Cannot start with a number or a dash
        Can only contain Chinese characters, letters, numbers, underscores and dashes
        The length is limited between 1 ~ 128.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> pulumi.Output[str]:
        """
        The field instance_type is no longer support. The type of Instance.
        """
        warnings.warn("""The field instance_type is no longer support.""", DeprecationWarning)
        pulumi.log.warn("""instance_type is deprecated: The field instance_type is no longer support.""")

        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="lowerCaseTableNames")
    def lower_case_table_names(self) -> pulumi.Output[Optional[str]]:
        """
        Whether the table name is case sensitive, the default value is 1.
        Ranges:
        0: Table names are stored as fixed and table names are case-sensitive.
        1: Table names will be stored in lowercase and table names are not case sensitive.
        """
        return pulumi.get(self, "lower_case_table_names")

    @property
    @pulumi.getter(name="nodeInfos")
    def node_infos(self) -> pulumi.Output[Sequence['outputs.RdsInstanceV2NodeInfo']]:
        """
        Instance specification configuration. This parameter is required for RDS for MySQL, RDS for PostgreSQL and MySQL Sharding. There is one and only one Primary node, one and only one Secondary node, and 0-10 Read-Only nodes.
        """
        return pulumi.get(self, "node_infos")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        Subordinate to the project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="storageSpace")
    def storage_space(self) -> pulumi.Output[Optional[int]]:
        """
        Instance storage space.
        When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, value range: [20, 3000], unit: GB, increments every 100GB.
        When the database type is veDB_MySQL/veDB_PostgreSQL, this parameter does not need to be passed.
        """
        return pulumi.get(self, "storage_space")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> pulumi.Output[str]:
        """
        Instance storage type. When the database type is MySQL/PostgreSQL/SQL_Server/MySQL Sharding, the value is:
        LocalSSD - local SSD disk
        When the database type is veDB_MySQL/veDB_PostgreSQL, the value is:
        DistributedStorage - Distributed Storage.
        """
        return pulumi.get(self, "storage_type")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        Subnet ID.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        Private network (VPC) ID. You can call the DescribeVpcs query and use this parameter to specify the VPC where the instance is to be created.
        """
        return pulumi.get(self, "vpc_id")

