# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BackupArgs', 'Backup']

@pulumi.input_type
class BackupArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a Backup resource.
        :param pulumi.Input[str] instance_id: Id of instance to create backup.
        """
        pulumi.set(__self__, "instance_id", instance_id)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Id of instance to create backup.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)


@pulumi.input_type
class _BackupState:
    def __init__(__self__, *,
                 backup_point_id: Optional[pulumi.Input[str]] = None,
                 backup_strategy: Optional[pulumi.Input[str]] = None,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 instance_details: Optional[pulumi.Input[Sequence[pulumi.Input['BackupInstanceDetailArgs']]]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 size: Optional[pulumi.Input[int]] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Backup resources.
        :param pulumi.Input[str] backup_point_id: The id of backup point.
        :param pulumi.Input[str] backup_strategy: Backup strategy.
        :param pulumi.Input[str] backup_type: Backup type.
        :param pulumi.Input[str] end_time: End time of backup.
        :param pulumi.Input[Sequence[pulumi.Input['BackupInstanceDetailArgs']]] instance_details: Information of instance.
        :param pulumi.Input[str] instance_id: Id of instance to create backup.
        :param pulumi.Input[int] size: Size in MiB.
        :param pulumi.Input[str] start_time: Start time of backup.
        :param pulumi.Input[str] status: Status of backup (Creating/Available/Unavailable/Deleting).
        """
        if backup_point_id is not None:
            pulumi.set(__self__, "backup_point_id", backup_point_id)
        if backup_strategy is not None:
            pulumi.set(__self__, "backup_strategy", backup_strategy)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if instance_details is not None:
            pulumi.set(__self__, "instance_details", instance_details)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if size is not None:
            pulumi.set(__self__, "size", size)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="backupPointId")
    def backup_point_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of backup point.
        """
        return pulumi.get(self, "backup_point_id")

    @backup_point_id.setter
    def backup_point_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_point_id", value)

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> Optional[pulumi.Input[str]]:
        """
        Backup strategy.
        """
        return pulumi.get(self, "backup_strategy")

    @backup_strategy.setter
    def backup_strategy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_strategy", value)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[str]]:
        """
        Backup type.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        End time of backup.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="instanceDetails")
    def instance_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BackupInstanceDetailArgs']]]]:
        """
        Information of instance.
        """
        return pulumi.get(self, "instance_details")

    @instance_details.setter
    def instance_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BackupInstanceDetailArgs']]]]):
        pulumi.set(self, "instance_details", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of instance to create backup.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def size(self) -> Optional[pulumi.Input[int]]:
        """
        Size in MiB.
        """
        return pulumi.get(self, "size")

    @size.setter
    def size(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "size", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Start time of backup.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        Status of backup (Creating/Available/Unavailable/Deleting).
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


class Backup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage redis backup
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.redis.Instance("fooInstance",
            zone_ids=[foo_zones.zones[0].id],
            instance_name="acc-test-tf-redis",
            sharded_cluster=1,
            password="1qaz!QAZ12",
            node_number=2,
            shard_capacity=1024,
            shard_number=2,
            engine_version="5.0",
            subnet_id=foo_subnet.id,
            deletion_protection="disabled",
            vpc_auth_mode="close",
            charge_type="PostPaid",
            port=6381,
            project_name="default")
        foo_backup = volcengine.redis.Backup("fooBackup", instance_id=foo_instance.id)
        ```

        ## Import

        Redis Backup can be imported using the instanceId:backupId, e.g.

        ```sh
         $ pulumi import volcengine:redis/backup:Backup default redis-cn02aqusft7ws****:b-cn02xmmrp751i9cdzcphjmk4****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] instance_id: Id of instance to create backup.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage redis backup
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.redis.Instance("fooInstance",
            zone_ids=[foo_zones.zones[0].id],
            instance_name="acc-test-tf-redis",
            sharded_cluster=1,
            password="1qaz!QAZ12",
            node_number=2,
            shard_capacity=1024,
            shard_number=2,
            engine_version="5.0",
            subnet_id=foo_subnet.id,
            deletion_protection="disabled",
            vpc_auth_mode="close",
            charge_type="PostPaid",
            port=6381,
            project_name="default")
        foo_backup = volcengine.redis.Backup("fooBackup", instance_id=foo_instance.id)
        ```

        ## Import

        Redis Backup can be imported using the instanceId:backupId, e.g.

        ```sh
         $ pulumi import volcengine:redis/backup:Backup default redis-cn02aqusft7ws****:b-cn02xmmrp751i9cdzcphjmk4****
        ```

        :param str resource_name: The name of the resource.
        :param BackupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupArgs.__new__(BackupArgs)

            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["backup_point_id"] = None
            __props__.__dict__["backup_strategy"] = None
            __props__.__dict__["backup_type"] = None
            __props__.__dict__["end_time"] = None
            __props__.__dict__["instance_details"] = None
            __props__.__dict__["size"] = None
            __props__.__dict__["start_time"] = None
            __props__.__dict__["status"] = None
        super(Backup, __self__).__init__(
            'volcengine:redis/backup:Backup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_point_id: Optional[pulumi.Input[str]] = None,
            backup_strategy: Optional[pulumi.Input[str]] = None,
            backup_type: Optional[pulumi.Input[str]] = None,
            end_time: Optional[pulumi.Input[str]] = None,
            instance_details: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackupInstanceDetailArgs']]]]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            size: Optional[pulumi.Input[int]] = None,
            start_time: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None) -> 'Backup':
        """
        Get an existing Backup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_point_id: The id of backup point.
        :param pulumi.Input[str] backup_strategy: Backup strategy.
        :param pulumi.Input[str] backup_type: Backup type.
        :param pulumi.Input[str] end_time: End time of backup.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BackupInstanceDetailArgs']]]] instance_details: Information of instance.
        :param pulumi.Input[str] instance_id: Id of instance to create backup.
        :param pulumi.Input[int] size: Size in MiB.
        :param pulumi.Input[str] start_time: Start time of backup.
        :param pulumi.Input[str] status: Status of backup (Creating/Available/Unavailable/Deleting).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupState.__new__(_BackupState)

        __props__.__dict__["backup_point_id"] = backup_point_id
        __props__.__dict__["backup_strategy"] = backup_strategy
        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["end_time"] = end_time
        __props__.__dict__["instance_details"] = instance_details
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["size"] = size
        __props__.__dict__["start_time"] = start_time
        __props__.__dict__["status"] = status
        return Backup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupPointId")
    def backup_point_id(self) -> pulumi.Output[str]:
        """
        The id of backup point.
        """
        return pulumi.get(self, "backup_point_id")

    @property
    @pulumi.getter(name="backupStrategy")
    def backup_strategy(self) -> pulumi.Output[str]:
        """
        Backup strategy.
        """
        return pulumi.get(self, "backup_strategy")

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[str]:
        """
        Backup type.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Output[str]:
        """
        End time of backup.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="instanceDetails")
    def instance_details(self) -> pulumi.Output[Sequence['outputs.BackupInstanceDetail']]:
        """
        Information of instance.
        """
        return pulumi.get(self, "instance_details")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Id of instance to create backup.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def size(self) -> pulumi.Output[int]:
        """
        Size in MiB.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Output[str]:
        """
        Start time of backup.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        Status of backup (Creating/Available/Unavailable/Deleting).
        """
        return pulumi.get(self, "status")

