# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BackupRestoreArgs', 'BackupRestore']

@pulumi.input_type
class BackupRestoreArgs:
    def __init__(__self__, *,
                 instance_id: pulumi.Input[str],
                 time_point: pulumi.Input[str],
                 backup_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BackupRestore resource.
        :param pulumi.Input[str] instance_id: Id of instance.
        :param pulumi.Input[str] time_point: Time point of backup, for example: 2021-11-09T06:07:26Z. Use lifecycle and ignore_changes in import.
        :param pulumi.Input[str] backup_type: The type of backup. The value can be Full or Inc.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "time_point", time_point)
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Input[str]:
        """
        Id of instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="timePoint")
    def time_point(self) -> pulumi.Input[str]:
        """
        Time point of backup, for example: 2021-11-09T06:07:26Z. Use lifecycle and ignore_changes in import.
        """
        return pulumi.get(self, "time_point")

    @time_point.setter
    def time_point(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_point", value)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of backup. The value can be Full or Inc.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_type", value)


@pulumi.input_type
class _BackupRestoreState:
    def __init__(__self__, *,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 time_point: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BackupRestore resources.
        :param pulumi.Input[str] backup_type: The type of backup. The value can be Full or Inc.
        :param pulumi.Input[str] instance_id: Id of instance.
        :param pulumi.Input[str] time_point: Time point of backup, for example: 2021-11-09T06:07:26Z. Use lifecycle and ignore_changes in import.
        """
        if backup_type is not None:
            pulumi.set(__self__, "backup_type", backup_type)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if time_point is not None:
            pulumi.set(__self__, "time_point", time_point)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of backup. The value can be Full or Inc.
        """
        return pulumi.get(self, "backup_type")

    @backup_type.setter
    def backup_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_type", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of instance.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter(name="timePoint")
    def time_point(self) -> Optional[pulumi.Input[str]]:
        """
        Time point of backup, for example: 2021-11-09T06:07:26Z. Use lifecycle and ignore_changes in import.
        """
        return pulumi.get(self, "time_point")

    @time_point.setter
    def time_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_point", value)


class BackupRestore(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 time_point: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage redis backup restore
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.redis.Instance("fooInstance",
            zone_ids=[foo_zones.zones[0].id],
            instance_name="acc-test-tf-redis",
            sharded_cluster=1,
            password="1qaz!QAZ12",
            node_number=2,
            shard_capacity=1024,
            shard_number=2,
            engine_version="5.0",
            subnet_id=foo_subnet.id,
            deletion_protection="disabled",
            vpc_auth_mode="close",
            charge_type="PostPaid",
            port=6381,
            project_name="default")
        foo_backup = volcengine.redis.Backup("fooBackup", instance_id=foo_instance.id)
        foo_backup_restore = volcengine.redis.BackupRestore("fooBackupRestore",
            instance_id=foo_instance.id,
            time_point=foo_backup.end_time,
            backup_type="Full")
        ```

        ## Import

        Redis Backup Restore can be imported using the restore:instanceId, e.g.

        ```sh
         $ pulumi import volcengine:redis/backupRestore:BackupRestore default restore:redis-asdljioeixxxx
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_type: The type of backup. The value can be Full or Inc.
        :param pulumi.Input[str] instance_id: Id of instance.
        :param pulumi.Input[str] time_point: Time point of backup, for example: 2021-11-09T06:07:26Z. Use lifecycle and ignore_changes in import.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupRestoreArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage redis backup restore
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.redis.Instance("fooInstance",
            zone_ids=[foo_zones.zones[0].id],
            instance_name="acc-test-tf-redis",
            sharded_cluster=1,
            password="1qaz!QAZ12",
            node_number=2,
            shard_capacity=1024,
            shard_number=2,
            engine_version="5.0",
            subnet_id=foo_subnet.id,
            deletion_protection="disabled",
            vpc_auth_mode="close",
            charge_type="PostPaid",
            port=6381,
            project_name="default")
        foo_backup = volcengine.redis.Backup("fooBackup", instance_id=foo_instance.id)
        foo_backup_restore = volcengine.redis.BackupRestore("fooBackupRestore",
            instance_id=foo_instance.id,
            time_point=foo_backup.end_time,
            backup_type="Full")
        ```

        ## Import

        Redis Backup Restore can be imported using the restore:instanceId, e.g.

        ```sh
         $ pulumi import volcengine:redis/backupRestore:BackupRestore default restore:redis-asdljioeixxxx
        ```

        :param str resource_name: The name of the resource.
        :param BackupRestoreArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupRestoreArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 backup_type: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 time_point: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupRestoreArgs.__new__(BackupRestoreArgs)

            __props__.__dict__["backup_type"] = backup_type
            if instance_id is None and not opts.urn:
                raise TypeError("Missing required property 'instance_id'")
            __props__.__dict__["instance_id"] = instance_id
            if time_point is None and not opts.urn:
                raise TypeError("Missing required property 'time_point'")
            __props__.__dict__["time_point"] = time_point
        super(BackupRestore, __self__).__init__(
            'volcengine:redis/backupRestore:BackupRestore',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            backup_type: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            time_point: Optional[pulumi.Input[str]] = None) -> 'BackupRestore':
        """
        Get an existing BackupRestore resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] backup_type: The type of backup. The value can be Full or Inc.
        :param pulumi.Input[str] instance_id: Id of instance.
        :param pulumi.Input[str] time_point: Time point of backup, for example: 2021-11-09T06:07:26Z. Use lifecycle and ignore_changes in import.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupRestoreState.__new__(_BackupRestoreState)

        __props__.__dict__["backup_type"] = backup_type
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["time_point"] = time_point
        return BackupRestore(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="backupType")
    def backup_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of backup. The value can be Full or Inc.
        """
        return pulumi.get(self, "backup_type")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Id of instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="timePoint")
    def time_point(self) -> pulumi.Output[str]:
        """
        Time point of backup, for example: 2021-11-09T06:07:26Z. Use lifecycle and ignore_changes in import.
        """
        return pulumi.get(self, "time_point")

