# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BackupsResult',
    'AwaitableBackupsResult',
    'backups',
    'backups_output',
]

@pulumi.output_type
class BackupsResult:
    """
    A collection of values returned by Backups.
    """
    def __init__(__self__, backup_strategy_lists=None, backups=None, end_time=None, id=None, instance_id=None, output_file=None, start_time=None, total_count=None):
        if backup_strategy_lists and not isinstance(backup_strategy_lists, list):
            raise TypeError("Expected argument 'backup_strategy_lists' to be a list")
        pulumi.set(__self__, "backup_strategy_lists", backup_strategy_lists)
        if backups and not isinstance(backups, list):
            raise TypeError("Expected argument 'backups' to be a list")
        pulumi.set(__self__, "backups", backups)
        if end_time and not isinstance(end_time, str):
            raise TypeError("Expected argument 'end_time' to be a str")
        pulumi.set(__self__, "end_time", end_time)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if start_time and not isinstance(start_time, str):
            raise TypeError("Expected argument 'start_time' to be a str")
        pulumi.set(__self__, "start_time", start_time)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="backupStrategyLists")
    def backup_strategy_lists(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "backup_strategy_lists")

    @property
    @pulumi.getter
    def backups(self) -> Sequence['outputs.BackupsBackupResult']:
        """
        Information of backups.
        """
        return pulumi.get(self, "backups")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[str]:
        """
        End time of backup.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        Id of instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[str]:
        """
        Start time of backup.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of backup query.
        """
        return pulumi.get(self, "total_count")


class AwaitableBackupsResult(BackupsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return BackupsResult(
            backup_strategy_lists=self.backup_strategy_lists,
            backups=self.backups,
            end_time=self.end_time,
            id=self.id,
            instance_id=self.instance_id,
            output_file=self.output_file,
            start_time=self.start_time,
            total_count=self.total_count)


def backups(backup_strategy_lists: Optional[Sequence[str]] = None,
            end_time: Optional[str] = None,
            instance_id: Optional[str] = None,
            output_file: Optional[str] = None,
            start_time: Optional[str] = None,
            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableBackupsResult:
    """
    Use this data source to query detailed information of redis backups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_instance = volcengine.redis.Instance("fooInstance",
        zone_ids=[foo_zones.zones[0].id],
        instance_name="acc-test-tf-redis",
        sharded_cluster=1,
        password="1qaz!QAZ12",
        node_number=2,
        shard_capacity=1024,
        shard_number=2,
        engine_version="5.0",
        subnet_id=foo_subnet.id,
        deletion_protection="disabled",
        vpc_auth_mode="close",
        charge_type="PostPaid",
        port=6381,
        project_name="default")
    foo_backup = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_backup.append(volcengine.redis.Backup(f"fooBackup-{range['value']}", instance_id=foo_instance.id))
    foo_backups = volcengine.redis.backups_output(instance_id=foo_instance.id)
    ```


    :param Sequence[str] backup_strategy_lists: The list of backup strategy, support AutomatedBackup and ManualBackup.
    :param str end_time: Query end time.
    :param str instance_id: Id of instance.
    :param str output_file: File name where to save data source results.
    :param str start_time: Query start time.
    """
    __args__ = dict()
    __args__['backupStrategyLists'] = backup_strategy_lists
    __args__['endTime'] = end_time
    __args__['instanceId'] = instance_id
    __args__['outputFile'] = output_file
    __args__['startTime'] = start_time
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:redis/backups:Backups', __args__, opts=opts, typ=BackupsResult).value

    return AwaitableBackupsResult(
        backup_strategy_lists=pulumi.get(__ret__, 'backup_strategy_lists'),
        backups=pulumi.get(__ret__, 'backups'),
        end_time=pulumi.get(__ret__, 'end_time'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        start_time=pulumi.get(__ret__, 'start_time'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(backups)
def backups_output(backup_strategy_lists: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                   end_time: Optional[pulumi.Input[Optional[str]]] = None,
                   instance_id: Optional[pulumi.Input[str]] = None,
                   output_file: Optional[pulumi.Input[Optional[str]]] = None,
                   start_time: Optional[pulumi.Input[Optional[str]]] = None,
                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[BackupsResult]:
    """
    Use this data source to query detailed information of redis backups
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_instance = volcengine.redis.Instance("fooInstance",
        zone_ids=[foo_zones.zones[0].id],
        instance_name="acc-test-tf-redis",
        sharded_cluster=1,
        password="1qaz!QAZ12",
        node_number=2,
        shard_capacity=1024,
        shard_number=2,
        engine_version="5.0",
        subnet_id=foo_subnet.id,
        deletion_protection="disabled",
        vpc_auth_mode="close",
        charge_type="PostPaid",
        port=6381,
        project_name="default")
    foo_backup = []
    for range in [{"value": i} for i in range(0, 3)]:
        foo_backup.append(volcengine.redis.Backup(f"fooBackup-{range['value']}", instance_id=foo_instance.id))
    foo_backups = volcengine.redis.backups_output(instance_id=foo_instance.id)
    ```


    :param Sequence[str] backup_strategy_lists: The list of backup strategy, support AutomatedBackup and ManualBackup.
    :param str end_time: Query end time.
    :param str instance_id: Id of instance.
    :param str output_file: File name where to save data source results.
    :param str start_time: Query start time.
    """
    ...
