# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 engine_version: pulumi.Input[str],
                 node_number: pulumi.Input[int],
                 password: pulumi.Input[str],
                 shard_capacity: pulumi.Input[int],
                 sharded_cluster: pulumi.Input[int],
                 subnet_id: pulumi.Input[str],
                 zone_ids: pulumi.Input[Sequence[pulumi.Input[str]]],
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 backup_active: Optional[pulumi.Input[bool]] = None,
                 backup_hour: Optional[pulumi.Input[int]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 create_backup: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 param_values: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParamValueArgs']]]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 purchase_months: Optional[pulumi.Input[int]] = None,
                 shard_number: Optional[pulumi.Input[int]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] engine_version: The engine version of redis instance. Valid value: `4.0`, `5.0`, `6.0`.
        :param pulumi.Input[int] node_number: The number of nodes in each shard, the valid value range is `1-6`. When the value is 1, it means creating a single node instance, and this field can not be modified. When the value is greater than 1, it means creating a primary and secondary instance, and this field can be modified.
        :param pulumi.Input[str] password: The account password. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] shard_capacity: The memory capacity of each shard, unit is MiB. The valid value range is as fallows: When the value of `ShardedCluster` is 0: 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536. When the value of `ShardedCluster` is 1: 1024, 2048, 4096, 8192, 16384. When the value of `node_number` is 1, the value of this field can not be 256.
        :param pulumi.Input[int] sharded_cluster: Whether enable sharded cluster for the current redis instance. Valid values: 0, 1. 0 means disable, 1 means enable.
        :param pulumi.Input[str] subnet_id: The subnet id of the redis instance. The specified subnet id must belong to the zone ids.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The list of zone IDs of instance. When creating a single node instance, only one zone id can be specified.
        :param pulumi.Input[bool] apply_immediately: Whether to apply the instance configuration change operation immediately. The value of this field is false, means that the change operation will be applied within maintenance time.
        :param pulumi.Input[bool] auto_renew: Whether to enable automatic renewal. This field is valid only when `ChargeType` is `PrePaid`, the default value is false. 
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[bool] backup_active: Whether enable auto backup for redis instance. This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[int] backup_hour: The time period to start performing the backup. The valid value range is any integer between 0 and 23, where 0 means that the system will perform the backup in the period of 00:00~01:00, 1 means that the backup will be performed in the period of 01:00~02:00, and so on. 
               This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] backup_periods: The backup period. The valid value can be any integer between 1 and 7. Among them, 1 means backup every Monday, 2 means backup every Tuesday, and so on. 
               This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[str] charge_type: The charge type of redis instance. Valid value: `PostPaid`, `PrePaid`.
        :param pulumi.Input[bool] create_backup: Whether to create a final backup when modify the instance configuration or destroy the redis instance.
        :param pulumi.Input[str] deletion_protection: Whether enable deletion protection for redis instance. Valid values: `enabled`, `disabled`(default).
        :param pulumi.Input[str] instance_name: The name of the redis instance.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParamValueArgs']]] param_values: The configuration item information to be modified. This field can only be added or modified. Deleting this field is invalid.
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields, or use the command `pulumi up` to perform a modification operation.
        :param pulumi.Input[int] port: The port of custom define private network address. The valid value range is `1024-65535`. The default value is `6379`.
        :param pulumi.Input[str] project_name: The project name to which the redis instance belongs, if this parameter is empty, the new redis instance will not be added to any project.
        :param pulumi.Input[int] purchase_months: The purchase months of redis instance, the unit is month. the valid value range is as fallows: `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36`. This field is valid and required when `ChargeType` is `Prepaid`. 
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] shard_number: The number of shards in redis instance, the valid value range is `2-256`. This field is valid and required when the value of `ShardedCluster` is 1.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]] tags: Tags.
        :param pulumi.Input[str] vpc_auth_mode: Whether to enable password-free access when connecting to an instance through a private network. Valid values: `open`, `close`.
        """
        pulumi.set(__self__, "engine_version", engine_version)
        pulumi.set(__self__, "node_number", node_number)
        pulumi.set(__self__, "password", password)
        pulumi.set(__self__, "shard_capacity", shard_capacity)
        pulumi.set(__self__, "sharded_cluster", sharded_cluster)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "zone_ids", zone_ids)
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_active is not None:
            pulumi.set(__self__, "backup_active", backup_active)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_periods is not None:
            pulumi.set(__self__, "backup_periods", backup_periods)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if create_backup is not None:
            pulumi.set(__self__, "create_backup", create_backup)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if param_values is not None:
            pulumi.set(__self__, "param_values", param_values)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if purchase_months is not None:
            pulumi.set(__self__, "purchase_months", purchase_months)
        if shard_number is not None:
            pulumi.set(__self__, "shard_number", shard_number)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_auth_mode is not None:
            pulumi.set(__self__, "vpc_auth_mode", vpc_auth_mode)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Input[str]:
        """
        The engine version of redis instance. Valid value: `4.0`, `5.0`, `6.0`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Input[int]:
        """
        The number of nodes in each shard, the valid value range is `1-6`. When the value is 1, it means creating a single node instance, and this field can not be modified. When the value is greater than 1, it means creating a primary and secondary instance, and this field can be modified.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: pulumi.Input[int]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter
    def password(self) -> pulumi.Input[str]:
        """
        The account password. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: pulumi.Input[str]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter(name="shardCapacity")
    def shard_capacity(self) -> pulumi.Input[int]:
        """
        The memory capacity of each shard, unit is MiB. The valid value range is as fallows: When the value of `ShardedCluster` is 0: 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536. When the value of `ShardedCluster` is 1: 1024, 2048, 4096, 8192, 16384. When the value of `node_number` is 1, the value of this field can not be 256.
        """
        return pulumi.get(self, "shard_capacity")

    @shard_capacity.setter
    def shard_capacity(self, value: pulumi.Input[int]):
        pulumi.set(self, "shard_capacity", value)

    @property
    @pulumi.getter(name="shardedCluster")
    def sharded_cluster(self) -> pulumi.Input[int]:
        """
        Whether enable sharded cluster for the current redis instance. Valid values: 0, 1. 0 means disable, 1 means enable.
        """
        return pulumi.get(self, "sharded_cluster")

    @sharded_cluster.setter
    def sharded_cluster(self, value: pulumi.Input[int]):
        pulumi.set(self, "sharded_cluster", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id of the redis instance. The specified subnet id must belong to the zone ids.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of zone IDs of instance. When creating a single node instance, only one zone id can be specified.
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "zone_ids", value)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to apply the instance configuration change operation immediately. The value of this field is false, means that the change operation will be applied within maintenance time.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable automatic renewal. This field is valid only when `ChargeType` is `PrePaid`, the default value is false. 
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="backupActive")
    def backup_active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable auto backup for redis instance. This field is valid and required when updating the backup plan of primary and secondary instance.
        """
        return pulumi.get(self, "backup_active")

    @backup_active.setter
    def backup_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_active", value)

    @property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[int]]:
        """
        The time period to start performing the backup. The valid value range is any integer between 0 and 23, where 0 means that the system will perform the backup in the period of 00:00~01:00, 1 means that the backup will be performed in the period of 01:00~02:00, and so on. 
        This field is valid and required when updating the backup plan of primary and secondary instance.
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_hour", value)

    @property
    @pulumi.getter(name="backupPeriods")
    def backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The backup period. The valid value can be any integer between 1 and 7. Among them, 1 means backup every Monday, 2 means backup every Tuesday, and so on. 
        This field is valid and required when updating the backup plan of primary and secondary instance.
        """
        return pulumi.get(self, "backup_periods")

    @backup_periods.setter
    def backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "backup_periods", value)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of redis instance. Valid value: `PostPaid`, `PrePaid`.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_type", value)

    @property
    @pulumi.getter(name="createBackup")
    def create_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a final backup when modify the instance configuration or destroy the redis instance.
        """
        return pulumi.get(self, "create_backup")

    @create_backup.setter
    def create_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_backup", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[str]]:
        """
        Whether enable deletion protection for redis instance. Valid values: `enabled`, `disabled`(default).
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the redis instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="paramValues")
    def param_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParamValueArgs']]]]:
        """
        The configuration item information to be modified. This field can only be added or modified. Deleting this field is invalid.
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields, or use the command `pulumi up` to perform a modification operation.
        """
        return pulumi.get(self, "param_values")

    @param_values.setter
    def param_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParamValueArgs']]]]):
        pulumi.set(self, "param_values", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port of custom define private network address. The valid value range is `1024-65535`. The default value is `6379`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name to which the redis instance belongs, if this parameter is empty, the new redis instance will not be added to any project.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="purchaseMonths")
    def purchase_months(self) -> Optional[pulumi.Input[int]]:
        """
        The purchase months of redis instance, the unit is month. the valid value range is as fallows: `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36`. This field is valid and required when `ChargeType` is `Prepaid`. 
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "purchase_months")

    @purchase_months.setter
    def purchase_months(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "purchase_months", value)

    @property
    @pulumi.getter(name="shardNumber")
    def shard_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards in redis instance, the valid value range is `2-256`. This field is valid and required when the value of `ShardedCluster` is 1.
        """
        return pulumi.get(self, "shard_number")

    @shard_number.setter
    def shard_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_number", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable password-free access when connecting to an instance through a private network. Valid values: `open`, `close`.
        """
        return pulumi.get(self, "vpc_auth_mode")

    @vpc_auth_mode.setter
    def vpc_auth_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_auth_mode", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 backup_active: Optional[pulumi.Input[bool]] = None,
                 backup_hour: Optional[pulumi.Input[int]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 create_backup: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 node_number: Optional[pulumi.Input[int]] = None,
                 param_values: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParamValueArgs']]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 purchase_months: Optional[pulumi.Input[int]] = None,
                 shard_capacity: Optional[pulumi.Input[int]] = None,
                 shard_number: Optional[pulumi.Input[int]] = None,
                 sharded_cluster: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[str]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[bool] apply_immediately: Whether to apply the instance configuration change operation immediately. The value of this field is false, means that the change operation will be applied within maintenance time.
        :param pulumi.Input[bool] auto_renew: Whether to enable automatic renewal. This field is valid only when `ChargeType` is `PrePaid`, the default value is false. 
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[bool] backup_active: Whether enable auto backup for redis instance. This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[int] backup_hour: The time period to start performing the backup. The valid value range is any integer between 0 and 23, where 0 means that the system will perform the backup in the period of 00:00~01:00, 1 means that the backup will be performed in the period of 01:00~02:00, and so on. 
               This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] backup_periods: The backup period. The valid value can be any integer between 1 and 7. Among them, 1 means backup every Monday, 2 means backup every Tuesday, and so on. 
               This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[str] charge_type: The charge type of redis instance. Valid value: `PostPaid`, `PrePaid`.
        :param pulumi.Input[bool] create_backup: Whether to create a final backup when modify the instance configuration or destroy the redis instance.
        :param pulumi.Input[str] deletion_protection: Whether enable deletion protection for redis instance. Valid values: `enabled`, `disabled`(default).
        :param pulumi.Input[str] engine_version: The engine version of redis instance. Valid value: `4.0`, `5.0`, `6.0`.
        :param pulumi.Input[str] instance_name: The name of the redis instance.
        :param pulumi.Input[int] node_number: The number of nodes in each shard, the valid value range is `1-6`. When the value is 1, it means creating a single node instance, and this field can not be modified. When the value is greater than 1, it means creating a primary and secondary instance, and this field can be modified.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceParamValueArgs']]] param_values: The configuration item information to be modified. This field can only be added or modified. Deleting this field is invalid.
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields, or use the command `pulumi up` to perform a modification operation.
        :param pulumi.Input[str] password: The account password. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] port: The port of custom define private network address. The valid value range is `1024-65535`. The default value is `6379`.
        :param pulumi.Input[str] project_name: The project name to which the redis instance belongs, if this parameter is empty, the new redis instance will not be added to any project.
        :param pulumi.Input[int] purchase_months: The purchase months of redis instance, the unit is month. the valid value range is as fallows: `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36`. This field is valid and required when `ChargeType` is `Prepaid`. 
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] shard_capacity: The memory capacity of each shard, unit is MiB. The valid value range is as fallows: When the value of `ShardedCluster` is 0: 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536. When the value of `ShardedCluster` is 1: 1024, 2048, 4096, 8192, 16384. When the value of `node_number` is 1, the value of this field can not be 256.
        :param pulumi.Input[int] shard_number: The number of shards in redis instance, the valid value range is `2-256`. This field is valid and required when the value of `ShardedCluster` is 1.
        :param pulumi.Input[int] sharded_cluster: Whether enable sharded cluster for the current redis instance. Valid values: 0, 1. 0 means disable, 1 means enable.
        :param pulumi.Input[str] subnet_id: The subnet id of the redis instance. The specified subnet id must belong to the zone ids.
        :param pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]] tags: Tags.
        :param pulumi.Input[str] vpc_auth_mode: Whether to enable password-free access when connecting to an instance through a private network. Valid values: `open`, `close`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The list of zone IDs of instance. When creating a single node instance, only one zone id can be specified.
        """
        if apply_immediately is not None:
            pulumi.set(__self__, "apply_immediately", apply_immediately)
        if auto_renew is not None:
            pulumi.set(__self__, "auto_renew", auto_renew)
        if backup_active is not None:
            pulumi.set(__self__, "backup_active", backup_active)
        if backup_hour is not None:
            pulumi.set(__self__, "backup_hour", backup_hour)
        if backup_periods is not None:
            pulumi.set(__self__, "backup_periods", backup_periods)
        if charge_type is not None:
            pulumi.set(__self__, "charge_type", charge_type)
        if create_backup is not None:
            pulumi.set(__self__, "create_backup", create_backup)
        if deletion_protection is not None:
            pulumi.set(__self__, "deletion_protection", deletion_protection)
        if engine_version is not None:
            pulumi.set(__self__, "engine_version", engine_version)
        if instance_name is not None:
            pulumi.set(__self__, "instance_name", instance_name)
        if node_number is not None:
            pulumi.set(__self__, "node_number", node_number)
        if param_values is not None:
            pulumi.set(__self__, "param_values", param_values)
        if password is not None:
            pulumi.set(__self__, "password", password)
        if port is not None:
            pulumi.set(__self__, "port", port)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if purchase_months is not None:
            pulumi.set(__self__, "purchase_months", purchase_months)
        if shard_capacity is not None:
            pulumi.set(__self__, "shard_capacity", shard_capacity)
        if shard_number is not None:
            pulumi.set(__self__, "shard_number", shard_number)
        if sharded_cluster is not None:
            pulumi.set(__self__, "sharded_cluster", sharded_cluster)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)
        if vpc_auth_mode is not None:
            pulumi.set(__self__, "vpc_auth_mode", vpc_auth_mode)
        if zone_ids is not None:
            pulumi.set(__self__, "zone_ids", zone_ids)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to apply the instance configuration change operation immediately. The value of this field is false, means that the change operation will be applied within maintenance time.
        """
        return pulumi.get(self, "apply_immediately")

    @apply_immediately.setter
    def apply_immediately(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "apply_immediately", value)

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to enable automatic renewal. This field is valid only when `ChargeType` is `PrePaid`, the default value is false. 
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew")

    @auto_renew.setter
    def auto_renew(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "auto_renew", value)

    @property
    @pulumi.getter(name="backupActive")
    def backup_active(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether enable auto backup for redis instance. This field is valid and required when updating the backup plan of primary and secondary instance.
        """
        return pulumi.get(self, "backup_active")

    @backup_active.setter
    def backup_active(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "backup_active", value)

    @property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> Optional[pulumi.Input[int]]:
        """
        The time period to start performing the backup. The valid value range is any integer between 0 and 23, where 0 means that the system will perform the backup in the period of 00:00~01:00, 1 means that the backup will be performed in the period of 01:00~02:00, and so on. 
        This field is valid and required when updating the backup plan of primary and secondary instance.
        """
        return pulumi.get(self, "backup_hour")

    @backup_hour.setter
    def backup_hour(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "backup_hour", value)

    @property
    @pulumi.getter(name="backupPeriods")
    def backup_periods(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]:
        """
        The backup period. The valid value can be any integer between 1 and 7. Among them, 1 means backup every Monday, 2 means backup every Tuesday, and so on. 
        This field is valid and required when updating the backup plan of primary and secondary instance.
        """
        return pulumi.get(self, "backup_periods")

    @backup_periods.setter
    def backup_periods(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]]):
        pulumi.set(self, "backup_periods", value)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[pulumi.Input[str]]:
        """
        The charge type of redis instance. Valid value: `PostPaid`, `PrePaid`.
        """
        return pulumi.get(self, "charge_type")

    @charge_type.setter
    def charge_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "charge_type", value)

    @property
    @pulumi.getter(name="createBackup")
    def create_backup(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to create a final backup when modify the instance configuration or destroy the redis instance.
        """
        return pulumi.get(self, "create_backup")

    @create_backup.setter
    def create_backup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_backup", value)

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> Optional[pulumi.Input[str]]:
        """
        Whether enable deletion protection for redis instance. Valid values: `enabled`, `disabled`(default).
        """
        return pulumi.get(self, "deletion_protection")

    @deletion_protection.setter
    def deletion_protection(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deletion_protection", value)

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[pulumi.Input[str]]:
        """
        The engine version of redis instance. Valid value: `4.0`, `5.0`, `6.0`.
        """
        return pulumi.get(self, "engine_version")

    @engine_version.setter
    def engine_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "engine_version", value)

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the redis instance.
        """
        return pulumi.get(self, "instance_name")

    @instance_name.setter
    def instance_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_name", value)

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in each shard, the valid value range is `1-6`. When the value is 1, it means creating a single node instance, and this field can not be modified. When the value is greater than 1, it means creating a primary and secondary instance, and this field can be modified.
        """
        return pulumi.get(self, "node_number")

    @node_number.setter
    def node_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_number", value)

    @property
    @pulumi.getter(name="paramValues")
    def param_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParamValueArgs']]]]:
        """
        The configuration item information to be modified. This field can only be added or modified. Deleting this field is invalid.
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields, or use the command `pulumi up` to perform a modification operation.
        """
        return pulumi.get(self, "param_values")

    @param_values.setter
    def param_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceParamValueArgs']]]]):
        pulumi.set(self, "param_values", value)

    @property
    @pulumi.getter
    def password(self) -> Optional[pulumi.Input[str]]:
        """
        The account password. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "password")

    @password.setter
    def password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "password", value)

    @property
    @pulumi.getter
    def port(self) -> Optional[pulumi.Input[int]]:
        """
        The port of custom define private network address. The valid value range is `1024-65535`. The default value is `6379`.
        """
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "port", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name to which the redis instance belongs, if this parameter is empty, the new redis instance will not be added to any project.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter(name="purchaseMonths")
    def purchase_months(self) -> Optional[pulumi.Input[int]]:
        """
        The purchase months of redis instance, the unit is month. the valid value range is as fallows: `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36`. This field is valid and required when `ChargeType` is `Prepaid`. 
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "purchase_months")

    @purchase_months.setter
    def purchase_months(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "purchase_months", value)

    @property
    @pulumi.getter(name="shardCapacity")
    def shard_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        The memory capacity of each shard, unit is MiB. The valid value range is as fallows: When the value of `ShardedCluster` is 0: 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536. When the value of `ShardedCluster` is 1: 1024, 2048, 4096, 8192, 16384. When the value of `node_number` is 1, the value of this field can not be 256.
        """
        return pulumi.get(self, "shard_capacity")

    @shard_capacity.setter
    def shard_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_capacity", value)

    @property
    @pulumi.getter(name="shardNumber")
    def shard_number(self) -> Optional[pulumi.Input[int]]:
        """
        The number of shards in redis instance, the valid value range is `2-256`. This field is valid and required when the value of `ShardedCluster` is 1.
        """
        return pulumi.get(self, "shard_number")

    @shard_number.setter
    def shard_number(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "shard_number", value)

    @property
    @pulumi.getter(name="shardedCluster")
    def sharded_cluster(self) -> Optional[pulumi.Input[int]]:
        """
        Whether enable sharded cluster for the current redis instance. Valid values: 0, 1. 0 means disable, 1 means enable.
        """
        return pulumi.get(self, "sharded_cluster")

    @sharded_cluster.setter
    def sharded_cluster(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "sharded_cluster", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet id of the redis instance. The specified subnet id must belong to the zone ids.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['InstanceTagArgs']]]]):
        pulumi.set(self, "tags", value)

    @property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> Optional[pulumi.Input[str]]:
        """
        Whether to enable password-free access when connecting to an instance through a private network. Valid values: `open`, `close`.
        """
        return pulumi.get(self, "vpc_auth_mode")

    @vpc_auth_mode.setter
    def vpc_auth_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_auth_mode", value)

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of zone IDs of instance. When creating a single node instance, only one zone id can be specified.
        """
        return pulumi.get(self, "zone_ids")

    @zone_ids.setter
    def zone_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "zone_ids", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 backup_active: Optional[pulumi.Input[bool]] = None,
                 backup_hour: Optional[pulumi.Input[int]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 create_backup: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 node_number: Optional[pulumi.Input[int]] = None,
                 param_values: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParamValueArgs']]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 purchase_months: Optional[pulumi.Input[int]] = None,
                 shard_capacity: Optional[pulumi.Input[int]] = None,
                 shard_number: Optional[pulumi.Input[int]] = None,
                 sharded_cluster: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[str]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.redis.Instance("fooInstance",
            zone_ids=[foo_zones.zones[0].id],
            instance_name="tf-test",
            sharded_cluster=1,
            password="1qaz!QAZ12",
            node_number=2,
            shard_capacity=1024,
            shard_number=2,
            engine_version="5.0",
            subnet_id=foo_subnet.id,
            deletion_protection="disabled",
            vpc_auth_mode="close",
            charge_type="PostPaid",
            port=6381,
            project_name="default",
            tags=[
                volcengine.redis.InstanceTagArgs(
                    key="k1",
                    value="v1",
                ),
                volcengine.redis.InstanceTagArgs(
                    key="k3",
                    value="v3",
                ),
            ],
            param_values=[
                volcengine.redis.InstanceParamValueArgs(
                    name="active-defrag-cycle-min",
                    value="5",
                ),
                volcengine.redis.InstanceParamValueArgs(
                    name="active-defrag-cycle-max",
                    value="28",
                ),
            ],
            backup_periods=[
                1,
                2,
                3,
            ],
            backup_hour=6,
            backup_active=True,
            create_backup=False,
            apply_immediately=True)
        ```

        ## Import

        redis instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:redis/instance:Instance default redis-n769ewmjjqyqh5dv
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_immediately: Whether to apply the instance configuration change operation immediately. The value of this field is false, means that the change operation will be applied within maintenance time.
        :param pulumi.Input[bool] auto_renew: Whether to enable automatic renewal. This field is valid only when `ChargeType` is `PrePaid`, the default value is false. 
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[bool] backup_active: Whether enable auto backup for redis instance. This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[int] backup_hour: The time period to start performing the backup. The valid value range is any integer between 0 and 23, where 0 means that the system will perform the backup in the period of 00:00~01:00, 1 means that the backup will be performed in the period of 01:00~02:00, and so on. 
               This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] backup_periods: The backup period. The valid value can be any integer between 1 and 7. Among them, 1 means backup every Monday, 2 means backup every Tuesday, and so on. 
               This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[str] charge_type: The charge type of redis instance. Valid value: `PostPaid`, `PrePaid`.
        :param pulumi.Input[bool] create_backup: Whether to create a final backup when modify the instance configuration or destroy the redis instance.
        :param pulumi.Input[str] deletion_protection: Whether enable deletion protection for redis instance. Valid values: `enabled`, `disabled`(default).
        :param pulumi.Input[str] engine_version: The engine version of redis instance. Valid value: `4.0`, `5.0`, `6.0`.
        :param pulumi.Input[str] instance_name: The name of the redis instance.
        :param pulumi.Input[int] node_number: The number of nodes in each shard, the valid value range is `1-6`. When the value is 1, it means creating a single node instance, and this field can not be modified. When the value is greater than 1, it means creating a primary and secondary instance, and this field can be modified.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParamValueArgs']]]] param_values: The configuration item information to be modified. This field can only be added or modified. Deleting this field is invalid.
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields, or use the command `pulumi up` to perform a modification operation.
        :param pulumi.Input[str] password: The account password. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] port: The port of custom define private network address. The valid value range is `1024-65535`. The default value is `6379`.
        :param pulumi.Input[str] project_name: The project name to which the redis instance belongs, if this parameter is empty, the new redis instance will not be added to any project.
        :param pulumi.Input[int] purchase_months: The purchase months of redis instance, the unit is month. the valid value range is as fallows: `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36`. This field is valid and required when `ChargeType` is `Prepaid`. 
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] shard_capacity: The memory capacity of each shard, unit is MiB. The valid value range is as fallows: When the value of `ShardedCluster` is 0: 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536. When the value of `ShardedCluster` is 1: 1024, 2048, 4096, 8192, 16384. When the value of `node_number` is 1, the value of this field can not be 256.
        :param pulumi.Input[int] shard_number: The number of shards in redis instance, the valid value range is `2-256`. This field is valid and required when the value of `ShardedCluster` is 1.
        :param pulumi.Input[int] sharded_cluster: Whether enable sharded cluster for the current redis instance. Valid values: 0, 1. 0 means disable, 1 means enable.
        :param pulumi.Input[str] subnet_id: The subnet id of the redis instance. The specified subnet id must belong to the zone ids.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] vpc_auth_mode: Whether to enable password-free access when connecting to an instance through a private network. Valid values: `open`, `close`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The list of zone IDs of instance. When creating a single node instance, only one zone id can be specified.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: InstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_instance = volcengine.redis.Instance("fooInstance",
            zone_ids=[foo_zones.zones[0].id],
            instance_name="tf-test",
            sharded_cluster=1,
            password="1qaz!QAZ12",
            node_number=2,
            shard_capacity=1024,
            shard_number=2,
            engine_version="5.0",
            subnet_id=foo_subnet.id,
            deletion_protection="disabled",
            vpc_auth_mode="close",
            charge_type="PostPaid",
            port=6381,
            project_name="default",
            tags=[
                volcengine.redis.InstanceTagArgs(
                    key="k1",
                    value="v1",
                ),
                volcengine.redis.InstanceTagArgs(
                    key="k3",
                    value="v3",
                ),
            ],
            param_values=[
                volcengine.redis.InstanceParamValueArgs(
                    name="active-defrag-cycle-min",
                    value="5",
                ),
                volcengine.redis.InstanceParamValueArgs(
                    name="active-defrag-cycle-max",
                    value="28",
                ),
            ],
            backup_periods=[
                1,
                2,
                3,
            ],
            backup_hour=6,
            backup_active=True,
            create_backup=False,
            apply_immediately=True)
        ```

        ## Import

        redis instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:redis/instance:Instance default redis-n769ewmjjqyqh5dv
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 apply_immediately: Optional[pulumi.Input[bool]] = None,
                 auto_renew: Optional[pulumi.Input[bool]] = None,
                 backup_active: Optional[pulumi.Input[bool]] = None,
                 backup_hour: Optional[pulumi.Input[int]] = None,
                 backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
                 charge_type: Optional[pulumi.Input[str]] = None,
                 create_backup: Optional[pulumi.Input[bool]] = None,
                 deletion_protection: Optional[pulumi.Input[str]] = None,
                 engine_version: Optional[pulumi.Input[str]] = None,
                 instance_name: Optional[pulumi.Input[str]] = None,
                 node_number: Optional[pulumi.Input[int]] = None,
                 param_values: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParamValueArgs']]]]] = None,
                 password: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 purchase_months: Optional[pulumi.Input[int]] = None,
                 shard_capacity: Optional[pulumi.Input[int]] = None,
                 shard_number: Optional[pulumi.Input[int]] = None,
                 sharded_cluster: Optional[pulumi.Input[int]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]]] = None,
                 vpc_auth_mode: Optional[pulumi.Input[str]] = None,
                 zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["apply_immediately"] = apply_immediately
            __props__.__dict__["auto_renew"] = auto_renew
            __props__.__dict__["backup_active"] = backup_active
            __props__.__dict__["backup_hour"] = backup_hour
            __props__.__dict__["backup_periods"] = backup_periods
            __props__.__dict__["charge_type"] = charge_type
            __props__.__dict__["create_backup"] = create_backup
            __props__.__dict__["deletion_protection"] = deletion_protection
            if engine_version is None and not opts.urn:
                raise TypeError("Missing required property 'engine_version'")
            __props__.__dict__["engine_version"] = engine_version
            __props__.__dict__["instance_name"] = instance_name
            if node_number is None and not opts.urn:
                raise TypeError("Missing required property 'node_number'")
            __props__.__dict__["node_number"] = node_number
            __props__.__dict__["param_values"] = param_values
            if password is None and not opts.urn:
                raise TypeError("Missing required property 'password'")
            __props__.__dict__["password"] = None if password is None else pulumi.Output.secret(password)
            __props__.__dict__["port"] = port
            __props__.__dict__["project_name"] = project_name
            __props__.__dict__["purchase_months"] = purchase_months
            if shard_capacity is None and not opts.urn:
                raise TypeError("Missing required property 'shard_capacity'")
            __props__.__dict__["shard_capacity"] = shard_capacity
            __props__.__dict__["shard_number"] = shard_number
            if sharded_cluster is None and not opts.urn:
                raise TypeError("Missing required property 'sharded_cluster'")
            __props__.__dict__["sharded_cluster"] = sharded_cluster
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["tags"] = tags
            __props__.__dict__["vpc_auth_mode"] = vpc_auth_mode
            if zone_ids is None and not opts.urn:
                raise TypeError("Missing required property 'zone_ids'")
            __props__.__dict__["zone_ids"] = zone_ids
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["password"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Instance, __self__).__init__(
            'volcengine:redis/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_immediately: Optional[pulumi.Input[bool]] = None,
            auto_renew: Optional[pulumi.Input[bool]] = None,
            backup_active: Optional[pulumi.Input[bool]] = None,
            backup_hour: Optional[pulumi.Input[int]] = None,
            backup_periods: Optional[pulumi.Input[Sequence[pulumi.Input[int]]]] = None,
            charge_type: Optional[pulumi.Input[str]] = None,
            create_backup: Optional[pulumi.Input[bool]] = None,
            deletion_protection: Optional[pulumi.Input[str]] = None,
            engine_version: Optional[pulumi.Input[str]] = None,
            instance_name: Optional[pulumi.Input[str]] = None,
            node_number: Optional[pulumi.Input[int]] = None,
            param_values: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParamValueArgs']]]]] = None,
            password: Optional[pulumi.Input[str]] = None,
            port: Optional[pulumi.Input[int]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            purchase_months: Optional[pulumi.Input[int]] = None,
            shard_capacity: Optional[pulumi.Input[int]] = None,
            shard_number: Optional[pulumi.Input[int]] = None,
            sharded_cluster: Optional[pulumi.Input[int]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]]] = None,
            vpc_auth_mode: Optional[pulumi.Input[str]] = None,
            zone_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] apply_immediately: Whether to apply the instance configuration change operation immediately. The value of this field is false, means that the change operation will be applied within maintenance time.
        :param pulumi.Input[bool] auto_renew: Whether to enable automatic renewal. This field is valid only when `ChargeType` is `PrePaid`, the default value is false. 
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[bool] backup_active: Whether enable auto backup for redis instance. This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[int] backup_hour: The time period to start performing the backup. The valid value range is any integer between 0 and 23, where 0 means that the system will perform the backup in the period of 00:00~01:00, 1 means that the backup will be performed in the period of 01:00~02:00, and so on. 
               This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[Sequence[pulumi.Input[int]]] backup_periods: The backup period. The valid value can be any integer between 1 and 7. Among them, 1 means backup every Monday, 2 means backup every Tuesday, and so on. 
               This field is valid and required when updating the backup plan of primary and secondary instance.
        :param pulumi.Input[str] charge_type: The charge type of redis instance. Valid value: `PostPaid`, `PrePaid`.
        :param pulumi.Input[bool] create_backup: Whether to create a final backup when modify the instance configuration or destroy the redis instance.
        :param pulumi.Input[str] deletion_protection: Whether enable deletion protection for redis instance. Valid values: `enabled`, `disabled`(default).
        :param pulumi.Input[str] engine_version: The engine version of redis instance. Valid value: `4.0`, `5.0`, `6.0`.
        :param pulumi.Input[str] instance_name: The name of the redis instance.
        :param pulumi.Input[int] node_number: The number of nodes in each shard, the valid value range is `1-6`. When the value is 1, it means creating a single node instance, and this field can not be modified. When the value is greater than 1, it means creating a primary and secondary instance, and this field can be modified.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceParamValueArgs']]]] param_values: The configuration item information to be modified. This field can only be added or modified. Deleting this field is invalid.
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields, or use the command `pulumi up` to perform a modification operation.
        :param pulumi.Input[str] password: The account password. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] port: The port of custom define private network address. The valid value range is `1024-65535`. The default value is `6379`.
        :param pulumi.Input[str] project_name: The project name to which the redis instance belongs, if this parameter is empty, the new redis instance will not be added to any project.
        :param pulumi.Input[int] purchase_months: The purchase months of redis instance, the unit is month. the valid value range is as fallows: `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36`. This field is valid and required when `ChargeType` is `Prepaid`. 
               When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[int] shard_capacity: The memory capacity of each shard, unit is MiB. The valid value range is as fallows: When the value of `ShardedCluster` is 0: 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536. When the value of `ShardedCluster` is 1: 1024, 2048, 4096, 8192, 16384. When the value of `node_number` is 1, the value of this field can not be 256.
        :param pulumi.Input[int] shard_number: The number of shards in redis instance, the valid value range is `2-256`. This field is valid and required when the value of `ShardedCluster` is 1.
        :param pulumi.Input[int] sharded_cluster: Whether enable sharded cluster for the current redis instance. Valid values: 0, 1. 0 means disable, 1 means enable.
        :param pulumi.Input[str] subnet_id: The subnet id of the redis instance. The specified subnet id must belong to the zone ids.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['InstanceTagArgs']]]] tags: Tags.
        :param pulumi.Input[str] vpc_auth_mode: Whether to enable password-free access when connecting to an instance through a private network. Valid values: `open`, `close`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] zone_ids: The list of zone IDs of instance. When creating a single node instance, only one zone id can be specified.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["apply_immediately"] = apply_immediately
        __props__.__dict__["auto_renew"] = auto_renew
        __props__.__dict__["backup_active"] = backup_active
        __props__.__dict__["backup_hour"] = backup_hour
        __props__.__dict__["backup_periods"] = backup_periods
        __props__.__dict__["charge_type"] = charge_type
        __props__.__dict__["create_backup"] = create_backup
        __props__.__dict__["deletion_protection"] = deletion_protection
        __props__.__dict__["engine_version"] = engine_version
        __props__.__dict__["instance_name"] = instance_name
        __props__.__dict__["node_number"] = node_number
        __props__.__dict__["param_values"] = param_values
        __props__.__dict__["password"] = password
        __props__.__dict__["port"] = port
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["purchase_months"] = purchase_months
        __props__.__dict__["shard_capacity"] = shard_capacity
        __props__.__dict__["shard_number"] = shard_number
        __props__.__dict__["sharded_cluster"] = sharded_cluster
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["tags"] = tags
        __props__.__dict__["vpc_auth_mode"] = vpc_auth_mode
        __props__.__dict__["zone_ids"] = zone_ids
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyImmediately")
    def apply_immediately(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to apply the instance configuration change operation immediately. The value of this field is false, means that the change operation will be applied within maintenance time.
        """
        return pulumi.get(self, "apply_immediately")

    @property
    @pulumi.getter(name="autoRenew")
    def auto_renew(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to enable automatic renewal. This field is valid only when `ChargeType` is `PrePaid`, the default value is false. 
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "auto_renew")

    @property
    @pulumi.getter(name="backupActive")
    def backup_active(self) -> pulumi.Output[bool]:
        """
        Whether enable auto backup for redis instance. This field is valid and required when updating the backup plan of primary and secondary instance.
        """
        return pulumi.get(self, "backup_active")

    @property
    @pulumi.getter(name="backupHour")
    def backup_hour(self) -> pulumi.Output[int]:
        """
        The time period to start performing the backup. The valid value range is any integer between 0 and 23, where 0 means that the system will perform the backup in the period of 00:00~01:00, 1 means that the backup will be performed in the period of 01:00~02:00, and so on. 
        This field is valid and required when updating the backup plan of primary and secondary instance.
        """
        return pulumi.get(self, "backup_hour")

    @property
    @pulumi.getter(name="backupPeriods")
    def backup_periods(self) -> pulumi.Output[Sequence[int]]:
        """
        The backup period. The valid value can be any integer between 1 and 7. Among them, 1 means backup every Monday, 2 means backup every Tuesday, and so on. 
        This field is valid and required when updating the backup plan of primary and secondary instance.
        """
        return pulumi.get(self, "backup_periods")

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> pulumi.Output[Optional[str]]:
        """
        The charge type of redis instance. Valid value: `PostPaid`, `PrePaid`.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="createBackup")
    def create_backup(self) -> pulumi.Output[Optional[bool]]:
        """
        Whether to create a final backup when modify the instance configuration or destroy the redis instance.
        """
        return pulumi.get(self, "create_backup")

    @property
    @pulumi.getter(name="deletionProtection")
    def deletion_protection(self) -> pulumi.Output[Optional[str]]:
        """
        Whether enable deletion protection for redis instance. Valid values: `enabled`, `disabled`(default).
        """
        return pulumi.get(self, "deletion_protection")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> pulumi.Output[str]:
        """
        The engine version of redis instance. Valid value: `4.0`, `5.0`, `6.0`.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> pulumi.Output[Optional[str]]:
        """
        The name of the redis instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="nodeNumber")
    def node_number(self) -> pulumi.Output[int]:
        """
        The number of nodes in each shard, the valid value range is `1-6`. When the value is 1, it means creating a single node instance, and this field can not be modified. When the value is greater than 1, it means creating a primary and secondary instance, and this field can be modified.
        """
        return pulumi.get(self, "node_number")

    @property
    @pulumi.getter(name="paramValues")
    def param_values(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceParamValue']]]:
        """
        The configuration item information to be modified. This field can only be added or modified. Deleting this field is invalid.
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields, or use the command `pulumi up` to perform a modification operation.
        """
        return pulumi.get(self, "param_values")

    @property
    @pulumi.getter
    def password(self) -> pulumi.Output[str]:
        """
        The account password. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter
    def port(self) -> pulumi.Output[Optional[int]]:
        """
        The port of custom define private network address. The valid value range is `1024-65535`. The default value is `6379`.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name to which the redis instance belongs, if this parameter is empty, the new redis instance will not be added to any project.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="purchaseMonths")
    def purchase_months(self) -> pulumi.Output[Optional[int]]:
        """
        The purchase months of redis instance, the unit is month. the valid value range is as fallows: `1, 2, 3, 4, 5, 6, 7, 8, 9, 12, 24, 36`. This field is valid and required when `ChargeType` is `Prepaid`. 
        When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "purchase_months")

    @property
    @pulumi.getter(name="shardCapacity")
    def shard_capacity(self) -> pulumi.Output[int]:
        """
        The memory capacity of each shard, unit is MiB. The valid value range is as fallows: When the value of `ShardedCluster` is 0: 256, 1024, 2048, 4096, 8192, 16384, 32768, 65536. When the value of `ShardedCluster` is 1: 1024, 2048, 4096, 8192, 16384. When the value of `node_number` is 1, the value of this field can not be 256.
        """
        return pulumi.get(self, "shard_capacity")

    @property
    @pulumi.getter(name="shardNumber")
    def shard_number(self) -> pulumi.Output[int]:
        """
        The number of shards in redis instance, the valid value range is `2-256`. This field is valid and required when the value of `ShardedCluster` is 1.
        """
        return pulumi.get(self, "shard_number")

    @property
    @pulumi.getter(name="shardedCluster")
    def sharded_cluster(self) -> pulumi.Output[int]:
        """
        Whether enable sharded cluster for the current redis instance. Valid values: 0, 1. 0 means disable, 1 means enable.
        """
        return pulumi.get(self, "sharded_cluster")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The subnet id of the redis instance. The specified subnet id must belong to the zone ids.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.InstanceTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="vpcAuthMode")
    def vpc_auth_mode(self) -> pulumi.Output[str]:
        """
        Whether to enable password-free access when connecting to an instance through a private network. Valid values: `open`, `close`.
        """
        return pulumi.get(self, "vpc_auth_mode")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The list of zone IDs of instance. When creating a single node instance, only one zone id can be specified.
        """
        return pulumi.get(self, "zone_ids")

