# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'InstancesResult',
    'AwaitableInstancesResult',
    'instances',
    'instances_output',
]

@pulumi.output_type
class InstancesResult:
    """
    A collection of values returned by Instances.
    """
    def __init__(__self__, charge_type=None, engine_version=None, id=None, instance_id=None, instance_name=None, instances=None, name_regex=None, output_file=None, project_name=None, sharded_cluster=None, status=None, tags=None, total_count=None, vpc_id=None, zone_id=None):
        if charge_type and not isinstance(charge_type, str):
            raise TypeError("Expected argument 'charge_type' to be a str")
        pulumi.set(__self__, "charge_type", charge_type)
        if engine_version and not isinstance(engine_version, str):
            raise TypeError("Expected argument 'engine_version' to be a str")
        pulumi.set(__self__, "engine_version", engine_version)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_id and not isinstance(instance_id, str):
            raise TypeError("Expected argument 'instance_id' to be a str")
        pulumi.set(__self__, "instance_id", instance_id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_name and not isinstance(project_name, str):
            raise TypeError("Expected argument 'project_name' to be a str")
        pulumi.set(__self__, "project_name", project_name)
        if sharded_cluster and not isinstance(sharded_cluster, int):
            raise TypeError("Expected argument 'sharded_cluster' to be a int")
        pulumi.set(__self__, "sharded_cluster", sharded_cluster)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if vpc_id and not isinstance(vpc_id, str):
            raise TypeError("Expected argument 'vpc_id' to be a str")
        pulumi.set(__self__, "vpc_id", vpc_id)
        if zone_id and not isinstance(zone_id, str):
            raise TypeError("Expected argument 'zone_id' to be a str")
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="chargeType")
    def charge_type(self) -> Optional[str]:
        """
        The charge type of the redis instance.
        """
        return pulumi.get(self, "charge_type")

    @property
    @pulumi.getter(name="engineVersion")
    def engine_version(self) -> Optional[str]:
        """
        The engine version of the redis instance.
        """
        return pulumi.get(self, "engine_version")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[str]:
        """
        The id of the redis instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> Optional[str]:
        """
        The name of the redis instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.InstancesInstanceResult']:
        """
        The collection of redis instances query.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[str]:
        """
        The project name of the redis instance.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter(name="shardedCluster")
    def sharded_cluster(self) -> Optional[int]:
        """
        Whether enable sharded cluster for the redis instance.
        """
        return pulumi.get(self, "sharded_cluster")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the redis instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.InstancesTagResult']]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of redis instances query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[str]:
        """
        The vpc ID of the redis instance.
        """
        return pulumi.get(self, "vpc_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[str]:
        return pulumi.get(self, "zone_id")


class AwaitableInstancesResult(InstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return InstancesResult(
            charge_type=self.charge_type,
            engine_version=self.engine_version,
            id=self.id,
            instance_id=self.instance_id,
            instance_name=self.instance_name,
            instances=self.instances,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project_name=self.project_name,
            sharded_cluster=self.sharded_cluster,
            status=self.status,
            tags=self.tags,
            total_count=self.total_count,
            vpc_id=self.vpc_id,
            zone_id=self.zone_id)


def instances(charge_type: Optional[str] = None,
              engine_version: Optional[str] = None,
              instance_id: Optional[str] = None,
              instance_name: Optional[str] = None,
              name_regex: Optional[str] = None,
              output_file: Optional[str] = None,
              project_name: Optional[str] = None,
              sharded_cluster: Optional[int] = None,
              status: Optional[str] = None,
              tags: Optional[Sequence[pulumi.InputType['InstancesTagArgs']]] = None,
              vpc_id: Optional[str] = None,
              zone_id: Optional[str] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableInstancesResult:
    """
    Use this data source to query detailed information of redis instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_instance = volcengine.redis.Instance("fooInstance",
        zone_ids=[foo_zones.zones[0].id],
        instance_name="acc-test-tf-redis",
        sharded_cluster=1,
        password="1qaz!QAZ12",
        node_number=2,
        shard_capacity=1024,
        shard_number=2,
        engine_version="5.0",
        subnet_id=foo_subnet.id,
        deletion_protection="disabled",
        vpc_auth_mode="close",
        charge_type="PostPaid",
        port=6381,
        project_name="default")
    foo_instances = volcengine.redis.instances_output(instance_id=foo_instance.id)
    ```


    :param str charge_type: The charge type of redis instance to query. Valid values: `PostPaid`, `PrePaid`.
    :param str engine_version: The engine version of redis instance to query. Valid values: `4.0`, `5.0`, `6.0`.
    :param str instance_id: The id of redis instance to query. This field supports fuzzy queries.
    :param str instance_name: The name of redis instance to query. This field supports fuzzy queries.
    :param str name_regex: A name regex of redis.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of redis instance to query.
    :param int sharded_cluster: Whether enable sharded cluster for redis instance. Valid values: 0, 1.
    :param str status: The status of redis instance to query.
    :param Sequence[pulumi.InputType['InstancesTagArgs']] tags: Tags.
    :param str vpc_id: The vpc id of redis instance to query. This field supports fuzzy queries.
    :param str zone_id: The zone id of redis instance to query. This field supports fuzzy queries.
    """
    __args__ = dict()
    __args__['chargeType'] = charge_type
    __args__['engineVersion'] = engine_version
    __args__['instanceId'] = instance_id
    __args__['instanceName'] = instance_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectName'] = project_name
    __args__['shardedCluster'] = sharded_cluster
    __args__['status'] = status
    __args__['tags'] = tags
    __args__['vpcId'] = vpc_id
    __args__['zoneId'] = zone_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:redis/instances:Instances', __args__, opts=opts, typ=InstancesResult).value

    return AwaitableInstancesResult(
        charge_type=pulumi.get(__ret__, 'charge_type'),
        engine_version=pulumi.get(__ret__, 'engine_version'),
        id=pulumi.get(__ret__, 'id'),
        instance_id=pulumi.get(__ret__, 'instance_id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        instances=pulumi.get(__ret__, 'instances'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_name=pulumi.get(__ret__, 'project_name'),
        sharded_cluster=pulumi.get(__ret__, 'sharded_cluster'),
        status=pulumi.get(__ret__, 'status'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        vpc_id=pulumi.get(__ret__, 'vpc_id'),
        zone_id=pulumi.get(__ret__, 'zone_id'))


@_utilities.lift_output_func(instances)
def instances_output(charge_type: Optional[pulumi.Input[Optional[str]]] = None,
                     engine_version: Optional[pulumi.Input[Optional[str]]] = None,
                     instance_id: Optional[pulumi.Input[Optional[str]]] = None,
                     instance_name: Optional[pulumi.Input[Optional[str]]] = None,
                     name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     project_name: Optional[pulumi.Input[Optional[str]]] = None,
                     sharded_cluster: Optional[pulumi.Input[Optional[int]]] = None,
                     status: Optional[pulumi.Input[Optional[str]]] = None,
                     tags: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['InstancesTagArgs']]]]] = None,
                     vpc_id: Optional[pulumi.Input[Optional[str]]] = None,
                     zone_id: Optional[pulumi.Input[Optional[str]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[InstancesResult]:
    """
    Use this data source to query detailed information of redis instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_instance = volcengine.redis.Instance("fooInstance",
        zone_ids=[foo_zones.zones[0].id],
        instance_name="acc-test-tf-redis",
        sharded_cluster=1,
        password="1qaz!QAZ12",
        node_number=2,
        shard_capacity=1024,
        shard_number=2,
        engine_version="5.0",
        subnet_id=foo_subnet.id,
        deletion_protection="disabled",
        vpc_auth_mode="close",
        charge_type="PostPaid",
        port=6381,
        project_name="default")
    foo_instances = volcengine.redis.instances_output(instance_id=foo_instance.id)
    ```


    :param str charge_type: The charge type of redis instance to query. Valid values: `PostPaid`, `PrePaid`.
    :param str engine_version: The engine version of redis instance to query. Valid values: `4.0`, `5.0`, `6.0`.
    :param str instance_id: The id of redis instance to query. This field supports fuzzy queries.
    :param str instance_name: The name of redis instance to query. This field supports fuzzy queries.
    :param str name_regex: A name regex of redis.
    :param str output_file: File name where to save data source results.
    :param str project_name: The project name of redis instance to query.
    :param int sharded_cluster: Whether enable sharded cluster for redis instance. Valid values: 0, 1.
    :param str status: The status of redis instance to query.
    :param Sequence[pulumi.InputType['InstancesTagArgs']] tags: Tags.
    :param str vpc_id: The vpc id of redis instance to query. This field supports fuzzy queries.
    :param str zone_id: The zone id of redis instance to query. This field supports fuzzy queries.
    """
    ...
