# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'AlarmAlarmPeriodDetailArgs',
    'AlarmNotifyGroupReceiverArgs',
    'AlarmQueryRequestArgs',
    'AlarmRequestCycleArgs',
    'IndexFullTextArgs',
    'IndexKeyValueArgs',
    'IndexKeyValueJsonKeyArgs',
    'IndexUserInnerKeyValueArgs',
    'IndexUserInnerKeyValueJsonKeyArgs',
    'ProjectTagArgs',
    'ProjectsTagArgs',
    'RuleContainerRuleArgs',
    'RuleContainerRuleKubernetesRuleArgs',
    'RuleExcludePathArgs',
    'RuleExtractRuleArgs',
    'RuleExtractRuleFilterKeyRegexArgs',
    'RuleExtractRuleLogTemplateArgs',
    'RuleUserDefineRuleArgs',
    'RuleUserDefineRuleAdvancedArgs',
    'RuleUserDefineRuleParsePathRuleArgs',
    'RuleUserDefineRulePluginArgs',
    'RuleUserDefineRuleShardHashKeyArgs',
    'TopicTagArgs',
    'TopicsTagArgs',
]

@pulumi.input_type
class AlarmAlarmPeriodDetailArgs:
    def __init__(__self__, *,
                 email: pulumi.Input[int],
                 general_webhook: pulumi.Input[int],
                 phone: pulumi.Input[int],
                 sms: pulumi.Input[int]):
        """
        :param pulumi.Input[int] email: Email alarm period, the unit is minutes, and the value range is 1~1440.
        :param pulumi.Input[int] general_webhook: Customize the webhook alarm period, the unit is minutes, and the value range is 1~1440.
        :param pulumi.Input[int] phone: Telephone alarm cycle, the unit is minutes, and the value range is 10~1440.
        :param pulumi.Input[int] sms: SMS alarm cycle, the unit is minutes, and the value range is 10~1440.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "general_webhook", general_webhook)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "sms", sms)

    @property
    @pulumi.getter
    def email(self) -> pulumi.Input[int]:
        """
        Email alarm period, the unit is minutes, and the value range is 1~1440.
        """
        return pulumi.get(self, "email")

    @email.setter
    def email(self, value: pulumi.Input[int]):
        pulumi.set(self, "email", value)

    @property
    @pulumi.getter(name="generalWebhook")
    def general_webhook(self) -> pulumi.Input[int]:
        """
        Customize the webhook alarm period, the unit is minutes, and the value range is 1~1440.
        """
        return pulumi.get(self, "general_webhook")

    @general_webhook.setter
    def general_webhook(self, value: pulumi.Input[int]):
        pulumi.set(self, "general_webhook", value)

    @property
    @pulumi.getter
    def phone(self) -> pulumi.Input[int]:
        """
        Telephone alarm cycle, the unit is minutes, and the value range is 10~1440.
        """
        return pulumi.get(self, "phone")

    @phone.setter
    def phone(self, value: pulumi.Input[int]):
        pulumi.set(self, "phone", value)

    @property
    @pulumi.getter
    def sms(self) -> pulumi.Input[int]:
        """
        SMS alarm cycle, the unit is minutes, and the value range is 10~1440.
        """
        return pulumi.get(self, "sms")

    @sms.setter
    def sms(self, value: pulumi.Input[int]):
        pulumi.set(self, "sms", value)


@pulumi.input_type
class AlarmNotifyGroupReceiverArgs:
    def __init__(__self__, *,
                 end_time: pulumi.Input[str],
                 receiver_channels: pulumi.Input[Sequence[pulumi.Input[str]]],
                 receiver_names: pulumi.Input[Sequence[pulumi.Input[str]]],
                 receiver_type: pulumi.Input[str],
                 start_time: pulumi.Input[str]):
        """
        :param pulumi.Input[str] end_time: The end time.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] receiver_channels: The list of the receiver channels. Currently supported channels: Email, Sms, Phone.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] receiver_names: List of the receiver names.
        :param pulumi.Input[str] receiver_type: The receiver type, Can be set as: `User`(The id of user).
        :param pulumi.Input[str] start_time: The start time.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "receiver_channels", receiver_channels)
        pulumi.set(__self__, "receiver_names", receiver_names)
        pulumi.set(__self__, "receiver_type", receiver_type)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> pulumi.Input[str]:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="receiverChannels")
    def receiver_channels(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The list of the receiver channels. Currently supported channels: Email, Sms, Phone.
        """
        return pulumi.get(self, "receiver_channels")

    @receiver_channels.setter
    def receiver_channels(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "receiver_channels", value)

    @property
    @pulumi.getter(name="receiverNames")
    def receiver_names(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        List of the receiver names.
        """
        return pulumi.get(self, "receiver_names")

    @receiver_names.setter
    def receiver_names(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "receiver_names", value)

    @property
    @pulumi.getter(name="receiverType")
    def receiver_type(self) -> pulumi.Input[str]:
        """
        The receiver type, Can be set as: `User`(The id of user).
        """
        return pulumi.get(self, "receiver_type")

    @receiver_type.setter
    def receiver_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "receiver_type", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> pulumi.Input[str]:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "start_time", value)


@pulumi.input_type
class AlarmQueryRequestArgs:
    def __init__(__self__, *,
                 end_time_offset: pulumi.Input[int],
                 number: pulumi.Input[int],
                 query: pulumi.Input[str],
                 start_time_offset: pulumi.Input[int],
                 topic_id: pulumi.Input[str]):
        """
        :param pulumi.Input[int] end_time_offset: The end time of the query range is relative to the current historical time. The unit is minutes. The value is not positive and must be greater than StartTimeOffset. The maximum value is 0 and the minimum value is -1440.
        :param pulumi.Input[int] number: Alarm object sequence number; increments from 1.
        :param pulumi.Input[str] query: Query statement, the maximum supported length is 1024.
        :param pulumi.Input[int] start_time_offset: The start time of the query range is relative to the current historical time, in minutes. The value is non-positive, the maximum value is 0, and the minimum value is -1440.
        :param pulumi.Input[str] topic_id: The id of the topic.
        """
        pulumi.set(__self__, "end_time_offset", end_time_offset)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "start_time_offset", start_time_offset)
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> pulumi.Input[int]:
        """
        The end time of the query range is relative to the current historical time. The unit is minutes. The value is not positive and must be greater than StartTimeOffset. The maximum value is 0 and the minimum value is -1440.
        """
        return pulumi.get(self, "end_time_offset")

    @end_time_offset.setter
    def end_time_offset(self, value: pulumi.Input[int]):
        pulumi.set(self, "end_time_offset", value)

    @property
    @pulumi.getter
    def number(self) -> pulumi.Input[int]:
        """
        Alarm object sequence number; increments from 1.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: pulumi.Input[int]):
        pulumi.set(self, "number", value)

    @property
    @pulumi.getter
    def query(self) -> pulumi.Input[str]:
        """
        Query statement, the maximum supported length is 1024.
        """
        return pulumi.get(self, "query")

    @query.setter
    def query(self, value: pulumi.Input[str]):
        pulumi.set(self, "query", value)

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> pulumi.Input[int]:
        """
        The start time of the query range is relative to the current historical time, in minutes. The value is non-positive, the maximum value is 0, and the minimum value is -1440.
        """
        return pulumi.get(self, "start_time_offset")

    @start_time_offset.setter
    def start_time_offset(self, value: pulumi.Input[int]):
        pulumi.set(self, "start_time_offset", value)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Input[str]:
        """
        The id of the topic.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_id", value)


@pulumi.input_type
class AlarmRequestCycleArgs:
    def __init__(__self__, *,
                 time: pulumi.Input[int],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[int] time: The cycle of alarm task execution, or the time point of periodic execution. The unit is minutes, and the value range is 1~1440.
        :param pulumi.Input[str] type: Execution cycle type.
               Period: Periodic execution, which means executing once every certain period of time.
               Fixed: Regular execution, which means executing at a fixed time point every day.
        """
        pulumi.set(__self__, "time", time)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def time(self) -> pulumi.Input[int]:
        """
        The cycle of alarm task execution, or the time point of periodic execution. The unit is minutes, and the value range is 1~1440.
        """
        return pulumi.get(self, "time")

    @time.setter
    def time(self, value: pulumi.Input[int]):
        pulumi.set(self, "time", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Execution cycle type.
        Period: Periodic execution, which means executing once every certain period of time.
        Fixed: Regular execution, which means executing at a fixed time point every day.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class IndexFullTextArgs:
    def __init__(__self__, *,
                 case_sensitive: pulumi.Input[bool],
                 delimiter: Optional[pulumi.Input[str]] = None,
                 include_chinese: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[bool] case_sensitive: Whether the FullTextInfo is case sensitive.
        :param pulumi.Input[str] delimiter: The delimiter of the FullTextInfo.
        :param pulumi.Input[bool] include_chinese: Whether the FullTextInfo include chinese.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> pulumi.Input[bool]:
        """
        Whether the FullTextInfo is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: pulumi.Input[bool]):
        pulumi.set(self, "case_sensitive", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        The delimiter of the FullTextInfo.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the FullTextInfo include chinese.
        """
        return pulumi.get(self, "include_chinese")

    @include_chinese.setter
    def include_chinese(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_chinese", value)


@pulumi.input_type
class IndexKeyValueArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value_type: pulumi.Input[str],
                 case_sensitive: Optional[pulumi.Input[bool]] = None,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 include_chinese: Optional[pulumi.Input[bool]] = None,
                 json_keys: Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyValueJsonKeyArgs']]]] = None,
                 sql_flag: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] key: The key of the KeyValueInfo.
        :param pulumi.Input[str] value_type: The type of value. Valid values: `long`, `double`, `text`, `json`.
        :param pulumi.Input[bool] case_sensitive: Whether the value is case sensitive.
        :param pulumi.Input[str] delimiter: The delimiter of the value.
        :param pulumi.Input[bool] include_chinese: Whether the value include chinese.
        :param pulumi.Input[Sequence[pulumi.Input['IndexKeyValueJsonKeyArgs']]] json_keys: The JSON subfield key value index.
        :param pulumi.Input[bool] sql_flag: Whether the filed is enabled for analysis.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if json_keys is not None:
            pulumi.set(__self__, "json_keys", json_keys)
        if sql_flag is not None:
            pulumi.set(__self__, "sql_flag", sql_flag)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key of the KeyValueInfo.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Input[str]:
        """
        The type of value. Valid values: `long`, `double`, `text`, `json`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "value_type", value)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the value is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "case_sensitive", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        The delimiter of the value.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the value include chinese.
        """
        return pulumi.get(self, "include_chinese")

    @include_chinese.setter
    def include_chinese(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_chinese", value)

    @property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyValueJsonKeyArgs']]]]:
        """
        The JSON subfield key value index.
        """
        return pulumi.get(self, "json_keys")

    @json_keys.setter
    def json_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyValueJsonKeyArgs']]]]):
        pulumi.set(self, "json_keys", value)

    @property
    @pulumi.getter(name="sqlFlag")
    def sql_flag(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the filed is enabled for analysis.
        """
        return pulumi.get(self, "sql_flag")

    @sql_flag.setter
    def sql_flag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sql_flag", value)


@pulumi.input_type
class IndexKeyValueJsonKeyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The key of the subfield key value index.
        :param pulumi.Input[str] value_type: The type of value. Valid values: `long`, `double`, `text`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key of the subfield key value index.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Input[str]:
        """
        The type of value. Valid values: `long`, `double`, `text`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class IndexUserInnerKeyValueArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value_type: pulumi.Input[str],
                 case_sensitive: Optional[pulumi.Input[bool]] = None,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 include_chinese: Optional[pulumi.Input[bool]] = None,
                 json_keys: Optional[pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueJsonKeyArgs']]]] = None,
                 sql_flag: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] key: The key of the KeyValueInfo.
        :param pulumi.Input[str] value_type: The type of value. Valid values: `long`, `double`, `text`, `json`.
        :param pulumi.Input[bool] case_sensitive: Whether the value is case sensitive.
        :param pulumi.Input[str] delimiter: The delimiter of the value.
        :param pulumi.Input[bool] include_chinese: Whether the value include chinese.
        :param pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueJsonKeyArgs']]] json_keys: The JSON subfield key value index.
        :param pulumi.Input[bool] sql_flag: Whether the filed is enabled for analysis.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if json_keys is not None:
            pulumi.set(__self__, "json_keys", json_keys)
        if sql_flag is not None:
            pulumi.set(__self__, "sql_flag", sql_flag)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key of the KeyValueInfo.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Input[str]:
        """
        The type of value. Valid values: `long`, `double`, `text`, `json`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "value_type", value)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the value is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @case_sensitive.setter
    def case_sensitive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "case_sensitive", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        The delimiter of the value.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the value include chinese.
        """
        return pulumi.get(self, "include_chinese")

    @include_chinese.setter
    def include_chinese(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "include_chinese", value)

    @property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueJsonKeyArgs']]]]:
        """
        The JSON subfield key value index.
        """
        return pulumi.get(self, "json_keys")

    @json_keys.setter
    def json_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueJsonKeyArgs']]]]):
        pulumi.set(self, "json_keys", value)

    @property
    @pulumi.getter(name="sqlFlag")
    def sql_flag(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the filed is enabled for analysis.
        """
        return pulumi.get(self, "sql_flag")

    @sql_flag.setter
    def sql_flag(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sql_flag", value)


@pulumi.input_type
class IndexUserInnerKeyValueJsonKeyArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value_type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The key of the subfield key value index.
        :param pulumi.Input[str] value_type: The type of value. Valid values: `long`, `double`, `text`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The key of the subfield key value index.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> pulumi.Input[str]:
        """
        The type of value. Valid values: `long`, `double`, `text`.
        """
        return pulumi.get(self, "value_type")

    @value_type.setter
    def value_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "value_type", value)


@pulumi.input_type
class ProjectTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The Key of Tags.
        :param pulumi.Input[str] value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class ProjectsTagArgs:
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: str):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RuleContainerRuleArgs:
    def __init__(__self__, *,
                 stream: pulumi.Input[str],
                 container_name_regex: Optional[pulumi.Input[str]] = None,
                 env_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 exclude_container_env_regex: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 exclude_container_label_regex: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 include_container_env_regex: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 include_container_label_regex: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 kubernetes_rule: Optional[pulumi.Input['RuleContainerRuleKubernetesRuleArgs']] = None):
        """
        :param pulumi.Input[str] stream: The collection mode.
        :param pulumi.Input[str] container_name_regex: The name of the container to be collected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] env_tag: Whether to add environment variables as log tags to raw log data.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] exclude_container_env_regex: The container environment variable blacklist is used to specify the range of containers not to be collected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] exclude_container_label_regex: The container Label blacklist is used to specify the range of containers not to be collected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] include_container_env_regex: The container environment variable whitelist specifies the container to be collected through the container environment variable. If the whitelist is not enabled, it means that all containers are specified to be collected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] include_container_label_regex: The container label whitelist specifies the containers to be collected through the container label. If the whitelist is not enabled, all containers are specified to be collected.
        :param pulumi.Input['RuleContainerRuleKubernetesRuleArgs'] kubernetes_rule: Collection rules for Kubernetes containers.
        """
        pulumi.set(__self__, "stream", stream)
        if container_name_regex is not None:
            pulumi.set(__self__, "container_name_regex", container_name_regex)
        if env_tag is not None:
            pulumi.set(__self__, "env_tag", env_tag)
        if exclude_container_env_regex is not None:
            pulumi.set(__self__, "exclude_container_env_regex", exclude_container_env_regex)
        if exclude_container_label_regex is not None:
            pulumi.set(__self__, "exclude_container_label_regex", exclude_container_label_regex)
        if include_container_env_regex is not None:
            pulumi.set(__self__, "include_container_env_regex", include_container_env_regex)
        if include_container_label_regex is not None:
            pulumi.set(__self__, "include_container_label_regex", include_container_label_regex)
        if kubernetes_rule is not None:
            pulumi.set(__self__, "kubernetes_rule", kubernetes_rule)

    @property
    @pulumi.getter
    def stream(self) -> pulumi.Input[str]:
        """
        The collection mode.
        """
        return pulumi.get(self, "stream")

    @stream.setter
    def stream(self, value: pulumi.Input[str]):
        pulumi.set(self, "stream", value)

    @property
    @pulumi.getter(name="containerNameRegex")
    def container_name_regex(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the container to be collected.
        """
        return pulumi.get(self, "container_name_regex")

    @container_name_regex.setter
    def container_name_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "container_name_regex", value)

    @property
    @pulumi.getter(name="envTag")
    def env_tag(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Whether to add environment variables as log tags to raw log data.
        """
        return pulumi.get(self, "env_tag")

    @env_tag.setter
    def env_tag(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "env_tag", value)

    @property
    @pulumi.getter(name="excludeContainerEnvRegex")
    def exclude_container_env_regex(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The container environment variable blacklist is used to specify the range of containers not to be collected.
        """
        return pulumi.get(self, "exclude_container_env_regex")

    @exclude_container_env_regex.setter
    def exclude_container_env_regex(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_container_env_regex", value)

    @property
    @pulumi.getter(name="excludeContainerLabelRegex")
    def exclude_container_label_regex(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The container Label blacklist is used to specify the range of containers not to be collected.
        """
        return pulumi.get(self, "exclude_container_label_regex")

    @exclude_container_label_regex.setter
    def exclude_container_label_regex(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_container_label_regex", value)

    @property
    @pulumi.getter(name="includeContainerEnvRegex")
    def include_container_env_regex(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The container environment variable whitelist specifies the container to be collected through the container environment variable. If the whitelist is not enabled, it means that all containers are specified to be collected.
        """
        return pulumi.get(self, "include_container_env_regex")

    @include_container_env_regex.setter
    def include_container_env_regex(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "include_container_env_regex", value)

    @property
    @pulumi.getter(name="includeContainerLabelRegex")
    def include_container_label_regex(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The container label whitelist specifies the containers to be collected through the container label. If the whitelist is not enabled, all containers are specified to be collected.
        """
        return pulumi.get(self, "include_container_label_regex")

    @include_container_label_regex.setter
    def include_container_label_regex(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "include_container_label_regex", value)

    @property
    @pulumi.getter(name="kubernetesRule")
    def kubernetes_rule(self) -> Optional[pulumi.Input['RuleContainerRuleKubernetesRuleArgs']]:
        """
        Collection rules for Kubernetes containers.
        """
        return pulumi.get(self, "kubernetes_rule")

    @kubernetes_rule.setter
    def kubernetes_rule(self, value: Optional[pulumi.Input['RuleContainerRuleKubernetesRuleArgs']]):
        pulumi.set(self, "kubernetes_rule", value)


@pulumi.input_type
class RuleContainerRuleKubernetesRuleArgs:
    def __init__(__self__, *,
                 annotation_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 exclude_pod_label_regex: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 include_pod_label_regex: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 label_tag: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 namespace_name_regex: Optional[pulumi.Input[str]] = None,
                 pod_name_regex: Optional[pulumi.Input[str]] = None,
                 workload_name_regex: Optional[pulumi.Input[str]] = None,
                 workload_type: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] annotation_tag: Whether to add Kubernetes Annotation as a log tag to the raw log data.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] exclude_pod_label_regex: Specify the containers not to be collected through the Pod Label blacklist, and not enable means to collect all containers.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] include_pod_label_regex: The Pod Label whitelist is used to specify containers to be collected. When the Pod Label whitelist is not enabled, it means that all containers are collected.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] label_tag: Whether to add Kubernetes Label as a log label to the original log data.
        :param pulumi.Input[str] namespace_name_regex: The name of the Kubernetes Namespace to be collected. If no Namespace name is specified, all containers will be collected. Namespace names support regular matching.
        :param pulumi.Input[str] pod_name_regex: The Pod name is used to specify the container to be collected. When no Pod name is specified, it means to collect all containers.
        :param pulumi.Input[str] workload_name_regex: Specify the container to be collected by the name of the workload. When no workload name is specified, all containers are collected. The workload name supports regular matching.
        :param pulumi.Input[str] workload_type: Specify the containers to be collected by the type of workload, only one type can be selected. When no type is specified, it means all types of containers are collected. The supported types of workloads are:
               Deployment: stateless workload.
               StatefulSet: stateful workload.
               DaemonSet: daemon process.
               Job: task.
               CronJob: scheduled task.
        """
        if annotation_tag is not None:
            pulumi.set(__self__, "annotation_tag", annotation_tag)
        if exclude_pod_label_regex is not None:
            pulumi.set(__self__, "exclude_pod_label_regex", exclude_pod_label_regex)
        if include_pod_label_regex is not None:
            pulumi.set(__self__, "include_pod_label_regex", include_pod_label_regex)
        if label_tag is not None:
            pulumi.set(__self__, "label_tag", label_tag)
        if namespace_name_regex is not None:
            pulumi.set(__self__, "namespace_name_regex", namespace_name_regex)
        if pod_name_regex is not None:
            pulumi.set(__self__, "pod_name_regex", pod_name_regex)
        if workload_name_regex is not None:
            pulumi.set(__self__, "workload_name_regex", workload_name_regex)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="annotationTag")
    def annotation_tag(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Whether to add Kubernetes Annotation as a log tag to the raw log data.
        """
        return pulumi.get(self, "annotation_tag")

    @annotation_tag.setter
    def annotation_tag(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "annotation_tag", value)

    @property
    @pulumi.getter(name="excludePodLabelRegex")
    def exclude_pod_label_regex(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specify the containers not to be collected through the Pod Label blacklist, and not enable means to collect all containers.
        """
        return pulumi.get(self, "exclude_pod_label_regex")

    @exclude_pod_label_regex.setter
    def exclude_pod_label_regex(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "exclude_pod_label_regex", value)

    @property
    @pulumi.getter(name="includePodLabelRegex")
    def include_pod_label_regex(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        The Pod Label whitelist is used to specify containers to be collected. When the Pod Label whitelist is not enabled, it means that all containers are collected.
        """
        return pulumi.get(self, "include_pod_label_regex")

    @include_pod_label_regex.setter
    def include_pod_label_regex(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "include_pod_label_regex", value)

    @property
    @pulumi.getter(name="labelTag")
    def label_tag(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Whether to add Kubernetes Label as a log label to the original log data.
        """
        return pulumi.get(self, "label_tag")

    @label_tag.setter
    def label_tag(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "label_tag", value)

    @property
    @pulumi.getter(name="namespaceNameRegex")
    def namespace_name_regex(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Kubernetes Namespace to be collected. If no Namespace name is specified, all containers will be collected. Namespace names support regular matching.
        """
        return pulumi.get(self, "namespace_name_regex")

    @namespace_name_regex.setter
    def namespace_name_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace_name_regex", value)

    @property
    @pulumi.getter(name="podNameRegex")
    def pod_name_regex(self) -> Optional[pulumi.Input[str]]:
        """
        The Pod name is used to specify the container to be collected. When no Pod name is specified, it means to collect all containers.
        """
        return pulumi.get(self, "pod_name_regex")

    @pod_name_regex.setter
    def pod_name_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "pod_name_regex", value)

    @property
    @pulumi.getter(name="workloadNameRegex")
    def workload_name_regex(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the container to be collected by the name of the workload. When no workload name is specified, all containers are collected. The workload name supports regular matching.
        """
        return pulumi.get(self, "workload_name_regex")

    @workload_name_regex.setter
    def workload_name_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_name_regex", value)

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specify the containers to be collected by the type of workload, only one type can be selected. When no type is specified, it means all types of containers are collected. The supported types of workloads are:
        Deployment: stateless workload.
        StatefulSet: stateful workload.
        DaemonSet: daemon process.
        Job: task.
        CronJob: scheduled task.
        """
        return pulumi.get(self, "workload_type")

    @workload_type.setter
    def workload_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "workload_type", value)


@pulumi.input_type
class RuleExcludePathArgs:
    def __init__(__self__, *,
                 type: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] type: Collection path type. The path type can be `File` or `Path`.
        :param pulumi.Input[str] value: Collection path.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        Collection path type. The path type can be `File` or `Path`.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        Collection path.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class RuleExtractRuleArgs:
    def __init__(__self__, *,
                 begin_regex: Optional[pulumi.Input[str]] = None,
                 delimiter: Optional[pulumi.Input[str]] = None,
                 filter_key_regexes: Optional[pulumi.Input[Sequence[pulumi.Input['RuleExtractRuleFilterKeyRegexArgs']]]] = None,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 log_regex: Optional[pulumi.Input[str]] = None,
                 log_template: Optional[pulumi.Input['RuleExtractRuleLogTemplateArgs']] = None,
                 time_format: Optional[pulumi.Input[str]] = None,
                 time_key: Optional[pulumi.Input[str]] = None,
                 un_match_log_key: Optional[pulumi.Input[str]] = None,
                 un_match_up_load_switch: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input[str] begin_regex: The first log line needs to match the regular expression.
        :param pulumi.Input[str] delimiter: The delimiter of the log.
        :param pulumi.Input[Sequence[pulumi.Input['RuleExtractRuleFilterKeyRegexArgs']]] filter_key_regexes: The filter key list.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: A list of log field names (Key).
        :param pulumi.Input[str] log_regex: The entire log needs to match the regular expression.
        :param pulumi.Input['RuleExtractRuleLogTemplateArgs'] log_template: Automatically extract log fields according to the specified log template.
        :param pulumi.Input[str] time_format: Parsing format of the time field.
        :param pulumi.Input[str] time_key: The field name of the log time field.
        :param pulumi.Input[str] un_match_log_key: When uploading the failed log, the key name of the failed log.
        :param pulumi.Input[bool] un_match_up_load_switch: Whether to upload the log of parsing failure.
        """
        if begin_regex is not None:
            pulumi.set(__self__, "begin_regex", begin_regex)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if filter_key_regexes is not None:
            pulumi.set(__self__, "filter_key_regexes", filter_key_regexes)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if log_regex is not None:
            pulumi.set(__self__, "log_regex", log_regex)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_key is not None:
            pulumi.set(__self__, "time_key", time_key)
        if un_match_log_key is not None:
            pulumi.set(__self__, "un_match_log_key", un_match_log_key)
        if un_match_up_load_switch is not None:
            pulumi.set(__self__, "un_match_up_load_switch", un_match_up_load_switch)

    @property
    @pulumi.getter(name="beginRegex")
    def begin_regex(self) -> Optional[pulumi.Input[str]]:
        """
        The first log line needs to match the regular expression.
        """
        return pulumi.get(self, "begin_regex")

    @begin_regex.setter
    def begin_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "begin_regex", value)

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[pulumi.Input[str]]:
        """
        The delimiter of the log.
        """
        return pulumi.get(self, "delimiter")

    @delimiter.setter
    def delimiter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delimiter", value)

    @property
    @pulumi.getter(name="filterKeyRegexes")
    def filter_key_regexes(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleExtractRuleFilterKeyRegexArgs']]]]:
        """
        The filter key list.
        """
        return pulumi.get(self, "filter_key_regexes")

    @filter_key_regexes.setter
    def filter_key_regexes(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleExtractRuleFilterKeyRegexArgs']]]]):
        pulumi.set(self, "filter_key_regexes", value)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of log field names (Key).
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="logRegex")
    def log_regex(self) -> Optional[pulumi.Input[str]]:
        """
        The entire log needs to match the regular expression.
        """
        return pulumi.get(self, "log_regex")

    @log_regex.setter
    def log_regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_regex", value)

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional[pulumi.Input['RuleExtractRuleLogTemplateArgs']]:
        """
        Automatically extract log fields according to the specified log template.
        """
        return pulumi.get(self, "log_template")

    @log_template.setter
    def log_template(self, value: Optional[pulumi.Input['RuleExtractRuleLogTemplateArgs']]):
        pulumi.set(self, "log_template", value)

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[pulumi.Input[str]]:
        """
        Parsing format of the time field.
        """
        return pulumi.get(self, "time_format")

    @time_format.setter
    def time_format(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_format", value)

    @property
    @pulumi.getter(name="timeKey")
    def time_key(self) -> Optional[pulumi.Input[str]]:
        """
        The field name of the log time field.
        """
        return pulumi.get(self, "time_key")

    @time_key.setter
    def time_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_key", value)

    @property
    @pulumi.getter(name="unMatchLogKey")
    def un_match_log_key(self) -> Optional[pulumi.Input[str]]:
        """
        When uploading the failed log, the key name of the failed log.
        """
        return pulumi.get(self, "un_match_log_key")

    @un_match_log_key.setter
    def un_match_log_key(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "un_match_log_key", value)

    @property
    @pulumi.getter(name="unMatchUpLoadSwitch")
    def un_match_up_load_switch(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to upload the log of parsing failure.
        """
        return pulumi.get(self, "un_match_up_load_switch")

    @un_match_up_load_switch.setter
    def un_match_up_load_switch(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "un_match_up_load_switch", value)


@pulumi.input_type
class RuleExtractRuleFilterKeyRegexArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 regex: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The name of the filter key.
        :param pulumi.Input[str] regex: The log content of the filter field needs to match the regular expression.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The name of the filter key.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def regex(self) -> pulumi.Input[str]:
        """
        The log content of the filter field needs to match the regular expression.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: pulumi.Input[str]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class RuleExtractRuleLogTemplateArgs:
    def __init__(__self__, *,
                 format: pulumi.Input[str],
                 type: pulumi.Input[str]):
        """
        :param pulumi.Input[str] format: Log template content.
        :param pulumi.Input[str] type: The type of the log template.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def format(self) -> pulumi.Input[str]:
        """
        Log template content.
        """
        return pulumi.get(self, "format")

    @format.setter
    def format(self, value: pulumi.Input[str]):
        pulumi.set(self, "format", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the log template.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RuleUserDefineRuleArgs:
    def __init__(__self__, *,
                 advanced: Optional[pulumi.Input['RuleUserDefineRuleAdvancedArgs']] = None,
                 enable_raw_log: Optional[pulumi.Input[bool]] = None,
                 fields: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 parse_path_rule: Optional[pulumi.Input['RuleUserDefineRuleParsePathRuleArgs']] = None,
                 plugin: Optional[pulumi.Input['RuleUserDefineRulePluginArgs']] = None,
                 shard_hash_key: Optional[pulumi.Input['RuleUserDefineRuleShardHashKeyArgs']] = None,
                 tail_files: Optional[pulumi.Input[bool]] = None):
        """
        :param pulumi.Input['RuleUserDefineRuleAdvancedArgs'] advanced: LogCollector extension configuration.
        :param pulumi.Input[bool] enable_raw_log: Whether to upload raw logs.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] fields: Add constant fields to logs.
        :param pulumi.Input['RuleUserDefineRuleParsePathRuleArgs'] parse_path_rule: Rules for parsing collection paths. After the rules are set, the fields in the collection path will be extracted through the regular expressions specified in the rules, and added to the log data as metadata.
        :param pulumi.Input['RuleUserDefineRulePluginArgs'] plugin: Plugin configuration. After the plugin configuration is enabled, one or more LogCollector processor plugins can be added to parse logs with complex or variable structures.
        :param pulumi.Input['RuleUserDefineRuleShardHashKeyArgs'] shard_hash_key: Rules for routing log partitions. Setting this parameter indicates that the HashKey routing shard mode is used when collecting logs, and Log Service will write the data to the shard containing the specified Key value.
        :param pulumi.Input[bool] tail_files: LogCollector collection strategy, which specifies whether LogCollector collects incremental logs or full logs. The default is false, which means to collect all logs.
        """
        if advanced is not None:
            pulumi.set(__self__, "advanced", advanced)
        if enable_raw_log is not None:
            pulumi.set(__self__, "enable_raw_log", enable_raw_log)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if parse_path_rule is not None:
            pulumi.set(__self__, "parse_path_rule", parse_path_rule)
        if plugin is not None:
            pulumi.set(__self__, "plugin", plugin)
        if shard_hash_key is not None:
            pulumi.set(__self__, "shard_hash_key", shard_hash_key)
        if tail_files is not None:
            pulumi.set(__self__, "tail_files", tail_files)

    @property
    @pulumi.getter
    def advanced(self) -> Optional[pulumi.Input['RuleUserDefineRuleAdvancedArgs']]:
        """
        LogCollector extension configuration.
        """
        return pulumi.get(self, "advanced")

    @advanced.setter
    def advanced(self, value: Optional[pulumi.Input['RuleUserDefineRuleAdvancedArgs']]):
        pulumi.set(self, "advanced", value)

    @property
    @pulumi.getter(name="enableRawLog")
    def enable_raw_log(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to upload raw logs.
        """
        return pulumi.get(self, "enable_raw_log")

    @enable_raw_log.setter
    def enable_raw_log(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_raw_log", value)

    @property
    @pulumi.getter
    def fields(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Add constant fields to logs.
        """
        return pulumi.get(self, "fields")

    @fields.setter
    def fields(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "fields", value)

    @property
    @pulumi.getter(name="parsePathRule")
    def parse_path_rule(self) -> Optional[pulumi.Input['RuleUserDefineRuleParsePathRuleArgs']]:
        """
        Rules for parsing collection paths. After the rules are set, the fields in the collection path will be extracted through the regular expressions specified in the rules, and added to the log data as metadata.
        """
        return pulumi.get(self, "parse_path_rule")

    @parse_path_rule.setter
    def parse_path_rule(self, value: Optional[pulumi.Input['RuleUserDefineRuleParsePathRuleArgs']]):
        pulumi.set(self, "parse_path_rule", value)

    @property
    @pulumi.getter
    def plugin(self) -> Optional[pulumi.Input['RuleUserDefineRulePluginArgs']]:
        """
        Plugin configuration. After the plugin configuration is enabled, one or more LogCollector processor plugins can be added to parse logs with complex or variable structures.
        """
        return pulumi.get(self, "plugin")

    @plugin.setter
    def plugin(self, value: Optional[pulumi.Input['RuleUserDefineRulePluginArgs']]):
        pulumi.set(self, "plugin", value)

    @property
    @pulumi.getter(name="shardHashKey")
    def shard_hash_key(self) -> Optional[pulumi.Input['RuleUserDefineRuleShardHashKeyArgs']]:
        """
        Rules for routing log partitions. Setting this parameter indicates that the HashKey routing shard mode is used when collecting logs, and Log Service will write the data to the shard containing the specified Key value.
        """
        return pulumi.get(self, "shard_hash_key")

    @shard_hash_key.setter
    def shard_hash_key(self, value: Optional[pulumi.Input['RuleUserDefineRuleShardHashKeyArgs']]):
        pulumi.set(self, "shard_hash_key", value)

    @property
    @pulumi.getter(name="tailFiles")
    def tail_files(self) -> Optional[pulumi.Input[bool]]:
        """
        LogCollector collection strategy, which specifies whether LogCollector collects incremental logs or full logs. The default is false, which means to collect all logs.
        """
        return pulumi.get(self, "tail_files")

    @tail_files.setter
    def tail_files(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "tail_files", value)


@pulumi.input_type
class RuleUserDefineRuleAdvancedArgs:
    def __init__(__self__, *,
                 close_eof: Optional[pulumi.Input[bool]] = None,
                 close_inactive: Optional[pulumi.Input[int]] = None,
                 close_removed: Optional[pulumi.Input[bool]] = None,
                 close_renamed: Optional[pulumi.Input[bool]] = None,
                 close_timeout: Optional[pulumi.Input[int]] = None):
        """
        :param pulumi.Input[bool] close_eof: Whether to release the log file handle after reading to the end of the log file. The default is false.
        :param pulumi.Input[int] close_inactive: The wait time to release the log file handle. When the log file has not written a new log for more than the specified time, release the handle of the log file.
        :param pulumi.Input[bool] close_removed: After the log file is removed, whether to release the handle of the log file. The default is false.
        :param pulumi.Input[bool] close_renamed: After the log file is renamed, whether to release the handle of the log file. The default is false.
        :param pulumi.Input[int] close_timeout: The maximum length of time that LogCollector monitors log files. The unit is seconds, and the default is 0 seconds, which means that there is no limit to the length of time LogCollector monitors log files.
        """
        if close_eof is not None:
            pulumi.set(__self__, "close_eof", close_eof)
        if close_inactive is not None:
            pulumi.set(__self__, "close_inactive", close_inactive)
        if close_removed is not None:
            pulumi.set(__self__, "close_removed", close_removed)
        if close_renamed is not None:
            pulumi.set(__self__, "close_renamed", close_renamed)
        if close_timeout is not None:
            pulumi.set(__self__, "close_timeout", close_timeout)

    @property
    @pulumi.getter(name="closeEof")
    def close_eof(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether to release the log file handle after reading to the end of the log file. The default is false.
        """
        return pulumi.get(self, "close_eof")

    @close_eof.setter
    def close_eof(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "close_eof", value)

    @property
    @pulumi.getter(name="closeInactive")
    def close_inactive(self) -> Optional[pulumi.Input[int]]:
        """
        The wait time to release the log file handle. When the log file has not written a new log for more than the specified time, release the handle of the log file.
        """
        return pulumi.get(self, "close_inactive")

    @close_inactive.setter
    def close_inactive(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "close_inactive", value)

    @property
    @pulumi.getter(name="closeRemoved")
    def close_removed(self) -> Optional[pulumi.Input[bool]]:
        """
        After the log file is removed, whether to release the handle of the log file. The default is false.
        """
        return pulumi.get(self, "close_removed")

    @close_removed.setter
    def close_removed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "close_removed", value)

    @property
    @pulumi.getter(name="closeRenamed")
    def close_renamed(self) -> Optional[pulumi.Input[bool]]:
        """
        After the log file is renamed, whether to release the handle of the log file. The default is false.
        """
        return pulumi.get(self, "close_renamed")

    @close_renamed.setter
    def close_renamed(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "close_renamed", value)

    @property
    @pulumi.getter(name="closeTimeout")
    def close_timeout(self) -> Optional[pulumi.Input[int]]:
        """
        The maximum length of time that LogCollector monitors log files. The unit is seconds, and the default is 0 seconds, which means that there is no limit to the length of time LogCollector monitors log files.
        """
        return pulumi.get(self, "close_timeout")

    @close_timeout.setter
    def close_timeout(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "close_timeout", value)


@pulumi.input_type
class RuleUserDefineRuleParsePathRuleArgs:
    def __init__(__self__, *,
                 keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 path_sample: Optional[pulumi.Input[str]] = None,
                 regex: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] keys: A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        :param pulumi.Input[str] path_sample: Sample capture path for a real scene.
        :param pulumi.Input[str] regex: Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if path_sample is not None:
            pulumi.set(__self__, "path_sample", path_sample)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        """
        return pulumi.get(self, "keys")

    @keys.setter
    def keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "keys", value)

    @property
    @pulumi.getter(name="pathSample")
    def path_sample(self) -> Optional[pulumi.Input[str]]:
        """
        Sample capture path for a real scene.
        """
        return pulumi.get(self, "path_sample")

    @path_sample.setter
    def path_sample(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path_sample", value)

    @property
    @pulumi.getter
    def regex(self) -> Optional[pulumi.Input[str]]:
        """
        Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        return pulumi.get(self, "regex")

    @regex.setter
    def regex(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "regex", value)


@pulumi.input_type
class RuleUserDefineRulePluginArgs:
    def __init__(__self__, *,
                 processors: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        :param pulumi.Input[Sequence[pulumi.Input[str]]] processors: LogCollector plugin.
        """
        pulumi.set(__self__, "processors", processors)

    @property
    @pulumi.getter
    def processors(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        LogCollector plugin.
        """
        return pulumi.get(self, "processors")

    @processors.setter
    def processors(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "processors", value)


@pulumi.input_type
class RuleUserDefineRuleShardHashKeyArgs:
    def __init__(__self__, *,
                 hash_key: pulumi.Input[str]):
        """
        :param pulumi.Input[str] hash_key: The HashKey of the log group is used to specify the partition (shard) to be written to by the current log group.
        """
        pulumi.set(__self__, "hash_key", hash_key)

    @property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> pulumi.Input[str]:
        """
        The HashKey of the log group is used to specify the partition (shard) to be written to by the current log group.
        """
        return pulumi.get(self, "hash_key")

    @hash_key.setter
    def hash_key(self, value: pulumi.Input[str]):
        pulumi.set(self, "hash_key", value)


@pulumi.input_type
class TopicTagArgs:
    def __init__(__self__, *,
                 key: pulumi.Input[str],
                 value: pulumi.Input[str]):
        """
        :param pulumi.Input[str] key: The Key of Tags.
        :param pulumi.Input[str] value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> pulumi.Input[str]:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: pulumi.Input[str]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> pulumi.Input[str]:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: pulumi.Input[str]):
        pulumi.set(self, "value", value)


@pulumi.input_type
class TopicsTagArgs:
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: str):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")

    @value.setter
    def value(self, value: str):
        pulumi.set(self, "value", value)


