# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AlarmNotifyGroupArgs', 'AlarmNotifyGroup']

@pulumi.input_type
class AlarmNotifyGroupArgs:
    def __init__(__self__, *,
                 alarm_notify_group_name: pulumi.Input[str],
                 notify_types: pulumi.Input[Sequence[pulumi.Input[str]]],
                 receivers: pulumi.Input[Sequence[pulumi.Input['AlarmNotifyGroupReceiverArgs']]],
                 iam_project_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AlarmNotifyGroup resource.
        :param pulumi.Input[str] alarm_notify_group_name: The name of the notify group.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_types: The notify type.
               Trigger: Alarm Trigger
               Recovery: Alarm Recovery.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmNotifyGroupReceiverArgs']]] receivers: List of IAM users to receive alerts.
        :param pulumi.Input[str] iam_project_name: The name of the iam project.
        """
        pulumi.set(__self__, "alarm_notify_group_name", alarm_notify_group_name)
        pulumi.set(__self__, "notify_types", notify_types)
        pulumi.set(__self__, "receivers", receivers)
        if iam_project_name is not None:
            pulumi.set(__self__, "iam_project_name", iam_project_name)

    @property
    @pulumi.getter(name="alarmNotifyGroupName")
    def alarm_notify_group_name(self) -> pulumi.Input[str]:
        """
        The name of the notify group.
        """
        return pulumi.get(self, "alarm_notify_group_name")

    @alarm_notify_group_name.setter
    def alarm_notify_group_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "alarm_notify_group_name", value)

    @property
    @pulumi.getter(name="notifyTypes")
    def notify_types(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The notify type.
        Trigger: Alarm Trigger
        Recovery: Alarm Recovery.
        """
        return pulumi.get(self, "notify_types")

    @notify_types.setter
    def notify_types(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "notify_types", value)

    @property
    @pulumi.getter
    def receivers(self) -> pulumi.Input[Sequence[pulumi.Input['AlarmNotifyGroupReceiverArgs']]]:
        """
        List of IAM users to receive alerts.
        """
        return pulumi.get(self, "receivers")

    @receivers.setter
    def receivers(self, value: pulumi.Input[Sequence[pulumi.Input['AlarmNotifyGroupReceiverArgs']]]):
        pulumi.set(self, "receivers", value)

    @property
    @pulumi.getter(name="iamProjectName")
    def iam_project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the iam project.
        """
        return pulumi.get(self, "iam_project_name")

    @iam_project_name.setter
    def iam_project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_project_name", value)


@pulumi.input_type
class _AlarmNotifyGroupState:
    def __init__(__self__, *,
                 alarm_notify_group_id: Optional[pulumi.Input[str]] = None,
                 alarm_notify_group_name: Optional[pulumi.Input[str]] = None,
                 iam_project_name: Optional[pulumi.Input[str]] = None,
                 notify_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 receivers: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmNotifyGroupReceiverArgs']]]] = None):
        """
        Input properties used for looking up and filtering AlarmNotifyGroup resources.
        :param pulumi.Input[str] alarm_notify_group_id: The alarm notification group id.
        :param pulumi.Input[str] alarm_notify_group_name: The name of the notify group.
        :param pulumi.Input[str] iam_project_name: The name of the iam project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_types: The notify type.
               Trigger: Alarm Trigger
               Recovery: Alarm Recovery.
        :param pulumi.Input[Sequence[pulumi.Input['AlarmNotifyGroupReceiverArgs']]] receivers: List of IAM users to receive alerts.
        """
        if alarm_notify_group_id is not None:
            pulumi.set(__self__, "alarm_notify_group_id", alarm_notify_group_id)
        if alarm_notify_group_name is not None:
            pulumi.set(__self__, "alarm_notify_group_name", alarm_notify_group_name)
        if iam_project_name is not None:
            pulumi.set(__self__, "iam_project_name", iam_project_name)
        if notify_types is not None:
            pulumi.set(__self__, "notify_types", notify_types)
        if receivers is not None:
            pulumi.set(__self__, "receivers", receivers)

    @property
    @pulumi.getter(name="alarmNotifyGroupId")
    def alarm_notify_group_id(self) -> Optional[pulumi.Input[str]]:
        """
        The alarm notification group id.
        """
        return pulumi.get(self, "alarm_notify_group_id")

    @alarm_notify_group_id.setter
    def alarm_notify_group_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_notify_group_id", value)

    @property
    @pulumi.getter(name="alarmNotifyGroupName")
    def alarm_notify_group_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the notify group.
        """
        return pulumi.get(self, "alarm_notify_group_name")

    @alarm_notify_group_name.setter
    def alarm_notify_group_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "alarm_notify_group_name", value)

    @property
    @pulumi.getter(name="iamProjectName")
    def iam_project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the iam project.
        """
        return pulumi.get(self, "iam_project_name")

    @iam_project_name.setter
    def iam_project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "iam_project_name", value)

    @property
    @pulumi.getter(name="notifyTypes")
    def notify_types(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The notify type.
        Trigger: Alarm Trigger
        Recovery: Alarm Recovery.
        """
        return pulumi.get(self, "notify_types")

    @notify_types.setter
    def notify_types(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "notify_types", value)

    @property
    @pulumi.getter
    def receivers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['AlarmNotifyGroupReceiverArgs']]]]:
        """
        List of IAM users to receive alerts.
        """
        return pulumi.get(self, "receivers")

    @receivers.setter
    def receivers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['AlarmNotifyGroupReceiverArgs']]]]):
        pulumi.set(self, "receivers", value)


class AlarmNotifyGroup(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_notify_group_name: Optional[pulumi.Input[str]] = None,
                 iam_project_name: Optional[pulumi.Input[str]] = None,
                 notify_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 receivers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmNotifyGroupReceiverArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage tls alarm notify group
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.tls.AlarmNotifyGroup("foo",
            alarm_notify_group_name="tf-test",
            iam_project_name="yyy",
            notify_types=["Trigger"],
            receivers=[volcengine.tls.AlarmNotifyGroupReceiverArgs(
                end_time="23:59:59",
                receiver_channels=[
                    "Email",
                    "Sms",
                ],
                receiver_names=["vke-qs"],
                receiver_type="User",
                start_time="23:00:00",
            )])
        ```

        ## Import

        tls alarm notify group can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:tls/alarmNotifyGroup:AlarmNotifyGroup default fa************
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alarm_notify_group_name: The name of the notify group.
        :param pulumi.Input[str] iam_project_name: The name of the iam project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_types: The notify type.
               Trigger: Alarm Trigger
               Recovery: Alarm Recovery.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmNotifyGroupReceiverArgs']]]] receivers: List of IAM users to receive alerts.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AlarmNotifyGroupArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage tls alarm notify group
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.tls.AlarmNotifyGroup("foo",
            alarm_notify_group_name="tf-test",
            iam_project_name="yyy",
            notify_types=["Trigger"],
            receivers=[volcengine.tls.AlarmNotifyGroupReceiverArgs(
                end_time="23:59:59",
                receiver_channels=[
                    "Email",
                    "Sms",
                ],
                receiver_names=["vke-qs"],
                receiver_type="User",
                start_time="23:00:00",
            )])
        ```

        ## Import

        tls alarm notify group can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:tls/alarmNotifyGroup:AlarmNotifyGroup default fa************
        ```

        :param str resource_name: The name of the resource.
        :param AlarmNotifyGroupArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AlarmNotifyGroupArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 alarm_notify_group_name: Optional[pulumi.Input[str]] = None,
                 iam_project_name: Optional[pulumi.Input[str]] = None,
                 notify_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 receivers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmNotifyGroupReceiverArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AlarmNotifyGroupArgs.__new__(AlarmNotifyGroupArgs)

            if alarm_notify_group_name is None and not opts.urn:
                raise TypeError("Missing required property 'alarm_notify_group_name'")
            __props__.__dict__["alarm_notify_group_name"] = alarm_notify_group_name
            __props__.__dict__["iam_project_name"] = iam_project_name
            if notify_types is None and not opts.urn:
                raise TypeError("Missing required property 'notify_types'")
            __props__.__dict__["notify_types"] = notify_types
            if receivers is None and not opts.urn:
                raise TypeError("Missing required property 'receivers'")
            __props__.__dict__["receivers"] = receivers
            __props__.__dict__["alarm_notify_group_id"] = None
        super(AlarmNotifyGroup, __self__).__init__(
            'volcengine:tls/alarmNotifyGroup:AlarmNotifyGroup',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            alarm_notify_group_id: Optional[pulumi.Input[str]] = None,
            alarm_notify_group_name: Optional[pulumi.Input[str]] = None,
            iam_project_name: Optional[pulumi.Input[str]] = None,
            notify_types: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            receivers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmNotifyGroupReceiverArgs']]]]] = None) -> 'AlarmNotifyGroup':
        """
        Get an existing AlarmNotifyGroup resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] alarm_notify_group_id: The alarm notification group id.
        :param pulumi.Input[str] alarm_notify_group_name: The name of the notify group.
        :param pulumi.Input[str] iam_project_name: The name of the iam project.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] notify_types: The notify type.
               Trigger: Alarm Trigger
               Recovery: Alarm Recovery.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['AlarmNotifyGroupReceiverArgs']]]] receivers: List of IAM users to receive alerts.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AlarmNotifyGroupState.__new__(_AlarmNotifyGroupState)

        __props__.__dict__["alarm_notify_group_id"] = alarm_notify_group_id
        __props__.__dict__["alarm_notify_group_name"] = alarm_notify_group_name
        __props__.__dict__["iam_project_name"] = iam_project_name
        __props__.__dict__["notify_types"] = notify_types
        __props__.__dict__["receivers"] = receivers
        return AlarmNotifyGroup(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="alarmNotifyGroupId")
    def alarm_notify_group_id(self) -> pulumi.Output[str]:
        """
        The alarm notification group id.
        """
        return pulumi.get(self, "alarm_notify_group_id")

    @property
    @pulumi.getter(name="alarmNotifyGroupName")
    def alarm_notify_group_name(self) -> pulumi.Output[str]:
        """
        The name of the notify group.
        """
        return pulumi.get(self, "alarm_notify_group_name")

    @property
    @pulumi.getter(name="iamProjectName")
    def iam_project_name(self) -> pulumi.Output[str]:
        """
        The name of the iam project.
        """
        return pulumi.get(self, "iam_project_name")

    @property
    @pulumi.getter(name="notifyTypes")
    def notify_types(self) -> pulumi.Output[Sequence[str]]:
        """
        The notify type.
        Trigger: Alarm Trigger
        Recovery: Alarm Recovery.
        """
        return pulumi.get(self, "notify_types")

    @property
    @pulumi.getter
    def receivers(self) -> pulumi.Output[Sequence['outputs.AlarmNotifyGroupReceiver']]:
        """
        List of IAM users to receive alerts.
        """
        return pulumi.get(self, "receivers")

