# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AlarmsResult',
    'AwaitableAlarmsResult',
    'alarms',
    'alarms_output',
]

@pulumi.output_type
class AlarmsResult:
    """
    A collection of values returned by Alarms.
    """
    def __init__(__self__, alarm_id=None, alarm_name=None, alarms=None, id=None, output_file=None, project_id=None, status=None, topic_id=None, topic_name=None, total_count=None):
        if alarm_id and not isinstance(alarm_id, str):
            raise TypeError("Expected argument 'alarm_id' to be a str")
        pulumi.set(__self__, "alarm_id", alarm_id)
        if alarm_name and not isinstance(alarm_name, str):
            raise TypeError("Expected argument 'alarm_name' to be a str")
        pulumi.set(__self__, "alarm_name", alarm_name)
        if alarms and not isinstance(alarms, list):
            raise TypeError("Expected argument 'alarms' to be a list")
        pulumi.set(__self__, "alarms", alarms)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if status and not isinstance(status, bool):
            raise TypeError("Expected argument 'status' to be a bool")
        pulumi.set(__self__, "status", status)
        if topic_id and not isinstance(topic_id, str):
            raise TypeError("Expected argument 'topic_id' to be a str")
        pulumi.set(__self__, "topic_id", topic_id)
        if topic_name and not isinstance(topic_name, str):
            raise TypeError("Expected argument 'topic_name' to be a str")
        pulumi.set(__self__, "topic_name", topic_name)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> Optional[str]:
        """
        The alarm id.
        """
        return pulumi.get(self, "alarm_id")

    @property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> Optional[str]:
        """
        The name of the alarm.
        """
        return pulumi.get(self, "alarm_name")

    @property
    @pulumi.getter
    def alarms(self) -> Sequence['outputs.AlarmsAlarmResult']:
        """
        The list of alarms.
        """
        return pulumi.get(self, "alarms")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The project id.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def status(self) -> Optional[bool]:
        """
        Whether to enable the alert policy. The default value is true, that is, on.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[str]:
        """
        The id of the topic.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[str]:
        """
        The name of the topic.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableAlarmsResult(AlarmsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return AlarmsResult(
            alarm_id=self.alarm_id,
            alarm_name=self.alarm_name,
            alarms=self.alarms,
            id=self.id,
            output_file=self.output_file,
            project_id=self.project_id,
            status=self.status,
            topic_id=self.topic_id,
            topic_name=self.topic_name,
            total_count=self.total_count)


def alarms(alarm_id: Optional[str] = None,
           alarm_name: Optional[str] = None,
           output_file: Optional[str] = None,
           project_id: Optional[str] = None,
           status: Optional[bool] = None,
           topic_id: Optional[str] = None,
           topic_name: Optional[str] = None,
           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableAlarmsResult:
    """
    Use this data source to query detailed information of tls alarms
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.tls.alarms(project_id="cc44f8b6-0328-4622-b043-023fca735cd4")
    ```


    :param str alarm_id: The alarm id.
    :param str alarm_name: The alarm name.
    :param str output_file: File name where to save data source results.
    :param str project_id: The project id.
    :param bool status: The status.
    :param str topic_id: The topic id.
    :param str topic_name: The topic name.
    """
    __args__ = dict()
    __args__['alarmId'] = alarm_id
    __args__['alarmName'] = alarm_name
    __args__['outputFile'] = output_file
    __args__['projectId'] = project_id
    __args__['status'] = status
    __args__['topicId'] = topic_id
    __args__['topicName'] = topic_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:tls/alarms:Alarms', __args__, opts=opts, typ=AlarmsResult).value

    return AwaitableAlarmsResult(
        alarm_id=pulumi.get(__ret__, 'alarm_id'),
        alarm_name=pulumi.get(__ret__, 'alarm_name'),
        alarms=pulumi.get(__ret__, 'alarms'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_id=pulumi.get(__ret__, 'project_id'),
        status=pulumi.get(__ret__, 'status'),
        topic_id=pulumi.get(__ret__, 'topic_id'),
        topic_name=pulumi.get(__ret__, 'topic_name'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(alarms)
def alarms_output(alarm_id: Optional[pulumi.Input[Optional[str]]] = None,
                  alarm_name: Optional[pulumi.Input[Optional[str]]] = None,
                  output_file: Optional[pulumi.Input[Optional[str]]] = None,
                  project_id: Optional[pulumi.Input[str]] = None,
                  status: Optional[pulumi.Input[Optional[bool]]] = None,
                  topic_id: Optional[pulumi.Input[Optional[str]]] = None,
                  topic_name: Optional[pulumi.Input[Optional[str]]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[AlarmsResult]:
    """
    Use this data source to query detailed information of tls alarms
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.tls.alarms(project_id="cc44f8b6-0328-4622-b043-023fca735cd4")
    ```


    :param str alarm_id: The alarm id.
    :param str alarm_name: The alarm name.
    :param str output_file: File name where to save data source results.
    :param str project_id: The project id.
    :param bool status: The status.
    :param str topic_id: The topic id.
    :param str topic_name: The topic name.
    """
    ...
