# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['IndexArgs', 'Index']

@pulumi.input_type
class IndexArgs:
    def __init__(__self__, *,
                 topic_id: pulumi.Input[str],
                 full_text: Optional[pulumi.Input['IndexFullTextArgs']] = None,
                 key_values: Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyValueArgs']]]] = None,
                 user_inner_key_values: Optional[pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueArgs']]]] = None):
        """
        The set of arguments for constructing a Index resource.
        :param pulumi.Input[str] topic_id: The topic id of the tls index.
        :param pulumi.Input['IndexFullTextArgs'] full_text: The full text info of the tls index.
        :param pulumi.Input[Sequence[pulumi.Input['IndexKeyValueArgs']]] key_values: The key value info of the tls index.
        :param pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueArgs']]] user_inner_key_values: The reserved field index configuration of the tls index.
        """
        pulumi.set(__self__, "topic_id", topic_id)
        if full_text is not None:
            pulumi.set(__self__, "full_text", full_text)
        if key_values is not None:
            pulumi.set(__self__, "key_values", key_values)
        if user_inner_key_values is not None:
            pulumi.set(__self__, "user_inner_key_values", user_inner_key_values)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Input[str]:
        """
        The topic id of the tls index.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_id", value)

    @property
    @pulumi.getter(name="fullText")
    def full_text(self) -> Optional[pulumi.Input['IndexFullTextArgs']]:
        """
        The full text info of the tls index.
        """
        return pulumi.get(self, "full_text")

    @full_text.setter
    def full_text(self, value: Optional[pulumi.Input['IndexFullTextArgs']]):
        pulumi.set(self, "full_text", value)

    @property
    @pulumi.getter(name="keyValues")
    def key_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyValueArgs']]]]:
        """
        The key value info of the tls index.
        """
        return pulumi.get(self, "key_values")

    @key_values.setter
    def key_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyValueArgs']]]]):
        pulumi.set(self, "key_values", value)

    @property
    @pulumi.getter(name="userInnerKeyValues")
    def user_inner_key_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueArgs']]]]:
        """
        The reserved field index configuration of the tls index.
        """
        return pulumi.get(self, "user_inner_key_values")

    @user_inner_key_values.setter
    def user_inner_key_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueArgs']]]]):
        pulumi.set(self, "user_inner_key_values", value)


@pulumi.input_type
class _IndexState:
    def __init__(__self__, *,
                 create_time: Optional[pulumi.Input[str]] = None,
                 full_text: Optional[pulumi.Input['IndexFullTextArgs']] = None,
                 key_values: Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyValueArgs']]]] = None,
                 modify_time: Optional[pulumi.Input[str]] = None,
                 topic_id: Optional[pulumi.Input[str]] = None,
                 user_inner_key_values: Optional[pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueArgs']]]] = None):
        """
        Input properties used for looking up and filtering Index resources.
        :param pulumi.Input[str] create_time: The create time of the tls index.
        :param pulumi.Input['IndexFullTextArgs'] full_text: The full text info of the tls index.
        :param pulumi.Input[Sequence[pulumi.Input['IndexKeyValueArgs']]] key_values: The key value info of the tls index.
        :param pulumi.Input[str] modify_time: The modify time of the tls index.
        :param pulumi.Input[str] topic_id: The topic id of the tls index.
        :param pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueArgs']]] user_inner_key_values: The reserved field index configuration of the tls index.
        """
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if full_text is not None:
            pulumi.set(__self__, "full_text", full_text)
        if key_values is not None:
            pulumi.set(__self__, "key_values", key_values)
        if modify_time is not None:
            pulumi.set(__self__, "modify_time", modify_time)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)
        if user_inner_key_values is not None:
            pulumi.set(__self__, "user_inner_key_values", user_inner_key_values)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the tls index.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter(name="fullText")
    def full_text(self) -> Optional[pulumi.Input['IndexFullTextArgs']]:
        """
        The full text info of the tls index.
        """
        return pulumi.get(self, "full_text")

    @full_text.setter
    def full_text(self, value: Optional[pulumi.Input['IndexFullTextArgs']]):
        pulumi.set(self, "full_text", value)

    @property
    @pulumi.getter(name="keyValues")
    def key_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyValueArgs']]]]:
        """
        The key value info of the tls index.
        """
        return pulumi.get(self, "key_values")

    @key_values.setter
    def key_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexKeyValueArgs']]]]):
        pulumi.set(self, "key_values", value)

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> Optional[pulumi.Input[str]]:
        """
        The modify time of the tls index.
        """
        return pulumi.get(self, "modify_time")

    @modify_time.setter
    def modify_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "modify_time", value)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[pulumi.Input[str]]:
        """
        The topic id of the tls index.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_id", value)

    @property
    @pulumi.getter(name="userInnerKeyValues")
    def user_inner_key_values(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueArgs']]]]:
        """
        The reserved field index configuration of the tls index.
        """
        return pulumi.get(self, "user_inner_key_values")

    @user_inner_key_values.setter
    def user_inner_key_values(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['IndexUserInnerKeyValueArgs']]]]):
        pulumi.set(self, "user_inner_key_values", value)


class Index(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 full_text: Optional[pulumi.Input[pulumi.InputType['IndexFullTextArgs']]] = None,
                 key_values: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexKeyValueArgs']]]]] = None,
                 topic_id: Optional[pulumi.Input[str]] = None,
                 user_inner_key_values: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexUserInnerKeyValueArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage tls index
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.tls.Index("foo",
            key_values=[
                volcengine.tls.IndexKeyValueArgs(
                    case_sensitive=True,
                    delimiter="!",
                    include_chinese=False,
                    json_keys=[
                        volcengine.tls.IndexKeyValueJsonKeyArgs(
                            key="class",
                            value_type="text",
                        ),
                        volcengine.tls.IndexKeyValueJsonKeyArgs(
                            key="age",
                            value_type="long",
                        ),
                    ],
                    key="k1",
                    sql_flag=False,
                    value_type="json",
                ),
                volcengine.tls.IndexKeyValueArgs(
                    case_sensitive=True,
                    delimiter="!",
                    include_chinese=False,
                    key="k5",
                    sql_flag=False,
                    value_type="text",
                ),
            ],
            topic_id="7ce12237-6670-44a7-9d79-2e36961586e6",
            user_inner_key_values=[volcengine.tls.IndexUserInnerKeyValueArgs(
                case_sensitive=False,
                delimiter=",:-/ ",
                include_chinese=False,
                json_keys=[
                    volcengine.tls.IndexUserInnerKeyValueJsonKeyArgs(
                        key="age",
                        value_type="long",
                    ),
                    volcengine.tls.IndexUserInnerKeyValueJsonKeyArgs(
                        key="name",
                        value_type="long",
                    ),
                ],
                key="__content__",
                sql_flag=False,
                value_type="json",
            )])
        ```

        ## Import

        Tls Index can be imported using the topic id, e.g.

        ```sh
         $ pulumi import volcengine:tls/index:Index default index:edf051ed-3c46-49ba-9339-bea628fe****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['IndexFullTextArgs']] full_text: The full text info of the tls index.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexKeyValueArgs']]]] key_values: The key value info of the tls index.
        :param pulumi.Input[str] topic_id: The topic id of the tls index.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexUserInnerKeyValueArgs']]]] user_inner_key_values: The reserved field index configuration of the tls index.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: IndexArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage tls index
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.tls.Index("foo",
            key_values=[
                volcengine.tls.IndexKeyValueArgs(
                    case_sensitive=True,
                    delimiter="!",
                    include_chinese=False,
                    json_keys=[
                        volcengine.tls.IndexKeyValueJsonKeyArgs(
                            key="class",
                            value_type="text",
                        ),
                        volcengine.tls.IndexKeyValueJsonKeyArgs(
                            key="age",
                            value_type="long",
                        ),
                    ],
                    key="k1",
                    sql_flag=False,
                    value_type="json",
                ),
                volcengine.tls.IndexKeyValueArgs(
                    case_sensitive=True,
                    delimiter="!",
                    include_chinese=False,
                    key="k5",
                    sql_flag=False,
                    value_type="text",
                ),
            ],
            topic_id="7ce12237-6670-44a7-9d79-2e36961586e6",
            user_inner_key_values=[volcengine.tls.IndexUserInnerKeyValueArgs(
                case_sensitive=False,
                delimiter=",:-/ ",
                include_chinese=False,
                json_keys=[
                    volcengine.tls.IndexUserInnerKeyValueJsonKeyArgs(
                        key="age",
                        value_type="long",
                    ),
                    volcengine.tls.IndexUserInnerKeyValueJsonKeyArgs(
                        key="name",
                        value_type="long",
                    ),
                ],
                key="__content__",
                sql_flag=False,
                value_type="json",
            )])
        ```

        ## Import

        Tls Index can be imported using the topic id, e.g.

        ```sh
         $ pulumi import volcengine:tls/index:Index default index:edf051ed-3c46-49ba-9339-bea628fe****
        ```

        :param str resource_name: The name of the resource.
        :param IndexArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(IndexArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 full_text: Optional[pulumi.Input[pulumi.InputType['IndexFullTextArgs']]] = None,
                 key_values: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexKeyValueArgs']]]]] = None,
                 topic_id: Optional[pulumi.Input[str]] = None,
                 user_inner_key_values: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexUserInnerKeyValueArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = IndexArgs.__new__(IndexArgs)

            __props__.__dict__["full_text"] = full_text
            __props__.__dict__["key_values"] = key_values
            if topic_id is None and not opts.urn:
                raise TypeError("Missing required property 'topic_id'")
            __props__.__dict__["topic_id"] = topic_id
            __props__.__dict__["user_inner_key_values"] = user_inner_key_values
            __props__.__dict__["create_time"] = None
            __props__.__dict__["modify_time"] = None
        super(Index, __self__).__init__(
            'volcengine:tls/index:Index',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            create_time: Optional[pulumi.Input[str]] = None,
            full_text: Optional[pulumi.Input[pulumi.InputType['IndexFullTextArgs']]] = None,
            key_values: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexKeyValueArgs']]]]] = None,
            modify_time: Optional[pulumi.Input[str]] = None,
            topic_id: Optional[pulumi.Input[str]] = None,
            user_inner_key_values: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexUserInnerKeyValueArgs']]]]] = None) -> 'Index':
        """
        Get an existing Index resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] create_time: The create time of the tls index.
        :param pulumi.Input[pulumi.InputType['IndexFullTextArgs']] full_text: The full text info of the tls index.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexKeyValueArgs']]]] key_values: The key value info of the tls index.
        :param pulumi.Input[str] modify_time: The modify time of the tls index.
        :param pulumi.Input[str] topic_id: The topic id of the tls index.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['IndexUserInnerKeyValueArgs']]]] user_inner_key_values: The reserved field index configuration of the tls index.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _IndexState.__new__(_IndexState)

        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["full_text"] = full_text
        __props__.__dict__["key_values"] = key_values
        __props__.__dict__["modify_time"] = modify_time
        __props__.__dict__["topic_id"] = topic_id
        __props__.__dict__["user_inner_key_values"] = user_inner_key_values
        return Index(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The create time of the tls index.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="fullText")
    def full_text(self) -> pulumi.Output[Optional['outputs.IndexFullText']]:
        """
        The full text info of the tls index.
        """
        return pulumi.get(self, "full_text")

    @property
    @pulumi.getter(name="keyValues")
    def key_values(self) -> pulumi.Output[Optional[Sequence['outputs.IndexKeyValue']]]:
        """
        The key value info of the tls index.
        """
        return pulumi.get(self, "key_values")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> pulumi.Output[str]:
        """
        The modify time of the tls index.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Output[str]:
        """
        The topic id of the tls index.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="userInnerKeyValues")
    def user_inner_key_values(self) -> pulumi.Output[Optional[Sequence['outputs.IndexUserInnerKeyValue']]]:
        """
        The reserved field index configuration of the tls index.
        """
        return pulumi.get(self, "user_inner_key_values")

