# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['KafkaConsumerArgs', 'KafkaConsumer']

@pulumi.input_type
class KafkaConsumerArgs:
    def __init__(__self__, *,
                 topic_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a KafkaConsumer resource.
        :param pulumi.Input[str] topic_id: The id of topic.
        """
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Input[str]:
        """
        The id of topic.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_id", value)


@pulumi.input_type
class _KafkaConsumerState:
    def __init__(__self__, *,
                 allow_consume: Optional[pulumi.Input[bool]] = None,
                 consume_topic: Optional[pulumi.Input[str]] = None,
                 topic_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering KafkaConsumer resources.
        :param pulumi.Input[bool] allow_consume: Whether allow consume.
        :param pulumi.Input[str] consume_topic: The topic of consume.
        :param pulumi.Input[str] topic_id: The id of topic.
        """
        if allow_consume is not None:
            pulumi.set(__self__, "allow_consume", allow_consume)
        if consume_topic is not None:
            pulumi.set(__self__, "consume_topic", consume_topic)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="allowConsume")
    def allow_consume(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether allow consume.
        """
        return pulumi.get(self, "allow_consume")

    @allow_consume.setter
    def allow_consume(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "allow_consume", value)

    @property
    @pulumi.getter(name="consumeTopic")
    def consume_topic(self) -> Optional[pulumi.Input[str]]:
        """
        The topic of consume.
        """
        return pulumi.get(self, "consume_topic")

    @consume_topic.setter
    def consume_topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "consume_topic", value)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of topic.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_id", value)


class KafkaConsumer(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 topic_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage tls kafka consumer
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.tls.KafkaConsumer("foo", topic_id="cfb5c08b-0c7a-44fa-8971-8afc12f1b123")
        ```

        ## Import

        Tls Kafka Consumer can be imported using the kafka:topic_id, e.g.

        ```sh
         $ pulumi import volcengine:tls/kafkaConsumer:KafkaConsumer default kafka:edf051ed-3c46-49ba-9339-bea628fedc15
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] topic_id: The id of topic.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KafkaConsumerArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage tls kafka consumer
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.tls.KafkaConsumer("foo", topic_id="cfb5c08b-0c7a-44fa-8971-8afc12f1b123")
        ```

        ## Import

        Tls Kafka Consumer can be imported using the kafka:topic_id, e.g.

        ```sh
         $ pulumi import volcengine:tls/kafkaConsumer:KafkaConsumer default kafka:edf051ed-3c46-49ba-9339-bea628fedc15
        ```

        :param str resource_name: The name of the resource.
        :param KafkaConsumerArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KafkaConsumerArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 topic_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KafkaConsumerArgs.__new__(KafkaConsumerArgs)

            if topic_id is None and not opts.urn:
                raise TypeError("Missing required property 'topic_id'")
            __props__.__dict__["topic_id"] = topic_id
            __props__.__dict__["allow_consume"] = None
            __props__.__dict__["consume_topic"] = None
        super(KafkaConsumer, __self__).__init__(
            'volcengine:tls/kafkaConsumer:KafkaConsumer',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allow_consume: Optional[pulumi.Input[bool]] = None,
            consume_topic: Optional[pulumi.Input[str]] = None,
            topic_id: Optional[pulumi.Input[str]] = None) -> 'KafkaConsumer':
        """
        Get an existing KafkaConsumer resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] allow_consume: Whether allow consume.
        :param pulumi.Input[str] consume_topic: The topic of consume.
        :param pulumi.Input[str] topic_id: The id of topic.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KafkaConsumerState.__new__(_KafkaConsumerState)

        __props__.__dict__["allow_consume"] = allow_consume
        __props__.__dict__["consume_topic"] = consume_topic
        __props__.__dict__["topic_id"] = topic_id
        return KafkaConsumer(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="allowConsume")
    def allow_consume(self) -> pulumi.Output[bool]:
        """
        Whether allow consume.
        """
        return pulumi.get(self, "allow_consume")

    @property
    @pulumi.getter(name="consumeTopic")
    def consume_topic(self) -> pulumi.Output[str]:
        """
        The topic of consume.
        """
        return pulumi.get(self, "consume_topic")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Output[str]:
        """
        The id of topic.
        """
        return pulumi.get(self, "topic_id")

