# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'KafkaConsumersResult',
    'AwaitableKafkaConsumersResult',
    'kafka_consumers',
    'kafka_consumers_output',
]

@pulumi.output_type
class KafkaConsumersResult:
    """
    A collection of values returned by KafkaConsumers.
    """
    def __init__(__self__, datas=None, id=None, ids=None, output_file=None, total_count=None):
        if datas and not isinstance(datas, list):
            raise TypeError("Expected argument 'datas' to be a list")
        pulumi.set(__self__, "datas", datas)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def datas(self) -> Sequence['outputs.KafkaConsumersDataResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "datas")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableKafkaConsumersResult(KafkaConsumersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return KafkaConsumersResult(
            datas=self.datas,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            total_count=self.total_count)


def kafka_consumers(ids: Optional[Sequence[str]] = None,
                    output_file: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableKafkaConsumersResult:
    """
    Use this data source to query detailed information of tls kafka consumers
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.tls.kafka_consumers(ids=[
        "65d67d34-c5b4-4ec8-b3a9-175d33668b45",
        "cfb5c08b-0c7a-44fa-8971-8afc12f1b123",
        "edf051ed-3c46-49ba-9339-bea628fedc15",
    ])
    ```


    :param Sequence[str] ids: A list of topic IDs.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:tls/kafkaConsumers:KafkaConsumers', __args__, opts=opts, typ=KafkaConsumersResult).value

    return AwaitableKafkaConsumersResult(
        datas=pulumi.get(__ret__, 'datas'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(kafka_consumers)
def kafka_consumers_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           output_file: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[KafkaConsumersResult]:
    """
    Use this data source to query detailed information of tls kafka consumers
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.tls.kafka_consumers(ids=[
        "65d67d34-c5b4-4ec8-b3a9-175d33668b45",
        "cfb5c08b-0c7a-44fa-8971-8afc12f1b123",
        "edf051ed-3c46-49ba-9339-bea628fedc15",
    ])
    ```


    :param Sequence[str] ids: A list of topic IDs.
    :param str output_file: File name where to save data source results.
    """
    ...
