# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AlarmAlarmPeriodDetail',
    'AlarmNotifyGroupReceiver',
    'AlarmNotifyGroupsGroupResult',
    'AlarmNotifyGroupsGroupReceiverResult',
    'AlarmQueryRequest',
    'AlarmRequestCycle',
    'AlarmsAlarmResult',
    'AlarmsAlarmAlarmNotifyGroupResult',
    'AlarmsAlarmAlarmNotifyGroupReceiverResult',
    'AlarmsAlarmAlarmPeriodDetailResult',
    'AlarmsAlarmQueryRequestResult',
    'AlarmsAlarmRequestCycleResult',
    'HostGroupsInfoResult',
    'HostsHostInfoResult',
    'IndexFullText',
    'IndexKeyValue',
    'IndexKeyValueJsonKey',
    'IndexUserInnerKeyValue',
    'IndexUserInnerKeyValueJsonKey',
    'IndexesTlsIndexResult',
    'IndexesTlsIndexFullTextResult',
    'IndexesTlsIndexKeyValueResult',
    'IndexesTlsIndexKeyValueJsonKeyResult',
    'IndexesTlsIndexUserInnerKeyValueResult',
    'IndexesTlsIndexUserInnerKeyValueJsonKeyResult',
    'KafkaConsumersDataResult',
    'ProjectTag',
    'ProjectsTagResult',
    'ProjectsTlsProjectResult',
    'ProjectsTlsProjectTagResult',
    'RuleAppliersRuleResult',
    'RuleAppliersRuleContainerRuleResult',
    'RuleAppliersRuleContainerRuleKubernetesRuleResult',
    'RuleAppliersRuleExcludePathResult',
    'RuleAppliersRuleExtractRuleResult',
    'RuleAppliersRuleExtractRuleFilterKeyRegexResult',
    'RuleAppliersRuleExtractRuleLogTemplateResult',
    'RuleAppliersRuleUserDefineRuleResult',
    'RuleAppliersRuleUserDefineRuleAdvancedResult',
    'RuleAppliersRuleUserDefineRuleParsePathRuleResult',
    'RuleAppliersRuleUserDefineRulePluginResult',
    'RuleAppliersRuleUserDefineRuleShardHashKeyResult',
    'RuleContainerRule',
    'RuleContainerRuleKubernetesRule',
    'RuleExcludePath',
    'RuleExtractRule',
    'RuleExtractRuleFilterKeyRegex',
    'RuleExtractRuleLogTemplate',
    'RuleUserDefineRule',
    'RuleUserDefineRuleAdvanced',
    'RuleUserDefineRuleParsePathRule',
    'RuleUserDefineRulePlugin',
    'RuleUserDefineRuleShardHashKey',
    'RulesRuleResult',
    'RulesRuleContainerRuleResult',
    'RulesRuleContainerRuleKubernetesRuleResult',
    'RulesRuleExcludePathResult',
    'RulesRuleExtractRuleResult',
    'RulesRuleExtractRuleFilterKeyRegexResult',
    'RulesRuleExtractRuleLogTemplateResult',
    'RulesRuleUserDefineRuleResult',
    'RulesRuleUserDefineRuleAdvancedResult',
    'RulesRuleUserDefineRuleParsePathRuleResult',
    'RulesRuleUserDefineRulePluginResult',
    'RulesRuleUserDefineRuleShardHashKeyResult',
    'ShardsShardResult',
    'TopicTag',
    'TopicsTagResult',
    'TopicsTlsTopicResult',
    'TopicsTlsTopicTagResult',
]

@pulumi.output_type
class AlarmAlarmPeriodDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "generalWebhook":
            suggest = "general_webhook"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmAlarmPeriodDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmAlarmPeriodDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmAlarmPeriodDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: int,
                 general_webhook: int,
                 phone: int,
                 sms: int):
        """
        :param int email: Email alarm period, the unit is minutes, and the value range is 1~1440.
        :param int general_webhook: Customize the webhook alarm period, the unit is minutes, and the value range is 1~1440.
        :param int phone: Telephone alarm cycle, the unit is minutes, and the value range is 10~1440.
        :param int sms: SMS alarm cycle, the unit is minutes, and the value range is 10~1440.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "general_webhook", general_webhook)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "sms", sms)

    @property
    @pulumi.getter
    def email(self) -> int:
        """
        Email alarm period, the unit is minutes, and the value range is 1~1440.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="generalWebhook")
    def general_webhook(self) -> int:
        """
        Customize the webhook alarm period, the unit is minutes, and the value range is 1~1440.
        """
        return pulumi.get(self, "general_webhook")

    @property
    @pulumi.getter
    def phone(self) -> int:
        """
        Telephone alarm cycle, the unit is minutes, and the value range is 10~1440.
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter
    def sms(self) -> int:
        """
        SMS alarm cycle, the unit is minutes, and the value range is 10~1440.
        """
        return pulumi.get(self, "sms")


@pulumi.output_type
class AlarmNotifyGroupReceiver(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTime":
            suggest = "end_time"
        elif key == "receiverChannels":
            suggest = "receiver_channels"
        elif key == "receiverNames":
            suggest = "receiver_names"
        elif key == "receiverType":
            suggest = "receiver_type"
        elif key == "startTime":
            suggest = "start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmNotifyGroupReceiver. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmNotifyGroupReceiver.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmNotifyGroupReceiver.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time: str,
                 receiver_channels: Sequence[str],
                 receiver_names: Sequence[str],
                 receiver_type: str,
                 start_time: str):
        """
        :param str end_time: The end time.
        :param Sequence[str] receiver_channels: The list of the receiver channels. Currently supported channels: Email, Sms, Phone.
        :param Sequence[str] receiver_names: List of the receiver names.
        :param str receiver_type: The receiver type, Can be set as: `User`(The id of user).
        :param str start_time: The start time.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "receiver_channels", receiver_channels)
        pulumi.set(__self__, "receiver_names", receiver_names)
        pulumi.set(__self__, "receiver_type", receiver_type)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="receiverChannels")
    def receiver_channels(self) -> Sequence[str]:
        """
        The list of the receiver channels. Currently supported channels: Email, Sms, Phone.
        """
        return pulumi.get(self, "receiver_channels")

    @property
    @pulumi.getter(name="receiverNames")
    def receiver_names(self) -> Sequence[str]:
        """
        List of the receiver names.
        """
        return pulumi.get(self, "receiver_names")

    @property
    @pulumi.getter(name="receiverType")
    def receiver_type(self) -> str:
        """
        The receiver type, Can be set as: `User`(The id of user).
        """
        return pulumi.get(self, "receiver_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class AlarmNotifyGroupsGroupResult(dict):
    def __init__(__self__, *,
                 alarm_notify_group_id: str,
                 alarm_notify_group_name: str,
                 create_time: str,
                 iam_project_name: str,
                 modify_time: str,
                 notify_types: Sequence[str],
                 receivers: Sequence['outputs.AlarmNotifyGroupsGroupReceiverResult']):
        """
        :param str alarm_notify_group_id: The id of the alarm notify group.
        :param str alarm_notify_group_name: The name of the alarm notify group.
        :param str create_time: The create time the notification.
        :param str iam_project_name: The name of the iam project.
        :param str modify_time: The modification time the notification.
        :param Sequence[str] notify_types: The notify group type.
        :param Sequence['AlarmNotifyGroupsGroupReceiverArgs'] receivers: List of IAM users to receive alerts.
        """
        pulumi.set(__self__, "alarm_notify_group_id", alarm_notify_group_id)
        pulumi.set(__self__, "alarm_notify_group_name", alarm_notify_group_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "iam_project_name", iam_project_name)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "notify_types", notify_types)
        pulumi.set(__self__, "receivers", receivers)

    @property
    @pulumi.getter(name="alarmNotifyGroupId")
    def alarm_notify_group_id(self) -> str:
        """
        The id of the alarm notify group.
        """
        return pulumi.get(self, "alarm_notify_group_id")

    @property
    @pulumi.getter(name="alarmNotifyGroupName")
    def alarm_notify_group_name(self) -> str:
        """
        The name of the alarm notify group.
        """
        return pulumi.get(self, "alarm_notify_group_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time the notification.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="iamProjectName")
    def iam_project_name(self) -> str:
        """
        The name of the iam project.
        """
        return pulumi.get(self, "iam_project_name")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modification time the notification.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="notifyTypes")
    def notify_types(self) -> Sequence[str]:
        """
        The notify group type.
        """
        return pulumi.get(self, "notify_types")

    @property
    @pulumi.getter
    def receivers(self) -> Sequence['outputs.AlarmNotifyGroupsGroupReceiverResult']:
        """
        List of IAM users to receive alerts.
        """
        return pulumi.get(self, "receivers")


@pulumi.output_type
class AlarmNotifyGroupsGroupReceiverResult(dict):
    def __init__(__self__, *,
                 end_time: str,
                 receiver_channels: Sequence[str],
                 receiver_names: Sequence[str],
                 receiver_type: str,
                 start_time: str):
        """
        :param str end_time: The end time.
        :param Sequence[str] receiver_channels: The list of the receiver channels.
        :param Sequence[str] receiver_names: List of the receiver names.
        :param str receiver_type: The receiver type.
        :param str start_time: The start time.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "receiver_channels", receiver_channels)
        pulumi.set(__self__, "receiver_names", receiver_names)
        pulumi.set(__self__, "receiver_type", receiver_type)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="receiverChannels")
    def receiver_channels(self) -> Sequence[str]:
        """
        The list of the receiver channels.
        """
        return pulumi.get(self, "receiver_channels")

    @property
    @pulumi.getter(name="receiverNames")
    def receiver_names(self) -> Sequence[str]:
        """
        List of the receiver names.
        """
        return pulumi.get(self, "receiver_names")

    @property
    @pulumi.getter(name="receiverType")
    def receiver_type(self) -> str:
        """
        The receiver type.
        """
        return pulumi.get(self, "receiver_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class AlarmQueryRequest(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "endTimeOffset":
            suggest = "end_time_offset"
        elif key == "startTimeOffset":
            suggest = "start_time_offset"
        elif key == "topicId":
            suggest = "topic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AlarmQueryRequest. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AlarmQueryRequest.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AlarmQueryRequest.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 end_time_offset: int,
                 number: int,
                 query: str,
                 start_time_offset: int,
                 topic_id: str):
        """
        :param int end_time_offset: The end time of the query range is relative to the current historical time. The unit is minutes. The value is not positive and must be greater than StartTimeOffset. The maximum value is 0 and the minimum value is -1440.
        :param int number: Alarm object sequence number; increments from 1.
        :param str query: Query statement, the maximum supported length is 1024.
        :param int start_time_offset: The start time of the query range is relative to the current historical time, in minutes. The value is non-positive, the maximum value is 0, and the minimum value is -1440.
        :param str topic_id: The id of the topic.
        """
        pulumi.set(__self__, "end_time_offset", end_time_offset)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "start_time_offset", start_time_offset)
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> int:
        """
        The end time of the query range is relative to the current historical time. The unit is minutes. The value is not positive and must be greater than StartTimeOffset. The maximum value is 0 and the minimum value is -1440.
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter
    def number(self) -> int:
        """
        Alarm object sequence number; increments from 1.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query statement, the maximum supported length is 1024.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> int:
        """
        The start time of the query range is relative to the current historical time, in minutes. The value is non-positive, the maximum value is 0, and the minimum value is -1440.
        """
        return pulumi.get(self, "start_time_offset")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The id of the topic.
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class AlarmRequestCycle(dict):
    def __init__(__self__, *,
                 time: int,
                 type: str):
        """
        :param int time: The cycle of alarm task execution, or the time point of periodic execution. The unit is minutes, and the value range is 1~1440.
        :param str type: Execution cycle type.
               Period: Periodic execution, which means executing once every certain period of time.
               Fixed: Regular execution, which means executing at a fixed time point every day.
        """
        pulumi.set(__self__, "time", time)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def time(self) -> int:
        """
        The cycle of alarm task execution, or the time point of periodic execution. The unit is minutes, and the value range is 1~1440.
        """
        return pulumi.get(self, "time")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Execution cycle type.
        Period: Periodic execution, which means executing once every certain period of time.
        Fixed: Regular execution, which means executing at a fixed time point every day.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class AlarmsAlarmResult(dict):
    def __init__(__self__, *,
                 alarm_id: str,
                 alarm_name: str,
                 alarm_notify_groups: Sequence['outputs.AlarmsAlarmAlarmNotifyGroupResult'],
                 alarm_period: int,
                 alarm_period_details: Sequence['outputs.AlarmsAlarmAlarmPeriodDetailResult'],
                 condition: str,
                 create_time: str,
                 modify_time: str,
                 project_id: str,
                 query_requests: Sequence['outputs.AlarmsAlarmQueryRequestResult'],
                 request_cycles: Sequence['outputs.AlarmsAlarmRequestCycleResult'],
                 status: bool,
                 trigger_period: int,
                 user_define_msg: str):
        """
        :param str alarm_id: The alarm id.
        :param str alarm_name: The alarm name.
        :param Sequence['AlarmsAlarmAlarmNotifyGroupArgs'] alarm_notify_groups: List of notification groups corresponding to the alarm.
        :param int alarm_period: Period for sending alarm notifications. When the number of continuous alarm triggers reaches the specified limit (TriggerPeriod), Log Service will send alarm notifications according to the specified period.
        :param Sequence['AlarmsAlarmAlarmPeriodDetailArgs'] alarm_period_details: Period for sending alarm notifications. When the number of continuous alarm triggers reaches the specified limit (TriggerPeriod), Log Service will send alarm notifications according to the specified period.
        :param str condition: Alarm trigger condition.
        :param str create_time: The create time.
        :param str modify_time: The modify time.
        :param str project_id: The project id.
        :param Sequence['AlarmsAlarmQueryRequestArgs'] query_requests: Search and analyze sentences, 1~3 can be configured.
        :param Sequence['AlarmsAlarmRequestCycleArgs'] request_cycles: The execution period of the alarm task.
        :param bool status: The status.
        :param int trigger_period: Continuous cycle. The alarm will be issued after the trigger condition is continuously met for TriggerPeriod periods; the minimum value is 1, the maximum value is 10, and the default value is 1.
        :param str user_define_msg: Customize the alarm notification content.
        """
        pulumi.set(__self__, "alarm_id", alarm_id)
        pulumi.set(__self__, "alarm_name", alarm_name)
        pulumi.set(__self__, "alarm_notify_groups", alarm_notify_groups)
        pulumi.set(__self__, "alarm_period", alarm_period)
        pulumi.set(__self__, "alarm_period_details", alarm_period_details)
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "query_requests", query_requests)
        pulumi.set(__self__, "request_cycles", request_cycles)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "trigger_period", trigger_period)
        pulumi.set(__self__, "user_define_msg", user_define_msg)

    @property
    @pulumi.getter(name="alarmId")
    def alarm_id(self) -> str:
        """
        The alarm id.
        """
        return pulumi.get(self, "alarm_id")

    @property
    @pulumi.getter(name="alarmName")
    def alarm_name(self) -> str:
        """
        The alarm name.
        """
        return pulumi.get(self, "alarm_name")

    @property
    @pulumi.getter(name="alarmNotifyGroups")
    def alarm_notify_groups(self) -> Sequence['outputs.AlarmsAlarmAlarmNotifyGroupResult']:
        """
        List of notification groups corresponding to the alarm.
        """
        return pulumi.get(self, "alarm_notify_groups")

    @property
    @pulumi.getter(name="alarmPeriod")
    def alarm_period(self) -> int:
        """
        Period for sending alarm notifications. When the number of continuous alarm triggers reaches the specified limit (TriggerPeriod), Log Service will send alarm notifications according to the specified period.
        """
        return pulumi.get(self, "alarm_period")

    @property
    @pulumi.getter(name="alarmPeriodDetails")
    def alarm_period_details(self) -> Sequence['outputs.AlarmsAlarmAlarmPeriodDetailResult']:
        """
        Period for sending alarm notifications. When the number of continuous alarm triggers reaches the specified limit (TriggerPeriod), Log Service will send alarm notifications according to the specified period.
        """
        return pulumi.get(self, "alarm_period_details")

    @property
    @pulumi.getter
    def condition(self) -> str:
        """
        Alarm trigger condition.
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modify time.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The project id.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="queryRequests")
    def query_requests(self) -> Sequence['outputs.AlarmsAlarmQueryRequestResult']:
        """
        Search and analyze sentences, 1~3 can be configured.
        """
        return pulumi.get(self, "query_requests")

    @property
    @pulumi.getter(name="requestCycles")
    def request_cycles(self) -> Sequence['outputs.AlarmsAlarmRequestCycleResult']:
        """
        The execution period of the alarm task.
        """
        return pulumi.get(self, "request_cycles")

    @property
    @pulumi.getter
    def status(self) -> bool:
        """
        The status.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="triggerPeriod")
    def trigger_period(self) -> int:
        """
        Continuous cycle. The alarm will be issued after the trigger condition is continuously met for TriggerPeriod periods; the minimum value is 1, the maximum value is 10, and the default value is 1.
        """
        return pulumi.get(self, "trigger_period")

    @property
    @pulumi.getter(name="userDefineMsg")
    def user_define_msg(self) -> str:
        """
        Customize the alarm notification content.
        """
        return pulumi.get(self, "user_define_msg")


@pulumi.output_type
class AlarmsAlarmAlarmNotifyGroupResult(dict):
    def __init__(__self__, *,
                 alarm_notify_group_id: str,
                 alarm_notify_group_name: str,
                 create_time: str,
                 iam_project_name: str,
                 modify_time: str,
                 notify_types: Sequence[str],
                 receivers: Sequence['outputs.AlarmsAlarmAlarmNotifyGroupReceiverResult']):
        """
        :param str alarm_notify_group_id: The id of the notify group.
        :param str alarm_notify_group_name: Name of the notification group.
        :param str create_time: The create time.
        :param str iam_project_name: The iam project name.
        :param str modify_time: The modify time.
        :param Sequence[str] notify_types: The notify group type.
        :param Sequence['AlarmsAlarmAlarmNotifyGroupReceiverArgs'] receivers: List of IAM users to receive alerts.
        """
        pulumi.set(__self__, "alarm_notify_group_id", alarm_notify_group_id)
        pulumi.set(__self__, "alarm_notify_group_name", alarm_notify_group_name)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "iam_project_name", iam_project_name)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "notify_types", notify_types)
        pulumi.set(__self__, "receivers", receivers)

    @property
    @pulumi.getter(name="alarmNotifyGroupId")
    def alarm_notify_group_id(self) -> str:
        """
        The id of the notify group.
        """
        return pulumi.get(self, "alarm_notify_group_id")

    @property
    @pulumi.getter(name="alarmNotifyGroupName")
    def alarm_notify_group_name(self) -> str:
        """
        Name of the notification group.
        """
        return pulumi.get(self, "alarm_notify_group_name")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="iamProjectName")
    def iam_project_name(self) -> str:
        """
        The iam project name.
        """
        return pulumi.get(self, "iam_project_name")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modify time.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="notifyTypes")
    def notify_types(self) -> Sequence[str]:
        """
        The notify group type.
        """
        return pulumi.get(self, "notify_types")

    @property
    @pulumi.getter
    def receivers(self) -> Sequence['outputs.AlarmsAlarmAlarmNotifyGroupReceiverResult']:
        """
        List of IAM users to receive alerts.
        """
        return pulumi.get(self, "receivers")


@pulumi.output_type
class AlarmsAlarmAlarmNotifyGroupReceiverResult(dict):
    def __init__(__self__, *,
                 end_time: str,
                 receiver_channels: Sequence[str],
                 receiver_names: Sequence[str],
                 receiver_type: str,
                 start_time: str):
        """
        :param str end_time: The end time.
        :param Sequence[str] receiver_channels: The list of the receiver channels.
        :param Sequence[str] receiver_names: List of the receiver names.
        :param str receiver_type: The receiver type.
        :param str start_time: The start time.
        """
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "receiver_channels", receiver_channels)
        pulumi.set(__self__, "receiver_names", receiver_names)
        pulumi.set(__self__, "receiver_type", receiver_type)
        pulumi.set(__self__, "start_time", start_time)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> str:
        """
        The end time.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter(name="receiverChannels")
    def receiver_channels(self) -> Sequence[str]:
        """
        The list of the receiver channels.
        """
        return pulumi.get(self, "receiver_channels")

    @property
    @pulumi.getter(name="receiverNames")
    def receiver_names(self) -> Sequence[str]:
        """
        List of the receiver names.
        """
        return pulumi.get(self, "receiver_names")

    @property
    @pulumi.getter(name="receiverType")
    def receiver_type(self) -> str:
        """
        The receiver type.
        """
        return pulumi.get(self, "receiver_type")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> str:
        """
        The start time.
        """
        return pulumi.get(self, "start_time")


@pulumi.output_type
class AlarmsAlarmAlarmPeriodDetailResult(dict):
    def __init__(__self__, *,
                 email: int,
                 general_webhook: int,
                 phone: int,
                 sms: int):
        """
        :param int email: Email alarm period, the unit is minutes, and the value range is 1~1440.
        :param int general_webhook: Customize the webhook alarm period, the unit is minutes, and the value range is 1~1440.
        :param int phone: Telephone alarm cycle, the unit is minutes, and the value range is 10~1440.
        :param int sms: SMS alarm cycle, the unit is minutes, and the value range is 10~1440.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "general_webhook", general_webhook)
        pulumi.set(__self__, "phone", phone)
        pulumi.set(__self__, "sms", sms)

    @property
    @pulumi.getter
    def email(self) -> int:
        """
        Email alarm period, the unit is minutes, and the value range is 1~1440.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="generalWebhook")
    def general_webhook(self) -> int:
        """
        Customize the webhook alarm period, the unit is minutes, and the value range is 1~1440.
        """
        return pulumi.get(self, "general_webhook")

    @property
    @pulumi.getter
    def phone(self) -> int:
        """
        Telephone alarm cycle, the unit is minutes, and the value range is 10~1440.
        """
        return pulumi.get(self, "phone")

    @property
    @pulumi.getter
    def sms(self) -> int:
        """
        SMS alarm cycle, the unit is minutes, and the value range is 10~1440.
        """
        return pulumi.get(self, "sms")


@pulumi.output_type
class AlarmsAlarmQueryRequestResult(dict):
    def __init__(__self__, *,
                 end_time_offset: int,
                 number: int,
                 query: str,
                 start_time_offset: int,
                 topic_id: str,
                 topic_name: str):
        """
        :param int end_time_offset: The end time of the query range is relative to the current historical time. The unit is minutes. The value is not positive and must be greater than StartTimeOffset. The maximum value is 0 and the minimum value is -1440.
        :param int number: Alarm object sequence number; increments from 1.
        :param str query: Query statement, the maximum supported length is 1024.
        :param int start_time_offset: The start time of the query range is relative to the current historical time, in minutes. The value is non-positive, the maximum value is 0, and the minimum value is -1440.
        :param str topic_id: The topic id.
        :param str topic_name: The topic name.
        """
        pulumi.set(__self__, "end_time_offset", end_time_offset)
        pulumi.set(__self__, "number", number)
        pulumi.set(__self__, "query", query)
        pulumi.set(__self__, "start_time_offset", start_time_offset)
        pulumi.set(__self__, "topic_id", topic_id)
        pulumi.set(__self__, "topic_name", topic_name)

    @property
    @pulumi.getter(name="endTimeOffset")
    def end_time_offset(self) -> int:
        """
        The end time of the query range is relative to the current historical time. The unit is minutes. The value is not positive and must be greater than StartTimeOffset. The maximum value is 0 and the minimum value is -1440.
        """
        return pulumi.get(self, "end_time_offset")

    @property
    @pulumi.getter
    def number(self) -> int:
        """
        Alarm object sequence number; increments from 1.
        """
        return pulumi.get(self, "number")

    @property
    @pulumi.getter
    def query(self) -> str:
        """
        Query statement, the maximum supported length is 1024.
        """
        return pulumi.get(self, "query")

    @property
    @pulumi.getter(name="startTimeOffset")
    def start_time_offset(self) -> int:
        """
        The start time of the query range is relative to the current historical time, in minutes. The value is non-positive, the maximum value is 0, and the minimum value is -1440.
        """
        return pulumi.get(self, "start_time_offset")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The topic id.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> str:
        """
        The topic name.
        """
        return pulumi.get(self, "topic_name")


@pulumi.output_type
class AlarmsAlarmRequestCycleResult(dict):
    def __init__(__self__, *,
                 time: int,
                 type: str):
        """
        :param int time: The cycle of alarm task execution, or the time point of periodic execution. The unit is minutes, and the value range is 1~1440.
        :param str type: Execution cycle type.
        """
        pulumi.set(__self__, "time", time)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def time(self) -> int:
        """
        The cycle of alarm task execution, or the time point of periodic execution. The unit is minutes, and the value range is 1~1440.
        """
        return pulumi.get(self, "time")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Execution cycle type.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class HostGroupsInfoResult(dict):
    def __init__(__self__, *,
                 abnormal_heartbeat_status_count: int,
                 agent_latest_version: str,
                 auto_update: bool,
                 create_time: str,
                 host_count: int,
                 host_group_id: str,
                 host_group_name: str,
                 host_group_type: str,
                 host_identifier: str,
                 host_ip_lists: Sequence[str],
                 iam_project_name: str,
                 modify_time: str,
                 normal_heartbeat_status_count: int,
                 rule_count: int,
                 service_logging: bool,
                 update_end_time: str,
                 update_start_time: str):
        """
        :param int abnormal_heartbeat_status_count: The abnormal heartbeat status count of host.
        :param str agent_latest_version: The latest version of log collector.
        :param bool auto_update: Whether enable auto update.
        :param str create_time: The create time of host group.
        :param int host_count: The count of host.
        :param str host_group_id: The id of host group.
        :param str host_group_name: The name of host group.
        :param str host_group_type: The type of host group.
        :param str host_identifier: The identifier of host.
        :param Sequence[str] host_ip_lists: The ip list of host group.
        :param str iam_project_name: The project name of iam.
        :param str modify_time: The modify time of host group.
        :param int normal_heartbeat_status_count: The normal heartbeat status count of host.
        :param int rule_count: The rule count of host.
        :param bool service_logging: Whether enable service logging.
        :param str update_end_time: The update end time of log collector.
        :param str update_start_time: The update start time of log collector.
        """
        pulumi.set(__self__, "abnormal_heartbeat_status_count", abnormal_heartbeat_status_count)
        pulumi.set(__self__, "agent_latest_version", agent_latest_version)
        pulumi.set(__self__, "auto_update", auto_update)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "host_count", host_count)
        pulumi.set(__self__, "host_group_id", host_group_id)
        pulumi.set(__self__, "host_group_name", host_group_name)
        pulumi.set(__self__, "host_group_type", host_group_type)
        pulumi.set(__self__, "host_identifier", host_identifier)
        pulumi.set(__self__, "host_ip_lists", host_ip_lists)
        pulumi.set(__self__, "iam_project_name", iam_project_name)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "normal_heartbeat_status_count", normal_heartbeat_status_count)
        pulumi.set(__self__, "rule_count", rule_count)
        pulumi.set(__self__, "service_logging", service_logging)
        pulumi.set(__self__, "update_end_time", update_end_time)
        pulumi.set(__self__, "update_start_time", update_start_time)

    @property
    @pulumi.getter(name="abnormalHeartbeatStatusCount")
    def abnormal_heartbeat_status_count(self) -> int:
        """
        The abnormal heartbeat status count of host.
        """
        return pulumi.get(self, "abnormal_heartbeat_status_count")

    @property
    @pulumi.getter(name="agentLatestVersion")
    def agent_latest_version(self) -> str:
        """
        The latest version of log collector.
        """
        return pulumi.get(self, "agent_latest_version")

    @property
    @pulumi.getter(name="autoUpdate")
    def auto_update(self) -> bool:
        """
        Whether enable auto update.
        """
        return pulumi.get(self, "auto_update")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time of host group.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="hostCount")
    def host_count(self) -> int:
        """
        The count of host.
        """
        return pulumi.get(self, "host_count")

    @property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> str:
        """
        The id of host group.
        """
        return pulumi.get(self, "host_group_id")

    @property
    @pulumi.getter(name="hostGroupName")
    def host_group_name(self) -> str:
        """
        The name of host group.
        """
        return pulumi.get(self, "host_group_name")

    @property
    @pulumi.getter(name="hostGroupType")
    def host_group_type(self) -> str:
        """
        The type of host group.
        """
        return pulumi.get(self, "host_group_type")

    @property
    @pulumi.getter(name="hostIdentifier")
    def host_identifier(self) -> str:
        """
        The identifier of host.
        """
        return pulumi.get(self, "host_identifier")

    @property
    @pulumi.getter(name="hostIpLists")
    def host_ip_lists(self) -> Sequence[str]:
        """
        The ip list of host group.
        """
        return pulumi.get(self, "host_ip_lists")

    @property
    @pulumi.getter(name="iamProjectName")
    def iam_project_name(self) -> str:
        """
        The project name of iam.
        """
        return pulumi.get(self, "iam_project_name")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modify time of host group.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="normalHeartbeatStatusCount")
    def normal_heartbeat_status_count(self) -> int:
        """
        The normal heartbeat status count of host.
        """
        return pulumi.get(self, "normal_heartbeat_status_count")

    @property
    @pulumi.getter(name="ruleCount")
    def rule_count(self) -> int:
        """
        The rule count of host.
        """
        return pulumi.get(self, "rule_count")

    @property
    @pulumi.getter(name="serviceLogging")
    def service_logging(self) -> bool:
        """
        Whether enable service logging.
        """
        return pulumi.get(self, "service_logging")

    @property
    @pulumi.getter(name="updateEndTime")
    def update_end_time(self) -> str:
        """
        The update end time of log collector.
        """
        return pulumi.get(self, "update_end_time")

    @property
    @pulumi.getter(name="updateStartTime")
    def update_start_time(self) -> str:
        """
        The update start time of log collector.
        """
        return pulumi.get(self, "update_start_time")


@pulumi.output_type
class HostsHostInfoResult(dict):
    def __init__(__self__, *,
                 heartbeat_status: int,
                 host_group_id: str,
                 ip: str,
                 log_collector_version: str):
        """
        :param int heartbeat_status: The the heartbeat status.
        :param str host_group_id: The id of host group.
        :param str ip: The ip address.
        :param str log_collector_version: The version of log collector.
        """
        pulumi.set(__self__, "heartbeat_status", heartbeat_status)
        pulumi.set(__self__, "host_group_id", host_group_id)
        pulumi.set(__self__, "ip", ip)
        pulumi.set(__self__, "log_collector_version", log_collector_version)

    @property
    @pulumi.getter(name="heartbeatStatus")
    def heartbeat_status(self) -> int:
        """
        The the heartbeat status.
        """
        return pulumi.get(self, "heartbeat_status")

    @property
    @pulumi.getter(name="hostGroupId")
    def host_group_id(self) -> str:
        """
        The id of host group.
        """
        return pulumi.get(self, "host_group_id")

    @property
    @pulumi.getter
    def ip(self) -> str:
        """
        The ip address.
        """
        return pulumi.get(self, "ip")

    @property
    @pulumi.getter(name="logCollectorVersion")
    def log_collector_version(self) -> str:
        """
        The version of log collector.
        """
        return pulumi.get(self, "log_collector_version")


@pulumi.output_type
class IndexFullText(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "includeChinese":
            suggest = "include_chinese"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexFullText. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexFullText.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexFullText.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 case_sensitive: bool,
                 delimiter: Optional[str] = None,
                 include_chinese: Optional[bool] = None):
        """
        :param bool case_sensitive: Whether the FullTextInfo is case sensitive.
        :param str delimiter: The delimiter of the FullTextInfo.
        :param bool include_chinese: Whether the FullTextInfo include chinese.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> bool:
        """
        Whether the FullTextInfo is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        The delimiter of the FullTextInfo.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[bool]:
        """
        Whether the FullTextInfo include chinese.
        """
        return pulumi.get(self, "include_chinese")


@pulumi.output_type
class IndexKeyValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"
        elif key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "includeChinese":
            suggest = "include_chinese"
        elif key == "jsonKeys":
            suggest = "json_keys"
        elif key == "sqlFlag":
            suggest = "sql_flag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexKeyValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexKeyValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexKeyValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 value_type: str,
                 case_sensitive: Optional[bool] = None,
                 delimiter: Optional[str] = None,
                 include_chinese: Optional[bool] = None,
                 json_keys: Optional[Sequence['outputs.IndexKeyValueJsonKey']] = None,
                 sql_flag: Optional[bool] = None):
        """
        :param str key: The key of the KeyValueInfo.
        :param str value_type: The type of value. Valid values: `long`, `double`, `text`, `json`.
        :param bool case_sensitive: Whether the value is case sensitive.
        :param str delimiter: The delimiter of the value.
        :param bool include_chinese: Whether the value include chinese.
        :param Sequence['IndexKeyValueJsonKeyArgs'] json_keys: The JSON subfield key value index.
        :param bool sql_flag: Whether the filed is enabled for analysis.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if json_keys is not None:
            pulumi.set(__self__, "json_keys", json_keys)
        if sql_flag is not None:
            pulumi.set(__self__, "sql_flag", sql_flag)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the KeyValueInfo.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of value. Valid values: `long`, `double`, `text`, `json`.
        """
        return pulumi.get(self, "value_type")

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[bool]:
        """
        Whether the value is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        The delimiter of the value.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[bool]:
        """
        Whether the value include chinese.
        """
        return pulumi.get(self, "include_chinese")

    @property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Optional[Sequence['outputs.IndexKeyValueJsonKey']]:
        """
        The JSON subfield key value index.
        """
        return pulumi.get(self, "json_keys")

    @property
    @pulumi.getter(name="sqlFlag")
    def sql_flag(self) -> Optional[bool]:
        """
        Whether the filed is enabled for analysis.
        """
        return pulumi.get(self, "sql_flag")


@pulumi.output_type
class IndexKeyValueJsonKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexKeyValueJsonKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexKeyValueJsonKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexKeyValueJsonKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 value_type: str):
        """
        :param str key: The key of the subfield key value index.
        :param str value_type: The type of value. Valid values: `long`, `double`, `text`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the subfield key value index.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of value. Valid values: `long`, `double`, `text`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class IndexUserInnerKeyValue(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"
        elif key == "caseSensitive":
            suggest = "case_sensitive"
        elif key == "includeChinese":
            suggest = "include_chinese"
        elif key == "jsonKeys":
            suggest = "json_keys"
        elif key == "sqlFlag":
            suggest = "sql_flag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexUserInnerKeyValue. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexUserInnerKeyValue.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexUserInnerKeyValue.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 value_type: str,
                 case_sensitive: Optional[bool] = None,
                 delimiter: Optional[str] = None,
                 include_chinese: Optional[bool] = None,
                 json_keys: Optional[Sequence['outputs.IndexUserInnerKeyValueJsonKey']] = None,
                 sql_flag: Optional[bool] = None):
        """
        :param str key: The key of the KeyValueInfo.
        :param str value_type: The type of value. Valid values: `long`, `double`, `text`, `json`.
        :param bool case_sensitive: Whether the value is case sensitive.
        :param str delimiter: The delimiter of the value.
        :param bool include_chinese: Whether the value include chinese.
        :param Sequence['IndexUserInnerKeyValueJsonKeyArgs'] json_keys: The JSON subfield key value index.
        :param bool sql_flag: Whether the filed is enabled for analysis.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)
        if case_sensitive is not None:
            pulumi.set(__self__, "case_sensitive", case_sensitive)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if include_chinese is not None:
            pulumi.set(__self__, "include_chinese", include_chinese)
        if json_keys is not None:
            pulumi.set(__self__, "json_keys", json_keys)
        if sql_flag is not None:
            pulumi.set(__self__, "sql_flag", sql_flag)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the KeyValueInfo.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of value. Valid values: `long`, `double`, `text`, `json`.
        """
        return pulumi.get(self, "value_type")

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> Optional[bool]:
        """
        Whether the value is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        The delimiter of the value.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> Optional[bool]:
        """
        Whether the value include chinese.
        """
        return pulumi.get(self, "include_chinese")

    @property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Optional[Sequence['outputs.IndexUserInnerKeyValueJsonKey']]:
        """
        The JSON subfield key value index.
        """
        return pulumi.get(self, "json_keys")

    @property
    @pulumi.getter(name="sqlFlag")
    def sql_flag(self) -> Optional[bool]:
        """
        Whether the filed is enabled for analysis.
        """
        return pulumi.get(self, "sql_flag")


@pulumi.output_type
class IndexUserInnerKeyValueJsonKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "valueType":
            suggest = "value_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IndexUserInnerKeyValueJsonKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IndexUserInnerKeyValueJsonKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IndexUserInnerKeyValueJsonKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 key: str,
                 value_type: str):
        """
        :param str key: The key of the subfield key value index.
        :param str value_type: The type of value. Valid values: `long`, `double`, `text`.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the subfield key value index.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of value. Valid values: `long`, `double`, `text`.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class IndexesTlsIndexResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 full_text: 'outputs.IndexesTlsIndexFullTextResult',
                 id: str,
                 key_values: Sequence['outputs.IndexesTlsIndexKeyValueResult'],
                 modify_time: str,
                 topic_id: str,
                 user_inner_key_values: Sequence['outputs.IndexesTlsIndexUserInnerKeyValueResult']):
        """
        :param str create_time: The create time of the tls index.
        :param 'IndexesTlsIndexFullTextArgs' full_text: The FullText index of the tls topic.
        :param str id: The topic id of the tls index.
        :param Sequence['IndexesTlsIndexKeyValueArgs'] key_values: The KeyValue index of the tls topic.
        :param str modify_time: The modify time of the tls index.
        :param str topic_id: The topic id of the tls index.
        :param Sequence['IndexesTlsIndexUserInnerKeyValueArgs'] user_inner_key_values: The reserved field index configuration of the tls topic.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "full_text", full_text)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "key_values", key_values)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "topic_id", topic_id)
        pulumi.set(__self__, "user_inner_key_values", user_inner_key_values)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time of the tls index.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="fullText")
    def full_text(self) -> 'outputs.IndexesTlsIndexFullTextResult':
        """
        The FullText index of the tls topic.
        """
        return pulumi.get(self, "full_text")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The topic id of the tls index.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="keyValues")
    def key_values(self) -> Sequence['outputs.IndexesTlsIndexKeyValueResult']:
        """
        The KeyValue index of the tls topic.
        """
        return pulumi.get(self, "key_values")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modify time of the tls index.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The topic id of the tls index.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="userInnerKeyValues")
    def user_inner_key_values(self) -> Sequence['outputs.IndexesTlsIndexUserInnerKeyValueResult']:
        """
        The reserved field index configuration of the tls topic.
        """
        return pulumi.get(self, "user_inner_key_values")


@pulumi.output_type
class IndexesTlsIndexFullTextResult(dict):
    def __init__(__self__, *,
                 case_sensitive: bool,
                 delimiter: str,
                 include_chinese: bool):
        """
        :param bool case_sensitive: Whether the value is case sensitive.
        :param str delimiter: The delimiter of the value.
        :param bool include_chinese: Whether the value include chinese.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "include_chinese", include_chinese)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> bool:
        """
        Whether the value is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        The delimiter of the value.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> bool:
        """
        Whether the value include chinese.
        """
        return pulumi.get(self, "include_chinese")


@pulumi.output_type
class IndexesTlsIndexKeyValueResult(dict):
    def __init__(__self__, *,
                 case_sensitive: bool,
                 delimiter: str,
                 include_chinese: bool,
                 json_keys: Sequence['outputs.IndexesTlsIndexKeyValueJsonKeyResult'],
                 key: str,
                 sql_flag: bool,
                 value_type: str):
        """
        :param bool case_sensitive: Whether the value is case sensitive.
        :param str delimiter: The delimiter of the value.
        :param bool include_chinese: Whether the value include chinese.
        :param Sequence['IndexesTlsIndexKeyValueJsonKeyArgs'] json_keys: The JSON subfield key value index.
        :param str key: The key of the KeyValue index.
        :param bool sql_flag: Whether the filed is enabled for analysis.
        :param str value_type: The type of value.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "include_chinese", include_chinese)
        pulumi.set(__self__, "json_keys", json_keys)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "sql_flag", sql_flag)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> bool:
        """
        Whether the value is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        The delimiter of the value.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> bool:
        """
        Whether the value include chinese.
        """
        return pulumi.get(self, "include_chinese")

    @property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Sequence['outputs.IndexesTlsIndexKeyValueJsonKeyResult']:
        """
        The JSON subfield key value index.
        """
        return pulumi.get(self, "json_keys")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the KeyValue index.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="sqlFlag")
    def sql_flag(self) -> bool:
        """
        Whether the filed is enabled for analysis.
        """
        return pulumi.get(self, "sql_flag")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of value.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class IndexesTlsIndexKeyValueJsonKeyResult(dict):
    def __init__(__self__, *,
                 case_sensitive: bool,
                 delimiter: str,
                 include_chinese: bool,
                 key: str,
                 sql_flag: bool,
                 value_type: str):
        """
        :param bool case_sensitive: Whether the value is case sensitive.
        :param str delimiter: The delimiter of the value.
        :param bool include_chinese: Whether the value include chinese.
        :param str key: The key of the KeyValue index.
        :param bool sql_flag: Whether the filed is enabled for analysis.
        :param str value_type: The type of value.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "include_chinese", include_chinese)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "sql_flag", sql_flag)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> bool:
        """
        Whether the value is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        The delimiter of the value.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> bool:
        """
        Whether the value include chinese.
        """
        return pulumi.get(self, "include_chinese")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the KeyValue index.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="sqlFlag")
    def sql_flag(self) -> bool:
        """
        Whether the filed is enabled for analysis.
        """
        return pulumi.get(self, "sql_flag")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of value.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class IndexesTlsIndexUserInnerKeyValueResult(dict):
    def __init__(__self__, *,
                 case_sensitive: bool,
                 delimiter: str,
                 include_chinese: bool,
                 json_keys: Sequence['outputs.IndexesTlsIndexUserInnerKeyValueJsonKeyResult'],
                 key: str,
                 sql_flag: bool,
                 value_type: str):
        """
        :param bool case_sensitive: Whether the value is case sensitive.
        :param str delimiter: The delimiter of the value.
        :param bool include_chinese: Whether the value include chinese.
        :param Sequence['IndexesTlsIndexUserInnerKeyValueJsonKeyArgs'] json_keys: The JSON subfield key value index.
        :param str key: The key of the KeyValue index.
        :param bool sql_flag: Whether the filed is enabled for analysis.
        :param str value_type: The type of value.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "include_chinese", include_chinese)
        pulumi.set(__self__, "json_keys", json_keys)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "sql_flag", sql_flag)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> bool:
        """
        Whether the value is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        The delimiter of the value.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> bool:
        """
        Whether the value include chinese.
        """
        return pulumi.get(self, "include_chinese")

    @property
    @pulumi.getter(name="jsonKeys")
    def json_keys(self) -> Sequence['outputs.IndexesTlsIndexUserInnerKeyValueJsonKeyResult']:
        """
        The JSON subfield key value index.
        """
        return pulumi.get(self, "json_keys")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the KeyValue index.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="sqlFlag")
    def sql_flag(self) -> bool:
        """
        Whether the filed is enabled for analysis.
        """
        return pulumi.get(self, "sql_flag")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of value.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class IndexesTlsIndexUserInnerKeyValueJsonKeyResult(dict):
    def __init__(__self__, *,
                 case_sensitive: bool,
                 delimiter: str,
                 include_chinese: bool,
                 key: str,
                 sql_flag: bool,
                 value_type: str):
        """
        :param bool case_sensitive: Whether the value is case sensitive.
        :param str delimiter: The delimiter of the value.
        :param bool include_chinese: Whether the value include chinese.
        :param str key: The key of the KeyValue index.
        :param bool sql_flag: Whether the filed is enabled for analysis.
        :param str value_type: The type of value.
        """
        pulumi.set(__self__, "case_sensitive", case_sensitive)
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "include_chinese", include_chinese)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "sql_flag", sql_flag)
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="caseSensitive")
    def case_sensitive(self) -> bool:
        """
        Whether the value is case sensitive.
        """
        return pulumi.get(self, "case_sensitive")

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        The delimiter of the value.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="includeChinese")
    def include_chinese(self) -> bool:
        """
        Whether the value include chinese.
        """
        return pulumi.get(self, "include_chinese")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the KeyValue index.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="sqlFlag")
    def sql_flag(self) -> bool:
        """
        Whether the filed is enabled for analysis.
        """
        return pulumi.get(self, "sql_flag")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        The type of value.
        """
        return pulumi.get(self, "value_type")


@pulumi.output_type
class KafkaConsumersDataResult(dict):
    def __init__(__self__, *,
                 allow_consume: bool,
                 consume_topic: str,
                 topic_id: str):
        """
        :param bool allow_consume: Whether allow consume.
        :param str consume_topic: The topic of consume.
        :param str topic_id: The ID of Topic.
        """
        pulumi.set(__self__, "allow_consume", allow_consume)
        pulumi.set(__self__, "consume_topic", consume_topic)
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="allowConsume")
    def allow_consume(self) -> bool:
        """
        Whether allow consume.
        """
        return pulumi.get(self, "allow_consume")

    @property
    @pulumi.getter(name="consumeTopic")
    def consume_topic(self) -> str:
        """
        The topic of consume.
        """
        return pulumi.get(self, "consume_topic")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The ID of Topic.
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class ProjectTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectsTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ProjectsTlsProjectResult(dict):
    def __init__(__self__, *,
                 create_time: str,
                 description: str,
                 iam_project_name: str,
                 id: str,
                 inner_net_domain: str,
                 project_id: str,
                 project_name: str,
                 tags: Sequence['outputs.ProjectsTlsProjectTagResult'],
                 topic_count: int):
        """
        :param str create_time: The create time of the tls project.
        :param str description: The description of the tls project.
        :param str iam_project_name: The IAM project name of the tls project.
        :param str id: The ID of the tls project.
        :param str inner_net_domain: The inner net domain of the tls project.
        :param str project_id: The id of tls project. This field supports fuzzy queries. It is not supported to specify both ProjectName and ProjectId at the same time.
        :param str project_name: The name of tls project. This field supports fuzzy queries. It is not supported to specify both ProjectName and ProjectId at the same time.
        :param Sequence['ProjectsTlsProjectTagArgs'] tags: Tags.
        :param int topic_count: The count of topics in the tls project.
        """
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "iam_project_name", iam_project_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "inner_net_domain", inner_net_domain)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "project_name", project_name)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "topic_count", topic_count)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time of the tls project.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the tls project.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="iamProjectName")
    def iam_project_name(self) -> str:
        """
        The IAM project name of the tls project.
        """
        return pulumi.get(self, "iam_project_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the tls project.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="innerNetDomain")
    def inner_net_domain(self) -> str:
        """
        The inner net domain of the tls project.
        """
        return pulumi.get(self, "inner_net_domain")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The id of tls project. This field supports fuzzy queries. It is not supported to specify both ProjectName and ProjectId at the same time.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> str:
        """
        The name of tls project. This field supports fuzzy queries. It is not supported to specify both ProjectName and ProjectId at the same time.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.ProjectsTlsProjectTagResult']:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="topicCount")
    def topic_count(self) -> int:
        """
        The count of topics in the tls project.
        """
        return pulumi.get(self, "topic_count")


@pulumi.output_type
class ProjectsTlsProjectTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleAppliersRuleResult(dict):
    def __init__(__self__, *,
                 container_rules: Sequence['outputs.RuleAppliersRuleContainerRuleResult'],
                 create_time: str,
                 exclude_paths: Sequence['outputs.RuleAppliersRuleExcludePathResult'],
                 extract_rules: Sequence['outputs.RuleAppliersRuleExtractRuleResult'],
                 input_type: int,
                 log_sample: str,
                 log_type: str,
                 modify_time: str,
                 paths: Sequence[str],
                 rule_id: str,
                 rule_name: str,
                 topic_id: str,
                 topic_name: str,
                 user_define_rules: Sequence['outputs.RuleAppliersRuleUserDefineRuleResult']):
        """
        :param Sequence['RuleAppliersRuleContainerRuleArgs'] container_rules: Container collection rules.
        :param str create_time: The creation time.
        :param Sequence['RuleAppliersRuleExcludePathArgs'] exclude_paths: Collect the blacklist list.
        :param Sequence['RuleAppliersRuleExtractRuleArgs'] extract_rules: The extract rule.
        :param int input_type: The collection type.
        :param str log_sample: Log sample.
        :param str log_type: The log type.
        :param str modify_time: The modification time.
        :param Sequence[str] paths: Collection path list.
        :param str rule_id: The rule id.
        :param str rule_name: The rule name.
        :param str topic_id: The topic id.
        :param str topic_name: The topic name.
        :param Sequence['RuleAppliersRuleUserDefineRuleArgs'] user_define_rules: User-defined collection rules.
        """
        pulumi.set(__self__, "container_rules", container_rules)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "exclude_paths", exclude_paths)
        pulumi.set(__self__, "extract_rules", extract_rules)
        pulumi.set(__self__, "input_type", input_type)
        pulumi.set(__self__, "log_sample", log_sample)
        pulumi.set(__self__, "log_type", log_type)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "topic_id", topic_id)
        pulumi.set(__self__, "topic_name", topic_name)
        pulumi.set(__self__, "user_define_rules", user_define_rules)

    @property
    @pulumi.getter(name="containerRules")
    def container_rules(self) -> Sequence['outputs.RuleAppliersRuleContainerRuleResult']:
        """
        Container collection rules.
        """
        return pulumi.get(self, "container_rules")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="excludePaths")
    def exclude_paths(self) -> Sequence['outputs.RuleAppliersRuleExcludePathResult']:
        """
        Collect the blacklist list.
        """
        return pulumi.get(self, "exclude_paths")

    @property
    @pulumi.getter(name="extractRules")
    def extract_rules(self) -> Sequence['outputs.RuleAppliersRuleExtractRuleResult']:
        """
        The extract rule.
        """
        return pulumi.get(self, "extract_rules")

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> int:
        """
        The collection type.
        """
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter(name="logSample")
    def log_sample(self) -> str:
        """
        Log sample.
        """
        return pulumi.get(self, "log_sample")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modification time.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Collection path list.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> str:
        """
        The rule id.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> str:
        """
        The rule name.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The topic id.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> str:
        """
        The topic name.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="userDefineRules")
    def user_define_rules(self) -> Sequence['outputs.RuleAppliersRuleUserDefineRuleResult']:
        """
        User-defined collection rules.
        """
        return pulumi.get(self, "user_define_rules")


@pulumi.output_type
class RuleAppliersRuleContainerRuleResult(dict):
    def __init__(__self__, *,
                 container_name_regex: str,
                 env_tag: Mapping[str, Any],
                 exclude_container_env_regex: Mapping[str, Any],
                 exclude_container_label_regex: Mapping[str, Any],
                 include_container_env_regex: Mapping[str, Any],
                 include_container_label_regex: Mapping[str, Any],
                 kubernetes_rules: Sequence['outputs.RuleAppliersRuleContainerRuleKubernetesRuleResult'],
                 stream: str):
        """
        :param str container_name_regex: The name of the container to be collected.
        :param Mapping[str, Any] env_tag: Whether to add environment variables as log tags to raw log data.
        :param Mapping[str, Any] exclude_container_env_regex: The container environment variable blacklist is used to specify the range of containers not to be collected.
        :param Mapping[str, Any] exclude_container_label_regex: The container Label blacklist is used to specify the range of containers not to be collected.
        :param Mapping[str, Any] include_container_env_regex: The container environment variable whitelist specifies the container to be collected through the container environment variable. If the whitelist is not enabled, it means that all containers are specified to be collected.
        :param Mapping[str, Any] include_container_label_regex: The container label whitelist specifies the containers to be collected through the container label. If the whitelist is not enabled, all containers are specified to be collected.
        :param Sequence['RuleAppliersRuleContainerRuleKubernetesRuleArgs'] kubernetes_rules: Collection rules for Kubernetes containers.
        :param str stream: The collection mode.
        """
        pulumi.set(__self__, "container_name_regex", container_name_regex)
        pulumi.set(__self__, "env_tag", env_tag)
        pulumi.set(__self__, "exclude_container_env_regex", exclude_container_env_regex)
        pulumi.set(__self__, "exclude_container_label_regex", exclude_container_label_regex)
        pulumi.set(__self__, "include_container_env_regex", include_container_env_regex)
        pulumi.set(__self__, "include_container_label_regex", include_container_label_regex)
        pulumi.set(__self__, "kubernetes_rules", kubernetes_rules)
        pulumi.set(__self__, "stream", stream)

    @property
    @pulumi.getter(name="containerNameRegex")
    def container_name_regex(self) -> str:
        """
        The name of the container to be collected.
        """
        return pulumi.get(self, "container_name_regex")

    @property
    @pulumi.getter(name="envTag")
    def env_tag(self) -> Mapping[str, Any]:
        """
        Whether to add environment variables as log tags to raw log data.
        """
        return pulumi.get(self, "env_tag")

    @property
    @pulumi.getter(name="excludeContainerEnvRegex")
    def exclude_container_env_regex(self) -> Mapping[str, Any]:
        """
        The container environment variable blacklist is used to specify the range of containers not to be collected.
        """
        return pulumi.get(self, "exclude_container_env_regex")

    @property
    @pulumi.getter(name="excludeContainerLabelRegex")
    def exclude_container_label_regex(self) -> Mapping[str, Any]:
        """
        The container Label blacklist is used to specify the range of containers not to be collected.
        """
        return pulumi.get(self, "exclude_container_label_regex")

    @property
    @pulumi.getter(name="includeContainerEnvRegex")
    def include_container_env_regex(self) -> Mapping[str, Any]:
        """
        The container environment variable whitelist specifies the container to be collected through the container environment variable. If the whitelist is not enabled, it means that all containers are specified to be collected.
        """
        return pulumi.get(self, "include_container_env_regex")

    @property
    @pulumi.getter(name="includeContainerLabelRegex")
    def include_container_label_regex(self) -> Mapping[str, Any]:
        """
        The container label whitelist specifies the containers to be collected through the container label. If the whitelist is not enabled, all containers are specified to be collected.
        """
        return pulumi.get(self, "include_container_label_regex")

    @property
    @pulumi.getter(name="kubernetesRules")
    def kubernetes_rules(self) -> Sequence['outputs.RuleAppliersRuleContainerRuleKubernetesRuleResult']:
        """
        Collection rules for Kubernetes containers.
        """
        return pulumi.get(self, "kubernetes_rules")

    @property
    @pulumi.getter
    def stream(self) -> str:
        """
        The collection mode.
        """
        return pulumi.get(self, "stream")


@pulumi.output_type
class RuleAppliersRuleContainerRuleKubernetesRuleResult(dict):
    def __init__(__self__, *,
                 annotation_tag: Mapping[str, Any],
                 exclude_pod_label_regex: Mapping[str, Any],
                 include_pod_label_regex: Mapping[str, Any],
                 label_tag: Mapping[str, Any],
                 namespace_name_regex: str,
                 pod_name_regex: str,
                 workload_name_regex: str,
                 workload_type: str):
        """
        :param Mapping[str, Any] annotation_tag: Whether to add Kubernetes Annotation as a log tag to the raw log data.
        :param Mapping[str, Any] exclude_pod_label_regex: Specify the containers not to be collected through the Pod Label blacklist, and not enable means to collect all containers.
        :param Mapping[str, Any] include_pod_label_regex: The Pod Label whitelist is used to specify containers to be collected. When the Pod Label whitelist is not enabled, it means that all containers are collected.
        :param Mapping[str, Any] label_tag: Whether to add Kubernetes Label as a log label to the original log data.
        :param str namespace_name_regex: The name of the Kubernetes Namespace to be collected. If no Namespace name is specified, all containers will be collected. Namespace names support regular matching.
        :param str pod_name_regex: The Pod name is used to specify the container to be collected. When no Pod name is specified, it means to collect all containers.
        :param str workload_name_regex: Specify the container to be collected by the name of the workload. When no workload name is specified, all containers are collected. The workload name supports regular matching.
        :param str workload_type: Specify the container to be collected by the type of workload. Only one type can be selected. When no type is specified, it means to collect all types of containers.
        """
        pulumi.set(__self__, "annotation_tag", annotation_tag)
        pulumi.set(__self__, "exclude_pod_label_regex", exclude_pod_label_regex)
        pulumi.set(__self__, "include_pod_label_regex", include_pod_label_regex)
        pulumi.set(__self__, "label_tag", label_tag)
        pulumi.set(__self__, "namespace_name_regex", namespace_name_regex)
        pulumi.set(__self__, "pod_name_regex", pod_name_regex)
        pulumi.set(__self__, "workload_name_regex", workload_name_regex)
        pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="annotationTag")
    def annotation_tag(self) -> Mapping[str, Any]:
        """
        Whether to add Kubernetes Annotation as a log tag to the raw log data.
        """
        return pulumi.get(self, "annotation_tag")

    @property
    @pulumi.getter(name="excludePodLabelRegex")
    def exclude_pod_label_regex(self) -> Mapping[str, Any]:
        """
        Specify the containers not to be collected through the Pod Label blacklist, and not enable means to collect all containers.
        """
        return pulumi.get(self, "exclude_pod_label_regex")

    @property
    @pulumi.getter(name="includePodLabelRegex")
    def include_pod_label_regex(self) -> Mapping[str, Any]:
        """
        The Pod Label whitelist is used to specify containers to be collected. When the Pod Label whitelist is not enabled, it means that all containers are collected.
        """
        return pulumi.get(self, "include_pod_label_regex")

    @property
    @pulumi.getter(name="labelTag")
    def label_tag(self) -> Mapping[str, Any]:
        """
        Whether to add Kubernetes Label as a log label to the original log data.
        """
        return pulumi.get(self, "label_tag")

    @property
    @pulumi.getter(name="namespaceNameRegex")
    def namespace_name_regex(self) -> str:
        """
        The name of the Kubernetes Namespace to be collected. If no Namespace name is specified, all containers will be collected. Namespace names support regular matching.
        """
        return pulumi.get(self, "namespace_name_regex")

    @property
    @pulumi.getter(name="podNameRegex")
    def pod_name_regex(self) -> str:
        """
        The Pod name is used to specify the container to be collected. When no Pod name is specified, it means to collect all containers.
        """
        return pulumi.get(self, "pod_name_regex")

    @property
    @pulumi.getter(name="workloadNameRegex")
    def workload_name_regex(self) -> str:
        """
        Specify the container to be collected by the name of the workload. When no workload name is specified, all containers are collected. The workload name supports regular matching.
        """
        return pulumi.get(self, "workload_name_regex")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Specify the container to be collected by the type of workload. Only one type can be selected. When no type is specified, it means to collect all types of containers.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class RuleAppliersRuleExcludePathResult(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: The type of the log template.
        :param str value: Collection path.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the log template.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Collection path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleAppliersRuleExtractRuleResult(dict):
    def __init__(__self__, *,
                 begin_regex: str,
                 delimiter: str,
                 filter_key_regexes: Sequence['outputs.RuleAppliersRuleExtractRuleFilterKeyRegexResult'],
                 keys: Sequence[str],
                 log_regex: str,
                 log_templates: Sequence['outputs.RuleAppliersRuleExtractRuleLogTemplateResult'],
                 time_format: str,
                 time_key: str,
                 un_match_log_key: str,
                 un_match_up_load_switch: bool):
        """
        :param str begin_regex: The first log line needs to match the regular expression.
        :param str delimiter: The delimiter of the log.
        :param Sequence['RuleAppliersRuleExtractRuleFilterKeyRegexArgs'] filter_key_regexes: The filter key list.
        :param Sequence[str] keys: A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        :param str log_regex: The entire log needs to match the regular expression.
        :param Sequence['RuleAppliersRuleExtractRuleLogTemplateArgs'] log_templates: Automatically extract log fields according to the specified log template.
        :param str time_format: Parsing format of the time field.
        :param str time_key: The field name of the log time field.
        :param str un_match_log_key: When uploading the failed log, the key name of the failed log.
        :param bool un_match_up_load_switch: Whether to upload the log of parsing failure.
        """
        pulumi.set(__self__, "begin_regex", begin_regex)
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "filter_key_regexes", filter_key_regexes)
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "log_regex", log_regex)
        pulumi.set(__self__, "log_templates", log_templates)
        pulumi.set(__self__, "time_format", time_format)
        pulumi.set(__self__, "time_key", time_key)
        pulumi.set(__self__, "un_match_log_key", un_match_log_key)
        pulumi.set(__self__, "un_match_up_load_switch", un_match_up_load_switch)

    @property
    @pulumi.getter(name="beginRegex")
    def begin_regex(self) -> str:
        """
        The first log line needs to match the regular expression.
        """
        return pulumi.get(self, "begin_regex")

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        The delimiter of the log.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="filterKeyRegexes")
    def filter_key_regexes(self) -> Sequence['outputs.RuleAppliersRuleExtractRuleFilterKeyRegexResult']:
        """
        The filter key list.
        """
        return pulumi.get(self, "filter_key_regexes")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="logRegex")
    def log_regex(self) -> str:
        """
        The entire log needs to match the regular expression.
        """
        return pulumi.get(self, "log_regex")

    @property
    @pulumi.getter(name="logTemplates")
    def log_templates(self) -> Sequence['outputs.RuleAppliersRuleExtractRuleLogTemplateResult']:
        """
        Automatically extract log fields according to the specified log template.
        """
        return pulumi.get(self, "log_templates")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Parsing format of the time field.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeKey")
    def time_key(self) -> str:
        """
        The field name of the log time field.
        """
        return pulumi.get(self, "time_key")

    @property
    @pulumi.getter(name="unMatchLogKey")
    def un_match_log_key(self) -> str:
        """
        When uploading the failed log, the key name of the failed log.
        """
        return pulumi.get(self, "un_match_log_key")

    @property
    @pulumi.getter(name="unMatchUpLoadSwitch")
    def un_match_up_load_switch(self) -> bool:
        """
        Whether to upload the log of parsing failure.
        """
        return pulumi.get(self, "un_match_up_load_switch")


@pulumi.output_type
class RuleAppliersRuleExtractRuleFilterKeyRegexResult(dict):
    def __init__(__self__, *,
                 key: str,
                 regex: str):
        """
        :param str key: The name of the filter key.
        :param str regex: Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the filter key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def regex(self) -> str:
        """
        Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class RuleAppliersRuleExtractRuleLogTemplateResult(dict):
    def __init__(__self__, *,
                 format: str,
                 type: str):
        """
        :param str format: Log template content.
        :param str type: The type of the log template.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        Log template content.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the log template.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RuleAppliersRuleUserDefineRuleResult(dict):
    def __init__(__self__, *,
                 advanceds: Sequence['outputs.RuleAppliersRuleUserDefineRuleAdvancedResult'],
                 enable_raw_log: bool,
                 fields: Mapping[str, Any],
                 parse_path_rules: Sequence['outputs.RuleAppliersRuleUserDefineRuleParsePathRuleResult'],
                 plugins: Sequence['outputs.RuleAppliersRuleUserDefineRulePluginResult'],
                 shard_hash_keys: Sequence['outputs.RuleAppliersRuleUserDefineRuleShardHashKeyResult'],
                 tail_files: bool):
        """
        :param Sequence['RuleAppliersRuleUserDefineRuleAdvancedArgs'] advanceds: LogCollector extension configuration.
        :param bool enable_raw_log: Whether to upload raw logs.
        :param Mapping[str, Any] fields: Add constant fields to logs.
        :param Sequence['RuleAppliersRuleUserDefineRuleParsePathRuleArgs'] parse_path_rules: Rules for parsing collection paths. After the rules are set, the fields in the collection path will be extracted through the regular expressions specified in the rules, and added to the log data as metadata.
        :param Sequence['RuleAppliersRuleUserDefineRulePluginArgs'] plugins: Plugin configuration. After the plugin configuration is enabled, one or more LogCollector processor plugins can be added to parse logs with complex or variable structures.
        :param Sequence['RuleAppliersRuleUserDefineRuleShardHashKeyArgs'] shard_hash_keys: Rules for routing log partitions. Setting this parameter indicates that the HashKey routing shard mode is used when collecting logs, and Log Service will write the data to the shard containing the specified Key value.
        :param bool tail_files: LogCollector collection strategy, which specifies whether LogCollector collects incremental logs or full logs. The default is false, which means to collect all logs.
        """
        pulumi.set(__self__, "advanceds", advanceds)
        pulumi.set(__self__, "enable_raw_log", enable_raw_log)
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "parse_path_rules", parse_path_rules)
        pulumi.set(__self__, "plugins", plugins)
        pulumi.set(__self__, "shard_hash_keys", shard_hash_keys)
        pulumi.set(__self__, "tail_files", tail_files)

    @property
    @pulumi.getter
    def advanceds(self) -> Sequence['outputs.RuleAppliersRuleUserDefineRuleAdvancedResult']:
        """
        LogCollector extension configuration.
        """
        return pulumi.get(self, "advanceds")

    @property
    @pulumi.getter(name="enableRawLog")
    def enable_raw_log(self) -> bool:
        """
        Whether to upload raw logs.
        """
        return pulumi.get(self, "enable_raw_log")

    @property
    @pulumi.getter
    def fields(self) -> Mapping[str, Any]:
        """
        Add constant fields to logs.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="parsePathRules")
    def parse_path_rules(self) -> Sequence['outputs.RuleAppliersRuleUserDefineRuleParsePathRuleResult']:
        """
        Rules for parsing collection paths. After the rules are set, the fields in the collection path will be extracted through the regular expressions specified in the rules, and added to the log data as metadata.
        """
        return pulumi.get(self, "parse_path_rules")

    @property
    @pulumi.getter
    def plugins(self) -> Sequence['outputs.RuleAppliersRuleUserDefineRulePluginResult']:
        """
        Plugin configuration. After the plugin configuration is enabled, one or more LogCollector processor plugins can be added to parse logs with complex or variable structures.
        """
        return pulumi.get(self, "plugins")

    @property
    @pulumi.getter(name="shardHashKeys")
    def shard_hash_keys(self) -> Sequence['outputs.RuleAppliersRuleUserDefineRuleShardHashKeyResult']:
        """
        Rules for routing log partitions. Setting this parameter indicates that the HashKey routing shard mode is used when collecting logs, and Log Service will write the data to the shard containing the specified Key value.
        """
        return pulumi.get(self, "shard_hash_keys")

    @property
    @pulumi.getter(name="tailFiles")
    def tail_files(self) -> bool:
        """
        LogCollector collection strategy, which specifies whether LogCollector collects incremental logs or full logs. The default is false, which means to collect all logs.
        """
        return pulumi.get(self, "tail_files")


@pulumi.output_type
class RuleAppliersRuleUserDefineRuleAdvancedResult(dict):
    def __init__(__self__, *,
                 close_eof: bool,
                 close_inactive: int,
                 close_removed: bool,
                 close_renamed: bool,
                 close_timeout: int):
        """
        :param bool close_eof: Whether to release the log file handle after reading to the end of the log file. The default is false.
        :param int close_inactive: The wait time to release the log file handle. When the log file has not written a new log for more than the specified time, release the handle of the log file.
        :param bool close_removed: After the log file is removed, whether to release the handle of the log file. The default is false.
        :param bool close_renamed: After the log file is renamed, whether to release the handle of the log file. The default is false.
        :param int close_timeout: The maximum length of time that LogCollector monitors log files. The unit is seconds, and the default is 0 seconds, which means that there is no limit to the length of time LogCollector monitors log files.
        """
        pulumi.set(__self__, "close_eof", close_eof)
        pulumi.set(__self__, "close_inactive", close_inactive)
        pulumi.set(__self__, "close_removed", close_removed)
        pulumi.set(__self__, "close_renamed", close_renamed)
        pulumi.set(__self__, "close_timeout", close_timeout)

    @property
    @pulumi.getter(name="closeEof")
    def close_eof(self) -> bool:
        """
        Whether to release the log file handle after reading to the end of the log file. The default is false.
        """
        return pulumi.get(self, "close_eof")

    @property
    @pulumi.getter(name="closeInactive")
    def close_inactive(self) -> int:
        """
        The wait time to release the log file handle. When the log file has not written a new log for more than the specified time, release the handle of the log file.
        """
        return pulumi.get(self, "close_inactive")

    @property
    @pulumi.getter(name="closeRemoved")
    def close_removed(self) -> bool:
        """
        After the log file is removed, whether to release the handle of the log file. The default is false.
        """
        return pulumi.get(self, "close_removed")

    @property
    @pulumi.getter(name="closeRenamed")
    def close_renamed(self) -> bool:
        """
        After the log file is renamed, whether to release the handle of the log file. The default is false.
        """
        return pulumi.get(self, "close_renamed")

    @property
    @pulumi.getter(name="closeTimeout")
    def close_timeout(self) -> int:
        """
        The maximum length of time that LogCollector monitors log files. The unit is seconds, and the default is 0 seconds, which means that there is no limit to the length of time LogCollector monitors log files.
        """
        return pulumi.get(self, "close_timeout")


@pulumi.output_type
class RuleAppliersRuleUserDefineRuleParsePathRuleResult(dict):
    def __init__(__self__, *,
                 keys: Sequence[str],
                 path_sample: str,
                 regex: str):
        """
        :param Sequence[str] keys: A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        :param str path_sample: Sample capture path for a real scene.
        :param str regex: Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "path_sample", path_sample)
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="pathSample")
    def path_sample(self) -> str:
        """
        Sample capture path for a real scene.
        """
        return pulumi.get(self, "path_sample")

    @property
    @pulumi.getter
    def regex(self) -> str:
        """
        Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class RuleAppliersRuleUserDefineRulePluginResult(dict):
    def __init__(__self__, *,
                 processors: str):
        """
        :param str processors: LogCollector plugin.
        """
        pulumi.set(__self__, "processors", processors)

    @property
    @pulumi.getter
    def processors(self) -> str:
        """
        LogCollector plugin.
        """
        return pulumi.get(self, "processors")


@pulumi.output_type
class RuleAppliersRuleUserDefineRuleShardHashKeyResult(dict):
    def __init__(__self__, *,
                 hash_key: str):
        """
        :param str hash_key: The HashKey of the log group is used to specify the partition (shard) to be written to by the current log group.
        """
        pulumi.set(__self__, "hash_key", hash_key)

    @property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> str:
        """
        The HashKey of the log group is used to specify the partition (shard) to be written to by the current log group.
        """
        return pulumi.get(self, "hash_key")


@pulumi.output_type
class RuleContainerRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerNameRegex":
            suggest = "container_name_regex"
        elif key == "envTag":
            suggest = "env_tag"
        elif key == "excludeContainerEnvRegex":
            suggest = "exclude_container_env_regex"
        elif key == "excludeContainerLabelRegex":
            suggest = "exclude_container_label_regex"
        elif key == "includeContainerEnvRegex":
            suggest = "include_container_env_regex"
        elif key == "includeContainerLabelRegex":
            suggest = "include_container_label_regex"
        elif key == "kubernetesRule":
            suggest = "kubernetes_rule"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleContainerRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleContainerRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleContainerRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 stream: str,
                 container_name_regex: Optional[str] = None,
                 env_tag: Optional[Mapping[str, str]] = None,
                 exclude_container_env_regex: Optional[Mapping[str, str]] = None,
                 exclude_container_label_regex: Optional[Mapping[str, str]] = None,
                 include_container_env_regex: Optional[Mapping[str, str]] = None,
                 include_container_label_regex: Optional[Mapping[str, str]] = None,
                 kubernetes_rule: Optional['outputs.RuleContainerRuleKubernetesRule'] = None):
        """
        :param str stream: The collection mode.
        :param str container_name_regex: The name of the container to be collected.
        :param Mapping[str, str] env_tag: Whether to add environment variables as log tags to raw log data.
        :param Mapping[str, str] exclude_container_env_regex: The container environment variable blacklist is used to specify the range of containers not to be collected.
        :param Mapping[str, str] exclude_container_label_regex: The container Label blacklist is used to specify the range of containers not to be collected.
        :param Mapping[str, str] include_container_env_regex: The container environment variable whitelist specifies the container to be collected through the container environment variable. If the whitelist is not enabled, it means that all containers are specified to be collected.
        :param Mapping[str, str] include_container_label_regex: The container label whitelist specifies the containers to be collected through the container label. If the whitelist is not enabled, all containers are specified to be collected.
        :param 'RuleContainerRuleKubernetesRuleArgs' kubernetes_rule: Collection rules for Kubernetes containers.
        """
        pulumi.set(__self__, "stream", stream)
        if container_name_regex is not None:
            pulumi.set(__self__, "container_name_regex", container_name_regex)
        if env_tag is not None:
            pulumi.set(__self__, "env_tag", env_tag)
        if exclude_container_env_regex is not None:
            pulumi.set(__self__, "exclude_container_env_regex", exclude_container_env_regex)
        if exclude_container_label_regex is not None:
            pulumi.set(__self__, "exclude_container_label_regex", exclude_container_label_regex)
        if include_container_env_regex is not None:
            pulumi.set(__self__, "include_container_env_regex", include_container_env_regex)
        if include_container_label_regex is not None:
            pulumi.set(__self__, "include_container_label_regex", include_container_label_regex)
        if kubernetes_rule is not None:
            pulumi.set(__self__, "kubernetes_rule", kubernetes_rule)

    @property
    @pulumi.getter
    def stream(self) -> str:
        """
        The collection mode.
        """
        return pulumi.get(self, "stream")

    @property
    @pulumi.getter(name="containerNameRegex")
    def container_name_regex(self) -> Optional[str]:
        """
        The name of the container to be collected.
        """
        return pulumi.get(self, "container_name_regex")

    @property
    @pulumi.getter(name="envTag")
    def env_tag(self) -> Optional[Mapping[str, str]]:
        """
        Whether to add environment variables as log tags to raw log data.
        """
        return pulumi.get(self, "env_tag")

    @property
    @pulumi.getter(name="excludeContainerEnvRegex")
    def exclude_container_env_regex(self) -> Optional[Mapping[str, str]]:
        """
        The container environment variable blacklist is used to specify the range of containers not to be collected.
        """
        return pulumi.get(self, "exclude_container_env_regex")

    @property
    @pulumi.getter(name="excludeContainerLabelRegex")
    def exclude_container_label_regex(self) -> Optional[Mapping[str, str]]:
        """
        The container Label blacklist is used to specify the range of containers not to be collected.
        """
        return pulumi.get(self, "exclude_container_label_regex")

    @property
    @pulumi.getter(name="includeContainerEnvRegex")
    def include_container_env_regex(self) -> Optional[Mapping[str, str]]:
        """
        The container environment variable whitelist specifies the container to be collected through the container environment variable. If the whitelist is not enabled, it means that all containers are specified to be collected.
        """
        return pulumi.get(self, "include_container_env_regex")

    @property
    @pulumi.getter(name="includeContainerLabelRegex")
    def include_container_label_regex(self) -> Optional[Mapping[str, str]]:
        """
        The container label whitelist specifies the containers to be collected through the container label. If the whitelist is not enabled, all containers are specified to be collected.
        """
        return pulumi.get(self, "include_container_label_regex")

    @property
    @pulumi.getter(name="kubernetesRule")
    def kubernetes_rule(self) -> Optional['outputs.RuleContainerRuleKubernetesRule']:
        """
        Collection rules for Kubernetes containers.
        """
        return pulumi.get(self, "kubernetes_rule")


@pulumi.output_type
class RuleContainerRuleKubernetesRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "annotationTag":
            suggest = "annotation_tag"
        elif key == "excludePodLabelRegex":
            suggest = "exclude_pod_label_regex"
        elif key == "includePodLabelRegex":
            suggest = "include_pod_label_regex"
        elif key == "labelTag":
            suggest = "label_tag"
        elif key == "namespaceNameRegex":
            suggest = "namespace_name_regex"
        elif key == "podNameRegex":
            suggest = "pod_name_regex"
        elif key == "workloadNameRegex":
            suggest = "workload_name_regex"
        elif key == "workloadType":
            suggest = "workload_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleContainerRuleKubernetesRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleContainerRuleKubernetesRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleContainerRuleKubernetesRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 annotation_tag: Optional[Mapping[str, str]] = None,
                 exclude_pod_label_regex: Optional[Mapping[str, str]] = None,
                 include_pod_label_regex: Optional[Mapping[str, str]] = None,
                 label_tag: Optional[Mapping[str, str]] = None,
                 namespace_name_regex: Optional[str] = None,
                 pod_name_regex: Optional[str] = None,
                 workload_name_regex: Optional[str] = None,
                 workload_type: Optional[str] = None):
        """
        :param Mapping[str, str] annotation_tag: Whether to add Kubernetes Annotation as a log tag to the raw log data.
        :param Mapping[str, str] exclude_pod_label_regex: Specify the containers not to be collected through the Pod Label blacklist, and not enable means to collect all containers.
        :param Mapping[str, str] include_pod_label_regex: The Pod Label whitelist is used to specify containers to be collected. When the Pod Label whitelist is not enabled, it means that all containers are collected.
        :param Mapping[str, str] label_tag: Whether to add Kubernetes Label as a log label to the original log data.
        :param str namespace_name_regex: The name of the Kubernetes Namespace to be collected. If no Namespace name is specified, all containers will be collected. Namespace names support regular matching.
        :param str pod_name_regex: The Pod name is used to specify the container to be collected. When no Pod name is specified, it means to collect all containers.
        :param str workload_name_regex: Specify the container to be collected by the name of the workload. When no workload name is specified, all containers are collected. The workload name supports regular matching.
        :param str workload_type: Specify the containers to be collected by the type of workload, only one type can be selected. When no type is specified, it means all types of containers are collected. The supported types of workloads are:
               Deployment: stateless workload.
               StatefulSet: stateful workload.
               DaemonSet: daemon process.
               Job: task.
               CronJob: scheduled task.
        """
        if annotation_tag is not None:
            pulumi.set(__self__, "annotation_tag", annotation_tag)
        if exclude_pod_label_regex is not None:
            pulumi.set(__self__, "exclude_pod_label_regex", exclude_pod_label_regex)
        if include_pod_label_regex is not None:
            pulumi.set(__self__, "include_pod_label_regex", include_pod_label_regex)
        if label_tag is not None:
            pulumi.set(__self__, "label_tag", label_tag)
        if namespace_name_regex is not None:
            pulumi.set(__self__, "namespace_name_regex", namespace_name_regex)
        if pod_name_regex is not None:
            pulumi.set(__self__, "pod_name_regex", pod_name_regex)
        if workload_name_regex is not None:
            pulumi.set(__self__, "workload_name_regex", workload_name_regex)
        if workload_type is not None:
            pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="annotationTag")
    def annotation_tag(self) -> Optional[Mapping[str, str]]:
        """
        Whether to add Kubernetes Annotation as a log tag to the raw log data.
        """
        return pulumi.get(self, "annotation_tag")

    @property
    @pulumi.getter(name="excludePodLabelRegex")
    def exclude_pod_label_regex(self) -> Optional[Mapping[str, str]]:
        """
        Specify the containers not to be collected through the Pod Label blacklist, and not enable means to collect all containers.
        """
        return pulumi.get(self, "exclude_pod_label_regex")

    @property
    @pulumi.getter(name="includePodLabelRegex")
    def include_pod_label_regex(self) -> Optional[Mapping[str, str]]:
        """
        The Pod Label whitelist is used to specify containers to be collected. When the Pod Label whitelist is not enabled, it means that all containers are collected.
        """
        return pulumi.get(self, "include_pod_label_regex")

    @property
    @pulumi.getter(name="labelTag")
    def label_tag(self) -> Optional[Mapping[str, str]]:
        """
        Whether to add Kubernetes Label as a log label to the original log data.
        """
        return pulumi.get(self, "label_tag")

    @property
    @pulumi.getter(name="namespaceNameRegex")
    def namespace_name_regex(self) -> Optional[str]:
        """
        The name of the Kubernetes Namespace to be collected. If no Namespace name is specified, all containers will be collected. Namespace names support regular matching.
        """
        return pulumi.get(self, "namespace_name_regex")

    @property
    @pulumi.getter(name="podNameRegex")
    def pod_name_regex(self) -> Optional[str]:
        """
        The Pod name is used to specify the container to be collected. When no Pod name is specified, it means to collect all containers.
        """
        return pulumi.get(self, "pod_name_regex")

    @property
    @pulumi.getter(name="workloadNameRegex")
    def workload_name_regex(self) -> Optional[str]:
        """
        Specify the container to be collected by the name of the workload. When no workload name is specified, all containers are collected. The workload name supports regular matching.
        """
        return pulumi.get(self, "workload_name_regex")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> Optional[str]:
        """
        Specify the containers to be collected by the type of workload, only one type can be selected. When no type is specified, it means all types of containers are collected. The supported types of workloads are:
        Deployment: stateless workload.
        StatefulSet: stateful workload.
        DaemonSet: daemon process.
        Job: task.
        CronJob: scheduled task.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class RuleExcludePath(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: Collection path type. The path type can be `File` or `Path`.
        :param str value: Collection path.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Collection path type. The path type can be `File` or `Path`.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Collection path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RuleExtractRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "beginRegex":
            suggest = "begin_regex"
        elif key == "filterKeyRegexes":
            suggest = "filter_key_regexes"
        elif key == "logRegex":
            suggest = "log_regex"
        elif key == "logTemplate":
            suggest = "log_template"
        elif key == "timeFormat":
            suggest = "time_format"
        elif key == "timeKey":
            suggest = "time_key"
        elif key == "unMatchLogKey":
            suggest = "un_match_log_key"
        elif key == "unMatchUpLoadSwitch":
            suggest = "un_match_up_load_switch"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleExtractRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleExtractRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleExtractRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 begin_regex: Optional[str] = None,
                 delimiter: Optional[str] = None,
                 filter_key_regexes: Optional[Sequence['outputs.RuleExtractRuleFilterKeyRegex']] = None,
                 keys: Optional[Sequence[str]] = None,
                 log_regex: Optional[str] = None,
                 log_template: Optional['outputs.RuleExtractRuleLogTemplate'] = None,
                 time_format: Optional[str] = None,
                 time_key: Optional[str] = None,
                 un_match_log_key: Optional[str] = None,
                 un_match_up_load_switch: Optional[bool] = None):
        """
        :param str begin_regex: The first log line needs to match the regular expression.
        :param str delimiter: The delimiter of the log.
        :param Sequence['RuleExtractRuleFilterKeyRegexArgs'] filter_key_regexes: The filter key list.
        :param Sequence[str] keys: A list of log field names (Key).
        :param str log_regex: The entire log needs to match the regular expression.
        :param 'RuleExtractRuleLogTemplateArgs' log_template: Automatically extract log fields according to the specified log template.
        :param str time_format: Parsing format of the time field.
        :param str time_key: The field name of the log time field.
        :param str un_match_log_key: When uploading the failed log, the key name of the failed log.
        :param bool un_match_up_load_switch: Whether to upload the log of parsing failure.
        """
        if begin_regex is not None:
            pulumi.set(__self__, "begin_regex", begin_regex)
        if delimiter is not None:
            pulumi.set(__self__, "delimiter", delimiter)
        if filter_key_regexes is not None:
            pulumi.set(__self__, "filter_key_regexes", filter_key_regexes)
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if log_regex is not None:
            pulumi.set(__self__, "log_regex", log_regex)
        if log_template is not None:
            pulumi.set(__self__, "log_template", log_template)
        if time_format is not None:
            pulumi.set(__self__, "time_format", time_format)
        if time_key is not None:
            pulumi.set(__self__, "time_key", time_key)
        if un_match_log_key is not None:
            pulumi.set(__self__, "un_match_log_key", un_match_log_key)
        if un_match_up_load_switch is not None:
            pulumi.set(__self__, "un_match_up_load_switch", un_match_up_load_switch)

    @property
    @pulumi.getter(name="beginRegex")
    def begin_regex(self) -> Optional[str]:
        """
        The first log line needs to match the regular expression.
        """
        return pulumi.get(self, "begin_regex")

    @property
    @pulumi.getter
    def delimiter(self) -> Optional[str]:
        """
        The delimiter of the log.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="filterKeyRegexes")
    def filter_key_regexes(self) -> Optional[Sequence['outputs.RuleExtractRuleFilterKeyRegex']]:
        """
        The filter key list.
        """
        return pulumi.get(self, "filter_key_regexes")

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        A list of log field names (Key).
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="logRegex")
    def log_regex(self) -> Optional[str]:
        """
        The entire log needs to match the regular expression.
        """
        return pulumi.get(self, "log_regex")

    @property
    @pulumi.getter(name="logTemplate")
    def log_template(self) -> Optional['outputs.RuleExtractRuleLogTemplate']:
        """
        Automatically extract log fields according to the specified log template.
        """
        return pulumi.get(self, "log_template")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> Optional[str]:
        """
        Parsing format of the time field.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeKey")
    def time_key(self) -> Optional[str]:
        """
        The field name of the log time field.
        """
        return pulumi.get(self, "time_key")

    @property
    @pulumi.getter(name="unMatchLogKey")
    def un_match_log_key(self) -> Optional[str]:
        """
        When uploading the failed log, the key name of the failed log.
        """
        return pulumi.get(self, "un_match_log_key")

    @property
    @pulumi.getter(name="unMatchUpLoadSwitch")
    def un_match_up_load_switch(self) -> Optional[bool]:
        """
        Whether to upload the log of parsing failure.
        """
        return pulumi.get(self, "un_match_up_load_switch")


@pulumi.output_type
class RuleExtractRuleFilterKeyRegex(dict):
    def __init__(__self__, *,
                 key: str,
                 regex: str):
        """
        :param str key: The name of the filter key.
        :param str regex: The log content of the filter field needs to match the regular expression.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the filter key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def regex(self) -> str:
        """
        The log content of the filter field needs to match the regular expression.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class RuleExtractRuleLogTemplate(dict):
    def __init__(__self__, *,
                 format: str,
                 type: str):
        """
        :param str format: Log template content.
        :param str type: The type of the log template.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        Log template content.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the log template.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RuleUserDefineRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableRawLog":
            suggest = "enable_raw_log"
        elif key == "parsePathRule":
            suggest = "parse_path_rule"
        elif key == "shardHashKey":
            suggest = "shard_hash_key"
        elif key == "tailFiles":
            suggest = "tail_files"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleUserDefineRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleUserDefineRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleUserDefineRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 advanced: Optional['outputs.RuleUserDefineRuleAdvanced'] = None,
                 enable_raw_log: Optional[bool] = None,
                 fields: Optional[Mapping[str, str]] = None,
                 parse_path_rule: Optional['outputs.RuleUserDefineRuleParsePathRule'] = None,
                 plugin: Optional['outputs.RuleUserDefineRulePlugin'] = None,
                 shard_hash_key: Optional['outputs.RuleUserDefineRuleShardHashKey'] = None,
                 tail_files: Optional[bool] = None):
        """
        :param 'RuleUserDefineRuleAdvancedArgs' advanced: LogCollector extension configuration.
        :param bool enable_raw_log: Whether to upload raw logs.
        :param Mapping[str, str] fields: Add constant fields to logs.
        :param 'RuleUserDefineRuleParsePathRuleArgs' parse_path_rule: Rules for parsing collection paths. After the rules are set, the fields in the collection path will be extracted through the regular expressions specified in the rules, and added to the log data as metadata.
        :param 'RuleUserDefineRulePluginArgs' plugin: Plugin configuration. After the plugin configuration is enabled, one or more LogCollector processor plugins can be added to parse logs with complex or variable structures.
        :param 'RuleUserDefineRuleShardHashKeyArgs' shard_hash_key: Rules for routing log partitions. Setting this parameter indicates that the HashKey routing shard mode is used when collecting logs, and Log Service will write the data to the shard containing the specified Key value.
        :param bool tail_files: LogCollector collection strategy, which specifies whether LogCollector collects incremental logs or full logs. The default is false, which means to collect all logs.
        """
        if advanced is not None:
            pulumi.set(__self__, "advanced", advanced)
        if enable_raw_log is not None:
            pulumi.set(__self__, "enable_raw_log", enable_raw_log)
        if fields is not None:
            pulumi.set(__self__, "fields", fields)
        if parse_path_rule is not None:
            pulumi.set(__self__, "parse_path_rule", parse_path_rule)
        if plugin is not None:
            pulumi.set(__self__, "plugin", plugin)
        if shard_hash_key is not None:
            pulumi.set(__self__, "shard_hash_key", shard_hash_key)
        if tail_files is not None:
            pulumi.set(__self__, "tail_files", tail_files)

    @property
    @pulumi.getter
    def advanced(self) -> Optional['outputs.RuleUserDefineRuleAdvanced']:
        """
        LogCollector extension configuration.
        """
        return pulumi.get(self, "advanced")

    @property
    @pulumi.getter(name="enableRawLog")
    def enable_raw_log(self) -> Optional[bool]:
        """
        Whether to upload raw logs.
        """
        return pulumi.get(self, "enable_raw_log")

    @property
    @pulumi.getter
    def fields(self) -> Optional[Mapping[str, str]]:
        """
        Add constant fields to logs.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="parsePathRule")
    def parse_path_rule(self) -> Optional['outputs.RuleUserDefineRuleParsePathRule']:
        """
        Rules for parsing collection paths. After the rules are set, the fields in the collection path will be extracted through the regular expressions specified in the rules, and added to the log data as metadata.
        """
        return pulumi.get(self, "parse_path_rule")

    @property
    @pulumi.getter
    def plugin(self) -> Optional['outputs.RuleUserDefineRulePlugin']:
        """
        Plugin configuration. After the plugin configuration is enabled, one or more LogCollector processor plugins can be added to parse logs with complex or variable structures.
        """
        return pulumi.get(self, "plugin")

    @property
    @pulumi.getter(name="shardHashKey")
    def shard_hash_key(self) -> Optional['outputs.RuleUserDefineRuleShardHashKey']:
        """
        Rules for routing log partitions. Setting this parameter indicates that the HashKey routing shard mode is used when collecting logs, and Log Service will write the data to the shard containing the specified Key value.
        """
        return pulumi.get(self, "shard_hash_key")

    @property
    @pulumi.getter(name="tailFiles")
    def tail_files(self) -> Optional[bool]:
        """
        LogCollector collection strategy, which specifies whether LogCollector collects incremental logs or full logs. The default is false, which means to collect all logs.
        """
        return pulumi.get(self, "tail_files")


@pulumi.output_type
class RuleUserDefineRuleAdvanced(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "closeEof":
            suggest = "close_eof"
        elif key == "closeInactive":
            suggest = "close_inactive"
        elif key == "closeRemoved":
            suggest = "close_removed"
        elif key == "closeRenamed":
            suggest = "close_renamed"
        elif key == "closeTimeout":
            suggest = "close_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleUserDefineRuleAdvanced. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleUserDefineRuleAdvanced.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleUserDefineRuleAdvanced.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 close_eof: Optional[bool] = None,
                 close_inactive: Optional[int] = None,
                 close_removed: Optional[bool] = None,
                 close_renamed: Optional[bool] = None,
                 close_timeout: Optional[int] = None):
        """
        :param bool close_eof: Whether to release the log file handle after reading to the end of the log file. The default is false.
        :param int close_inactive: The wait time to release the log file handle. When the log file has not written a new log for more than the specified time, release the handle of the log file.
        :param bool close_removed: After the log file is removed, whether to release the handle of the log file. The default is false.
        :param bool close_renamed: After the log file is renamed, whether to release the handle of the log file. The default is false.
        :param int close_timeout: The maximum length of time that LogCollector monitors log files. The unit is seconds, and the default is 0 seconds, which means that there is no limit to the length of time LogCollector monitors log files.
        """
        if close_eof is not None:
            pulumi.set(__self__, "close_eof", close_eof)
        if close_inactive is not None:
            pulumi.set(__self__, "close_inactive", close_inactive)
        if close_removed is not None:
            pulumi.set(__self__, "close_removed", close_removed)
        if close_renamed is not None:
            pulumi.set(__self__, "close_renamed", close_renamed)
        if close_timeout is not None:
            pulumi.set(__self__, "close_timeout", close_timeout)

    @property
    @pulumi.getter(name="closeEof")
    def close_eof(self) -> Optional[bool]:
        """
        Whether to release the log file handle after reading to the end of the log file. The default is false.
        """
        return pulumi.get(self, "close_eof")

    @property
    @pulumi.getter(name="closeInactive")
    def close_inactive(self) -> Optional[int]:
        """
        The wait time to release the log file handle. When the log file has not written a new log for more than the specified time, release the handle of the log file.
        """
        return pulumi.get(self, "close_inactive")

    @property
    @pulumi.getter(name="closeRemoved")
    def close_removed(self) -> Optional[bool]:
        """
        After the log file is removed, whether to release the handle of the log file. The default is false.
        """
        return pulumi.get(self, "close_removed")

    @property
    @pulumi.getter(name="closeRenamed")
    def close_renamed(self) -> Optional[bool]:
        """
        After the log file is renamed, whether to release the handle of the log file. The default is false.
        """
        return pulumi.get(self, "close_renamed")

    @property
    @pulumi.getter(name="closeTimeout")
    def close_timeout(self) -> Optional[int]:
        """
        The maximum length of time that LogCollector monitors log files. The unit is seconds, and the default is 0 seconds, which means that there is no limit to the length of time LogCollector monitors log files.
        """
        return pulumi.get(self, "close_timeout")


@pulumi.output_type
class RuleUserDefineRuleParsePathRule(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "pathSample":
            suggest = "path_sample"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleUserDefineRuleParsePathRule. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleUserDefineRuleParsePathRule.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleUserDefineRuleParsePathRule.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 keys: Optional[Sequence[str]] = None,
                 path_sample: Optional[str] = None,
                 regex: Optional[str] = None):
        """
        :param Sequence[str] keys: A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        :param str path_sample: Sample capture path for a real scene.
        :param str regex: Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        if keys is not None:
            pulumi.set(__self__, "keys", keys)
        if path_sample is not None:
            pulumi.set(__self__, "path_sample", path_sample)
        if regex is not None:
            pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def keys(self) -> Optional[Sequence[str]]:
        """
        A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="pathSample")
    def path_sample(self) -> Optional[str]:
        """
        Sample capture path for a real scene.
        """
        return pulumi.get(self, "path_sample")

    @property
    @pulumi.getter
    def regex(self) -> Optional[str]:
        """
        Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class RuleUserDefineRulePlugin(dict):
    def __init__(__self__, *,
                 processors: Sequence[str]):
        """
        :param Sequence[str] processors: LogCollector plugin.
        """
        pulumi.set(__self__, "processors", processors)

    @property
    @pulumi.getter
    def processors(self) -> Sequence[str]:
        """
        LogCollector plugin.
        """
        return pulumi.get(self, "processors")


@pulumi.output_type
class RuleUserDefineRuleShardHashKey(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hashKey":
            suggest = "hash_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuleUserDefineRuleShardHashKey. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuleUserDefineRuleShardHashKey.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuleUserDefineRuleShardHashKey.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hash_key: str):
        """
        :param str hash_key: The HashKey of the log group is used to specify the partition (shard) to be written to by the current log group.
        """
        pulumi.set(__self__, "hash_key", hash_key)

    @property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> str:
        """
        The HashKey of the log group is used to specify the partition (shard) to be written to by the current log group.
        """
        return pulumi.get(self, "hash_key")


@pulumi.output_type
class RulesRuleResult(dict):
    def __init__(__self__, *,
                 container_rules: Sequence['outputs.RulesRuleContainerRuleResult'],
                 create_time: str,
                 exclude_paths: Sequence['outputs.RulesRuleExcludePathResult'],
                 extract_rules: Sequence['outputs.RulesRuleExtractRuleResult'],
                 input_type: int,
                 log_sample: str,
                 log_type: str,
                 modify_time: str,
                 paths: Sequence[str],
                 rule_id: str,
                 rule_name: str,
                 topic_id: str,
                 topic_name: str,
                 user_define_rules: Sequence['outputs.RulesRuleUserDefineRuleResult']):
        """
        :param Sequence['RulesRuleContainerRuleArgs'] container_rules: Container collection rules.
        :param str create_time: The creation time.
        :param Sequence['RulesRuleExcludePathArgs'] exclude_paths: Collect the blacklist list.
        :param Sequence['RulesRuleExtractRuleArgs'] extract_rules: The extract rule.
        :param int input_type: The collection type.
        :param str log_sample: Log sample.
        :param str log_type: The log type.
        :param str modify_time: The modification time.
        :param Sequence[str] paths: Collection path list.
        :param str rule_id: The rule id.
        :param str rule_name: The rule name.
        :param str topic_id: The topic id.
        :param str topic_name: The topic name.
        :param Sequence['RulesRuleUserDefineRuleArgs'] user_define_rules: User-defined collection rules.
        """
        pulumi.set(__self__, "container_rules", container_rules)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "exclude_paths", exclude_paths)
        pulumi.set(__self__, "extract_rules", extract_rules)
        pulumi.set(__self__, "input_type", input_type)
        pulumi.set(__self__, "log_sample", log_sample)
        pulumi.set(__self__, "log_type", log_type)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "paths", paths)
        pulumi.set(__self__, "rule_id", rule_id)
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "topic_id", topic_id)
        pulumi.set(__self__, "topic_name", topic_name)
        pulumi.set(__self__, "user_define_rules", user_define_rules)

    @property
    @pulumi.getter(name="containerRules")
    def container_rules(self) -> Sequence['outputs.RulesRuleContainerRuleResult']:
        """
        Container collection rules.
        """
        return pulumi.get(self, "container_rules")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="excludePaths")
    def exclude_paths(self) -> Sequence['outputs.RulesRuleExcludePathResult']:
        """
        Collect the blacklist list.
        """
        return pulumi.get(self, "exclude_paths")

    @property
    @pulumi.getter(name="extractRules")
    def extract_rules(self) -> Sequence['outputs.RulesRuleExtractRuleResult']:
        """
        The extract rule.
        """
        return pulumi.get(self, "extract_rules")

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> int:
        """
        The collection type.
        """
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter(name="logSample")
    def log_sample(self) -> str:
        """
        Log sample.
        """
        return pulumi.get(self, "log_sample")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modification time.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter
    def paths(self) -> Sequence[str]:
        """
        Collection path list.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> str:
        """
        The rule id.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> str:
        """
        The rule name.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The topic id.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> str:
        """
        The topic name.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="userDefineRules")
    def user_define_rules(self) -> Sequence['outputs.RulesRuleUserDefineRuleResult']:
        """
        User-defined collection rules.
        """
        return pulumi.get(self, "user_define_rules")


@pulumi.output_type
class RulesRuleContainerRuleResult(dict):
    def __init__(__self__, *,
                 container_name_regex: str,
                 env_tag: Mapping[str, Any],
                 exclude_container_env_regex: Mapping[str, Any],
                 exclude_container_label_regex: Mapping[str, Any],
                 include_container_env_regex: Mapping[str, Any],
                 include_container_label_regex: Mapping[str, Any],
                 kubernetes_rules: Sequence['outputs.RulesRuleContainerRuleKubernetesRuleResult'],
                 stream: str):
        """
        :param str container_name_regex: The name of the container to be collected.
        :param Mapping[str, Any] env_tag: Whether to add environment variables as log tags to raw log data.
        :param Mapping[str, Any] exclude_container_env_regex: The container environment variable blacklist is used to specify the range of containers not to be collected.
        :param Mapping[str, Any] exclude_container_label_regex: The container Label blacklist is used to specify the range of containers not to be collected.
        :param Mapping[str, Any] include_container_env_regex: The container environment variable whitelist specifies the container to be collected through the container environment variable. If the whitelist is not enabled, it means that all containers are specified to be collected.
        :param Mapping[str, Any] include_container_label_regex: The container label whitelist specifies the containers to be collected through the container label. If the whitelist is not enabled, all containers are specified to be collected.
        :param Sequence['RulesRuleContainerRuleKubernetesRuleArgs'] kubernetes_rules: Collection rules for Kubernetes containers.
        :param str stream: The collection mode.
        """
        pulumi.set(__self__, "container_name_regex", container_name_regex)
        pulumi.set(__self__, "env_tag", env_tag)
        pulumi.set(__self__, "exclude_container_env_regex", exclude_container_env_regex)
        pulumi.set(__self__, "exclude_container_label_regex", exclude_container_label_regex)
        pulumi.set(__self__, "include_container_env_regex", include_container_env_regex)
        pulumi.set(__self__, "include_container_label_regex", include_container_label_regex)
        pulumi.set(__self__, "kubernetes_rules", kubernetes_rules)
        pulumi.set(__self__, "stream", stream)

    @property
    @pulumi.getter(name="containerNameRegex")
    def container_name_regex(self) -> str:
        """
        The name of the container to be collected.
        """
        return pulumi.get(self, "container_name_regex")

    @property
    @pulumi.getter(name="envTag")
    def env_tag(self) -> Mapping[str, Any]:
        """
        Whether to add environment variables as log tags to raw log data.
        """
        return pulumi.get(self, "env_tag")

    @property
    @pulumi.getter(name="excludeContainerEnvRegex")
    def exclude_container_env_regex(self) -> Mapping[str, Any]:
        """
        The container environment variable blacklist is used to specify the range of containers not to be collected.
        """
        return pulumi.get(self, "exclude_container_env_regex")

    @property
    @pulumi.getter(name="excludeContainerLabelRegex")
    def exclude_container_label_regex(self) -> Mapping[str, Any]:
        """
        The container Label blacklist is used to specify the range of containers not to be collected.
        """
        return pulumi.get(self, "exclude_container_label_regex")

    @property
    @pulumi.getter(name="includeContainerEnvRegex")
    def include_container_env_regex(self) -> Mapping[str, Any]:
        """
        The container environment variable whitelist specifies the container to be collected through the container environment variable. If the whitelist is not enabled, it means that all containers are specified to be collected.
        """
        return pulumi.get(self, "include_container_env_regex")

    @property
    @pulumi.getter(name="includeContainerLabelRegex")
    def include_container_label_regex(self) -> Mapping[str, Any]:
        """
        The container label whitelist specifies the containers to be collected through the container label. If the whitelist is not enabled, all containers are specified to be collected.
        """
        return pulumi.get(self, "include_container_label_regex")

    @property
    @pulumi.getter(name="kubernetesRules")
    def kubernetes_rules(self) -> Sequence['outputs.RulesRuleContainerRuleKubernetesRuleResult']:
        """
        Collection rules for Kubernetes containers.
        """
        return pulumi.get(self, "kubernetes_rules")

    @property
    @pulumi.getter
    def stream(self) -> str:
        """
        The collection mode.
        """
        return pulumi.get(self, "stream")


@pulumi.output_type
class RulesRuleContainerRuleKubernetesRuleResult(dict):
    def __init__(__self__, *,
                 annotation_tag: Mapping[str, Any],
                 exclude_pod_label_regex: Mapping[str, Any],
                 include_pod_label_regex: Mapping[str, Any],
                 label_tag: Mapping[str, Any],
                 namespace_name_regex: str,
                 pod_name_regex: str,
                 workload_name_regex: str,
                 workload_type: str):
        """
        :param Mapping[str, Any] annotation_tag: Whether to add Kubernetes Annotation as a log tag to the raw log data.
        :param Mapping[str, Any] exclude_pod_label_regex: Specify the containers not to be collected through the Pod Label blacklist, and not enable means to collect all containers.
        :param Mapping[str, Any] include_pod_label_regex: The Pod Label whitelist is used to specify containers to be collected. When the Pod Label whitelist is not enabled, it means that all containers are collected.
        :param Mapping[str, Any] label_tag: Whether to add Kubernetes Label as a log label to the original log data.
        :param str namespace_name_regex: The name of the Kubernetes Namespace to be collected. If no Namespace name is specified, all containers will be collected. Namespace names support regular matching.
        :param str pod_name_regex: The Pod name is used to specify the container to be collected. When no Pod name is specified, it means to collect all containers.
        :param str workload_name_regex: Specify the container to be collected by the name of the workload. When no workload name is specified, all containers are collected. The workload name supports regular matching.
        :param str workload_type: Specify the container to be collected by the type of workload. Only one type can be selected. When no type is specified, it means to collect all types of containers.
        """
        pulumi.set(__self__, "annotation_tag", annotation_tag)
        pulumi.set(__self__, "exclude_pod_label_regex", exclude_pod_label_regex)
        pulumi.set(__self__, "include_pod_label_regex", include_pod_label_regex)
        pulumi.set(__self__, "label_tag", label_tag)
        pulumi.set(__self__, "namespace_name_regex", namespace_name_regex)
        pulumi.set(__self__, "pod_name_regex", pod_name_regex)
        pulumi.set(__self__, "workload_name_regex", workload_name_regex)
        pulumi.set(__self__, "workload_type", workload_type)

    @property
    @pulumi.getter(name="annotationTag")
    def annotation_tag(self) -> Mapping[str, Any]:
        """
        Whether to add Kubernetes Annotation as a log tag to the raw log data.
        """
        return pulumi.get(self, "annotation_tag")

    @property
    @pulumi.getter(name="excludePodLabelRegex")
    def exclude_pod_label_regex(self) -> Mapping[str, Any]:
        """
        Specify the containers not to be collected through the Pod Label blacklist, and not enable means to collect all containers.
        """
        return pulumi.get(self, "exclude_pod_label_regex")

    @property
    @pulumi.getter(name="includePodLabelRegex")
    def include_pod_label_regex(self) -> Mapping[str, Any]:
        """
        The Pod Label whitelist is used to specify containers to be collected. When the Pod Label whitelist is not enabled, it means that all containers are collected.
        """
        return pulumi.get(self, "include_pod_label_regex")

    @property
    @pulumi.getter(name="labelTag")
    def label_tag(self) -> Mapping[str, Any]:
        """
        Whether to add Kubernetes Label as a log label to the original log data.
        """
        return pulumi.get(self, "label_tag")

    @property
    @pulumi.getter(name="namespaceNameRegex")
    def namespace_name_regex(self) -> str:
        """
        The name of the Kubernetes Namespace to be collected. If no Namespace name is specified, all containers will be collected. Namespace names support regular matching.
        """
        return pulumi.get(self, "namespace_name_regex")

    @property
    @pulumi.getter(name="podNameRegex")
    def pod_name_regex(self) -> str:
        """
        The Pod name is used to specify the container to be collected. When no Pod name is specified, it means to collect all containers.
        """
        return pulumi.get(self, "pod_name_regex")

    @property
    @pulumi.getter(name="workloadNameRegex")
    def workload_name_regex(self) -> str:
        """
        Specify the container to be collected by the name of the workload. When no workload name is specified, all containers are collected. The workload name supports regular matching.
        """
        return pulumi.get(self, "workload_name_regex")

    @property
    @pulumi.getter(name="workloadType")
    def workload_type(self) -> str:
        """
        Specify the container to be collected by the type of workload. Only one type can be selected. When no type is specified, it means to collect all types of containers.
        """
        return pulumi.get(self, "workload_type")


@pulumi.output_type
class RulesRuleExcludePathResult(dict):
    def __init__(__self__, *,
                 type: str,
                 value: str):
        """
        :param str type: The type of the log template.
        :param str value: Collection path.
        """
        pulumi.set(__self__, "type", type)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the log template.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Collection path.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class RulesRuleExtractRuleResult(dict):
    def __init__(__self__, *,
                 begin_regex: str,
                 delimiter: str,
                 filter_key_regexes: Sequence['outputs.RulesRuleExtractRuleFilterKeyRegexResult'],
                 keys: Sequence[str],
                 log_regex: str,
                 log_templates: Sequence['outputs.RulesRuleExtractRuleLogTemplateResult'],
                 time_format: str,
                 time_key: str,
                 un_match_log_key: str,
                 un_match_up_load_switch: bool):
        """
        :param str begin_regex: The first log line needs to match the regular expression.
        :param str delimiter: The delimiter of the log.
        :param Sequence['RulesRuleExtractRuleFilterKeyRegexArgs'] filter_key_regexes: The filter key list.
        :param Sequence[str] keys: A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        :param str log_regex: The entire log needs to match the regular expression.
        :param Sequence['RulesRuleExtractRuleLogTemplateArgs'] log_templates: Automatically extract log fields according to the specified log template.
        :param str time_format: Parsing format of the time field.
        :param str time_key: The field name of the log time field.
        :param str un_match_log_key: When uploading the failed log, the key name of the failed log.
        :param bool un_match_up_load_switch: Whether to upload the log of parsing failure.
        """
        pulumi.set(__self__, "begin_regex", begin_regex)
        pulumi.set(__self__, "delimiter", delimiter)
        pulumi.set(__self__, "filter_key_regexes", filter_key_regexes)
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "log_regex", log_regex)
        pulumi.set(__self__, "log_templates", log_templates)
        pulumi.set(__self__, "time_format", time_format)
        pulumi.set(__self__, "time_key", time_key)
        pulumi.set(__self__, "un_match_log_key", un_match_log_key)
        pulumi.set(__self__, "un_match_up_load_switch", un_match_up_load_switch)

    @property
    @pulumi.getter(name="beginRegex")
    def begin_regex(self) -> str:
        """
        The first log line needs to match the regular expression.
        """
        return pulumi.get(self, "begin_regex")

    @property
    @pulumi.getter
    def delimiter(self) -> str:
        """
        The delimiter of the log.
        """
        return pulumi.get(self, "delimiter")

    @property
    @pulumi.getter(name="filterKeyRegexes")
    def filter_key_regexes(self) -> Sequence['outputs.RulesRuleExtractRuleFilterKeyRegexResult']:
        """
        The filter key list.
        """
        return pulumi.get(self, "filter_key_regexes")

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="logRegex")
    def log_regex(self) -> str:
        """
        The entire log needs to match the regular expression.
        """
        return pulumi.get(self, "log_regex")

    @property
    @pulumi.getter(name="logTemplates")
    def log_templates(self) -> Sequence['outputs.RulesRuleExtractRuleLogTemplateResult']:
        """
        Automatically extract log fields according to the specified log template.
        """
        return pulumi.get(self, "log_templates")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        Parsing format of the time field.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeKey")
    def time_key(self) -> str:
        """
        The field name of the log time field.
        """
        return pulumi.get(self, "time_key")

    @property
    @pulumi.getter(name="unMatchLogKey")
    def un_match_log_key(self) -> str:
        """
        When uploading the failed log, the key name of the failed log.
        """
        return pulumi.get(self, "un_match_log_key")

    @property
    @pulumi.getter(name="unMatchUpLoadSwitch")
    def un_match_up_load_switch(self) -> bool:
        """
        Whether to upload the log of parsing failure.
        """
        return pulumi.get(self, "un_match_up_load_switch")


@pulumi.output_type
class RulesRuleExtractRuleFilterKeyRegexResult(dict):
    def __init__(__self__, *,
                 key: str,
                 regex: str):
        """
        :param str key: The name of the filter key.
        :param str regex: Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The name of the filter key.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def regex(self) -> str:
        """
        Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class RulesRuleExtractRuleLogTemplateResult(dict):
    def __init__(__self__, *,
                 format: str,
                 type: str):
        """
        :param str format: Log template content.
        :param str type: The type of the log template.
        """
        pulumi.set(__self__, "format", format)
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        Log template content.
        """
        return pulumi.get(self, "format")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the log template.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class RulesRuleUserDefineRuleResult(dict):
    def __init__(__self__, *,
                 advanceds: Sequence['outputs.RulesRuleUserDefineRuleAdvancedResult'],
                 enable_raw_log: bool,
                 fields: Mapping[str, Any],
                 parse_path_rules: Sequence['outputs.RulesRuleUserDefineRuleParsePathRuleResult'],
                 plugins: Sequence['outputs.RulesRuleUserDefineRulePluginResult'],
                 shard_hash_keys: Sequence['outputs.RulesRuleUserDefineRuleShardHashKeyResult'],
                 tail_files: bool):
        """
        :param Sequence['RulesRuleUserDefineRuleAdvancedArgs'] advanceds: LogCollector extension configuration.
        :param bool enable_raw_log: Whether to upload raw logs.
        :param Mapping[str, Any] fields: Add constant fields to logs.
        :param Sequence['RulesRuleUserDefineRuleParsePathRuleArgs'] parse_path_rules: Rules for parsing collection paths. After the rules are set, the fields in the collection path will be extracted through the regular expressions specified in the rules, and added to the log data as metadata.
        :param Sequence['RulesRuleUserDefineRulePluginArgs'] plugins: Plugin configuration. After the plugin configuration is enabled, one or more LogCollector processor plugins can be added to parse logs with complex or variable structures.
        :param Sequence['RulesRuleUserDefineRuleShardHashKeyArgs'] shard_hash_keys: Rules for routing log partitions. Setting this parameter indicates that the HashKey routing shard mode is used when collecting logs, and Log Service will write the data to the shard containing the specified Key value.
        :param bool tail_files: LogCollector collection strategy, which specifies whether LogCollector collects incremental logs or full logs. The default is false, which means to collect all logs.
        """
        pulumi.set(__self__, "advanceds", advanceds)
        pulumi.set(__self__, "enable_raw_log", enable_raw_log)
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "parse_path_rules", parse_path_rules)
        pulumi.set(__self__, "plugins", plugins)
        pulumi.set(__self__, "shard_hash_keys", shard_hash_keys)
        pulumi.set(__self__, "tail_files", tail_files)

    @property
    @pulumi.getter
    def advanceds(self) -> Sequence['outputs.RulesRuleUserDefineRuleAdvancedResult']:
        """
        LogCollector extension configuration.
        """
        return pulumi.get(self, "advanceds")

    @property
    @pulumi.getter(name="enableRawLog")
    def enable_raw_log(self) -> bool:
        """
        Whether to upload raw logs.
        """
        return pulumi.get(self, "enable_raw_log")

    @property
    @pulumi.getter
    def fields(self) -> Mapping[str, Any]:
        """
        Add constant fields to logs.
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter(name="parsePathRules")
    def parse_path_rules(self) -> Sequence['outputs.RulesRuleUserDefineRuleParsePathRuleResult']:
        """
        Rules for parsing collection paths. After the rules are set, the fields in the collection path will be extracted through the regular expressions specified in the rules, and added to the log data as metadata.
        """
        return pulumi.get(self, "parse_path_rules")

    @property
    @pulumi.getter
    def plugins(self) -> Sequence['outputs.RulesRuleUserDefineRulePluginResult']:
        """
        Plugin configuration. After the plugin configuration is enabled, one or more LogCollector processor plugins can be added to parse logs with complex or variable structures.
        """
        return pulumi.get(self, "plugins")

    @property
    @pulumi.getter(name="shardHashKeys")
    def shard_hash_keys(self) -> Sequence['outputs.RulesRuleUserDefineRuleShardHashKeyResult']:
        """
        Rules for routing log partitions. Setting this parameter indicates that the HashKey routing shard mode is used when collecting logs, and Log Service will write the data to the shard containing the specified Key value.
        """
        return pulumi.get(self, "shard_hash_keys")

    @property
    @pulumi.getter(name="tailFiles")
    def tail_files(self) -> bool:
        """
        LogCollector collection strategy, which specifies whether LogCollector collects incremental logs or full logs. The default is false, which means to collect all logs.
        """
        return pulumi.get(self, "tail_files")


@pulumi.output_type
class RulesRuleUserDefineRuleAdvancedResult(dict):
    def __init__(__self__, *,
                 close_eof: bool,
                 close_inactive: int,
                 close_removed: bool,
                 close_renamed: bool,
                 close_timeout: int):
        """
        :param bool close_eof: Whether to release the log file handle after reading to the end of the log file. The default is false.
        :param int close_inactive: The wait time to release the log file handle. When the log file has not written a new log for more than the specified time, release the handle of the log file.
        :param bool close_removed: After the log file is removed, whether to release the handle of the log file. The default is false.
        :param bool close_renamed: After the log file is renamed, whether to release the handle of the log file. The default is false.
        :param int close_timeout: The maximum length of time that LogCollector monitors log files. The unit is seconds, and the default is 0 seconds, which means that there is no limit to the length of time LogCollector monitors log files.
        """
        pulumi.set(__self__, "close_eof", close_eof)
        pulumi.set(__self__, "close_inactive", close_inactive)
        pulumi.set(__self__, "close_removed", close_removed)
        pulumi.set(__self__, "close_renamed", close_renamed)
        pulumi.set(__self__, "close_timeout", close_timeout)

    @property
    @pulumi.getter(name="closeEof")
    def close_eof(self) -> bool:
        """
        Whether to release the log file handle after reading to the end of the log file. The default is false.
        """
        return pulumi.get(self, "close_eof")

    @property
    @pulumi.getter(name="closeInactive")
    def close_inactive(self) -> int:
        """
        The wait time to release the log file handle. When the log file has not written a new log for more than the specified time, release the handle of the log file.
        """
        return pulumi.get(self, "close_inactive")

    @property
    @pulumi.getter(name="closeRemoved")
    def close_removed(self) -> bool:
        """
        After the log file is removed, whether to release the handle of the log file. The default is false.
        """
        return pulumi.get(self, "close_removed")

    @property
    @pulumi.getter(name="closeRenamed")
    def close_renamed(self) -> bool:
        """
        After the log file is renamed, whether to release the handle of the log file. The default is false.
        """
        return pulumi.get(self, "close_renamed")

    @property
    @pulumi.getter(name="closeTimeout")
    def close_timeout(self) -> int:
        """
        The maximum length of time that LogCollector monitors log files. The unit is seconds, and the default is 0 seconds, which means that there is no limit to the length of time LogCollector monitors log files.
        """
        return pulumi.get(self, "close_timeout")


@pulumi.output_type
class RulesRuleUserDefineRuleParsePathRuleResult(dict):
    def __init__(__self__, *,
                 keys: Sequence[str],
                 path_sample: str,
                 regex: str):
        """
        :param Sequence[str] keys: A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        :param str path_sample: Sample capture path for a real scene.
        :param str regex: Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        pulumi.set(__self__, "keys", keys)
        pulumi.set(__self__, "path_sample", path_sample)
        pulumi.set(__self__, "regex", regex)

    @property
    @pulumi.getter
    def keys(self) -> Sequence[str]:
        """
        A list of field names. Log Service will parse the path sample (PathSample) into multiple fields according to the regular expression (Regex), and Keys is used to specify the field name of each field.
        """
        return pulumi.get(self, "keys")

    @property
    @pulumi.getter(name="pathSample")
    def path_sample(self) -> str:
        """
        Sample capture path for a real scene.
        """
        return pulumi.get(self, "path_sample")

    @property
    @pulumi.getter
    def regex(self) -> str:
        """
        Regular expression for extracting path fields. It must match the collection path sample, otherwise it cannot be extracted successfully.
        """
        return pulumi.get(self, "regex")


@pulumi.output_type
class RulesRuleUserDefineRulePluginResult(dict):
    def __init__(__self__, *,
                 processors: Sequence[str]):
        """
        :param Sequence[str] processors: LogCollector plugin.
        """
        pulumi.set(__self__, "processors", processors)

    @property
    @pulumi.getter
    def processors(self) -> Sequence[str]:
        """
        LogCollector plugin.
        """
        return pulumi.get(self, "processors")


@pulumi.output_type
class RulesRuleUserDefineRuleShardHashKeyResult(dict):
    def __init__(__self__, *,
                 hash_key: str):
        """
        :param str hash_key: The HashKey of the log group is used to specify the partition (shard) to be written to by the current log group.
        """
        pulumi.set(__self__, "hash_key", hash_key)

    @property
    @pulumi.getter(name="hashKey")
    def hash_key(self) -> str:
        """
        The HashKey of the log group is used to specify the partition (shard) to be written to by the current log group.
        """
        return pulumi.get(self, "hash_key")


@pulumi.output_type
class ShardsShardResult(dict):
    def __init__(__self__, *,
                 exclusive_end_key: str,
                 inclusive_begin_key: str,
                 modify_time: str,
                 shard_id: int,
                 status: str,
                 stop_write_time: str,
                 topic_id: str):
        """
        :param str exclusive_end_key: The end key info.
        :param str inclusive_begin_key: The begin key info.
        :param str modify_time: The modify time.
        :param int shard_id: The id of shard.
        :param str status: The status of shard.
        :param str stop_write_time: The stop write time.
        :param str topic_id: The id of topic.
        """
        pulumi.set(__self__, "exclusive_end_key", exclusive_end_key)
        pulumi.set(__self__, "inclusive_begin_key", inclusive_begin_key)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "shard_id", shard_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "stop_write_time", stop_write_time)
        pulumi.set(__self__, "topic_id", topic_id)

    @property
    @pulumi.getter(name="exclusiveEndKey")
    def exclusive_end_key(self) -> str:
        """
        The end key info.
        """
        return pulumi.get(self, "exclusive_end_key")

    @property
    @pulumi.getter(name="inclusiveBeginKey")
    def inclusive_begin_key(self) -> str:
        """
        The begin key info.
        """
        return pulumi.get(self, "inclusive_begin_key")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modify time.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="shardId")
    def shard_id(self) -> int:
        """
        The id of shard.
        """
        return pulumi.get(self, "shard_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of shard.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="stopWriteTime")
    def stop_write_time(self) -> str:
        """
        The stop write time.
        """
        return pulumi.get(self, "stop_write_time")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The id of topic.
        """
        return pulumi.get(self, "topic_id")


@pulumi.output_type
class TopicTag(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TopicsTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class TopicsTlsTopicResult(dict):
    def __init__(__self__, *,
                 auto_split: bool,
                 create_time: str,
                 description: str,
                 enable_tracking: bool,
                 id: str,
                 max_split_shard: int,
                 modify_time: str,
                 project_id: str,
                 shard_count: int,
                 tags: Sequence['outputs.TopicsTlsTopicTagResult'],
                 time_format: str,
                 time_key: str,
                 topic_id: str,
                 topic_name: str,
                 ttl: int):
        """
        :param bool auto_split: Whether to enable automatic partition splitting function of the tls topic.
        :param str create_time: The create time of the tls topic.
        :param str description: The description of the tls topic.
        :param bool enable_tracking: Whether to enable WebTracking function of the tls topic.
        :param str id: The ID of the tls topic.
        :param int max_split_shard: The max count of shards in the tls topic.
        :param str modify_time: The modify time of the tls topic.
        :param str project_id: The project id of tls topic.
        :param int shard_count: The count of shards in the tls topic.
        :param Sequence['TopicsTlsTopicTagArgs'] tags: Tags.
        :param str time_format: The format of the time field.
        :param str time_key: The name of the time field.
        :param str topic_id: The id of tls topic. This field supports fuzzy queries. It is not supported to specify both TopicName and TopicId at the same time.
        :param str topic_name: The name of tls topic. This field supports fuzzy queries. It is not supported to specify both TopicName and TopicId at the same time.
        :param int ttl: The data storage time of the tls topic. Unit: Day.
        """
        pulumi.set(__self__, "auto_split", auto_split)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "enable_tracking", enable_tracking)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "max_split_shard", max_split_shard)
        pulumi.set(__self__, "modify_time", modify_time)
        pulumi.set(__self__, "project_id", project_id)
        pulumi.set(__self__, "shard_count", shard_count)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "time_format", time_format)
        pulumi.set(__self__, "time_key", time_key)
        pulumi.set(__self__, "topic_id", topic_id)
        pulumi.set(__self__, "topic_name", topic_name)
        pulumi.set(__self__, "ttl", ttl)

    @property
    @pulumi.getter(name="autoSplit")
    def auto_split(self) -> bool:
        """
        Whether to enable automatic partition splitting function of the tls topic.
        """
        return pulumi.get(self, "auto_split")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The create time of the tls topic.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the tls topic.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="enableTracking")
    def enable_tracking(self) -> bool:
        """
        Whether to enable WebTracking function of the tls topic.
        """
        return pulumi.get(self, "enable_tracking")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the tls topic.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxSplitShard")
    def max_split_shard(self) -> int:
        """
        The max count of shards in the tls topic.
        """
        return pulumi.get(self, "max_split_shard")

    @property
    @pulumi.getter(name="modifyTime")
    def modify_time(self) -> str:
        """
        The modify time of the tls topic.
        """
        return pulumi.get(self, "modify_time")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The project id of tls topic.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="shardCount")
    def shard_count(self) -> int:
        """
        The count of shards in the tls topic.
        """
        return pulumi.get(self, "shard_count")

    @property
    @pulumi.getter
    def tags(self) -> Sequence['outputs.TopicsTlsTopicTagResult']:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="timeFormat")
    def time_format(self) -> str:
        """
        The format of the time field.
        """
        return pulumi.get(self, "time_format")

    @property
    @pulumi.getter(name="timeKey")
    def time_key(self) -> str:
        """
        The name of the time field.
        """
        return pulumi.get(self, "time_key")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> str:
        """
        The id of tls topic. This field supports fuzzy queries. It is not supported to specify both TopicName and TopicId at the same time.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> str:
        """
        The name of tls topic. This field supports fuzzy queries. It is not supported to specify both TopicName and TopicId at the same time.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter
    def ttl(self) -> int:
        """
        The data storage time of the tls topic. Unit: Day.
        """
        return pulumi.get(self, "ttl")


@pulumi.output_type
class TopicsTlsTopicTagResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The Key of Tags.
        :param str value: The Value of Tags.
        """
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The Key of Tags.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The Value of Tags.
        """
        return pulumi.get(self, "value")


