# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['RuleArgs', 'Rule']

@pulumi.input_type
class RuleArgs:
    def __init__(__self__, *,
                 rule_name: pulumi.Input[str],
                 topic_id: pulumi.Input[str],
                 container_rule: Optional[pulumi.Input['RuleContainerRuleArgs']] = None,
                 exclude_paths: Optional[pulumi.Input[Sequence[pulumi.Input['RuleExcludePathArgs']]]] = None,
                 extract_rule: Optional[pulumi.Input['RuleExtractRuleArgs']] = None,
                 input_type: Optional[pulumi.Input[int]] = None,
                 log_sample: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 user_define_rule: Optional[pulumi.Input['RuleUserDefineRuleArgs']] = None):
        """
        The set of arguments for constructing a Rule resource.
        :param pulumi.Input[str] rule_name: The name of the collection configuration.
        :param pulumi.Input[str] topic_id: The ID of the log topic to which the collection configuration belongs.
        :param pulumi.Input['RuleContainerRuleArgs'] container_rule: Container collection rules.
        :param pulumi.Input[Sequence[pulumi.Input['RuleExcludePathArgs']]] exclude_paths: Collect the blacklist list.
        :param pulumi.Input['RuleExtractRuleArgs'] extract_rule: The extract rule.
        :param pulumi.Input[int] input_type: The type of the collection configuration. Validate value can be `0`(host log file), `1`(K8s container standard output) and `2`(Log files in the K8s container).
        :param pulumi.Input[str] log_sample: The sample of the log.
        :param pulumi.Input[str] log_type: The log type. The value can be one of the following: `minimalist_log`, `json_log`, `delimiter_log`, `multiline_log`, `fullregex_log`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: Collection path list.
        :param pulumi.Input['RuleUserDefineRuleArgs'] user_define_rule: User-defined collection rules.
        """
        pulumi.set(__self__, "rule_name", rule_name)
        pulumi.set(__self__, "topic_id", topic_id)
        if container_rule is not None:
            pulumi.set(__self__, "container_rule", container_rule)
        if exclude_paths is not None:
            pulumi.set(__self__, "exclude_paths", exclude_paths)
        if extract_rule is not None:
            pulumi.set(__self__, "extract_rule", extract_rule)
        if input_type is not None:
            pulumi.set(__self__, "input_type", input_type)
        if log_sample is not None:
            pulumi.set(__self__, "log_sample", log_sample)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if user_define_rule is not None:
            pulumi.set(__self__, "user_define_rule", user_define_rule)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Input[str]:
        """
        The name of the collection configuration.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Input[str]:
        """
        The ID of the log topic to which the collection configuration belongs.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "topic_id", value)

    @property
    @pulumi.getter(name="containerRule")
    def container_rule(self) -> Optional[pulumi.Input['RuleContainerRuleArgs']]:
        """
        Container collection rules.
        """
        return pulumi.get(self, "container_rule")

    @container_rule.setter
    def container_rule(self, value: Optional[pulumi.Input['RuleContainerRuleArgs']]):
        pulumi.set(self, "container_rule", value)

    @property
    @pulumi.getter(name="excludePaths")
    def exclude_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleExcludePathArgs']]]]:
        """
        Collect the blacklist list.
        """
        return pulumi.get(self, "exclude_paths")

    @exclude_paths.setter
    def exclude_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleExcludePathArgs']]]]):
        pulumi.set(self, "exclude_paths", value)

    @property
    @pulumi.getter(name="extractRule")
    def extract_rule(self) -> Optional[pulumi.Input['RuleExtractRuleArgs']]:
        """
        The extract rule.
        """
        return pulumi.get(self, "extract_rule")

    @extract_rule.setter
    def extract_rule(self, value: Optional[pulumi.Input['RuleExtractRuleArgs']]):
        pulumi.set(self, "extract_rule", value)

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> Optional[pulumi.Input[int]]:
        """
        The type of the collection configuration. Validate value can be `0`(host log file), `1`(K8s container standard output) and `2`(Log files in the K8s container).
        """
        return pulumi.get(self, "input_type")

    @input_type.setter
    def input_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "input_type", value)

    @property
    @pulumi.getter(name="logSample")
    def log_sample(self) -> Optional[pulumi.Input[str]]:
        """
        The sample of the log.
        """
        return pulumi.get(self, "log_sample")

    @log_sample.setter
    def log_sample(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_sample", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        The log type. The value can be one of the following: `minimalist_log`, `json_log`, `delimiter_log`, `multiline_log`, `fullregex_log`.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Collection path list.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="userDefineRule")
    def user_define_rule(self) -> Optional[pulumi.Input['RuleUserDefineRuleArgs']]:
        """
        User-defined collection rules.
        """
        return pulumi.get(self, "user_define_rule")

    @user_define_rule.setter
    def user_define_rule(self, value: Optional[pulumi.Input['RuleUserDefineRuleArgs']]):
        pulumi.set(self, "user_define_rule", value)


@pulumi.input_type
class _RuleState:
    def __init__(__self__, *,
                 container_rule: Optional[pulumi.Input['RuleContainerRuleArgs']] = None,
                 exclude_paths: Optional[pulumi.Input[Sequence[pulumi.Input['RuleExcludePathArgs']]]] = None,
                 extract_rule: Optional[pulumi.Input['RuleExtractRuleArgs']] = None,
                 input_type: Optional[pulumi.Input[int]] = None,
                 log_sample: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rule_id: Optional[pulumi.Input[str]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 topic_id: Optional[pulumi.Input[str]] = None,
                 user_define_rule: Optional[pulumi.Input['RuleUserDefineRuleArgs']] = None):
        """
        Input properties used for looking up and filtering Rule resources.
        :param pulumi.Input['RuleContainerRuleArgs'] container_rule: Container collection rules.
        :param pulumi.Input[Sequence[pulumi.Input['RuleExcludePathArgs']]] exclude_paths: Collect the blacklist list.
        :param pulumi.Input['RuleExtractRuleArgs'] extract_rule: The extract rule.
        :param pulumi.Input[int] input_type: The type of the collection configuration. Validate value can be `0`(host log file), `1`(K8s container standard output) and `2`(Log files in the K8s container).
        :param pulumi.Input[str] log_sample: The sample of the log.
        :param pulumi.Input[str] log_type: The log type. The value can be one of the following: `minimalist_log`, `json_log`, `delimiter_log`, `multiline_log`, `fullregex_log`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: Collection path list.
        :param pulumi.Input[str] rule_id: The id of the rule.
        :param pulumi.Input[str] rule_name: The name of the collection configuration.
        :param pulumi.Input[str] topic_id: The ID of the log topic to which the collection configuration belongs.
        :param pulumi.Input['RuleUserDefineRuleArgs'] user_define_rule: User-defined collection rules.
        """
        if container_rule is not None:
            pulumi.set(__self__, "container_rule", container_rule)
        if exclude_paths is not None:
            pulumi.set(__self__, "exclude_paths", exclude_paths)
        if extract_rule is not None:
            pulumi.set(__self__, "extract_rule", extract_rule)
        if input_type is not None:
            pulumi.set(__self__, "input_type", input_type)
        if log_sample is not None:
            pulumi.set(__self__, "log_sample", log_sample)
        if log_type is not None:
            pulumi.set(__self__, "log_type", log_type)
        if paths is not None:
            pulumi.set(__self__, "paths", paths)
        if rule_id is not None:
            pulumi.set(__self__, "rule_id", rule_id)
        if rule_name is not None:
            pulumi.set(__self__, "rule_name", rule_name)
        if topic_id is not None:
            pulumi.set(__self__, "topic_id", topic_id)
        if user_define_rule is not None:
            pulumi.set(__self__, "user_define_rule", user_define_rule)

    @property
    @pulumi.getter(name="containerRule")
    def container_rule(self) -> Optional[pulumi.Input['RuleContainerRuleArgs']]:
        """
        Container collection rules.
        """
        return pulumi.get(self, "container_rule")

    @container_rule.setter
    def container_rule(self, value: Optional[pulumi.Input['RuleContainerRuleArgs']]):
        pulumi.set(self, "container_rule", value)

    @property
    @pulumi.getter(name="excludePaths")
    def exclude_paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['RuleExcludePathArgs']]]]:
        """
        Collect the blacklist list.
        """
        return pulumi.get(self, "exclude_paths")

    @exclude_paths.setter
    def exclude_paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['RuleExcludePathArgs']]]]):
        pulumi.set(self, "exclude_paths", value)

    @property
    @pulumi.getter(name="extractRule")
    def extract_rule(self) -> Optional[pulumi.Input['RuleExtractRuleArgs']]:
        """
        The extract rule.
        """
        return pulumi.get(self, "extract_rule")

    @extract_rule.setter
    def extract_rule(self, value: Optional[pulumi.Input['RuleExtractRuleArgs']]):
        pulumi.set(self, "extract_rule", value)

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> Optional[pulumi.Input[int]]:
        """
        The type of the collection configuration. Validate value can be `0`(host log file), `1`(K8s container standard output) and `2`(Log files in the K8s container).
        """
        return pulumi.get(self, "input_type")

    @input_type.setter
    def input_type(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "input_type", value)

    @property
    @pulumi.getter(name="logSample")
    def log_sample(self) -> Optional[pulumi.Input[str]]:
        """
        The sample of the log.
        """
        return pulumi.get(self, "log_sample")

    @log_sample.setter
    def log_sample(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_sample", value)

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> Optional[pulumi.Input[str]]:
        """
        The log type. The value can be one of the following: `minimalist_log`, `json_log`, `delimiter_log`, `multiline_log`, `fullregex_log`.
        """
        return pulumi.get(self, "log_type")

    @log_type.setter
    def log_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "log_type", value)

    @property
    @pulumi.getter
    def paths(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Collection path list.
        """
        return pulumi.get(self, "paths")

    @paths.setter
    def paths(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "paths", value)

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the rule.
        """
        return pulumi.get(self, "rule_id")

    @rule_id.setter
    def rule_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_id", value)

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the collection configuration.
        """
        return pulumi.get(self, "rule_name")

    @rule_name.setter
    def rule_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rule_name", value)

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the log topic to which the collection configuration belongs.
        """
        return pulumi.get(self, "topic_id")

    @topic_id.setter
    def topic_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic_id", value)

    @property
    @pulumi.getter(name="userDefineRule")
    def user_define_rule(self) -> Optional[pulumi.Input['RuleUserDefineRuleArgs']]:
        """
        User-defined collection rules.
        """
        return pulumi.get(self, "user_define_rule")

    @user_define_rule.setter
    def user_define_rule(self, value: Optional[pulumi.Input['RuleUserDefineRuleArgs']]):
        pulumi.set(self, "user_define_rule", value)


class Rule(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_rule: Optional[pulumi.Input[pulumi.InputType['RuleContainerRuleArgs']]] = None,
                 exclude_paths: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleExcludePathArgs']]]]] = None,
                 extract_rule: Optional[pulumi.Input[pulumi.InputType['RuleExtractRuleArgs']]] = None,
                 input_type: Optional[pulumi.Input[int]] = None,
                 log_sample: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 topic_id: Optional[pulumi.Input[str]] = None,
                 user_define_rule: Optional[pulumi.Input[pulumi.InputType['RuleUserDefineRuleArgs']]] = None,
                 __props__=None):
        """
        Provides a resource to manage tls rule
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_volcengine as volcengine

        foo = volcengine.tls.Rule("foo",
            topic_id="7bfa2cdc-4f8b-4cf9-b4c9-0ed05c33349f",
            rule_name="test",
            log_type="minimalist_log",
            log_sample="2018-05-22 15:35:53.850 INFO XXXX",
            input_type=1,
            user_define_rule=volcengine.tls.RuleUserDefineRuleArgs(
                enable_raw_log=False,
                tail_files=True,
                shard_hash_key=volcengine.tls.RuleUserDefineRuleShardHashKeyArgs(
                    hash_key="3C",
                ),
                plugin=volcengine.tls.RuleUserDefineRulePluginArgs(
                    processors=[
                        json.dumps({
                            "json": {
                                "field": "__content__",
                                "trim_keys": {
                                    "mode": "all",
                                    "chars": "#",
                                },
                                "trim_values": {
                                    "mode": "all",
                                    "chars": "#t",
                                },
                                "allow_overwrite_keys": True,
                                "allow_empty_values": True,
                            },
                        }),
                        json.dumps({
                            "json": {
                                "field": "__content__",
                                "trim_keys": {
                                    "mode": "all",
                                    "chars": "#xx",
                                },
                                "trim_values": {
                                    "mode": "all",
                                    "chars": "#txxxt",
                                },
                                "allow_overwrite_keys": True,
                                "allow_empty_values": True,
                            },
                        }),
                    ],
                ),
                advanced=volcengine.tls.RuleUserDefineRuleAdvancedArgs(
                    close_inactive=10,
                    close_removed=False,
                    close_renamed=False,
                    close_eof=False,
                    close_timeout=1,
                ),
            ),
            container_rule=volcengine.tls.RuleContainerRuleArgs(
                stream="all",
                container_name_regex=".*test.*",
                include_container_label_regex={
                    "Key1": "Value12",
                    "Key2": "Value23",
                },
                exclude_container_label_regex={
                    "Key1": "Value12",
                    "Key2": "Value22",
                },
                include_container_env_regex={
                    "Key1": "Value1",
                    "Key2": "Value2",
                },
                exclude_container_env_regex={
                    "Key1": "Value1",
                    "Key2": "Value2",
                },
                env_tag={
                    "Key1": "Value1",
                    "Key2": "Value2",
                },
                kubernetes_rule=volcengine.tls.RuleContainerRuleKubernetesRuleArgs(
                    namespace_name_regex=".*test.*",
                    workload_type="Deployment",
                    workload_name_regex=".*test.*",
                    include_pod_label_regex={
                        "Key1": "Value1",
                        "Key2": "Value2",
                    },
                    exclude_pod_label_regex={
                        "Key1": "Value1",
                        "Key2": "Value2",
                    },
                    pod_name_regex=".*test.*",
                    label_tag={
                        "Key1": "Value1",
                        "Key2": "Value2",
                    },
                    annotation_tag={
                        "Key1": "Value1",
                        "Key2": "Value2",
                    },
                ),
            ))
        ```

        ## Import

        tls rule can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:tls/rule:Rule default fa************
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['RuleContainerRuleArgs']] container_rule: Container collection rules.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleExcludePathArgs']]]] exclude_paths: Collect the blacklist list.
        :param pulumi.Input[pulumi.InputType['RuleExtractRuleArgs']] extract_rule: The extract rule.
        :param pulumi.Input[int] input_type: The type of the collection configuration. Validate value can be `0`(host log file), `1`(K8s container standard output) and `2`(Log files in the K8s container).
        :param pulumi.Input[str] log_sample: The sample of the log.
        :param pulumi.Input[str] log_type: The log type. The value can be one of the following: `minimalist_log`, `json_log`, `delimiter_log`, `multiline_log`, `fullregex_log`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: Collection path list.
        :param pulumi.Input[str] rule_name: The name of the collection configuration.
        :param pulumi.Input[str] topic_id: The ID of the log topic to which the collection configuration belongs.
        :param pulumi.Input[pulumi.InputType['RuleUserDefineRuleArgs']] user_define_rule: User-defined collection rules.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RuleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage tls rule
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_volcengine as volcengine

        foo = volcengine.tls.Rule("foo",
            topic_id="7bfa2cdc-4f8b-4cf9-b4c9-0ed05c33349f",
            rule_name="test",
            log_type="minimalist_log",
            log_sample="2018-05-22 15:35:53.850 INFO XXXX",
            input_type=1,
            user_define_rule=volcengine.tls.RuleUserDefineRuleArgs(
                enable_raw_log=False,
                tail_files=True,
                shard_hash_key=volcengine.tls.RuleUserDefineRuleShardHashKeyArgs(
                    hash_key="3C",
                ),
                plugin=volcengine.tls.RuleUserDefineRulePluginArgs(
                    processors=[
                        json.dumps({
                            "json": {
                                "field": "__content__",
                                "trim_keys": {
                                    "mode": "all",
                                    "chars": "#",
                                },
                                "trim_values": {
                                    "mode": "all",
                                    "chars": "#t",
                                },
                                "allow_overwrite_keys": True,
                                "allow_empty_values": True,
                            },
                        }),
                        json.dumps({
                            "json": {
                                "field": "__content__",
                                "trim_keys": {
                                    "mode": "all",
                                    "chars": "#xx",
                                },
                                "trim_values": {
                                    "mode": "all",
                                    "chars": "#txxxt",
                                },
                                "allow_overwrite_keys": True,
                                "allow_empty_values": True,
                            },
                        }),
                    ],
                ),
                advanced=volcengine.tls.RuleUserDefineRuleAdvancedArgs(
                    close_inactive=10,
                    close_removed=False,
                    close_renamed=False,
                    close_eof=False,
                    close_timeout=1,
                ),
            ),
            container_rule=volcengine.tls.RuleContainerRuleArgs(
                stream="all",
                container_name_regex=".*test.*",
                include_container_label_regex={
                    "Key1": "Value12",
                    "Key2": "Value23",
                },
                exclude_container_label_regex={
                    "Key1": "Value12",
                    "Key2": "Value22",
                },
                include_container_env_regex={
                    "Key1": "Value1",
                    "Key2": "Value2",
                },
                exclude_container_env_regex={
                    "Key1": "Value1",
                    "Key2": "Value2",
                },
                env_tag={
                    "Key1": "Value1",
                    "Key2": "Value2",
                },
                kubernetes_rule=volcengine.tls.RuleContainerRuleKubernetesRuleArgs(
                    namespace_name_regex=".*test.*",
                    workload_type="Deployment",
                    workload_name_regex=".*test.*",
                    include_pod_label_regex={
                        "Key1": "Value1",
                        "Key2": "Value2",
                    },
                    exclude_pod_label_regex={
                        "Key1": "Value1",
                        "Key2": "Value2",
                    },
                    pod_name_regex=".*test.*",
                    label_tag={
                        "Key1": "Value1",
                        "Key2": "Value2",
                    },
                    annotation_tag={
                        "Key1": "Value1",
                        "Key2": "Value2",
                    },
                ),
            ))
        ```

        ## Import

        tls rule can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:tls/rule:Rule default fa************
        ```

        :param str resource_name: The name of the resource.
        :param RuleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RuleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 container_rule: Optional[pulumi.Input[pulumi.InputType['RuleContainerRuleArgs']]] = None,
                 exclude_paths: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleExcludePathArgs']]]]] = None,
                 extract_rule: Optional[pulumi.Input[pulumi.InputType['RuleExtractRuleArgs']]] = None,
                 input_type: Optional[pulumi.Input[int]] = None,
                 log_sample: Optional[pulumi.Input[str]] = None,
                 log_type: Optional[pulumi.Input[str]] = None,
                 paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 rule_name: Optional[pulumi.Input[str]] = None,
                 topic_id: Optional[pulumi.Input[str]] = None,
                 user_define_rule: Optional[pulumi.Input[pulumi.InputType['RuleUserDefineRuleArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RuleArgs.__new__(RuleArgs)

            __props__.__dict__["container_rule"] = container_rule
            __props__.__dict__["exclude_paths"] = exclude_paths
            __props__.__dict__["extract_rule"] = extract_rule
            __props__.__dict__["input_type"] = input_type
            __props__.__dict__["log_sample"] = log_sample
            __props__.__dict__["log_type"] = log_type
            __props__.__dict__["paths"] = paths
            if rule_name is None and not opts.urn:
                raise TypeError("Missing required property 'rule_name'")
            __props__.__dict__["rule_name"] = rule_name
            if topic_id is None and not opts.urn:
                raise TypeError("Missing required property 'topic_id'")
            __props__.__dict__["topic_id"] = topic_id
            __props__.__dict__["user_define_rule"] = user_define_rule
            __props__.__dict__["rule_id"] = None
        super(Rule, __self__).__init__(
            'volcengine:tls/rule:Rule',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            container_rule: Optional[pulumi.Input[pulumi.InputType['RuleContainerRuleArgs']]] = None,
            exclude_paths: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleExcludePathArgs']]]]] = None,
            extract_rule: Optional[pulumi.Input[pulumi.InputType['RuleExtractRuleArgs']]] = None,
            input_type: Optional[pulumi.Input[int]] = None,
            log_sample: Optional[pulumi.Input[str]] = None,
            log_type: Optional[pulumi.Input[str]] = None,
            paths: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            rule_id: Optional[pulumi.Input[str]] = None,
            rule_name: Optional[pulumi.Input[str]] = None,
            topic_id: Optional[pulumi.Input[str]] = None,
            user_define_rule: Optional[pulumi.Input[pulumi.InputType['RuleUserDefineRuleArgs']]] = None) -> 'Rule':
        """
        Get an existing Rule resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['RuleContainerRuleArgs']] container_rule: Container collection rules.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['RuleExcludePathArgs']]]] exclude_paths: Collect the blacklist list.
        :param pulumi.Input[pulumi.InputType['RuleExtractRuleArgs']] extract_rule: The extract rule.
        :param pulumi.Input[int] input_type: The type of the collection configuration. Validate value can be `0`(host log file), `1`(K8s container standard output) and `2`(Log files in the K8s container).
        :param pulumi.Input[str] log_sample: The sample of the log.
        :param pulumi.Input[str] log_type: The log type. The value can be one of the following: `minimalist_log`, `json_log`, `delimiter_log`, `multiline_log`, `fullregex_log`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] paths: Collection path list.
        :param pulumi.Input[str] rule_id: The id of the rule.
        :param pulumi.Input[str] rule_name: The name of the collection configuration.
        :param pulumi.Input[str] topic_id: The ID of the log topic to which the collection configuration belongs.
        :param pulumi.Input[pulumi.InputType['RuleUserDefineRuleArgs']] user_define_rule: User-defined collection rules.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RuleState.__new__(_RuleState)

        __props__.__dict__["container_rule"] = container_rule
        __props__.__dict__["exclude_paths"] = exclude_paths
        __props__.__dict__["extract_rule"] = extract_rule
        __props__.__dict__["input_type"] = input_type
        __props__.__dict__["log_sample"] = log_sample
        __props__.__dict__["log_type"] = log_type
        __props__.__dict__["paths"] = paths
        __props__.__dict__["rule_id"] = rule_id
        __props__.__dict__["rule_name"] = rule_name
        __props__.__dict__["topic_id"] = topic_id
        __props__.__dict__["user_define_rule"] = user_define_rule
        return Rule(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="containerRule")
    def container_rule(self) -> pulumi.Output[Optional['outputs.RuleContainerRule']]:
        """
        Container collection rules.
        """
        return pulumi.get(self, "container_rule")

    @property
    @pulumi.getter(name="excludePaths")
    def exclude_paths(self) -> pulumi.Output[Optional[Sequence['outputs.RuleExcludePath']]]:
        """
        Collect the blacklist list.
        """
        return pulumi.get(self, "exclude_paths")

    @property
    @pulumi.getter(name="extractRule")
    def extract_rule(self) -> pulumi.Output['outputs.RuleExtractRule']:
        """
        The extract rule.
        """
        return pulumi.get(self, "extract_rule")

    @property
    @pulumi.getter(name="inputType")
    def input_type(self) -> pulumi.Output[Optional[int]]:
        """
        The type of the collection configuration. Validate value can be `0`(host log file), `1`(K8s container standard output) and `2`(Log files in the K8s container).
        """
        return pulumi.get(self, "input_type")

    @property
    @pulumi.getter(name="logSample")
    def log_sample(self) -> pulumi.Output[Optional[str]]:
        """
        The sample of the log.
        """
        return pulumi.get(self, "log_sample")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> pulumi.Output[Optional[str]]:
        """
        The log type. The value can be one of the following: `minimalist_log`, `json_log`, `delimiter_log`, `multiline_log`, `fullregex_log`.
        """
        return pulumi.get(self, "log_type")

    @property
    @pulumi.getter
    def paths(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        Collection path list.
        """
        return pulumi.get(self, "paths")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> pulumi.Output[str]:
        """
        The id of the rule.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> pulumi.Output[str]:
        """
        The name of the collection configuration.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> pulumi.Output[str]:
        """
        The ID of the log topic to which the collection configuration belongs.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="userDefineRule")
    def user_define_rule(self) -> pulumi.Output[Optional['outputs.RuleUserDefineRule']]:
        """
        User-defined collection rules.
        """
        return pulumi.get(self, "user_define_rule")

