# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'RulesResult',
    'AwaitableRulesResult',
    'rules',
    'rules_output',
]

@pulumi.output_type
class RulesResult:
    """
    A collection of values returned by Rules.
    """
    def __init__(__self__, id=None, output_file=None, project_id=None, rule_id=None, rule_name=None, rules=None, topic_id=None, topic_name=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if rule_id and not isinstance(rule_id, str):
            raise TypeError("Expected argument 'rule_id' to be a str")
        pulumi.set(__self__, "rule_id", rule_id)
        if rule_name and not isinstance(rule_name, str):
            raise TypeError("Expected argument 'rule_name' to be a str")
        pulumi.set(__self__, "rule_name", rule_name)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if topic_id and not isinstance(topic_id, str):
            raise TypeError("Expected argument 'topic_id' to be a str")
        pulumi.set(__self__, "topic_id", topic_id)
        if topic_name and not isinstance(topic_name, str):
            raise TypeError("Expected argument 'topic_name' to be a str")
        pulumi.set(__self__, "topic_name", topic_name)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter(name="ruleId")
    def rule_id(self) -> Optional[str]:
        """
        The rule id.
        """
        return pulumi.get(self, "rule_id")

    @property
    @pulumi.getter(name="ruleName")
    def rule_name(self) -> Optional[str]:
        """
        The rule name.
        """
        return pulumi.get(self, "rule_name")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.RulesRuleResult']:
        """
        The rules list.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[str]:
        """
        The topic id.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[str]:
        """
        The topic name.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")


class AwaitableRulesResult(RulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return RulesResult(
            id=self.id,
            output_file=self.output_file,
            project_id=self.project_id,
            rule_id=self.rule_id,
            rule_name=self.rule_name,
            rules=self.rules,
            topic_id=self.topic_id,
            topic_name=self.topic_name,
            total_count=self.total_count)


def rules(output_file: Optional[str] = None,
          project_id: Optional[str] = None,
          rule_id: Optional[str] = None,
          rule_name: Optional[str] = None,
          topic_id: Optional[str] = None,
          topic_name: Optional[str] = None,
          opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableRulesResult:
    """
    Use this data source to query detailed information of tls rules
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.tls.rules(project_id="cc44f8b6-0328-4622-b043-023fca735cd4")
    ```


    :param str output_file: File name where to save data source results.
    :param str project_id: The project id.
    :param str rule_id: The rule id.
    :param str rule_name: The rule name.
    :param str topic_id: The topic id.
    :param str topic_name: The topic name.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['projectId'] = project_id
    __args__['ruleId'] = rule_id
    __args__['ruleName'] = rule_name
    __args__['topicId'] = topic_id
    __args__['topicName'] = topic_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:tls/rules:Rules', __args__, opts=opts, typ=RulesResult).value

    return AwaitableRulesResult(
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_id=pulumi.get(__ret__, 'project_id'),
        rule_id=pulumi.get(__ret__, 'rule_id'),
        rule_name=pulumi.get(__ret__, 'rule_name'),
        rules=pulumi.get(__ret__, 'rules'),
        topic_id=pulumi.get(__ret__, 'topic_id'),
        topic_name=pulumi.get(__ret__, 'topic_name'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(rules)
def rules_output(output_file: Optional[pulumi.Input[Optional[str]]] = None,
                 project_id: Optional[pulumi.Input[str]] = None,
                 rule_id: Optional[pulumi.Input[Optional[str]]] = None,
                 rule_name: Optional[pulumi.Input[Optional[str]]] = None,
                 topic_id: Optional[pulumi.Input[Optional[str]]] = None,
                 topic_name: Optional[pulumi.Input[Optional[str]]] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[RulesResult]:
    """
    Use this data source to query detailed information of tls rules
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.tls.rules(project_id="cc44f8b6-0328-4622-b043-023fca735cd4")
    ```


    :param str output_file: File name where to save data source results.
    :param str project_id: The project id.
    :param str rule_id: The rule id.
    :param str rule_name: The rule name.
    :param str topic_id: The topic id.
    :param str topic_name: The topic name.
    """
    ...
