# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'TopicsResult',
    'AwaitableTopicsResult',
    'topics',
    'topics_output',
]

@pulumi.output_type
class TopicsResult:
    """
    A collection of values returned by Topics.
    """
    def __init__(__self__, id=None, is_full_name=None, name_regex=None, output_file=None, project_id=None, tags=None, tls_topics=None, topic_id=None, topic_name=None, total_count=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_full_name and not isinstance(is_full_name, bool):
            raise TypeError("Expected argument 'is_full_name' to be a bool")
        pulumi.set(__self__, "is_full_name", is_full_name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if project_id and not isinstance(project_id, str):
            raise TypeError("Expected argument 'project_id' to be a str")
        pulumi.set(__self__, "project_id", project_id)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if tls_topics and not isinstance(tls_topics, list):
            raise TypeError("Expected argument 'tls_topics' to be a list")
        pulumi.set(__self__, "tls_topics", tls_topics)
        if topic_id and not isinstance(topic_id, str):
            raise TypeError("Expected argument 'topic_id' to be a str")
        pulumi.set(__self__, "topic_id", topic_id)
        if topic_name and not isinstance(topic_name, str):
            raise TypeError("Expected argument 'topic_name' to be a str")
        pulumi.set(__self__, "topic_name", topic_name)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isFullName")
    def is_full_name(self) -> Optional[bool]:
        return pulumi.get(self, "is_full_name")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="projectId")
    def project_id(self) -> str:
        """
        The project id of the tls topic.
        """
        return pulumi.get(self, "project_id")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.TopicsTagResult']]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="tlsTopics")
    def tls_topics(self) -> Sequence['outputs.TopicsTlsTopicResult']:
        """
        The collection of tls topic query.
        """
        return pulumi.get(self, "tls_topics")

    @property
    @pulumi.getter(name="topicId")
    def topic_id(self) -> Optional[str]:
        """
        The ID of the tls topic.
        """
        return pulumi.get(self, "topic_id")

    @property
    @pulumi.getter(name="topicName")
    def topic_name(self) -> Optional[str]:
        """
        The name of the tls topic.
        """
        return pulumi.get(self, "topic_name")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of tls topic query.
        """
        return pulumi.get(self, "total_count")


class AwaitableTopicsResult(TopicsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return TopicsResult(
            id=self.id,
            is_full_name=self.is_full_name,
            name_regex=self.name_regex,
            output_file=self.output_file,
            project_id=self.project_id,
            tags=self.tags,
            tls_topics=self.tls_topics,
            topic_id=self.topic_id,
            topic_name=self.topic_name,
            total_count=self.total_count)


def topics(is_full_name: Optional[bool] = None,
           name_regex: Optional[str] = None,
           output_file: Optional[str] = None,
           project_id: Optional[str] = None,
           tags: Optional[Sequence[pulumi.InputType['TopicsTagArgs']]] = None,
           topic_id: Optional[str] = None,
           topic_name: Optional[str] = None,
           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableTopicsResult:
    """
    Use this data source to query detailed information of tls topics
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.tls.topics(project_id="e020c978-4f05-40e1-9167-0113d3ef****",
        topic_id="edf051ed-3c46-49ba-9339-bea628fe****")
    ```


    :param bool is_full_name: Whether to match accurately when filtering based on TopicName.
    :param str name_regex: A Name Regex of tls topic.
    :param str output_file: File name where to save data source results.
    :param str project_id: The project id of tls topic.
    :param Sequence[pulumi.InputType['TopicsTagArgs']] tags: Tags.
    :param str topic_id: The id of tls topic. This field supports fuzzy queries. It is not supported to specify both TopicName and TopicId at the same time.
    :param str topic_name: The name of tls topic. This field supports fuzzy queries. It is not supported to specify both TopicName and TopicId at the same time.
    """
    __args__ = dict()
    __args__['isFullName'] = is_full_name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['projectId'] = project_id
    __args__['tags'] = tags
    __args__['topicId'] = topic_id
    __args__['topicName'] = topic_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:tls/topics:Topics', __args__, opts=opts, typ=TopicsResult).value

    return AwaitableTopicsResult(
        id=pulumi.get(__ret__, 'id'),
        is_full_name=pulumi.get(__ret__, 'is_full_name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        project_id=pulumi.get(__ret__, 'project_id'),
        tags=pulumi.get(__ret__, 'tags'),
        tls_topics=pulumi.get(__ret__, 'tls_topics'),
        topic_id=pulumi.get(__ret__, 'topic_id'),
        topic_name=pulumi.get(__ret__, 'topic_name'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(topics)
def topics_output(is_full_name: Optional[pulumi.Input[Optional[bool]]] = None,
                  name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                  output_file: Optional[pulumi.Input[Optional[str]]] = None,
                  project_id: Optional[pulumi.Input[str]] = None,
                  tags: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['TopicsTagArgs']]]]] = None,
                  topic_id: Optional[pulumi.Input[Optional[str]]] = None,
                  topic_name: Optional[pulumi.Input[Optional[str]]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[TopicsResult]:
    """
    Use this data source to query detailed information of tls topics
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.tls.topics(project_id="e020c978-4f05-40e1-9167-0113d3ef****",
        topic_id="edf051ed-3c46-49ba-9339-bea628fe****")
    ```


    :param bool is_full_name: Whether to match accurately when filtering based on TopicName.
    :param str name_regex: A Name Regex of tls topic.
    :param str output_file: File name where to save data source results.
    :param str project_id: The project id of tls topic.
    :param Sequence[pulumi.InputType['TopicsTagArgs']] tags: Tags.
    :param str topic_id: The id of tls topic. This field supports fuzzy queries. It is not supported to specify both TopicName and TopicId at the same time.
    :param str topic_name: The name of tls topic. This field supports fuzzy queries. It is not supported to specify both TopicName and TopicId at the same time.
    """
    ...
