# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BucketArgs', 'Bucket']

@pulumi.input_type
class BucketArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 account_acls: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAccountAclArgs']]]] = None,
                 enable_version: Optional[pulumi.Input[bool]] = None,
                 public_acl: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Bucket resource.
        :param pulumi.Input[str] bucket_name: The name of the bucket.
        :param pulumi.Input[Sequence[pulumi.Input['BucketAccountAclArgs']]] account_acls: The user set of grant full control.
        :param pulumi.Input[bool] enable_version: The flag of enable tos version.
        :param pulumi.Input[str] public_acl: The public acl control of object.Valid value is private|public-read|public-read-write|authenticated-read|bucket-owner-read.
        :param pulumi.Input[str] storage_class: The storage type of the object.Valid value is STANDARD|IA|ARCHIVE_FR.Default is STANDARD.
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        if account_acls is not None:
            pulumi.set(__self__, "account_acls", account_acls)
        if enable_version is not None:
            pulumi.set(__self__, "enable_version", enable_version)
        if public_acl is not None:
            pulumi.set(__self__, "public_acl", public_acl)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="accountAcls")
    def account_acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketAccountAclArgs']]]]:
        """
        The user set of grant full control.
        """
        return pulumi.get(self, "account_acls")

    @account_acls.setter
    def account_acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAccountAclArgs']]]]):
        pulumi.set(self, "account_acls", value)

    @property
    @pulumi.getter(name="enableVersion")
    def enable_version(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag of enable tos version.
        """
        return pulumi.get(self, "enable_version")

    @enable_version.setter
    def enable_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_version", value)

    @property
    @pulumi.getter(name="publicAcl")
    def public_acl(self) -> Optional[pulumi.Input[str]]:
        """
        The public acl control of object.Valid value is private|public-read|public-read-write|authenticated-read|bucket-owner-read.
        """
        return pulumi.get(self, "public_acl")

    @public_acl.setter
    def public_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_acl", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The storage type of the object.Valid value is STANDARD|IA|ARCHIVE_FR.Default is STANDARD.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)


@pulumi.input_type
class _BucketState:
    def __init__(__self__, *,
                 account_acls: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAccountAclArgs']]]] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 creation_date: Optional[pulumi.Input[str]] = None,
                 enable_version: Optional[pulumi.Input[bool]] = None,
                 extranet_endpoint: Optional[pulumi.Input[str]] = None,
                 intranet_endpoint: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 public_acl: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Bucket resources.
        :param pulumi.Input[Sequence[pulumi.Input['BucketAccountAclArgs']]] account_acls: The user set of grant full control.
        :param pulumi.Input[str] bucket_name: The name of the bucket.
        :param pulumi.Input[str] creation_date: The create date of the TOS bucket.
        :param pulumi.Input[bool] enable_version: The flag of enable tos version.
        :param pulumi.Input[str] extranet_endpoint: The extranet endpoint of the TOS bucket.
        :param pulumi.Input[str] intranet_endpoint: The intranet endpoint the TOS bucket.
        :param pulumi.Input[str] location: The location of the TOS bucket.
        :param pulumi.Input[str] public_acl: The public acl control of object.Valid value is private|public-read|public-read-write|authenticated-read|bucket-owner-read.
        :param pulumi.Input[str] storage_class: The storage type of the object.Valid value is STANDARD|IA|ARCHIVE_FR.Default is STANDARD.
        """
        if account_acls is not None:
            pulumi.set(__self__, "account_acls", account_acls)
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if creation_date is not None:
            pulumi.set(__self__, "creation_date", creation_date)
        if enable_version is not None:
            pulumi.set(__self__, "enable_version", enable_version)
        if extranet_endpoint is not None:
            pulumi.set(__self__, "extranet_endpoint", extranet_endpoint)
        if intranet_endpoint is not None:
            pulumi.set(__self__, "intranet_endpoint", intranet_endpoint)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if public_acl is not None:
            pulumi.set(__self__, "public_acl", public_acl)
        if storage_class is not None:
            pulumi.set(__self__, "storage_class", storage_class)

    @property
    @pulumi.getter(name="accountAcls")
    def account_acls(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BucketAccountAclArgs']]]]:
        """
        The user set of grant full control.
        """
        return pulumi.get(self, "account_acls")

    @account_acls.setter
    def account_acls(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BucketAccountAclArgs']]]]):
        pulumi.set(self, "account_acls", value)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> Optional[pulumi.Input[str]]:
        """
        The create date of the TOS bucket.
        """
        return pulumi.get(self, "creation_date")

    @creation_date.setter
    def creation_date(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_date", value)

    @property
    @pulumi.getter(name="enableVersion")
    def enable_version(self) -> Optional[pulumi.Input[bool]]:
        """
        The flag of enable tos version.
        """
        return pulumi.get(self, "enable_version")

    @enable_version.setter
    def enable_version(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "enable_version", value)

    @property
    @pulumi.getter(name="extranetEndpoint")
    def extranet_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The extranet endpoint of the TOS bucket.
        """
        return pulumi.get(self, "extranet_endpoint")

    @extranet_endpoint.setter
    def extranet_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "extranet_endpoint", value)

    @property
    @pulumi.getter(name="intranetEndpoint")
    def intranet_endpoint(self) -> Optional[pulumi.Input[str]]:
        """
        The intranet endpoint the TOS bucket.
        """
        return pulumi.get(self, "intranet_endpoint")

    @intranet_endpoint.setter
    def intranet_endpoint(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "intranet_endpoint", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        The location of the TOS bucket.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter(name="publicAcl")
    def public_acl(self) -> Optional[pulumi.Input[str]]:
        """
        The public acl control of object.Valid value is private|public-read|public-read-write|authenticated-read|bucket-owner-read.
        """
        return pulumi.get(self, "public_acl")

    @public_acl.setter
    def public_acl(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_acl", value)

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> Optional[pulumi.Input[str]]:
        """
        The storage type of the object.Valid value is STANDARD|IA|ARCHIVE_FR.Default is STANDARD.
        """
        return pulumi.get(self, "storage_class")

    @storage_class.setter
    def storage_class(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_class", value)


class Bucket(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_acls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccountAclArgs']]]]] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 enable_version: Optional[pulumi.Input[bool]] = None,
                 public_acl: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage tos bucket
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        default = volcengine.tos.Bucket("default",
            account_acls=[
                volcengine.tos.BucketAccountAclArgs(
                    account_id="1",
                    permission="READ",
                ),
                volcengine.tos.BucketAccountAclArgs(
                    account_id="2001",
                    permission="WRITE_ACP",
                ),
            ],
            bucket_name="test-xym-1",
            enable_version=True,
            public_acl="private")
        ```

        ## Import

        Tos Bucket can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:tos/bucket:Bucket default bucketName
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccountAclArgs']]]] account_acls: The user set of grant full control.
        :param pulumi.Input[str] bucket_name: The name of the bucket.
        :param pulumi.Input[bool] enable_version: The flag of enable tos version.
        :param pulumi.Input[str] public_acl: The public acl control of object.Valid value is private|public-read|public-read-write|authenticated-read|bucket-owner-read.
        :param pulumi.Input[str] storage_class: The storage type of the object.Valid value is STANDARD|IA|ARCHIVE_FR.Default is STANDARD.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage tos bucket
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        default = volcengine.tos.Bucket("default",
            account_acls=[
                volcengine.tos.BucketAccountAclArgs(
                    account_id="1",
                    permission="READ",
                ),
                volcengine.tos.BucketAccountAclArgs(
                    account_id="2001",
                    permission="WRITE_ACP",
                ),
            ],
            bucket_name="test-xym-1",
            enable_version=True,
            public_acl="private")
        ```

        ## Import

        Tos Bucket can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:tos/bucket:Bucket default bucketName
        ```

        :param str resource_name: The name of the resource.
        :param BucketArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 account_acls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccountAclArgs']]]]] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 enable_version: Optional[pulumi.Input[bool]] = None,
                 public_acl: Optional[pulumi.Input[str]] = None,
                 storage_class: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketArgs.__new__(BucketArgs)

            __props__.__dict__["account_acls"] = account_acls
            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            __props__.__dict__["enable_version"] = enable_version
            __props__.__dict__["public_acl"] = public_acl
            __props__.__dict__["storage_class"] = storage_class
            __props__.__dict__["creation_date"] = None
            __props__.__dict__["extranet_endpoint"] = None
            __props__.__dict__["intranet_endpoint"] = None
            __props__.__dict__["location"] = None
        super(Bucket, __self__).__init__(
            'volcengine:tos/bucket:Bucket',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            account_acls: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccountAclArgs']]]]] = None,
            bucket_name: Optional[pulumi.Input[str]] = None,
            creation_date: Optional[pulumi.Input[str]] = None,
            enable_version: Optional[pulumi.Input[bool]] = None,
            extranet_endpoint: Optional[pulumi.Input[str]] = None,
            intranet_endpoint: Optional[pulumi.Input[str]] = None,
            location: Optional[pulumi.Input[str]] = None,
            public_acl: Optional[pulumi.Input[str]] = None,
            storage_class: Optional[pulumi.Input[str]] = None) -> 'Bucket':
        """
        Get an existing Bucket resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BucketAccountAclArgs']]]] account_acls: The user set of grant full control.
        :param pulumi.Input[str] bucket_name: The name of the bucket.
        :param pulumi.Input[str] creation_date: The create date of the TOS bucket.
        :param pulumi.Input[bool] enable_version: The flag of enable tos version.
        :param pulumi.Input[str] extranet_endpoint: The extranet endpoint of the TOS bucket.
        :param pulumi.Input[str] intranet_endpoint: The intranet endpoint the TOS bucket.
        :param pulumi.Input[str] location: The location of the TOS bucket.
        :param pulumi.Input[str] public_acl: The public acl control of object.Valid value is private|public-read|public-read-write|authenticated-read|bucket-owner-read.
        :param pulumi.Input[str] storage_class: The storage type of the object.Valid value is STANDARD|IA|ARCHIVE_FR.Default is STANDARD.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketState.__new__(_BucketState)

        __props__.__dict__["account_acls"] = account_acls
        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["creation_date"] = creation_date
        __props__.__dict__["enable_version"] = enable_version
        __props__.__dict__["extranet_endpoint"] = extranet_endpoint
        __props__.__dict__["intranet_endpoint"] = intranet_endpoint
        __props__.__dict__["location"] = location
        __props__.__dict__["public_acl"] = public_acl
        __props__.__dict__["storage_class"] = storage_class
        return Bucket(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="accountAcls")
    def account_acls(self) -> pulumi.Output[Optional[Sequence['outputs.BucketAccountAcl']]]:
        """
        The user set of grant full control.
        """
        return pulumi.get(self, "account_acls")

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter(name="creationDate")
    def creation_date(self) -> pulumi.Output[str]:
        """
        The create date of the TOS bucket.
        """
        return pulumi.get(self, "creation_date")

    @property
    @pulumi.getter(name="enableVersion")
    def enable_version(self) -> pulumi.Output[Optional[bool]]:
        """
        The flag of enable tos version.
        """
        return pulumi.get(self, "enable_version")

    @property
    @pulumi.getter(name="extranetEndpoint")
    def extranet_endpoint(self) -> pulumi.Output[str]:
        """
        The extranet endpoint of the TOS bucket.
        """
        return pulumi.get(self, "extranet_endpoint")

    @property
    @pulumi.getter(name="intranetEndpoint")
    def intranet_endpoint(self) -> pulumi.Output[str]:
        """
        The intranet endpoint the TOS bucket.
        """
        return pulumi.get(self, "intranet_endpoint")

    @property
    @pulumi.getter
    def location(self) -> pulumi.Output[str]:
        """
        The location of the TOS bucket.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter(name="publicAcl")
    def public_acl(self) -> pulumi.Output[Optional[str]]:
        """
        The public acl control of object.Valid value is private|public-read|public-read-write|authenticated-read|bucket-owner-read.
        """
        return pulumi.get(self, "public_acl")

    @property
    @pulumi.getter(name="storageClass")
    def storage_class(self) -> pulumi.Output[Optional[str]]:
        """
        The storage type of the object.Valid value is STANDARD|IA|ARCHIVE_FR.Default is STANDARD.
        """
        return pulumi.get(self, "storage_class")

