# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['BucketPolicyArgs', 'BucketPolicy']

@pulumi.input_type
class BucketPolicyArgs:
    def __init__(__self__, *,
                 bucket_name: pulumi.Input[str],
                 policy: pulumi.Input[str]):
        """
        The set of arguments for constructing a BucketPolicy resource.
        :param pulumi.Input[str] bucket_name: The name of the bucket.
        :param pulumi.Input[str] policy: The policy document. This is a JSON formatted string. For more information about building Volcengine IAM policy
               documents with Terraform, see the [Volcengine IAM Policy Document Guide](https://www.volcengine.com/docs/6349/102127).
        """
        pulumi.set(__self__, "bucket_name", bucket_name)
        pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Input[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Input[str]:
        """
        The policy document. This is a JSON formatted string. For more information about building Volcengine IAM policy
        documents with Terraform, see the [Volcengine IAM Policy Document Guide](https://www.volcengine.com/docs/6349/102127).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: pulumi.Input[str]):
        pulumi.set(self, "policy", value)


@pulumi.input_type
class _BucketPolicyState:
    def __init__(__self__, *,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BucketPolicy resources.
        :param pulumi.Input[str] bucket_name: The name of the bucket.
        :param pulumi.Input[str] policy: The policy document. This is a JSON formatted string. For more information about building Volcengine IAM policy
               documents with Terraform, see the [Volcengine IAM Policy Document Guide](https://www.volcengine.com/docs/6349/102127).
        """
        if bucket_name is not None:
            pulumi.set(__self__, "bucket_name", bucket_name)
        if policy is not None:
            pulumi.set(__self__, "policy", policy)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @bucket_name.setter
    def bucket_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "bucket_name", value)

    @property
    @pulumi.getter
    def policy(self) -> Optional[pulumi.Input[str]]:
        """
        The policy document. This is a JSON formatted string. For more information about building Volcengine IAM policy
        documents with Terraform, see the [Volcengine IAM Policy Document Guide](https://www.volcengine.com/docs/6349/102127).
        """
        return pulumi.get(self, "policy")

    @policy.setter
    def policy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "policy", value)


class BucketPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage tos bucket policy
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_volcengine as volcengine

        default = volcengine.tos.BucketPolicy("default",
            bucket_name="bucket-20230418",
            policy=json.dumps({
                "Statement": [{
                    "Sid": "test",
                    "Effect": "Allow",
                    "Principal": ["AccountId/subUserName"],
                    "Action": ["tos:List*"],
                    "Resource": ["trn:tos:::bucket-20230418"],
                }],
            }))
        ```

        ## Import

        Tos Bucket can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:tos/bucketPolicy:BucketPolicy default bucketName:policy
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket_name: The name of the bucket.
        :param pulumi.Input[str] policy: The policy document. This is a JSON formatted string. For more information about building Volcengine IAM policy
               documents with Terraform, see the [Volcengine IAM Policy Document Guide](https://www.volcengine.com/docs/6349/102127).
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BucketPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage tos bucket policy
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_volcengine as volcengine

        default = volcengine.tos.BucketPolicy("default",
            bucket_name="bucket-20230418",
            policy=json.dumps({
                "Statement": [{
                    "Sid": "test",
                    "Effect": "Allow",
                    "Principal": ["AccountId/subUserName"],
                    "Action": ["tos:List*"],
                    "Resource": ["trn:tos:::bucket-20230418"],
                }],
            }))
        ```

        ## Import

        Tos Bucket can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:tos/bucketPolicy:BucketPolicy default bucketName:policy
        ```

        :param str resource_name: The name of the resource.
        :param BucketPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BucketPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bucket_name: Optional[pulumi.Input[str]] = None,
                 policy: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BucketPolicyArgs.__new__(BucketPolicyArgs)

            if bucket_name is None and not opts.urn:
                raise TypeError("Missing required property 'bucket_name'")
            __props__.__dict__["bucket_name"] = bucket_name
            if policy is None and not opts.urn:
                raise TypeError("Missing required property 'policy'")
            __props__.__dict__["policy"] = policy
        super(BucketPolicy, __self__).__init__(
            'volcengine:tos/bucketPolicy:BucketPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bucket_name: Optional[pulumi.Input[str]] = None,
            policy: Optional[pulumi.Input[str]] = None) -> 'BucketPolicy':
        """
        Get an existing BucketPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] bucket_name: The name of the bucket.
        :param pulumi.Input[str] policy: The policy document. This is a JSON formatted string. For more information about building Volcengine IAM policy
               documents with Terraform, see the [Volcengine IAM Policy Document Guide](https://www.volcengine.com/docs/6349/102127).
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BucketPolicyState.__new__(_BucketPolicyState)

        __props__.__dict__["bucket_name"] = bucket_name
        __props__.__dict__["policy"] = policy
        return BucketPolicy(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="bucketName")
    def bucket_name(self) -> pulumi.Output[str]:
        """
        The name of the bucket.
        """
        return pulumi.get(self, "bucket_name")

    @property
    @pulumi.getter
    def policy(self) -> pulumi.Output[str]:
        """
        The policy document. This is a JSON formatted string. For more information about building Volcengine IAM policy
        documents with Terraform, see the [Volcengine IAM Policy Document Guide](https://www.volcengine.com/docs/6349/102127).
        """
        return pulumi.get(self, "policy")

