# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BandwidthPackageArgs', 'BandwidthPackage']

@pulumi.input_type
class BandwidthPackageArgs:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 remain_renew_times: Optional[pulumi.Input[int]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renew_type: Optional[pulumi.Input[str]] = None,
                 transit_router_bandwidth_package_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a BandwidthPackage resource.
        :param pulumi.Input[int] bandwidth: The bandwidth peak of the transit router bandwidth package. Unit: Mbps. Valid values: 2-10000. Default is 2 Mbps.
        :param pulumi.Input[str] description: The description of the transit router bandwidth package.
        :param pulumi.Input[int] period: The period of the transit router bandwidth package, the valid value range in 1~9 or 12 or 36. Default value is 12. The period unit defaults to `Month`.The modification of this field only takes effect when the value of the `renew_type` is `Manual`.
        :param pulumi.Input[int] remain_renew_times: The remaining renewal times of of the transit router bandwidth package. Valid values: -1 or 1~100. Default value is -1, means unlimited renewal.This field is only effective when the value of the `renew_type` is `Auto`.
        :param pulumi.Input[int] renew_period: The auto renewal period of the transit router bandwidth package. Valid values: 1,2,3,6,12. Default value is 1. Unit: Month.This field is only effective when the value of the `renew_type` is `Auto`. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] renew_type: The renewal type of the transit router bandwidth package. Valid values: `Manual`, `Auto`, `NoRenew`. Default is `Manual`.This field is only effective when modifying the bandwidth package.
        :param pulumi.Input[str] transit_router_bandwidth_package_name: The name of the transit router bandwidth package.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if remain_renew_times is not None:
            pulumi.set(__self__, "remain_renew_times", remain_renew_times)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renew_type is not None:
            pulumi.set(__self__, "renew_type", renew_type)
        if transit_router_bandwidth_package_name is not None:
            pulumi.set(__self__, "transit_router_bandwidth_package_name", transit_router_bandwidth_package_name)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth peak of the transit router bandwidth package. Unit: Mbps. Valid values: 2-10000. Default is 2 Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the transit router bandwidth package.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period of the transit router bandwidth package, the valid value range in 1~9 or 12 or 36. Default value is 12. The period unit defaults to `Month`.The modification of this field only takes effect when the value of the `renew_type` is `Manual`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="remainRenewTimes")
    def remain_renew_times(self) -> Optional[pulumi.Input[int]]:
        """
        The remaining renewal times of of the transit router bandwidth package. Valid values: -1 or 1~100. Default value is -1, means unlimited renewal.This field is only effective when the value of the `renew_type` is `Auto`.
        """
        return pulumi.get(self, "remain_renew_times")

    @remain_renew_times.setter
    def remain_renew_times(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "remain_renew_times", value)

    @property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        The auto renewal period of the transit router bandwidth package. Valid values: 1,2,3,6,12. Default value is 1. Unit: Month.This field is only effective when the value of the `renew_type` is `Auto`. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renew_period", value)

    @property
    @pulumi.getter(name="renewType")
    def renew_type(self) -> Optional[pulumi.Input[str]]:
        """
        The renewal type of the transit router bandwidth package. Valid values: `Manual`, `Auto`, `NoRenew`. Default is `Manual`.This field is only effective when modifying the bandwidth package.
        """
        return pulumi.get(self, "renew_type")

    @renew_type.setter
    def renew_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renew_type", value)

    @property
    @pulumi.getter(name="transitRouterBandwidthPackageName")
    def transit_router_bandwidth_package_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the transit router bandwidth package.
        """
        return pulumi.get(self, "transit_router_bandwidth_package_name")

    @transit_router_bandwidth_package_name.setter
    def transit_router_bandwidth_package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_bandwidth_package_name", value)


@pulumi.input_type
class _BandwidthPackageState:
    def __init__(__self__, *,
                 allocations: Optional[pulumi.Input[Sequence[pulumi.Input['BandwidthPackageAllocationArgs']]]] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 business_status: Optional[pulumi.Input[str]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 delete_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 expired_time: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 remain_renew_times: Optional[pulumi.Input[int]] = None,
                 remaining_bandwidth: Optional[pulumi.Input[int]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renew_type: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 transit_router_bandwidth_package_name: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering BandwidthPackage resources.
        :param pulumi.Input[Sequence[pulumi.Input['BandwidthPackageAllocationArgs']]] allocations: The detailed information on cross regional connections associated with bandwidth packets.
        :param pulumi.Input[int] bandwidth: The bandwidth peak of the transit router bandwidth package. Unit: Mbps. Valid values: 2-10000. Default is 2 Mbps.
        :param pulumi.Input[str] business_status: The business status of the transit router bandwidth package.
        :param pulumi.Input[str] creation_time: The create time of the transit router bandwidth package.
        :param pulumi.Input[str] delete_time: The delete time of the transit router bandwidth package.
        :param pulumi.Input[str] description: The description of the transit router bandwidth package.
        :param pulumi.Input[str] expired_time: The expired time of the transit router bandwidth package.
        :param pulumi.Input[int] period: The period of the transit router bandwidth package, the valid value range in 1~9 or 12 or 36. Default value is 12. The period unit defaults to `Month`.The modification of this field only takes effect when the value of the `renew_type` is `Manual`.
        :param pulumi.Input[int] remain_renew_times: The remaining renewal times of of the transit router bandwidth package. Valid values: -1 or 1~100. Default value is -1, means unlimited renewal.This field is only effective when the value of the `renew_type` is `Auto`.
        :param pulumi.Input[int] remaining_bandwidth: The remaining bandwidth of the transit router bandwidth package. Unit: Mbps.
        :param pulumi.Input[int] renew_period: The auto renewal period of the transit router bandwidth package. Valid values: 1,2,3,6,12. Default value is 1. Unit: Month.This field is only effective when the value of the `renew_type` is `Auto`. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] renew_type: The renewal type of the transit router bandwidth package. Valid values: `Manual`, `Auto`, `NoRenew`. Default is `Manual`.This field is only effective when modifying the bandwidth package.
        :param pulumi.Input[str] status: The status of the transit router bandwidth package.
        :param pulumi.Input[str] transit_router_bandwidth_package_name: The name of the transit router bandwidth package.
        :param pulumi.Input[str] update_time: The update time of the transit router bandwidth package.
        """
        if allocations is not None:
            pulumi.set(__self__, "allocations", allocations)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if business_status is not None:
            pulumi.set(__self__, "business_status", business_status)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expired_time is not None:
            pulumi.set(__self__, "expired_time", expired_time)
        if period is not None:
            pulumi.set(__self__, "period", period)
        if remain_renew_times is not None:
            pulumi.set(__self__, "remain_renew_times", remain_renew_times)
        if remaining_bandwidth is not None:
            pulumi.set(__self__, "remaining_bandwidth", remaining_bandwidth)
        if renew_period is not None:
            pulumi.set(__self__, "renew_period", renew_period)
        if renew_type is not None:
            pulumi.set(__self__, "renew_type", renew_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_bandwidth_package_name is not None:
            pulumi.set(__self__, "transit_router_bandwidth_package_name", transit_router_bandwidth_package_name)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def allocations(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['BandwidthPackageAllocationArgs']]]]:
        """
        The detailed information on cross regional connections associated with bandwidth packets.
        """
        return pulumi.get(self, "allocations")

    @allocations.setter
    def allocations(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['BandwidthPackageAllocationArgs']]]]):
        pulumi.set(self, "allocations", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth peak of the transit router bandwidth package. Unit: Mbps. Valid values: 2-10000. Default is 2 Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> Optional[pulumi.Input[str]]:
        """
        The business status of the transit router bandwidth package.
        """
        return pulumi.get(self, "business_status")

    @business_status.setter
    def business_status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "business_status", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the transit router bandwidth package.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[pulumi.Input[str]]:
        """
        The delete time of the transit router bandwidth package.
        """
        return pulumi.get(self, "delete_time")

    @delete_time.setter
    def delete_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the transit router bandwidth package.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> Optional[pulumi.Input[str]]:
        """
        The expired time of the transit router bandwidth package.
        """
        return pulumi.get(self, "expired_time")

    @expired_time.setter
    def expired_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expired_time", value)

    @property
    @pulumi.getter
    def period(self) -> Optional[pulumi.Input[int]]:
        """
        The period of the transit router bandwidth package, the valid value range in 1~9 or 12 or 36. Default value is 12. The period unit defaults to `Month`.The modification of this field only takes effect when the value of the `renew_type` is `Manual`.
        """
        return pulumi.get(self, "period")

    @period.setter
    def period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "period", value)

    @property
    @pulumi.getter(name="remainRenewTimes")
    def remain_renew_times(self) -> Optional[pulumi.Input[int]]:
        """
        The remaining renewal times of of the transit router bandwidth package. Valid values: -1 or 1~100. Default value is -1, means unlimited renewal.This field is only effective when the value of the `renew_type` is `Auto`.
        """
        return pulumi.get(self, "remain_renew_times")

    @remain_renew_times.setter
    def remain_renew_times(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "remain_renew_times", value)

    @property
    @pulumi.getter(name="remainingBandwidth")
    def remaining_bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The remaining bandwidth of the transit router bandwidth package. Unit: Mbps.
        """
        return pulumi.get(self, "remaining_bandwidth")

    @remaining_bandwidth.setter
    def remaining_bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "remaining_bandwidth", value)

    @property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> Optional[pulumi.Input[int]]:
        """
        The auto renewal period of the transit router bandwidth package. Valid values: 1,2,3,6,12. Default value is 1. Unit: Month.This field is only effective when the value of the `renew_type` is `Auto`. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "renew_period")

    @renew_period.setter
    def renew_period(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "renew_period", value)

    @property
    @pulumi.getter(name="renewType")
    def renew_type(self) -> Optional[pulumi.Input[str]]:
        """
        The renewal type of the transit router bandwidth package. Valid values: `Manual`, `Auto`, `NoRenew`. Default is `Manual`.This field is only effective when modifying the bandwidth package.
        """
        return pulumi.get(self, "renew_type")

    @renew_type.setter
    def renew_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "renew_type", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the transit router bandwidth package.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="transitRouterBandwidthPackageName")
    def transit_router_bandwidth_package_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the transit router bandwidth package.
        """
        return pulumi.get(self, "transit_router_bandwidth_package_name")

    @transit_router_bandwidth_package_name.setter
    def transit_router_bandwidth_package_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_bandwidth_package_name", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the transit router bandwidth package.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class BandwidthPackage(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 remain_renew_times: Optional[pulumi.Input[int]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renew_type: Optional[pulumi.Input[str]] = None,
                 transit_router_bandwidth_package_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage transit router bandwidth package
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.BandwidthPackage("foo",
            bandwidth=2,
            description="acc-test",
            period=1,
            renew_type="Manual",
            transit_router_bandwidth_package_name="acc-tf-test")
        ```

        ## Import

        TransitRouterBandwidthPackage can be imported using the Id, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/bandwidthPackage:BandwidthPackage default tbp-cd-2felfww0i6pkw59gp68bq****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The bandwidth peak of the transit router bandwidth package. Unit: Mbps. Valid values: 2-10000. Default is 2 Mbps.
        :param pulumi.Input[str] description: The description of the transit router bandwidth package.
        :param pulumi.Input[int] period: The period of the transit router bandwidth package, the valid value range in 1~9 or 12 or 36. Default value is 12. The period unit defaults to `Month`.The modification of this field only takes effect when the value of the `renew_type` is `Manual`.
        :param pulumi.Input[int] remain_renew_times: The remaining renewal times of of the transit router bandwidth package. Valid values: -1 or 1~100. Default value is -1, means unlimited renewal.This field is only effective when the value of the `renew_type` is `Auto`.
        :param pulumi.Input[int] renew_period: The auto renewal period of the transit router bandwidth package. Valid values: 1,2,3,6,12. Default value is 1. Unit: Month.This field is only effective when the value of the `renew_type` is `Auto`. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] renew_type: The renewal type of the transit router bandwidth package. Valid values: `Manual`, `Auto`, `NoRenew`. Default is `Manual`.This field is only effective when modifying the bandwidth package.
        :param pulumi.Input[str] transit_router_bandwidth_package_name: The name of the transit router bandwidth package.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BandwidthPackageArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage transit router bandwidth package
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.BandwidthPackage("foo",
            bandwidth=2,
            description="acc-test",
            period=1,
            renew_type="Manual",
            transit_router_bandwidth_package_name="acc-tf-test")
        ```

        ## Import

        TransitRouterBandwidthPackage can be imported using the Id, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/bandwidthPackage:BandwidthPackage default tbp-cd-2felfww0i6pkw59gp68bq****
        ```

        :param str resource_name: The name of the resource.
        :param BandwidthPackageArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BandwidthPackageArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 period: Optional[pulumi.Input[int]] = None,
                 remain_renew_times: Optional[pulumi.Input[int]] = None,
                 renew_period: Optional[pulumi.Input[int]] = None,
                 renew_type: Optional[pulumi.Input[str]] = None,
                 transit_router_bandwidth_package_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BandwidthPackageArgs.__new__(BandwidthPackageArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["description"] = description
            __props__.__dict__["period"] = period
            __props__.__dict__["remain_renew_times"] = remain_renew_times
            __props__.__dict__["renew_period"] = renew_period
            __props__.__dict__["renew_type"] = renew_type
            __props__.__dict__["transit_router_bandwidth_package_name"] = transit_router_bandwidth_package_name
            __props__.__dict__["allocations"] = None
            __props__.__dict__["business_status"] = None
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["delete_time"] = None
            __props__.__dict__["expired_time"] = None
            __props__.__dict__["remaining_bandwidth"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["update_time"] = None
        super(BandwidthPackage, __self__).__init__(
            'volcengine:transit_router/bandwidthPackage:BandwidthPackage',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allocations: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BandwidthPackageAllocationArgs']]]]] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            business_status: Optional[pulumi.Input[str]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            delete_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            expired_time: Optional[pulumi.Input[str]] = None,
            period: Optional[pulumi.Input[int]] = None,
            remain_renew_times: Optional[pulumi.Input[int]] = None,
            remaining_bandwidth: Optional[pulumi.Input[int]] = None,
            renew_period: Optional[pulumi.Input[int]] = None,
            renew_type: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            transit_router_bandwidth_package_name: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'BandwidthPackage':
        """
        Get an existing BandwidthPackage resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['BandwidthPackageAllocationArgs']]]] allocations: The detailed information on cross regional connections associated with bandwidth packets.
        :param pulumi.Input[int] bandwidth: The bandwidth peak of the transit router bandwidth package. Unit: Mbps. Valid values: 2-10000. Default is 2 Mbps.
        :param pulumi.Input[str] business_status: The business status of the transit router bandwidth package.
        :param pulumi.Input[str] creation_time: The create time of the transit router bandwidth package.
        :param pulumi.Input[str] delete_time: The delete time of the transit router bandwidth package.
        :param pulumi.Input[str] description: The description of the transit router bandwidth package.
        :param pulumi.Input[str] expired_time: The expired time of the transit router bandwidth package.
        :param pulumi.Input[int] period: The period of the transit router bandwidth package, the valid value range in 1~9 or 12 or 36. Default value is 12. The period unit defaults to `Month`.The modification of this field only takes effect when the value of the `renew_type` is `Manual`.
        :param pulumi.Input[int] remain_renew_times: The remaining renewal times of of the transit router bandwidth package. Valid values: -1 or 1~100. Default value is -1, means unlimited renewal.This field is only effective when the value of the `renew_type` is `Auto`.
        :param pulumi.Input[int] remaining_bandwidth: The remaining bandwidth of the transit router bandwidth package. Unit: Mbps.
        :param pulumi.Input[int] renew_period: The auto renewal period of the transit router bandwidth package. Valid values: 1,2,3,6,12. Default value is 1. Unit: Month.This field is only effective when the value of the `renew_type` is `Auto`. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        :param pulumi.Input[str] renew_type: The renewal type of the transit router bandwidth package. Valid values: `Manual`, `Auto`, `NoRenew`. Default is `Manual`.This field is only effective when modifying the bandwidth package.
        :param pulumi.Input[str] status: The status of the transit router bandwidth package.
        :param pulumi.Input[str] transit_router_bandwidth_package_name: The name of the transit router bandwidth package.
        :param pulumi.Input[str] update_time: The update time of the transit router bandwidth package.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BandwidthPackageState.__new__(_BandwidthPackageState)

        __props__.__dict__["allocations"] = allocations
        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["business_status"] = business_status
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["delete_time"] = delete_time
        __props__.__dict__["description"] = description
        __props__.__dict__["expired_time"] = expired_time
        __props__.__dict__["period"] = period
        __props__.__dict__["remain_renew_times"] = remain_renew_times
        __props__.__dict__["remaining_bandwidth"] = remaining_bandwidth
        __props__.__dict__["renew_period"] = renew_period
        __props__.__dict__["renew_type"] = renew_type
        __props__.__dict__["status"] = status
        __props__.__dict__["transit_router_bandwidth_package_name"] = transit_router_bandwidth_package_name
        __props__.__dict__["update_time"] = update_time
        return BandwidthPackage(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def allocations(self) -> pulumi.Output[Sequence['outputs.BandwidthPackageAllocation']]:
        """
        The detailed information on cross regional connections associated with bandwidth packets.
        """
        return pulumi.get(self, "allocations")

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        The bandwidth peak of the transit router bandwidth package. Unit: Mbps. Valid values: 2-10000. Default is 2 Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> pulumi.Output[str]:
        """
        The business status of the transit router bandwidth package.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The create time of the transit router bandwidth package.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> pulumi.Output[str]:
        """
        The delete time of the transit router bandwidth package.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the transit router bandwidth package.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> pulumi.Output[str]:
        """
        The expired time of the transit router bandwidth package.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter
    def period(self) -> pulumi.Output[Optional[int]]:
        """
        The period of the transit router bandwidth package, the valid value range in 1~9 or 12 or 36. Default value is 12. The period unit defaults to `Month`.The modification of this field only takes effect when the value of the `renew_type` is `Manual`.
        """
        return pulumi.get(self, "period")

    @property
    @pulumi.getter(name="remainRenewTimes")
    def remain_renew_times(self) -> pulumi.Output[Optional[int]]:
        """
        The remaining renewal times of of the transit router bandwidth package. Valid values: -1 or 1~100. Default value is -1, means unlimited renewal.This field is only effective when the value of the `renew_type` is `Auto`.
        """
        return pulumi.get(self, "remain_renew_times")

    @property
    @pulumi.getter(name="remainingBandwidth")
    def remaining_bandwidth(self) -> pulumi.Output[int]:
        """
        The remaining bandwidth of the transit router bandwidth package. Unit: Mbps.
        """
        return pulumi.get(self, "remaining_bandwidth")

    @property
    @pulumi.getter(name="renewPeriod")
    def renew_period(self) -> pulumi.Output[Optional[int]]:
        """
        The auto renewal period of the transit router bandwidth package. Valid values: 1,2,3,6,12. Default value is 1. Unit: Month.This field is only effective when the value of the `renew_type` is `Auto`. When importing resources, this attribute will not be imported. If this attribute is set, please use lifecycle and ignore_changes ignore changes in fields.
        """
        return pulumi.get(self, "renew_period")

    @property
    @pulumi.getter(name="renewType")
    def renew_type(self) -> pulumi.Output[Optional[str]]:
        """
        The renewal type of the transit router bandwidth package. Valid values: `Manual`, `Auto`, `NoRenew`. Default is `Manual`.This field is only effective when modifying the bandwidth package.
        """
        return pulumi.get(self, "renew_type")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the transit router bandwidth package.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterBandwidthPackageName")
    def transit_router_bandwidth_package_name(self) -> pulumi.Output[str]:
        """
        The name of the transit router bandwidth package.
        """
        return pulumi.get(self, "transit_router_bandwidth_package_name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of the transit router bandwidth package.
        """
        return pulumi.get(self, "update_time")

