# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['DirectConnectGatewayAttachmentArgs', 'DirectConnectGatewayAttachment']

@pulumi.input_type
class DirectConnectGatewayAttachmentArgs:
    def __init__(__self__, *,
                 direct_connect_gateway_id: pulumi.Input[str],
                 transit_router_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DirectConnectGatewayAttachment resource.
        :param pulumi.Input[str] direct_connect_gateway_id: The id of the direct connect gateway.
        :param pulumi.Input[str] transit_router_id: The id of the transit router.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[str] transit_router_attachment_name: The name of the transit router direct connect gateway attachment.
        """
        pulumi.set(__self__, "direct_connect_gateway_id", direct_connect_gateway_id)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> pulumi.Input[str]:
        """
        The id of the direct connect gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_id")

    @direct_connect_gateway_id.setter
    def direct_connect_gateway_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "direct_connect_gateway_id", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Input[str]:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_router_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the transit router direct connect gateway attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_name", value)


@pulumi.input_type
class _DirectConnectGatewayAttachmentState:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_id: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_id: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DirectConnectGatewayAttachment resources.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[str] direct_connect_gateway_id: The id of the direct connect gateway.
        :param pulumi.Input[str] transit_router_attachment_id: The id of the transit router direct connect gateway attachment.
        :param pulumi.Input[str] transit_router_attachment_name: The name of the transit router direct connect gateway attachment.
        :param pulumi.Input[str] transit_router_id: The id of the transit router.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if direct_connect_gateway_id is not None:
            pulumi.set(__self__, "direct_connect_gateway_id", direct_connect_gateway_id)
        if transit_router_attachment_id is not None:
            pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the direct connect gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_id")

    @direct_connect_gateway_id.setter
    def direct_connect_gateway_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "direct_connect_gateway_id", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the transit router direct connect gateway attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @transit_router_attachment_id.setter
    def transit_router_attachment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_id", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the transit router direct connect gateway attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_id", value)


class DirectConnectGatewayAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_id: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage transit router direct connect gateway attachment
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.DirectConnectGatewayAttachment("foo",
            description="tf-test-modify",
            direct_connect_gateway_id="dcg-3reaq6ymdzegw5zsk2igxzusb",
            transit_router_attachment_name="tf-test-modify",
            transit_router_id="tr-2bzy39x27qtxc2dx0eg5qaj05")
        ```

        ## Import

        TransitRouterDirectConnectGatewayAttachment can be imported using the transitRouterId:attachmentId, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/directConnectGatewayAttachment:DirectConnectGatewayAttachment default tr-2d6fr7mzya2gw58ozfes5g2oh:tr-attach-7qthudw0ll6jmc****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[str] direct_connect_gateway_id: The id of the direct connect gateway.
        :param pulumi.Input[str] transit_router_attachment_name: The name of the transit router direct connect gateway attachment.
        :param pulumi.Input[str] transit_router_id: The id of the transit router.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DirectConnectGatewayAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage transit router direct connect gateway attachment
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.DirectConnectGatewayAttachment("foo",
            description="tf-test-modify",
            direct_connect_gateway_id="dcg-3reaq6ymdzegw5zsk2igxzusb",
            transit_router_attachment_name="tf-test-modify",
            transit_router_id="tr-2bzy39x27qtxc2dx0eg5qaj05")
        ```

        ## Import

        TransitRouterDirectConnectGatewayAttachment can be imported using the transitRouterId:attachmentId, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/directConnectGatewayAttachment:DirectConnectGatewayAttachment default tr-2d6fr7mzya2gw58ozfes5g2oh:tr-attach-7qthudw0ll6jmc****
        ```

        :param str resource_name: The name of the resource.
        :param DirectConnectGatewayAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DirectConnectGatewayAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 direct_connect_gateway_id: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DirectConnectGatewayAttachmentArgs.__new__(DirectConnectGatewayAttachmentArgs)

            __props__.__dict__["description"] = description
            if direct_connect_gateway_id is None and not opts.urn:
                raise TypeError("Missing required property 'direct_connect_gateway_id'")
            __props__.__dict__["direct_connect_gateway_id"] = direct_connect_gateway_id
            __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
            if transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_id'")
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["transit_router_attachment_id"] = None
        super(DirectConnectGatewayAttachment, __self__).__init__(
            'volcengine:transit_router/directConnectGatewayAttachment:DirectConnectGatewayAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            description: Optional[pulumi.Input[str]] = None,
            direct_connect_gateway_id: Optional[pulumi.Input[str]] = None,
            transit_router_attachment_id: Optional[pulumi.Input[str]] = None,
            transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
            transit_router_id: Optional[pulumi.Input[str]] = None) -> 'DirectConnectGatewayAttachment':
        """
        Get an existing DirectConnectGatewayAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description.
        :param pulumi.Input[str] direct_connect_gateway_id: The id of the direct connect gateway.
        :param pulumi.Input[str] transit_router_attachment_id: The id of the transit router direct connect gateway attachment.
        :param pulumi.Input[str] transit_router_attachment_name: The name of the transit router direct connect gateway attachment.
        :param pulumi.Input[str] transit_router_id: The id of the transit router.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DirectConnectGatewayAttachmentState.__new__(_DirectConnectGatewayAttachmentState)

        __props__.__dict__["description"] = description
        __props__.__dict__["direct_connect_gateway_id"] = direct_connect_gateway_id
        __props__.__dict__["transit_router_attachment_id"] = transit_router_attachment_id
        __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
        __props__.__dict__["transit_router_id"] = transit_router_id
        return DirectConnectGatewayAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> pulumi.Output[str]:
        """
        The id of the direct connect gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> pulumi.Output[str]:
        """
        The id of the transit router direct connect gateway attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> pulumi.Output[str]:
        """
        The name of the transit router direct connect gateway attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[str]:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

