# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GrantRulesResult',
    'AwaitableGrantRulesResult',
    'grant_rules',
    'grant_rules_output',
]

@pulumi.output_type
class GrantRulesResult:
    """
    A collection of values returned by GrantRules.
    """
    def __init__(__self__, grant_account_id=None, id=None, output_file=None, rules=None, total_count=None, transit_router_id=None):
        if grant_account_id and not isinstance(grant_account_id, str):
            raise TypeError("Expected argument 'grant_account_id' to be a str")
        pulumi.set(__self__, "grant_account_id", grant_account_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if rules and not isinstance(rules, list):
            raise TypeError("Expected argument 'rules' to be a list")
        pulumi.set(__self__, "rules", rules)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if transit_router_id and not isinstance(transit_router_id, str):
            raise TypeError("Expected argument 'transit_router_id' to be a str")
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter(name="grantAccountId")
    def grant_account_id(self) -> Optional[str]:
        """
        The id of the grant account.
        """
        return pulumi.get(self, "grant_account_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def rules(self) -> Sequence['outputs.GrantRulesRuleResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "rules")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The id of the transaction router.
        """
        return pulumi.get(self, "transit_router_id")


class AwaitableGrantRulesResult(GrantRulesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GrantRulesResult(
            grant_account_id=self.grant_account_id,
            id=self.id,
            output_file=self.output_file,
            rules=self.rules,
            total_count=self.total_count,
            transit_router_id=self.transit_router_id)


def grant_rules(grant_account_id: Optional[str] = None,
                output_file: Optional[str] = None,
                transit_router_id: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGrantRulesResult:
    """
    Use this data source to query detailed information of transit router grant rules
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.transit_router.grant_rules(transit_router_id="tr-2bzy39uy6u3282dx0efxiqyq0")
    ```


    :param str grant_account_id: The id of the grant account.
    :param str output_file: File name where to save data source results.
    :param str transit_router_id: The id of the transit router.
    """
    __args__ = dict()
    __args__['grantAccountId'] = grant_account_id
    __args__['outputFile'] = output_file
    __args__['transitRouterId'] = transit_router_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:transit_router/grantRules:GrantRules', __args__, opts=opts, typ=GrantRulesResult).value

    return AwaitableGrantRulesResult(
        grant_account_id=pulumi.get(__ret__, 'grant_account_id'),
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        rules=pulumi.get(__ret__, 'rules'),
        total_count=pulumi.get(__ret__, 'total_count'),
        transit_router_id=pulumi.get(__ret__, 'transit_router_id'))


@_utilities.lift_output_func(grant_rules)
def grant_rules_output(grant_account_id: Optional[pulumi.Input[Optional[str]]] = None,
                       output_file: Optional[pulumi.Input[Optional[str]]] = None,
                       transit_router_id: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GrantRulesResult]:
    """
    Use this data source to query detailed information of transit router grant rules
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.transit_router.grant_rules(transit_router_id="tr-2bzy39uy6u3282dx0efxiqyq0")
    ```


    :param str grant_account_id: The id of the grant account.
    :param str output_file: File name where to save data source results.
    :param str transit_router_id: The id of the transit router.
    """
    ...
