# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'BandwidthPackageAllocation',
    'BandwidthPackagesBandwidthPackageResult',
    'BandwidthPackagesBandwidthPackageAllocationResult',
    'DirectConnectGatewayAttachmentsAttachmentResult',
    'GrantRulesRuleResult',
    'PeerAttachmentsTransitRouterAttachmentResult',
    'RouteEntriesEntryResult',
    'RouteTableAssociationsAssociationResult',
    'RouteTablePropagationsPropagationResult',
    'RouteTablesRouteTableResult',
    'TransitRouterTransitRouterAttachment',
    'TransitRoutersTransitRouterResult',
    'TransitRoutersTransitRouterTransitRouterAttachmentResult',
    'VpcAttachmentAttachPoint',
    'VpcAttachmentsAttachmentResult',
    'VpcAttachmentsAttachmentAttachPointResult',
    'VpnAttachmentsAttachmentResult',
]

@pulumi.output_type
class BandwidthPackageAllocation(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "allocateTime":
            suggest = "allocate_time"
        elif key == "deleteTime":
            suggest = "delete_time"
        elif key == "localRegionId":
            suggest = "local_region_id"
        elif key == "transitRouterPeerAttachmentId":
            suggest = "transit_router_peer_attachment_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BandwidthPackageAllocation. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BandwidthPackageAllocation.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BandwidthPackageAllocation.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocate_time: Optional[str] = None,
                 delete_time: Optional[str] = None,
                 local_region_id: Optional[str] = None,
                 transit_router_peer_attachment_id: Optional[str] = None):
        """
        :param str allocate_time: The delete time of the transit router bandwidth package.
        :param str delete_time: The delete time of the transit router bandwidth package.
        :param str local_region_id: The local region id of the transit router.
        :param str transit_router_peer_attachment_id: The ID of the peer attachment.
        """
        if allocate_time is not None:
            pulumi.set(__self__, "allocate_time", allocate_time)
        if delete_time is not None:
            pulumi.set(__self__, "delete_time", delete_time)
        if local_region_id is not None:
            pulumi.set(__self__, "local_region_id", local_region_id)
        if transit_router_peer_attachment_id is not None:
            pulumi.set(__self__, "transit_router_peer_attachment_id", transit_router_peer_attachment_id)

    @property
    @pulumi.getter(name="allocateTime")
    def allocate_time(self) -> Optional[str]:
        """
        The delete time of the transit router bandwidth package.
        """
        return pulumi.get(self, "allocate_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> Optional[str]:
        """
        The delete time of the transit router bandwidth package.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="localRegionId")
    def local_region_id(self) -> Optional[str]:
        """
        The local region id of the transit router.
        """
        return pulumi.get(self, "local_region_id")

    @property
    @pulumi.getter(name="transitRouterPeerAttachmentId")
    def transit_router_peer_attachment_id(self) -> Optional[str]:
        """
        The ID of the peer attachment.
        """
        return pulumi.get(self, "transit_router_peer_attachment_id")


@pulumi.output_type
class BandwidthPackagesBandwidthPackageResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 allocations: Sequence['outputs.BandwidthPackagesBandwidthPackageAllocationResult'],
                 bandwidth: int,
                 billing_type: str,
                 business_status: str,
                 creation_time: str,
                 delete_time: str,
                 description: str,
                 expired_time: str,
                 id: str,
                 local_geographic_region_set_id: str,
                 peer_geographic_region_set_id: str,
                 remaining_bandwidth: int,
                 status: str,
                 transit_router_bandwidth_package_id: str,
                 transit_router_bandwidth_package_name: str,
                 update_time: str):
        """
        :param str account_id: The account id.
        :param Sequence['BandwidthPackagesBandwidthPackageAllocationArgs'] allocations: The detailed information on cross regional connections associated with bandwidth packets.
        :param int bandwidth: The bandwidth peak of the transit router bandwidth package. Unit: Mbps.
        :param str billing_type: The billing type of the transit router bandwidth package.
        :param str business_status: The business status of the transit router bandwidth package.
        :param str creation_time: The create time of the transit router bandwidth package.
        :param str delete_time: The delete time of the transit router bandwidth package.
        :param str description: The description of the transit router bandwidth package.
        :param str expired_time: The expired time of the transit router bandwidth package.
        :param str id: The id of the transit router bandwidth package.
        :param str local_geographic_region_set_id: The local geographic region set ID.
        :param str peer_geographic_region_set_id: The peer geographic region set ID.
        :param int remaining_bandwidth: The remaining bandwidth of the transit router bandwidth package. Unit: Mbps.
        :param str status: The status of the transit router bandwidth package.
        :param str transit_router_bandwidth_package_id: The id of the transit router attachment.
        :param str transit_router_bandwidth_package_name: The name of the TransitRouter bandwidth package.
        :param str update_time: The update time of the transit router bandwidth package.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "allocations", allocations)
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "billing_type", billing_type)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "delete_time", delete_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expired_time", expired_time)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "local_geographic_region_set_id", local_geographic_region_set_id)
        pulumi.set(__self__, "peer_geographic_region_set_id", peer_geographic_region_set_id)
        pulumi.set(__self__, "remaining_bandwidth", remaining_bandwidth)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_bandwidth_package_id", transit_router_bandwidth_package_id)
        pulumi.set(__self__, "transit_router_bandwidth_package_name", transit_router_bandwidth_package_name)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The account id.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter
    def allocations(self) -> Sequence['outputs.BandwidthPackagesBandwidthPackageAllocationResult']:
        """
        The detailed information on cross regional connections associated with bandwidth packets.
        """
        return pulumi.get(self, "allocations")

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The bandwidth peak of the transit router bandwidth package. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="billingType")
    def billing_type(self) -> str:
        """
        The billing type of the transit router bandwidth package.
        """
        return pulumi.get(self, "billing_type")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        The business status of the transit router bandwidth package.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The create time of the transit router bandwidth package.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        The delete time of the transit router bandwidth package.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the transit router bandwidth package.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="expiredTime")
    def expired_time(self) -> str:
        """
        The expired time of the transit router bandwidth package.
        """
        return pulumi.get(self, "expired_time")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the transit router bandwidth package.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="localGeographicRegionSetId")
    def local_geographic_region_set_id(self) -> str:
        """
        The local geographic region set ID.
        """
        return pulumi.get(self, "local_geographic_region_set_id")

    @property
    @pulumi.getter(name="peerGeographicRegionSetId")
    def peer_geographic_region_set_id(self) -> str:
        """
        The peer geographic region set ID.
        """
        return pulumi.get(self, "peer_geographic_region_set_id")

    @property
    @pulumi.getter(name="remainingBandwidth")
    def remaining_bandwidth(self) -> int:
        """
        The remaining bandwidth of the transit router bandwidth package. Unit: Mbps.
        """
        return pulumi.get(self, "remaining_bandwidth")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the transit router bandwidth package.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterBandwidthPackageId")
    def transit_router_bandwidth_package_id(self) -> str:
        """
        The id of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_bandwidth_package_id")

    @property
    @pulumi.getter(name="transitRouterBandwidthPackageName")
    def transit_router_bandwidth_package_name(self) -> str:
        """
        The name of the TransitRouter bandwidth package.
        """
        return pulumi.get(self, "transit_router_bandwidth_package_name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time of the transit router bandwidth package.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class BandwidthPackagesBandwidthPackageAllocationResult(dict):
    def __init__(__self__, *,
                 allocate_time: str,
                 delete_time: str,
                 local_region_id: str,
                 transit_router_peer_attachment_id: str):
        """
        :param str allocate_time: The delete time of the transit router bandwidth package.
        :param str delete_time: The delete time of the transit router bandwidth package.
        :param str local_region_id: The local region id of the transit router.
        :param str transit_router_peer_attachment_id: The ID of the peer attachment.
        """
        pulumi.set(__self__, "allocate_time", allocate_time)
        pulumi.set(__self__, "delete_time", delete_time)
        pulumi.set(__self__, "local_region_id", local_region_id)
        pulumi.set(__self__, "transit_router_peer_attachment_id", transit_router_peer_attachment_id)

    @property
    @pulumi.getter(name="allocateTime")
    def allocate_time(self) -> str:
        """
        The delete time of the transit router bandwidth package.
        """
        return pulumi.get(self, "allocate_time")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> str:
        """
        The delete time of the transit router bandwidth package.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="localRegionId")
    def local_region_id(self) -> str:
        """
        The local region id of the transit router.
        """
        return pulumi.get(self, "local_region_id")

    @property
    @pulumi.getter(name="transitRouterPeerAttachmentId")
    def transit_router_peer_attachment_id(self) -> str:
        """
        The ID of the peer attachment.
        """
        return pulumi.get(self, "transit_router_peer_attachment_id")


@pulumi.output_type
class DirectConnectGatewayAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 creation_time: str,
                 description: str,
                 direct_connect_gateway_id: str,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_attachment_name: str,
                 transit_router_id: str,
                 update_time: str):
        """
        :param str account_id: The account id.
        :param str creation_time: The create time.
        :param str description: The description info.
        :param str direct_connect_gateway_id: ID of the direct connection gateway.
        :param str status: The status of the network instance connection.
        :param str transit_router_attachment_id: The id of the transit router attachment.
        :param str transit_router_attachment_name: The name of the transit router attachment.
        :param str transit_router_id: The id of the transit router.
        :param str update_time: The update time.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "direct_connect_gateway_id", direct_connect_gateway_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The account id.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The create time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description info.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="directConnectGatewayId")
    def direct_connect_gateway_id(self) -> str:
        """
        ID of the direct connection gateway.
        """
        return pulumi.get(self, "direct_connect_gateway_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the network instance connection.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The id of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> str:
        """
        The name of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class GrantRulesRuleResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 description: str,
                 grant_account_id: str,
                 status: str,
                 transit_router_id: str,
                 update_time: str):
        """
        :param str creation_time: The creation time of the rule.
        :param str description: The description of the rule.
        :param str grant_account_id: The id of the grant account.
        :param str status: The status of the rule.
        :param str transit_router_id: The id of the transit router.
        :param str update_time: The update time of the rule.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "grant_account_id", grant_account_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The creation time of the rule.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the rule.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="grantAccountId")
    def grant_account_id(self) -> str:
        """
        The id of the grant account.
        """
        return pulumi.get(self, "grant_account_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the rule.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time of the rule.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class PeerAttachmentsTransitRouterAttachmentResult(dict):
    def __init__(__self__, *,
                 bandwidth: int,
                 creation_time: str,
                 description: str,
                 id: str,
                 peer_transit_router_id: str,
                 peer_transit_router_region_id: str,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_attachment_name: str,
                 transit_router_bandwidth_package_id: str,
                 transit_router_id: str,
                 transit_router_route_table_id: str,
                 update_time: str):
        """
        :param int bandwidth: The bandwidth of the transit router peer attachment.
        :param str creation_time: The creation time of the transit router peer attachment.
        :param str description: The description of the transit router peer attachment.
        :param str id: The id of the transit router peer attachment.
        :param str peer_transit_router_id: The id of peer transit router.
        :param str peer_transit_router_region_id: The region id of peer transit router.
        :param str status: The status of the transit router peer attachment.
        :param str transit_router_attachment_id: The id of the transit router peer attachment.
        :param str transit_router_attachment_name: The name of transit router peer attachment.
        :param str transit_router_bandwidth_package_id: The bandwidth package id of the transit router peer attachment.
        :param str transit_router_id: The id of local transit router.
        :param str transit_router_route_table_id: The route table id of the transit router peer attachment.
        :param str update_time: The update time of the transit router peer attachment.
        """
        pulumi.set(__self__, "bandwidth", bandwidth)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_bandwidth_package_id", transit_router_bandwidth_package_id)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def bandwidth(self) -> int:
        """
        The bandwidth of the transit router peer attachment.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The creation time of the transit router peer attachment.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the transit router peer attachment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of the transit router peer attachment.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> str:
        """
        The id of peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> str:
        """
        The region id of peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the transit router peer attachment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The id of the transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> str:
        """
        The name of transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterBandwidthPackageId")
    def transit_router_bandwidth_package_id(self) -> str:
        """
        The bandwidth package id of the transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_bandwidth_package_id")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The id of local transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> str:
        """
        The route table id of the transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time of the transit router peer attachment.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class RouteEntriesEntryResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 description: str,
                 destination_cidr_block: str,
                 status: str,
                 transit_router_route_entry_id: str,
                 transit_router_route_entry_name: str,
                 transit_router_route_entry_next_hop_id: str,
                 transit_router_route_entry_next_hop_type: str,
                 transit_router_route_entry_type: str,
                 update_time: str):
        """
        :param str creation_time: The creation time of the route entry.
        :param str description: Description of the transit router route entry.
        :param str destination_cidr_block: The target network segment of the route entry.
        :param str status: The status of the route entry.
        :param str transit_router_route_entry_id: The id of the route entry.
        :param str transit_router_route_entry_name: The name of the route entry.
        :param str transit_router_route_entry_next_hop_id: The next hot id of the routing entry.
        :param str transit_router_route_entry_next_hop_type: The next hop type of the routing entry. The value can be Attachment or BlackHole.
        :param str transit_router_route_entry_type: The type of the route entry.
        :param str update_time: The update time of the route entry.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_route_entry_id", transit_router_route_entry_id)
        pulumi.set(__self__, "transit_router_route_entry_name", transit_router_route_entry_name)
        pulumi.set(__self__, "transit_router_route_entry_next_hop_id", transit_router_route_entry_next_hop_id)
        pulumi.set(__self__, "transit_router_route_entry_next_hop_type", transit_router_route_entry_next_hop_type)
        pulumi.set(__self__, "transit_router_route_entry_type", transit_router_route_entry_type)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The creation time of the route entry.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Description of the transit router route entry.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> str:
        """
        The target network segment of the route entry.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the route entry.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterRouteEntryId")
    def transit_router_route_entry_id(self) -> str:
        """
        The id of the route entry.
        """
        return pulumi.get(self, "transit_router_route_entry_id")

    @property
    @pulumi.getter(name="transitRouterRouteEntryName")
    def transit_router_route_entry_name(self) -> str:
        """
        The name of the route entry.
        """
        return pulumi.get(self, "transit_router_route_entry_name")

    @property
    @pulumi.getter(name="transitRouterRouteEntryNextHopId")
    def transit_router_route_entry_next_hop_id(self) -> str:
        """
        The next hot id of the routing entry.
        """
        return pulumi.get(self, "transit_router_route_entry_next_hop_id")

    @property
    @pulumi.getter(name="transitRouterRouteEntryNextHopType")
    def transit_router_route_entry_next_hop_type(self) -> str:
        """
        The next hop type of the routing entry. The value can be Attachment or BlackHole.
        """
        return pulumi.get(self, "transit_router_route_entry_next_hop_type")

    @property
    @pulumi.getter(name="transitRouterRouteEntryType")
    def transit_router_route_entry_type(self) -> str:
        """
        The type of the route entry.
        """
        return pulumi.get(self, "transit_router_route_entry_type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time of the route entry.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class RouteTableAssociationsAssociationResult(dict):
    def __init__(__self__, *,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_route_table_id: str):
        """
        :param str status: The status of the route table.
        :param str transit_router_attachment_id: The ID of the network instance connection.
        :param str transit_router_route_table_id: The ID of the routing table associated with the transit router instance.
        """
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the route table.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The ID of the network instance connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> str:
        """
        The ID of the routing table associated with the transit router instance.
        """
        return pulumi.get(self, "transit_router_route_table_id")


@pulumi.output_type
class RouteTablePropagationsPropagationResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_route_table_id: str):
        """
        :param str creation_time: The creation time of the route table propagation.
        :param str status: The status of the route table.
        :param str transit_router_attachment_id: The ID of the network instance connection.
        :param str transit_router_route_table_id: The ID of the routing table associated with the transit router instance.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The creation time of the route table propagation.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the route table.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The ID of the network instance connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> str:
        """
        The ID of the routing table associated with the transit router instance.
        """
        return pulumi.get(self, "transit_router_route_table_id")


@pulumi.output_type
class RouteTablesRouteTableResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 description: str,
                 status: str,
                 transit_router_route_table_id: str,
                 transit_router_route_table_name: str,
                 transit_router_route_table_type: str,
                 update_time: str):
        """
        :param str creation_time: The creation time of the route table.
        :param str description: The description.
        :param str status: The status of the route table.
        :param str transit_router_route_table_id: The id of the route table.
        :param str transit_router_route_table_name: The name of the route table.
        :param str transit_router_route_table_type: The type of the route table. The value can be System or Custom.
        :param str update_time: The update time of the route table.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)
        pulumi.set(__self__, "transit_router_route_table_name", transit_router_route_table_name)
        pulumi.set(__self__, "transit_router_route_table_type", transit_router_route_table_type)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The creation time of the route table.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the route table.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> str:
        """
        The id of the route table.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableName")
    def transit_router_route_table_name(self) -> str:
        """
        The name of the route table.
        """
        return pulumi.get(self, "transit_router_route_table_name")

    @property
    @pulumi.getter(name="transitRouterRouteTableType")
    def transit_router_route_table_type(self) -> str:
        """
        The type of the route table. The value can be System or Custom.
        """
        return pulumi.get(self, "transit_router_route_table_type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time of the route table.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class TransitRouterTransitRouterAttachment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "creationTime":
            suggest = "creation_time"
        elif key == "resourceId":
            suggest = "resource_id"
        elif key == "resourceType":
            suggest = "resource_type"
        elif key == "transitRouterAttachmentId":
            suggest = "transit_router_attachment_id"
        elif key == "transitRouterAttachmentName":
            suggest = "transit_router_attachment_name"
        elif key == "transitRouterRouteTableId":
            suggest = "transit_router_route_table_id"
        elif key == "updateTime":
            suggest = "update_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TransitRouterTransitRouterAttachment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TransitRouterTransitRouterAttachment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TransitRouterTransitRouterAttachment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 creation_time: Optional[str] = None,
                 resource_id: Optional[str] = None,
                 resource_type: Optional[str] = None,
                 status: Optional[str] = None,
                 transit_router_attachment_id: Optional[str] = None,
                 transit_router_attachment_name: Optional[str] = None,
                 transit_router_route_table_id: Optional[str] = None,
                 update_time: Optional[str] = None):
        """
        :param str creation_time: The create time.
        :param str resource_id: The id of resource.
        :param str resource_type: The type of resource.
        :param str status: The status of the transit router.
        :param str transit_router_attachment_id: The id of transit router attachment.
        :param str transit_router_attachment_name: The name of transit router attachment.
        :param str transit_router_route_table_id: The id of transit router route table.
        :param str update_time: The update time.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_attachment_id is not None:
            pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_route_table_id is not None:
            pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[str]:
        """
        The create time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[str]:
        """
        The id of resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[str]:
        """
        The type of resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the transit router.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[str]:
        """
        The id of transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[str]:
        """
        The name of transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> Optional[str]:
        """
        The id of transit router route table.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[str]:
        """
        The update time.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class TransitRoutersTransitRouterResult(dict):
    def __init__(__self__, *,
                 account_id: str,
                 business_status: str,
                 creation_time: str,
                 description: str,
                 id: str,
                 overdue_time: str,
                 status: str,
                 transit_router_attachments: Sequence['outputs.TransitRoutersTransitRouterTransitRouterAttachmentResult'],
                 transit_router_id: str,
                 transit_router_name: str,
                 update_time: str):
        """
        :param str account_id: The ID of account.
        :param str business_status: The business status of the transit router.
        :param str creation_time: The create time.
        :param str description: The description info.
        :param str id: The ID of the transit router.
        :param str overdue_time: The overdue time.
        :param str status: The status of the transit router.
        :param Sequence['TransitRoutersTransitRouterTransitRouterAttachmentArgs'] transit_router_attachments: The attachments of transit router.
        :param str transit_router_id: The ID of the transit router.
        :param str transit_router_name: The name info.
        :param str update_time: The update time.
        """
        pulumi.set(__self__, "account_id", account_id)
        pulumi.set(__self__, "business_status", business_status)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "overdue_time", overdue_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachments", transit_router_attachments)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "transit_router_name", transit_router_name)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="accountId")
    def account_id(self) -> str:
        """
        The ID of account.
        """
        return pulumi.get(self, "account_id")

    @property
    @pulumi.getter(name="businessStatus")
    def business_status(self) -> str:
        """
        The business status of the transit router.
        """
        return pulumi.get(self, "business_status")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The create time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description info.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="overdueTime")
    def overdue_time(self) -> str:
        """
        The overdue time.
        """
        return pulumi.get(self, "overdue_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the transit router.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachments")
    def transit_router_attachments(self) -> Sequence['outputs.TransitRoutersTransitRouterTransitRouterAttachmentResult']:
        """
        The attachments of transit router.
        """
        return pulumi.get(self, "transit_router_attachments")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The ID of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="transitRouterName")
    def transit_router_name(self) -> str:
        """
        The name info.
        """
        return pulumi.get(self, "transit_router_name")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class TransitRoutersTransitRouterTransitRouterAttachmentResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 resource_id: str,
                 resource_type: str,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_attachment_name: str,
                 transit_router_route_table_id: str,
                 update_time: str):
        """
        :param str creation_time: The create time.
        :param str resource_id: The id of resource.
        :param str resource_type: The type of resource.
        :param str status: The status of the transit router.
        :param str transit_router_attachment_id: The id of transit router attachment.
        :param str transit_router_attachment_name: The name of transit router attachment.
        :param str transit_router_route_table_id: The id of transit router route table.
        :param str update_time: The update time.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_type", resource_type)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The create time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> str:
        """
        The id of resource.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> str:
        """
        The type of resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the transit router.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The id of transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> str:
        """
        The name of transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> str:
        """
        The id of transit router route table.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class VpcAttachmentAttachPoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "zoneId":
            suggest = "zone_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VpcAttachmentAttachPoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VpcAttachmentAttachPoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VpcAttachmentAttachPoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 zone_id: str):
        """
        :param str subnet_id: The id of subnet.
        :param str zone_id: The id of zone.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The id of subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The id of zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class VpcAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 attach_points: Sequence['outputs.VpcAttachmentsAttachmentAttachPointResult'],
                 creation_time: str,
                 description: str,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_attachment_name: str,
                 transit_router_id: str,
                 update_time: str,
                 vpc_id: str):
        """
        :param Sequence['VpcAttachmentsAttachmentAttachPointArgs'] attach_points: The collection of attach points.
        :param str creation_time: The create time.
        :param str description: The description info.
        :param str status: The status of the transit router.
        :param str transit_router_attachment_id: The id of the transit router attachment.
        :param str transit_router_attachment_name: The name of the transit router attachment.
        :param str transit_router_id: The id of transit router.
        :param str update_time: The update time.
        :param str vpc_id: The id of vpc.
        """
        pulumi.set(__self__, "attach_points", attach_points)
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="attachPoints")
    def attach_points(self) -> Sequence['outputs.VpcAttachmentsAttachmentAttachPointResult']:
        """
        The collection of attach points.
        """
        return pulumi.get(self, "attach_points")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The create time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description info.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the transit router.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The id of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> str:
        """
        The name of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The id of transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> str:
        """
        The id of vpc.
        """
        return pulumi.get(self, "vpc_id")


@pulumi.output_type
class VpcAttachmentsAttachmentAttachPointResult(dict):
    def __init__(__self__, *,
                 network_interface_id: str,
                 subnet_id: str,
                 zone_id: str):
        """
        :param str network_interface_id: The ID of network interface.
        :param str subnet_id: The ID of subnet.
        :param str zone_id: The ID of zone.
        """
        pulumi.set(__self__, "network_interface_id", network_interface_id)
        pulumi.set(__self__, "subnet_id", subnet_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="networkInterfaceId")
    def network_interface_id(self) -> str:
        """
        The ID of network interface.
        """
        return pulumi.get(self, "network_interface_id")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The ID of subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The ID of zone.
        """
        return pulumi.get(self, "zone_id")


@pulumi.output_type
class VpnAttachmentsAttachmentResult(dict):
    def __init__(__self__, *,
                 creation_time: str,
                 description: str,
                 status: str,
                 transit_router_attachment_id: str,
                 transit_router_attachment_name: str,
                 transit_router_id: str,
                 update_time: str,
                 vpn_connection_id: str,
                 zone_id: str):
        """
        :param str creation_time: The create time.
        :param str description: The description info.
        :param str status: The status of the transit router.
        :param str transit_router_attachment_id: The id of the transit router attachment.
        :param str transit_router_attachment_name: The name of the transit router attachment.
        :param str transit_router_id: The id of the transit router.
        :param str update_time: The update time.
        :param str vpn_connection_id: The ID of the IPSec connection.
        :param str zone_id: The ID of the availability zone.
        """
        pulumi.set(__self__, "creation_time", creation_time)
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)
        pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> str:
        """
        The create time.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description info.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the transit router.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> str:
        """
        The id of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> str:
        """
        The name of the transit router attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> str:
        """
        The update time.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> str:
        """
        The ID of the IPSec connection.
        """
        return pulumi.get(self, "vpn_connection_id")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> str:
        """
        The ID of the availability zone.
        """
        return pulumi.get(self, "zone_id")


