# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['PeerAttachmentArgs', 'PeerAttachment']

@pulumi.input_type
class PeerAttachmentArgs:
    def __init__(__self__, *,
                 peer_transit_router_id: pulumi.Input[str],
                 peer_transit_router_region_id: pulumi.Input[str],
                 transit_router_id: pulumi.Input[str],
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_bandwidth_package_id: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a PeerAttachment resource.
        :param pulumi.Input[str] peer_transit_router_id: The id of the peer transit router.
        :param pulumi.Input[str] peer_transit_router_region_id: The region id of the peer transit router.
        :param pulumi.Input[str] transit_router_id: The id of the local transit router.
        :param pulumi.Input[int] bandwidth: The bandwidth of the transit router peer attachment. Unit: Mbps.
        :param pulumi.Input[str] description: The description of the transit router peer attachment.
        :param pulumi.Input[str] transit_router_attachment_name: The name of the transit router peer attachment.
        :param pulumi.Input[str] transit_router_bandwidth_package_id: The bandwidth package id of the transit router peer attachment. When specifying this field, the field `bandwidth` must also be specified.
        """
        pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_bandwidth_package_id is not None:
            pulumi.set(__self__, "transit_router_bandwidth_package_id", transit_router_bandwidth_package_id)

    @property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> pulumi.Input[str]:
        """
        The id of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @peer_transit_router_id.setter
    def peer_transit_router_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_transit_router_id", value)

    @property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> pulumi.Input[str]:
        """
        The region id of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @peer_transit_router_region_id.setter
    def peer_transit_router_region_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_transit_router_region_id", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Input[str]:
        """
        The id of the local transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_router_id", value)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth of the transit router peer attachment. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the transit router peer attachment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @property
    @pulumi.getter(name="transitRouterBandwidthPackageId")
    def transit_router_bandwidth_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth package id of the transit router peer attachment. When specifying this field, the field `bandwidth` must also be specified.
        """
        return pulumi.get(self, "transit_router_bandwidth_package_id")

    @transit_router_bandwidth_package_id.setter
    def transit_router_bandwidth_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_bandwidth_package_id", value)


@pulumi.input_type
class _PeerAttachmentState:
    def __init__(__self__, *,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 peer_transit_router_id: Optional[pulumi.Input[str]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 transit_router_route_table_id: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering PeerAttachment resources.
        :param pulumi.Input[int] bandwidth: The bandwidth of the transit router peer attachment. Unit: Mbps.
        :param pulumi.Input[str] creation_time: The creation time of the transit router peer attachment.
        :param pulumi.Input[str] description: The description of the transit router peer attachment.
        :param pulumi.Input[str] peer_transit_router_id: The id of the peer transit router.
        :param pulumi.Input[str] peer_transit_router_region_id: The region id of the peer transit router.
        :param pulumi.Input[str] status: The status of the transit router peer attachment.
        :param pulumi.Input[str] transit_router_attachment_name: The name of the transit router peer attachment.
        :param pulumi.Input[str] transit_router_bandwidth_package_id: The bandwidth package id of the transit router peer attachment. When specifying this field, the field `bandwidth` must also be specified.
        :param pulumi.Input[str] transit_router_id: The id of the local transit router.
        :param pulumi.Input[str] transit_router_route_table_id: The route table id of the transit router peer attachment.
        :param pulumi.Input[str] update_time: The update time of the transit router peer attachment.
        """
        if bandwidth is not None:
            pulumi.set(__self__, "bandwidth", bandwidth)
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if peer_transit_router_id is not None:
            pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        if peer_transit_router_region_id is not None:
            pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_attachment_name is not None:
            pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_bandwidth_package_id is not None:
            pulumi.set(__self__, "transit_router_bandwidth_package_id", transit_router_bandwidth_package_id)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_route_table_id is not None:
            pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter
    def bandwidth(self) -> Optional[pulumi.Input[int]]:
        """
        The bandwidth of the transit router peer attachment. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @bandwidth.setter
    def bandwidth(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "bandwidth", value)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the transit router peer attachment.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the transit router peer attachment.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @peer_transit_router_id.setter
    def peer_transit_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_transit_router_id", value)

    @property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> Optional[pulumi.Input[str]]:
        """
        The region id of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @peer_transit_router_region_id.setter
    def peer_transit_router_region_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_transit_router_region_id", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the transit router peer attachment.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @transit_router_attachment_name.setter
    def transit_router_attachment_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_attachment_name", value)

    @property
    @pulumi.getter(name="transitRouterBandwidthPackageId")
    def transit_router_bandwidth_package_id(self) -> Optional[pulumi.Input[str]]:
        """
        The bandwidth package id of the transit router peer attachment. When specifying this field, the field `bandwidth` must also be specified.
        """
        return pulumi.get(self, "transit_router_bandwidth_package_id")

    @transit_router_bandwidth_package_id.setter
    def transit_router_bandwidth_package_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_bandwidth_package_id", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the local transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_id", value)

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> Optional[pulumi.Input[str]]:
        """
        The route table id of the transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @transit_router_route_table_id.setter
    def transit_router_route_table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_route_table_id", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the transit router peer attachment.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class PeerAttachment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 peer_transit_router_id: Optional[pulumi.Input[str]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage transit router peer attachment
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.PeerAttachment("foo",
            bandwidth=2,
            description="tf-test",
            peer_transit_router_id="tr-3jgsfiktn0feo3pncmfb5****",
            peer_transit_router_region_id="cn-beijing",
            transit_router_attachment_name="tf-test-tra",
            transit_router_bandwidth_package_id="tbp-cd-2felfww0i6pkw59gp68bq****",
            transit_router_id="tr-12bbdsa6ode6817q7y1f5****")
        ```

        ## Import

        TransitRouterPeerAttachment can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/peerAttachment:PeerAttachment default tr-attach-12be67d0yh2io17q7y1au****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The bandwidth of the transit router peer attachment. Unit: Mbps.
        :param pulumi.Input[str] description: The description of the transit router peer attachment.
        :param pulumi.Input[str] peer_transit_router_id: The id of the peer transit router.
        :param pulumi.Input[str] peer_transit_router_region_id: The region id of the peer transit router.
        :param pulumi.Input[str] transit_router_attachment_name: The name of the transit router peer attachment.
        :param pulumi.Input[str] transit_router_bandwidth_package_id: The bandwidth package id of the transit router peer attachment. When specifying this field, the field `bandwidth` must also be specified.
        :param pulumi.Input[str] transit_router_id: The id of the local transit router.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PeerAttachmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage transit router peer attachment
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.PeerAttachment("foo",
            bandwidth=2,
            description="tf-test",
            peer_transit_router_id="tr-3jgsfiktn0feo3pncmfb5****",
            peer_transit_router_region_id="cn-beijing",
            transit_router_attachment_name="tf-test-tra",
            transit_router_bandwidth_package_id="tbp-cd-2felfww0i6pkw59gp68bq****",
            transit_router_id="tr-12bbdsa6ode6817q7y1f5****")
        ```

        ## Import

        TransitRouterPeerAttachment can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/peerAttachment:PeerAttachment default tr-attach-12be67d0yh2io17q7y1au****
        ```

        :param str resource_name: The name of the resource.
        :param PeerAttachmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PeerAttachmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 bandwidth: Optional[pulumi.Input[int]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 peer_transit_router_id: Optional[pulumi.Input[str]] = None,
                 peer_transit_router_region_id: Optional[pulumi.Input[str]] = None,
                 transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
                 transit_router_bandwidth_package_id: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PeerAttachmentArgs.__new__(PeerAttachmentArgs)

            __props__.__dict__["bandwidth"] = bandwidth
            __props__.__dict__["description"] = description
            if peer_transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_transit_router_id'")
            __props__.__dict__["peer_transit_router_id"] = peer_transit_router_id
            if peer_transit_router_region_id is None and not opts.urn:
                raise TypeError("Missing required property 'peer_transit_router_region_id'")
            __props__.__dict__["peer_transit_router_region_id"] = peer_transit_router_region_id
            __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
            __props__.__dict__["transit_router_bandwidth_package_id"] = transit_router_bandwidth_package_id
            if transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_id'")
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["transit_router_route_table_id"] = None
            __props__.__dict__["update_time"] = None
        super(PeerAttachment, __self__).__init__(
            'volcengine:transit_router/peerAttachment:PeerAttachment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bandwidth: Optional[pulumi.Input[int]] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            peer_transit_router_id: Optional[pulumi.Input[str]] = None,
            peer_transit_router_region_id: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            transit_router_attachment_name: Optional[pulumi.Input[str]] = None,
            transit_router_bandwidth_package_id: Optional[pulumi.Input[str]] = None,
            transit_router_id: Optional[pulumi.Input[str]] = None,
            transit_router_route_table_id: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'PeerAttachment':
        """
        Get an existing PeerAttachment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] bandwidth: The bandwidth of the transit router peer attachment. Unit: Mbps.
        :param pulumi.Input[str] creation_time: The creation time of the transit router peer attachment.
        :param pulumi.Input[str] description: The description of the transit router peer attachment.
        :param pulumi.Input[str] peer_transit_router_id: The id of the peer transit router.
        :param pulumi.Input[str] peer_transit_router_region_id: The region id of the peer transit router.
        :param pulumi.Input[str] status: The status of the transit router peer attachment.
        :param pulumi.Input[str] transit_router_attachment_name: The name of the transit router peer attachment.
        :param pulumi.Input[str] transit_router_bandwidth_package_id: The bandwidth package id of the transit router peer attachment. When specifying this field, the field `bandwidth` must also be specified.
        :param pulumi.Input[str] transit_router_id: The id of the local transit router.
        :param pulumi.Input[str] transit_router_route_table_id: The route table id of the transit router peer attachment.
        :param pulumi.Input[str] update_time: The update time of the transit router peer attachment.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PeerAttachmentState.__new__(_PeerAttachmentState)

        __props__.__dict__["bandwidth"] = bandwidth
        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["peer_transit_router_id"] = peer_transit_router_id
        __props__.__dict__["peer_transit_router_region_id"] = peer_transit_router_region_id
        __props__.__dict__["status"] = status
        __props__.__dict__["transit_router_attachment_name"] = transit_router_attachment_name
        __props__.__dict__["transit_router_bandwidth_package_id"] = transit_router_bandwidth_package_id
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["transit_router_route_table_id"] = transit_router_route_table_id
        __props__.__dict__["update_time"] = update_time
        return PeerAttachment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def bandwidth(self) -> pulumi.Output[Optional[int]]:
        """
        The bandwidth of the transit router peer attachment. Unit: Mbps.
        """
        return pulumi.get(self, "bandwidth")

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The creation time of the transit router peer attachment.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the transit router peer attachment.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> pulumi.Output[str]:
        """
        The id of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> pulumi.Output[str]:
        """
        The region id of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the transit router peer attachment.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> pulumi.Output[str]:
        """
        The name of the transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterBandwidthPackageId")
    def transit_router_bandwidth_package_id(self) -> pulumi.Output[Optional[str]]:
        """
        The bandwidth package id of the transit router peer attachment. When specifying this field, the field `bandwidth` must also be specified.
        """
        return pulumi.get(self, "transit_router_bandwidth_package_id")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[str]:
        """
        The id of the local transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> pulumi.Output[str]:
        """
        The route table id of the transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of the transit router peer attachment.
        """
        return pulumi.get(self, "update_time")

