# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'PeerAttachmentsResult',
    'AwaitablePeerAttachmentsResult',
    'peer_attachments',
    'peer_attachments_output',
]

@pulumi.output_type
class PeerAttachmentsResult:
    """
    A collection of values returned by PeerAttachments.
    """
    def __init__(__self__, id=None, ids=None, name_regex=None, output_file=None, peer_transit_router_id=None, peer_transit_router_region_id=None, total_count=None, transit_router_attachment_name=None, transit_router_attachments=None, transit_router_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if peer_transit_router_id and not isinstance(peer_transit_router_id, str):
            raise TypeError("Expected argument 'peer_transit_router_id' to be a str")
        pulumi.set(__self__, "peer_transit_router_id", peer_transit_router_id)
        if peer_transit_router_region_id and not isinstance(peer_transit_router_region_id, str):
            raise TypeError("Expected argument 'peer_transit_router_region_id' to be a str")
        pulumi.set(__self__, "peer_transit_router_region_id", peer_transit_router_region_id)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if transit_router_attachment_name and not isinstance(transit_router_attachment_name, str):
            raise TypeError("Expected argument 'transit_router_attachment_name' to be a str")
        pulumi.set(__self__, "transit_router_attachment_name", transit_router_attachment_name)
        if transit_router_attachments and not isinstance(transit_router_attachments, list):
            raise TypeError("Expected argument 'transit_router_attachments' to be a list")
        pulumi.set(__self__, "transit_router_attachments", transit_router_attachments)
        if transit_router_id and not isinstance(transit_router_id, str):
            raise TypeError("Expected argument 'transit_router_id' to be a str")
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="peerTransitRouterId")
    def peer_transit_router_id(self) -> Optional[str]:
        """
        The id of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_id")

    @property
    @pulumi.getter(name="peerTransitRouterRegionId")
    def peer_transit_router_region_id(self) -> Optional[str]:
        """
        The region id of the peer transit router.
        """
        return pulumi.get(self, "peer_transit_router_region_id")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="transitRouterAttachmentName")
    def transit_router_attachment_name(self) -> Optional[str]:
        """
        The name of the transit router peer attachment.
        """
        return pulumi.get(self, "transit_router_attachment_name")

    @property
    @pulumi.getter(name="transitRouterAttachments")
    def transit_router_attachments(self) -> Sequence['outputs.PeerAttachmentsTransitRouterAttachmentResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "transit_router_attachments")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[str]:
        """
        The id of the local transit router.
        """
        return pulumi.get(self, "transit_router_id")


class AwaitablePeerAttachmentsResult(PeerAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return PeerAttachmentsResult(
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            peer_transit_router_id=self.peer_transit_router_id,
            peer_transit_router_region_id=self.peer_transit_router_region_id,
            total_count=self.total_count,
            transit_router_attachment_name=self.transit_router_attachment_name,
            transit_router_attachments=self.transit_router_attachments,
            transit_router_id=self.transit_router_id)


def peer_attachments(ids: Optional[Sequence[str]] = None,
                     name_regex: Optional[str] = None,
                     output_file: Optional[str] = None,
                     peer_transit_router_id: Optional[str] = None,
                     peer_transit_router_region_id: Optional[str] = None,
                     transit_router_attachment_name: Optional[str] = None,
                     transit_router_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitablePeerAttachmentsResult:
    """
    Use this data source to query detailed information of transit router peer attachments
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.transit_router.peer_attachments(ids=["tr-attach-12be67d0yh2io17q7y1au****"])
    ```


    :param Sequence[str] ids: A list of IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str peer_transit_router_id: The id of peer transit router.
    :param str peer_transit_router_region_id: The region id of peer transit router.
    :param str transit_router_attachment_name: The name of transit router peer attachment.
    :param str transit_router_id: The id of local transit router.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['peerTransitRouterId'] = peer_transit_router_id
    __args__['peerTransitRouterRegionId'] = peer_transit_router_region_id
    __args__['transitRouterAttachmentName'] = transit_router_attachment_name
    __args__['transitRouterId'] = transit_router_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:transit_router/peerAttachments:PeerAttachments', __args__, opts=opts, typ=PeerAttachmentsResult).value

    return AwaitablePeerAttachmentsResult(
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        peer_transit_router_id=pulumi.get(__ret__, 'peer_transit_router_id'),
        peer_transit_router_region_id=pulumi.get(__ret__, 'peer_transit_router_region_id'),
        total_count=pulumi.get(__ret__, 'total_count'),
        transit_router_attachment_name=pulumi.get(__ret__, 'transit_router_attachment_name'),
        transit_router_attachments=pulumi.get(__ret__, 'transit_router_attachments'),
        transit_router_id=pulumi.get(__ret__, 'transit_router_id'))


@_utilities.lift_output_func(peer_attachments)
def peer_attachments_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                            name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                            output_file: Optional[pulumi.Input[Optional[str]]] = None,
                            peer_transit_router_id: Optional[pulumi.Input[Optional[str]]] = None,
                            peer_transit_router_region_id: Optional[pulumi.Input[Optional[str]]] = None,
                            transit_router_attachment_name: Optional[pulumi.Input[Optional[str]]] = None,
                            transit_router_id: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[PeerAttachmentsResult]:
    """
    Use this data source to query detailed information of transit router peer attachments
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo = volcengine.transit_router.peer_attachments(ids=["tr-attach-12be67d0yh2io17q7y1au****"])
    ```


    :param Sequence[str] ids: A list of IDs.
    :param str name_regex: A Name Regex of Resource.
    :param str output_file: File name where to save data source results.
    :param str peer_transit_router_id: The id of peer transit router.
    :param str peer_transit_router_region_id: The region id of peer transit router.
    :param str transit_router_attachment_name: The name of transit router peer attachment.
    :param str transit_router_id: The id of local transit router.
    """
    ...
