# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'RouteEntriesResult',
    'AwaitableRouteEntriesResult',
    'route_entries',
    'route_entries_output',
]

@pulumi.output_type
class RouteEntriesResult:
    """
    A collection of values returned by RouteEntries.
    """
    def __init__(__self__, destination_cidr_block=None, entries=None, id=None, ids=None, output_file=None, status=None, total_count=None, transit_router_route_entry_name=None, transit_router_route_table_id=None):
        if destination_cidr_block and not isinstance(destination_cidr_block, str):
            raise TypeError("Expected argument 'destination_cidr_block' to be a str")
        pulumi.set(__self__, "destination_cidr_block", destination_cidr_block)
        if entries and not isinstance(entries, list):
            raise TypeError("Expected argument 'entries' to be a list")
        pulumi.set(__self__, "entries", entries)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if transit_router_route_entry_name and not isinstance(transit_router_route_entry_name, str):
            raise TypeError("Expected argument 'transit_router_route_entry_name' to be a str")
        pulumi.set(__self__, "transit_router_route_entry_name", transit_router_route_entry_name)
        if transit_router_route_table_id and not isinstance(transit_router_route_table_id, str):
            raise TypeError("Expected argument 'transit_router_route_table_id' to be a str")
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)

    @property
    @pulumi.getter(name="destinationCidrBlock")
    def destination_cidr_block(self) -> Optional[str]:
        """
        The target network segment of the route entry.
        """
        return pulumi.get(self, "destination_cidr_block")

    @property
    @pulumi.getter
    def entries(self) -> Sequence['outputs.RouteEntriesEntryResult']:
        """
        The list of route entries.
        """
        return pulumi.get(self, "entries")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the route entry.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of data query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="transitRouterRouteEntryName")
    def transit_router_route_entry_name(self) -> Optional[str]:
        """
        The name of the route entry.
        """
        return pulumi.get(self, "transit_router_route_entry_name")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> str:
        return pulumi.get(self, "transit_router_route_table_id")


class AwaitableRouteEntriesResult(RouteEntriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return RouteEntriesResult(
            destination_cidr_block=self.destination_cidr_block,
            entries=self.entries,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            status=self.status,
            total_count=self.total_count,
            transit_router_route_entry_name=self.transit_router_route_entry_name,
            transit_router_route_table_id=self.transit_router_route_table_id)


def route_entries(destination_cidr_block: Optional[str] = None,
                  ids: Optional[Sequence[str]] = None,
                  output_file: Optional[str] = None,
                  status: Optional[str] = None,
                  transit_router_route_entry_name: Optional[str] = None,
                  transit_router_route_table_id: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableRouteEntriesResult:
    """
    Use this data source to query detailed information of transit router route entries
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.transit_router.route_entries(ids=["tr-rte-12b7qd5eo3h1c17q7y1sq5ixv"],
        transit_router_route_table_id="tr-rtb-12b7qd3fmzf2817q7y2jkbd55")
    ```


    :param str destination_cidr_block: The target network segment of the route entry.
    :param Sequence[str] ids: The ids of the transit router route entry.
    :param str output_file: File name where to save data source results.
    :param str status: The status of the route entry.
    :param str transit_router_route_entry_name: The name of the route entry.
    :param str transit_router_route_table_id: The id of the route table.
    """
    __args__ = dict()
    __args__['destinationCidrBlock'] = destination_cidr_block
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['status'] = status
    __args__['transitRouterRouteEntryName'] = transit_router_route_entry_name
    __args__['transitRouterRouteTableId'] = transit_router_route_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:transit_router/routeEntries:RouteEntries', __args__, opts=opts, typ=RouteEntriesResult).value

    return AwaitableRouteEntriesResult(
        destination_cidr_block=pulumi.get(__ret__, 'destination_cidr_block'),
        entries=pulumi.get(__ret__, 'entries'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        status=pulumi.get(__ret__, 'status'),
        total_count=pulumi.get(__ret__, 'total_count'),
        transit_router_route_entry_name=pulumi.get(__ret__, 'transit_router_route_entry_name'),
        transit_router_route_table_id=pulumi.get(__ret__, 'transit_router_route_table_id'))


@_utilities.lift_output_func(route_entries)
def route_entries_output(destination_cidr_block: Optional[pulumi.Input[Optional[str]]] = None,
                         ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         output_file: Optional[pulumi.Input[Optional[str]]] = None,
                         status: Optional[pulumi.Input[Optional[str]]] = None,
                         transit_router_route_entry_name: Optional[pulumi.Input[Optional[str]]] = None,
                         transit_router_route_table_id: Optional[pulumi.Input[str]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[RouteEntriesResult]:
    """
    Use this data source to query detailed information of transit router route entries
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.transit_router.route_entries(ids=["tr-rte-12b7qd5eo3h1c17q7y1sq5ixv"],
        transit_router_route_table_id="tr-rtb-12b7qd3fmzf2817q7y2jkbd55")
    ```


    :param str destination_cidr_block: The target network segment of the route entry.
    :param Sequence[str] ids: The ids of the transit router route entry.
    :param str output_file: File name where to save data source results.
    :param str status: The status of the route entry.
    :param str transit_router_route_entry_name: The name of the route entry.
    :param str transit_router_route_table_id: The id of the route table.
    """
    ...
