# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['RouteTableArgs', 'RouteTable']

@pulumi.input_type
class RouteTableArgs:
    def __init__(__self__, *,
                 transit_router_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 transit_router_route_table_name: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a RouteTable resource.
        :param pulumi.Input[str] transit_router_id: Id of the transit router.
        :param pulumi.Input[str] description: Description of the transit router route table.
        :param pulumi.Input[str] transit_router_route_table_name: The name of the route table.
        """
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if transit_router_route_table_name is not None:
            pulumi.set(__self__, "transit_router_route_table_name", transit_router_route_table_name)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Input[str]:
        """
        Id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_router_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the transit router route table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="transitRouterRouteTableName")
    def transit_router_route_table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route table.
        """
        return pulumi.get(self, "transit_router_route_table_name")

    @transit_router_route_table_name.setter
    def transit_router_route_table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_route_table_name", value)


@pulumi.input_type
class _RouteTableState:
    def __init__(__self__, *,
                 creation_time: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 transit_router_route_table_id: Optional[pulumi.Input[str]] = None,
                 transit_router_route_table_name: Optional[pulumi.Input[str]] = None,
                 transit_router_route_table_type: Optional[pulumi.Input[str]] = None,
                 update_time: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering RouteTable resources.
        :param pulumi.Input[str] creation_time: The creation time of the route table.
        :param pulumi.Input[str] description: Description of the transit router route table.
        :param pulumi.Input[str] status: The status of the route table.
        :param pulumi.Input[str] transit_router_id: Id of the transit router.
        :param pulumi.Input[str] transit_router_route_table_id: The id of the route table.
        :param pulumi.Input[str] transit_router_route_table_name: The name of the route table.
        :param pulumi.Input[str] transit_router_route_table_type: The type of route table.
        :param pulumi.Input[str] update_time: The update time of the route table.
        """
        if creation_time is not None:
            pulumi.set(__self__, "creation_time", creation_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)
        if transit_router_route_table_id is not None:
            pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)
        if transit_router_route_table_name is not None:
            pulumi.set(__self__, "transit_router_route_table_name", transit_router_route_table_name)
        if transit_router_route_table_type is not None:
            pulumi.set(__self__, "transit_router_route_table_type", transit_router_route_table_type)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> Optional[pulumi.Input[str]]:
        """
        The creation time of the route table.
        """
        return pulumi.get(self, "creation_time")

    @creation_time.setter
    def creation_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_time", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Description of the transit router route table.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the route table.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        Id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_id", value)

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the route table.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @transit_router_route_table_id.setter
    def transit_router_route_table_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_route_table_id", value)

    @property
    @pulumi.getter(name="transitRouterRouteTableName")
    def transit_router_route_table_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the route table.
        """
        return pulumi.get(self, "transit_router_route_table_name")

    @transit_router_route_table_name.setter
    def transit_router_route_table_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_route_table_name", value)

    @property
    @pulumi.getter(name="transitRouterRouteTableType")
    def transit_router_route_table_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of route table.
        """
        return pulumi.get(self, "transit_router_route_table_type")

    @transit_router_route_table_type.setter
    def transit_router_route_table_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_route_table_type", value)

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the route table.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_time", value)


class RouteTable(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 transit_router_route_table_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage transit router route table
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.RouteTable("foo",
            description="tf test23",
            transit_router_id="tr-2ff4v69tkxji859gp684cm14e",
            transit_router_route_table_name="tf-table-23")
        ```

        ## Import

        transit router route table can be imported using the router id and route table id, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/routeTable:RouteTable default tr-2ff4v69tkxji859gp684cm14e:tr-rtb-hy13n2l4c6c0v****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: Description of the transit router route table.
        :param pulumi.Input[str] transit_router_id: Id of the transit router.
        :param pulumi.Input[str] transit_router_route_table_name: The name of the route table.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RouteTableArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage transit router route table
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.RouteTable("foo",
            description="tf test23",
            transit_router_id="tr-2ff4v69tkxji859gp684cm14e",
            transit_router_route_table_name="tf-table-23")
        ```

        ## Import

        transit router route table can be imported using the router id and route table id, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/routeTable:RouteTable default tr-2ff4v69tkxji859gp684cm14e:tr-rtb-hy13n2l4c6c0v****
        ```

        :param str resource_name: The name of the resource.
        :param RouteTableArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RouteTableArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 transit_router_route_table_name: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RouteTableArgs.__new__(RouteTableArgs)

            __props__.__dict__["description"] = description
            if transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_id'")
            __props__.__dict__["transit_router_id"] = transit_router_id
            __props__.__dict__["transit_router_route_table_name"] = transit_router_route_table_name
            __props__.__dict__["creation_time"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["transit_router_route_table_id"] = None
            __props__.__dict__["transit_router_route_table_type"] = None
            __props__.__dict__["update_time"] = None
        super(RouteTable, __self__).__init__(
            'volcengine:transit_router/routeTable:RouteTable',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            creation_time: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            transit_router_id: Optional[pulumi.Input[str]] = None,
            transit_router_route_table_id: Optional[pulumi.Input[str]] = None,
            transit_router_route_table_name: Optional[pulumi.Input[str]] = None,
            transit_router_route_table_type: Optional[pulumi.Input[str]] = None,
            update_time: Optional[pulumi.Input[str]] = None) -> 'RouteTable':
        """
        Get an existing RouteTable resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] creation_time: The creation time of the route table.
        :param pulumi.Input[str] description: Description of the transit router route table.
        :param pulumi.Input[str] status: The status of the route table.
        :param pulumi.Input[str] transit_router_id: Id of the transit router.
        :param pulumi.Input[str] transit_router_route_table_id: The id of the route table.
        :param pulumi.Input[str] transit_router_route_table_name: The name of the route table.
        :param pulumi.Input[str] transit_router_route_table_type: The type of route table.
        :param pulumi.Input[str] update_time: The update time of the route table.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RouteTableState.__new__(_RouteTableState)

        __props__.__dict__["creation_time"] = creation_time
        __props__.__dict__["description"] = description
        __props__.__dict__["status"] = status
        __props__.__dict__["transit_router_id"] = transit_router_id
        __props__.__dict__["transit_router_route_table_id"] = transit_router_route_table_id
        __props__.__dict__["transit_router_route_table_name"] = transit_router_route_table_name
        __props__.__dict__["transit_router_route_table_type"] = transit_router_route_table_type
        __props__.__dict__["update_time"] = update_time
        return RouteTable(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="creationTime")
    def creation_time(self) -> pulumi.Output[str]:
        """
        The creation time of the route table.
        """
        return pulumi.get(self, "creation_time")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        Description of the transit router route table.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the route table.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[str]:
        """
        Id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> pulumi.Output[str]:
        """
        The id of the route table.
        """
        return pulumi.get(self, "transit_router_route_table_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableName")
    def transit_router_route_table_name(self) -> pulumi.Output[str]:
        """
        The name of the route table.
        """
        return pulumi.get(self, "transit_router_route_table_name")

    @property
    @pulumi.getter(name="transitRouterRouteTableType")
    def transit_router_route_table_type(self) -> pulumi.Output[str]:
        """
        The type of route table.
        """
        return pulumi.get(self, "transit_router_route_table_type")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[str]:
        """
        The update time of the route table.
        """
        return pulumi.get(self, "update_time")

