# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'RouteTablePropagationsResult',
    'AwaitableRouteTablePropagationsResult',
    'route_table_propagations',
    'route_table_propagations_output',
]

@pulumi.output_type
class RouteTablePropagationsResult:
    """
    A collection of values returned by RouteTablePropagations.
    """
    def __init__(__self__, id=None, output_file=None, propagations=None, total_count=None, transit_router_attachment_id=None, transit_router_route_table_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if propagations and not isinstance(propagations, list):
            raise TypeError("Expected argument 'propagations' to be a list")
        pulumi.set(__self__, "propagations", propagations)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if transit_router_attachment_id and not isinstance(transit_router_attachment_id, str):
            raise TypeError("Expected argument 'transit_router_attachment_id' to be a str")
        pulumi.set(__self__, "transit_router_attachment_id", transit_router_attachment_id)
        if transit_router_route_table_id and not isinstance(transit_router_route_table_id, str):
            raise TypeError("Expected argument 'transit_router_route_table_id' to be a str")
        pulumi.set(__self__, "transit_router_route_table_id", transit_router_route_table_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def propagations(self) -> Sequence['outputs.RouteTablePropagationsPropagationResult']:
        """
        The list of route table propagations.
        """
        return pulumi.get(self, "propagations")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of data query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="transitRouterAttachmentId")
    def transit_router_attachment_id(self) -> Optional[str]:
        """
        The ID of the network instance connection.
        """
        return pulumi.get(self, "transit_router_attachment_id")

    @property
    @pulumi.getter(name="transitRouterRouteTableId")
    def transit_router_route_table_id(self) -> str:
        """
        The ID of the routing table associated with the transit router instance.
        """
        return pulumi.get(self, "transit_router_route_table_id")


class AwaitableRouteTablePropagationsResult(RouteTablePropagationsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return RouteTablePropagationsResult(
            id=self.id,
            output_file=self.output_file,
            propagations=self.propagations,
            total_count=self.total_count,
            transit_router_attachment_id=self.transit_router_attachment_id,
            transit_router_route_table_id=self.transit_router_route_table_id)


def route_table_propagations(output_file: Optional[str] = None,
                             transit_router_attachment_id: Optional[str] = None,
                             transit_router_route_table_id: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableRouteTablePropagationsResult:
    """
    Use this data source to query detailed information of transit router route table propagations
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.transit_router.route_table_propagations(transit_router_attachment_id="tr-attach-im73ng3n5kao8gbssz2ddpuq",
        transit_router_route_table_id="tr-rtb-12b7qd3fmzf2817q7y2jkbd55")
    ```


    :param str output_file: File name where to save data source results.
    :param str transit_router_attachment_id: The ID of the network instance connection.
    :param str transit_router_route_table_id: The ID of the routing table associated with the transit router instance.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['transitRouterAttachmentId'] = transit_router_attachment_id
    __args__['transitRouterRouteTableId'] = transit_router_route_table_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:transit_router/routeTablePropagations:RouteTablePropagations', __args__, opts=opts, typ=RouteTablePropagationsResult).value

    return AwaitableRouteTablePropagationsResult(
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        propagations=pulumi.get(__ret__, 'propagations'),
        total_count=pulumi.get(__ret__, 'total_count'),
        transit_router_attachment_id=pulumi.get(__ret__, 'transit_router_attachment_id'),
        transit_router_route_table_id=pulumi.get(__ret__, 'transit_router_route_table_id'))


@_utilities.lift_output_func(route_table_propagations)
def route_table_propagations_output(output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                    transit_router_attachment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                    transit_router_route_table_id: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[RouteTablePropagationsResult]:
    """
    Use this data source to query detailed information of transit router route table propagations
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.transit_router.route_table_propagations(transit_router_attachment_id="tr-attach-im73ng3n5kao8gbssz2ddpuq",
        transit_router_route_table_id="tr-rtb-12b7qd3fmzf2817q7y2jkbd55")
    ```


    :param str output_file: File name where to save data source results.
    :param str transit_router_attachment_id: The ID of the network instance connection.
    :param str transit_router_route_table_id: The ID of the routing table associated with the transit router instance.
    """
    ...
