# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['SharedTransitRouterStateArgs', 'SharedTransitRouterState']

@pulumi.input_type
class SharedTransitRouterStateArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 transit_router_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a SharedTransitRouterState resource.
        :param pulumi.Input[str] action: `Accept` or `Reject` the shared transit router.
        :param pulumi.Input[str] transit_router_id: The id of the transit router.
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        `Accept` or `Reject` the shared transit router.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Input[str]:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "transit_router_id", value)


@pulumi.input_type
class _SharedTransitRouterStateState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering SharedTransitRouterState resources.
        :param pulumi.Input[str] action: `Accept` or `Reject` the shared transit router.
        :param pulumi.Input[str] transit_router_id: The id of the transit router.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if transit_router_id is not None:
            pulumi.set(__self__, "transit_router_id", transit_router_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        `Accept` or `Reject` the shared transit router.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @transit_router_id.setter
    def transit_router_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transit_router_id", value)


class SharedTransitRouterState(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage transit router shared transit router state
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.SharedTransitRouterState("foo",
            action="Reject",
            transit_router_id="tr-2bzy39uy6u3282dx0efxiqyq0")
        ```

        ## Import

        SharedTransitRouterState can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/sharedTransitRouterState:SharedTransitRouterState default state:transitRouterId
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: `Accept` or `Reject` the shared transit router.
        :param pulumi.Input[str] transit_router_id: The id of the transit router.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SharedTransitRouterStateArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage transit router shared transit router state
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.transit_router.SharedTransitRouterState("foo",
            action="Reject",
            transit_router_id="tr-2bzy39uy6u3282dx0efxiqyq0")
        ```

        ## Import

        SharedTransitRouterState can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:transit_router/sharedTransitRouterState:SharedTransitRouterState default state:transitRouterId
        ```

        :param str resource_name: The name of the resource.
        :param SharedTransitRouterStateArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SharedTransitRouterStateArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 transit_router_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SharedTransitRouterStateArgs.__new__(SharedTransitRouterStateArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if transit_router_id is None and not opts.urn:
                raise TypeError("Missing required property 'transit_router_id'")
            __props__.__dict__["transit_router_id"] = transit_router_id
        super(SharedTransitRouterState, __self__).__init__(
            'volcengine:transit_router/sharedTransitRouterState:SharedTransitRouterState',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            transit_router_id: Optional[pulumi.Input[str]] = None) -> 'SharedTransitRouterState':
        """
        Get an existing SharedTransitRouterState resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: `Accept` or `Reject` the shared transit router.
        :param pulumi.Input[str] transit_router_id: The id of the transit router.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SharedTransitRouterStateState.__new__(_SharedTransitRouterStateState)

        __props__.__dict__["action"] = action
        __props__.__dict__["transit_router_id"] = transit_router_id
        return SharedTransitRouterState(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        `Accept` or `Reject` the shared transit router.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> pulumi.Output[str]:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

