# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'VpnAttachmentsResult',
    'AwaitableVpnAttachmentsResult',
    'vpn_attachments',
    'vpn_attachments_output',
]

@pulumi.output_type
class VpnAttachmentsResult:
    """
    A collection of values returned by VpnAttachments.
    """
    def __init__(__self__, attachments=None, id=None, ids=None, output_file=None, total_count=None, transit_router_id=None, vpn_connection_id=None):
        if attachments and not isinstance(attachments, list):
            raise TypeError("Expected argument 'attachments' to be a list")
        pulumi.set(__self__, "attachments", attachments)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if transit_router_id and not isinstance(transit_router_id, str):
            raise TypeError("Expected argument 'transit_router_id' to be a str")
        pulumi.set(__self__, "transit_router_id", transit_router_id)
        if vpn_connection_id and not isinstance(vpn_connection_id, str):
            raise TypeError("Expected argument 'vpn_connection_id' to be a str")
        pulumi.set(__self__, "vpn_connection_id", vpn_connection_id)

    @property
    @pulumi.getter
    def attachments(self) -> Sequence['outputs.VpnAttachmentsAttachmentResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "attachments")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="transitRouterId")
    def transit_router_id(self) -> str:
        """
        The id of the transit router.
        """
        return pulumi.get(self, "transit_router_id")

    @property
    @pulumi.getter(name="vpnConnectionId")
    def vpn_connection_id(self) -> Optional[str]:
        """
        The ID of the IPSec connection.
        """
        return pulumi.get(self, "vpn_connection_id")


class AwaitableVpnAttachmentsResult(VpnAttachmentsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return VpnAttachmentsResult(
            attachments=self.attachments,
            id=self.id,
            ids=self.ids,
            output_file=self.output_file,
            total_count=self.total_count,
            transit_router_id=self.transit_router_id,
            vpn_connection_id=self.vpn_connection_id)


def vpn_attachments(ids: Optional[Sequence[str]] = None,
                    output_file: Optional[str] = None,
                    transit_router_id: Optional[str] = None,
                    vpn_connection_id: Optional[str] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableVpnAttachmentsResult:
    """
    Use this data source to query detailed information of transit router vpn attachments
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.transit_router.vpn_attachments(ids=["tr-attach-3rf2xi7ae6y9s5zsk2hm6pibt"],
        transit_router_id="tr-2d6fr7f39unsw58ozfe1ow21x")
    ```


    :param Sequence[str] ids: The ID list of the VPN attachment.
    :param str output_file: File name where to save data source results.
    :param str transit_router_id: The id of the transit router.
    :param str vpn_connection_id: The ID of the IPSec connection.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['outputFile'] = output_file
    __args__['transitRouterId'] = transit_router_id
    __args__['vpnConnectionId'] = vpn_connection_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:transit_router/vpnAttachments:VpnAttachments', __args__, opts=opts, typ=VpnAttachmentsResult).value

    return AwaitableVpnAttachmentsResult(
        attachments=pulumi.get(__ret__, 'attachments'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'),
        transit_router_id=pulumi.get(__ret__, 'transit_router_id'),
        vpn_connection_id=pulumi.get(__ret__, 'vpn_connection_id'))


@_utilities.lift_output_func(vpn_attachments)
def vpn_attachments_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                           output_file: Optional[pulumi.Input[Optional[str]]] = None,
                           transit_router_id: Optional[pulumi.Input[str]] = None,
                           vpn_connection_id: Optional[pulumi.Input[Optional[str]]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[VpnAttachmentsResult]:
    """
    Use this data source to query detailed information of transit router vpn attachments
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.transit_router.vpn_attachments(ids=["tr-attach-3rf2xi7ae6y9s5zsk2hm6pibt"],
        transit_router_id="tr-2d6fr7f39unsw58ozfe1ow21x")
    ```


    :param Sequence[str] ids: The ID list of the VPN attachment.
    :param str output_file: File name where to save data source results.
    :param str transit_router_id: The id of the transit router.
    :param str vpn_connection_id: The ID of the IPSec connection.
    """
    ...
