# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AvailableResourcesResult',
    'AwaitableAvailableResourcesResult',
    'available_resources',
    'available_resources_output',
]

@pulumi.output_type
class AvailableResourcesResult:
    """
    A collection of values returned by AvailableResources.
    """
    def __init__(__self__, bandwith_limit=None, cloud_disk_type=None, id=None, instance_type=None, output_file=None, regions=None, total_count=None):
        if bandwith_limit and not isinstance(bandwith_limit, int):
            raise TypeError("Expected argument 'bandwith_limit' to be a int")
        pulumi.set(__self__, "bandwith_limit", bandwith_limit)
        if cloud_disk_type and not isinstance(cloud_disk_type, str):
            raise TypeError("Expected argument 'cloud_disk_type' to be a str")
        pulumi.set(__self__, "cloud_disk_type", cloud_disk_type)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_type and not isinstance(instance_type, str):
            raise TypeError("Expected argument 'instance_type' to be a str")
        pulumi.set(__self__, "instance_type", instance_type)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if regions and not isinstance(regions, list):
            raise TypeError("Expected argument 'regions' to be a list")
        pulumi.set(__self__, "regions", regions)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="bandwithLimit")
    def bandwith_limit(self) -> int:
        return pulumi.get(self, "bandwith_limit")

    @property
    @pulumi.getter(name="cloudDiskType")
    def cloud_disk_type(self) -> str:
        return pulumi.get(self, "cloud_disk_type")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def regions(self) -> Sequence['outputs.AvailableResourcesRegionResult']:
        """
        The collection of resource query.
        """
        return pulumi.get(self, "regions")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of resource query.
        """
        return pulumi.get(self, "total_count")


class AwaitableAvailableResourcesResult(AvailableResourcesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return AvailableResourcesResult(
            bandwith_limit=self.bandwith_limit,
            cloud_disk_type=self.cloud_disk_type,
            id=self.id,
            instance_type=self.instance_type,
            output_file=self.output_file,
            regions=self.regions,
            total_count=self.total_count)


def available_resources(bandwith_limit: Optional[int] = None,
                        cloud_disk_type: Optional[str] = None,
                        instance_type: Optional[str] = None,
                        output_file: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableAvailableResourcesResult:
    """
    Use this data source to query detailed information of veenedge available resources
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.veenedge.available_resources(bandwith_limit=20,
        cloud_disk_type="CloudSSD",
        instance_type="ve******rge")
    ```


    :param int bandwith_limit: The limit of bandwidth.
    :param str cloud_disk_type: The type of storage. The value can be `CloudHDD` or `CloudSSD`.
    :param str instance_type: The type of instance.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['bandwithLimit'] = bandwith_limit
    __args__['cloudDiskType'] = cloud_disk_type
    __args__['instanceType'] = instance_type
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:veenedge/availableResources:AvailableResources', __args__, opts=opts, typ=AvailableResourcesResult).value

    return AwaitableAvailableResourcesResult(
        bandwith_limit=pulumi.get(__ret__, 'bandwith_limit'),
        cloud_disk_type=pulumi.get(__ret__, 'cloud_disk_type'),
        id=pulumi.get(__ret__, 'id'),
        instance_type=pulumi.get(__ret__, 'instance_type'),
        output_file=pulumi.get(__ret__, 'output_file'),
        regions=pulumi.get(__ret__, 'regions'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(available_resources)
def available_resources_output(bandwith_limit: Optional[pulumi.Input[int]] = None,
                               cloud_disk_type: Optional[pulumi.Input[str]] = None,
                               instance_type: Optional[pulumi.Input[str]] = None,
                               output_file: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[AvailableResourcesResult]:
    """
    Use this data source to query detailed information of veenedge available resources
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.veenedge.available_resources(bandwith_limit=20,
        cloud_disk_type="CloudSSD",
        instance_type="ve******rge")
    ```


    :param int bandwith_limit: The limit of bandwidth.
    :param str cloud_disk_type: The type of storage. The value can be `CloudHDD` or `CloudSSD`.
    :param str instance_type: The type of instance.
    :param str output_file: File name where to save data source results.
    """
    ...
