# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'CloudServersResult',
    'AwaitableCloudServersResult',
    'cloud_servers',
    'cloud_servers_output',
]

@pulumi.output_type
class CloudServersResult:
    """
    A collection of values returned by CloudServers.
    """
    def __init__(__self__, cloud_servers=None, id=None, ids=None, name_regex=None, output_file=None, total_count=None):
        if cloud_servers and not isinstance(cloud_servers, list):
            raise TypeError("Expected argument 'cloud_servers' to be a list")
        pulumi.set(__self__, "cloud_servers", cloud_servers)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="cloudServers")
    def cloud_servers(self) -> Sequence['outputs.CloudServersCloudServerResult']:
        """
        The collection of cloud servers query.
        """
        return pulumi.get(self, "cloud_servers")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of cloud servers query.
        """
        return pulumi.get(self, "total_count")


class AwaitableCloudServersResult(CloudServersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return CloudServersResult(
            cloud_servers=self.cloud_servers,
            id=self.id,
            ids=self.ids,
            name_regex=self.name_regex,
            output_file=self.output_file,
            total_count=self.total_count)


def cloud_servers(ids: Optional[Sequence[str]] = None,
                  name_regex: Optional[str] = None,
                  output_file: Optional[str] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableCloudServersResult:
    """
    Use this data source to query detailed information of veenedge cloud servers
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.veenedge.cloud_servers()
    ```


    :param Sequence[str] ids: A list of cloud server IDs.
    :param str name_regex: A Name Regex of Cloud Server.
    :param str output_file: File name where to save data source results.
    """
    __args__ = dict()
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:veenedge/cloudServers:CloudServers', __args__, opts=opts, typ=CloudServersResult).value

    return AwaitableCloudServersResult(
        cloud_servers=pulumi.get(__ret__, 'cloud_servers'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(cloud_servers)
def cloud_servers_output(ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                         name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                         output_file: Optional[pulumi.Input[Optional[str]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[CloudServersResult]:
    """
    Use this data source to query detailed information of veenedge cloud servers
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.veenedge.cloud_servers()
    ```


    :param Sequence[str] ids: A list of cloud server IDs.
    :param str name_regex: A Name Regex of Cloud Server.
    :param str output_file: File name where to save data source results.
    """
    ...
