# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['InstanceArgs', 'Instance']

@pulumi.input_type
class InstanceArgs:
    def __init__(__self__, *,
                 area_name: Optional[pulumi.Input[str]] = None,
                 cloudserver_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 default_isp: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Instance resource.
        :param pulumi.Input[str] area_name: The area name.
        :param pulumi.Input[str] cloudserver_id: The id of cloud server.
        :param pulumi.Input[str] cluster_name: The name of cluster.
        :param pulumi.Input[str] default_isp: The default isp for multi line node.
        :param pulumi.Input[str] instance_id: Import an exist instance, usually for import a default instance generated with cloud server creating.
        :param pulumi.Input[str] isp: The isp info.
        :param pulumi.Input[str] name: The name of instance, only effected in update scene.
        :param pulumi.Input[str] secret_data: The data of secret, only effected in update scene.
        :param pulumi.Input[str] secret_type: The type of secret, only effected in update scene. The value can be `KeyPair` or `Password`.
        """
        if area_name is not None:
            pulumi.set(__self__, "area_name", area_name)
        if cloudserver_id is not None:
            pulumi.set(__self__, "cloudserver_id", cloudserver_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if default_isp is not None:
            pulumi.set(__self__, "default_isp", default_isp)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_data is not None:
            pulumi.set(__self__, "secret_data", secret_data)
        if secret_type is not None:
            pulumi.set(__self__, "secret_type", secret_type)

    @property
    @pulumi.getter(name="areaName")
    def area_name(self) -> Optional[pulumi.Input[str]]:
        """
        The area name.
        """
        return pulumi.get(self, "area_name")

    @area_name.setter
    def area_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "area_name", value)

    @property
    @pulumi.getter(name="cloudserverId")
    def cloudserver_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of cloud server.
        """
        return pulumi.get(self, "cloudserver_id")

    @cloudserver_id.setter
    def cloudserver_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudserver_id", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="defaultIsp")
    def default_isp(self) -> Optional[pulumi.Input[str]]:
        """
        The default isp for multi line node.
        """
        return pulumi.get(self, "default_isp")

    @default_isp.setter
    def default_isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_isp", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Import an exist instance, usually for import a default instance generated with cloud server creating.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        The isp info.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of instance, only effected in update scene.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> Optional[pulumi.Input[str]]:
        """
        The data of secret, only effected in update scene.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of secret, only effected in update scene. The value can be `KeyPair` or `Password`.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_type", value)


@pulumi.input_type
class _InstanceState:
    def __init__(__self__, *,
                 area_name: Optional[pulumi.Input[str]] = None,
                 cloudserver_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 default_isp: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Instance resources.
        :param pulumi.Input[str] area_name: The area name.
        :param pulumi.Input[str] cloudserver_id: The id of cloud server.
        :param pulumi.Input[str] cluster_name: The name of cluster.
        :param pulumi.Input[str] default_isp: The default isp for multi line node.
        :param pulumi.Input[str] instance_id: Import an exist instance, usually for import a default instance generated with cloud server creating.
        :param pulumi.Input[str] isp: The isp info.
        :param pulumi.Input[str] name: The name of instance, only effected in update scene.
        :param pulumi.Input[str] secret_data: The data of secret, only effected in update scene.
        :param pulumi.Input[str] secret_type: The type of secret, only effected in update scene. The value can be `KeyPair` or `Password`.
        """
        if area_name is not None:
            pulumi.set(__self__, "area_name", area_name)
        if cloudserver_id is not None:
            pulumi.set(__self__, "cloudserver_id", cloudserver_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if default_isp is not None:
            pulumi.set(__self__, "default_isp", default_isp)
        if instance_id is not None:
            pulumi.set(__self__, "instance_id", instance_id)
        if isp is not None:
            pulumi.set(__self__, "isp", isp)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if secret_data is not None:
            pulumi.set(__self__, "secret_data", secret_data)
        if secret_type is not None:
            pulumi.set(__self__, "secret_type", secret_type)

    @property
    @pulumi.getter(name="areaName")
    def area_name(self) -> Optional[pulumi.Input[str]]:
        """
        The area name.
        """
        return pulumi.get(self, "area_name")

    @area_name.setter
    def area_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "area_name", value)

    @property
    @pulumi.getter(name="cloudserverId")
    def cloudserver_id(self) -> Optional[pulumi.Input[str]]:
        """
        The id of cloud server.
        """
        return pulumi.get(self, "cloudserver_id")

    @cloudserver_id.setter
    def cloudserver_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cloudserver_id", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of cluster.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="defaultIsp")
    def default_isp(self) -> Optional[pulumi.Input[str]]:
        """
        The default isp for multi line node.
        """
        return pulumi.get(self, "default_isp")

    @default_isp.setter
    def default_isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "default_isp", value)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        Import an exist instance, usually for import a default instance generated with cloud server creating.
        """
        return pulumi.get(self, "instance_id")

    @instance_id.setter
    def instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "instance_id", value)

    @property
    @pulumi.getter
    def isp(self) -> Optional[pulumi.Input[str]]:
        """
        The isp info.
        """
        return pulumi.get(self, "isp")

    @isp.setter
    def isp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "isp", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of instance, only effected in update scene.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> Optional[pulumi.Input[str]]:
        """
        The data of secret, only effected in update scene.
        """
        return pulumi.get(self, "secret_data")

    @secret_data.setter
    def secret_data(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_data", value)

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of secret, only effected in update scene. The value can be `KeyPair` or `Password`.
        """
        return pulumi.get(self, "secret_type")

    @secret_type.setter
    def secret_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "secret_type", value)


class Instance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 area_name: Optional[pulumi.Input[str]] = None,
                 cloudserver_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 default_isp: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage veenedge instance
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.veenedge.Instance("foo",
            area_name="*****",
            cloudserver_id="cloudserver-x92*****jcc8f",
            isp="CMCC")
        foo1 = volcengine.veenedge.Instance("foo1", instance_id="veen0*****0111112")
        ```

        ## Import

        Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:veenedge/instance:Instance default veenn769ewmjjqyqh5dv
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] area_name: The area name.
        :param pulumi.Input[str] cloudserver_id: The id of cloud server.
        :param pulumi.Input[str] cluster_name: The name of cluster.
        :param pulumi.Input[str] default_isp: The default isp for multi line node.
        :param pulumi.Input[str] instance_id: Import an exist instance, usually for import a default instance generated with cloud server creating.
        :param pulumi.Input[str] isp: The isp info.
        :param pulumi.Input[str] name: The name of instance, only effected in update scene.
        :param pulumi.Input[str] secret_data: The data of secret, only effected in update scene.
        :param pulumi.Input[str] secret_type: The type of secret, only effected in update scene. The value can be `KeyPair` or `Password`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[InstanceArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage veenedge instance
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo = volcengine.veenedge.Instance("foo",
            area_name="*****",
            cloudserver_id="cloudserver-x92*****jcc8f",
            isp="CMCC")
        foo1 = volcengine.veenedge.Instance("foo1", instance_id="veen0*****0111112")
        ```

        ## Import

        Instance can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:veenedge/instance:Instance default veenn769ewmjjqyqh5dv
        ```

        :param str resource_name: The name of the resource.
        :param InstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(InstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 area_name: Optional[pulumi.Input[str]] = None,
                 cloudserver_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 default_isp: Optional[pulumi.Input[str]] = None,
                 instance_id: Optional[pulumi.Input[str]] = None,
                 isp: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 secret_data: Optional[pulumi.Input[str]] = None,
                 secret_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = InstanceArgs.__new__(InstanceArgs)

            __props__.__dict__["area_name"] = area_name
            __props__.__dict__["cloudserver_id"] = cloudserver_id
            __props__.__dict__["cluster_name"] = cluster_name
            __props__.__dict__["default_isp"] = default_isp
            __props__.__dict__["instance_id"] = instance_id
            __props__.__dict__["isp"] = isp
            __props__.__dict__["name"] = name
            __props__.__dict__["secret_data"] = secret_data
            __props__.__dict__["secret_type"] = secret_type
        super(Instance, __self__).__init__(
            'volcengine:veenedge/instance:Instance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            area_name: Optional[pulumi.Input[str]] = None,
            cloudserver_id: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            default_isp: Optional[pulumi.Input[str]] = None,
            instance_id: Optional[pulumi.Input[str]] = None,
            isp: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            secret_data: Optional[pulumi.Input[str]] = None,
            secret_type: Optional[pulumi.Input[str]] = None) -> 'Instance':
        """
        Get an existing Instance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] area_name: The area name.
        :param pulumi.Input[str] cloudserver_id: The id of cloud server.
        :param pulumi.Input[str] cluster_name: The name of cluster.
        :param pulumi.Input[str] default_isp: The default isp for multi line node.
        :param pulumi.Input[str] instance_id: Import an exist instance, usually for import a default instance generated with cloud server creating.
        :param pulumi.Input[str] isp: The isp info.
        :param pulumi.Input[str] name: The name of instance, only effected in update scene.
        :param pulumi.Input[str] secret_data: The data of secret, only effected in update scene.
        :param pulumi.Input[str] secret_type: The type of secret, only effected in update scene. The value can be `KeyPair` or `Password`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _InstanceState.__new__(_InstanceState)

        __props__.__dict__["area_name"] = area_name
        __props__.__dict__["cloudserver_id"] = cloudserver_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["default_isp"] = default_isp
        __props__.__dict__["instance_id"] = instance_id
        __props__.__dict__["isp"] = isp
        __props__.__dict__["name"] = name
        __props__.__dict__["secret_data"] = secret_data
        __props__.__dict__["secret_type"] = secret_type
        return Instance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="areaName")
    def area_name(self) -> pulumi.Output[str]:
        """
        The area name.
        """
        return pulumi.get(self, "area_name")

    @property
    @pulumi.getter(name="cloudserverId")
    def cloudserver_id(self) -> pulumi.Output[str]:
        """
        The id of cloud server.
        """
        return pulumi.get(self, "cloudserver_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        The name of cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="defaultIsp")
    def default_isp(self) -> pulumi.Output[Optional[str]]:
        """
        The default isp for multi line node.
        """
        return pulumi.get(self, "default_isp")

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> pulumi.Output[str]:
        """
        Import an exist instance, usually for import a default instance generated with cloud server creating.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter
    def isp(self) -> pulumi.Output[str]:
        """
        The isp info.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of instance, only effected in update scene.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> pulumi.Output[Optional[str]]:
        """
        The data of secret, only effected in update scene.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> pulumi.Output[Optional[str]]:
        """
        The type of secret, only effected in update scene. The value can be `KeyPair` or `Password`.
        """
        return pulumi.get(self, "secret_type")

