# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'InstancesResult',
    'AwaitableInstancesResult',
    'instances',
    'instances_output',
]

@pulumi.output_type
class InstancesResult:
    """
    A collection of values returned by Instances.
    """
    def __init__(__self__, cloud_server_ids=None, id=None, ids=None, instances=None, names=None, output_file=None, statuses=None, total_count=None):
        if cloud_server_ids and not isinstance(cloud_server_ids, list):
            raise TypeError("Expected argument 'cloud_server_ids' to be a list")
        pulumi.set(__self__, "cloud_server_ids", cloud_server_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if instances and not isinstance(instances, list):
            raise TypeError("Expected argument 'instances' to be a list")
        pulumi.set(__self__, "instances", instances)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)

    @property
    @pulumi.getter(name="cloudServerIds")
    def cloud_server_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cloud_server_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def instances(self) -> Sequence['outputs.InstancesInstanceResult']:
        """
        The collection of instance query.
        """
        return pulumi.get(self, "instances")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of instance query.
        """
        return pulumi.get(self, "total_count")


class AwaitableInstancesResult(InstancesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return InstancesResult(
            cloud_server_ids=self.cloud_server_ids,
            id=self.id,
            ids=self.ids,
            instances=self.instances,
            names=self.names,
            output_file=self.output_file,
            statuses=self.statuses,
            total_count=self.total_count)


def instances(cloud_server_ids: Optional[Sequence[str]] = None,
              ids: Optional[Sequence[str]] = None,
              names: Optional[Sequence[str]] = None,
              output_file: Optional[str] = None,
              statuses: Optional[Sequence[str]] = None,
              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableInstancesResult:
    """
    Use this data source to query detailed information of veenedge instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.veenedge.instances(ids=[
        "veen28*****21",
        "veen177110*****172",
    ])
    ```


    :param Sequence[str] cloud_server_ids: The list of cloud server ids.
    :param Sequence[str] ids: A list of instance IDs.
    :param Sequence[str] names: A list of instance names.
    :param str output_file: File name where to save data source results.
    :param Sequence[str] statuses: The list of instance status. The value can be `opening` or `starting` or `running` or `stopping` or `stop` or `rebooting` or `terminating`.
    """
    __args__ = dict()
    __args__['cloudServerIds'] = cloud_server_ids
    __args__['ids'] = ids
    __args__['names'] = names
    __args__['outputFile'] = output_file
    __args__['statuses'] = statuses
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:veenedge/instances:Instances', __args__, opts=opts, typ=InstancesResult).value

    return AwaitableInstancesResult(
        cloud_server_ids=pulumi.get(__ret__, 'cloud_server_ids'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        instances=pulumi.get(__ret__, 'instances'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        statuses=pulumi.get(__ret__, 'statuses'),
        total_count=pulumi.get(__ret__, 'total_count'))


@_utilities.lift_output_func(instances)
def instances_output(cloud_server_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     output_file: Optional[pulumi.Input[Optional[str]]] = None,
                     statuses: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[InstancesResult]:
    """
    Use this data source to query detailed information of veenedge instances
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.veenedge.instances(ids=[
        "veen28*****21",
        "veen177110*****172",
    ])
    ```


    :param Sequence[str] cloud_server_ids: The list of cloud server ids.
    :param Sequence[str] ids: A list of instance IDs.
    :param Sequence[str] names: A list of instance names.
    :param str output_file: File name where to save data source results.
    :param Sequence[str] statuses: The list of instance status. The value can be `opening` or `starting` or `running` or `stopping` or `stop` or `rebooting` or `terminating`.
    """
    ...
