# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AvailableResourcesRegionResult',
    'AvailableResourcesRegionAreaResult',
    'AvailableResourcesRegionCityResult',
    'AvailableResourcesRegionClusterResult',
    'AvailableResourcesRegionCountryResult',
    'AvailableResourcesRegionIspResult',
    'CloudServerBillingConfig',
    'CloudServerCustomData',
    'CloudServerNetworkConfig',
    'CloudServerScheduleStrategy',
    'CloudServerStorageConfig',
    'CloudServerStorageConfigDataDiskList',
    'CloudServerStorageConfigSystemDisk',
    'CloudServersCloudServerResult',
    'CloudServersCloudServerBillingConfigResult',
    'CloudServersCloudServerCustomDataResult',
    'CloudServersCloudServerGpuResult',
    'CloudServersCloudServerGpuGpusResult',
    'CloudServersCloudServerGpuGpusGpuSpecResult',
    'CloudServersCloudServerImageResult',
    'CloudServersCloudServerInstanceStatusResult',
    'CloudServersCloudServerNetworkResult',
    'CloudServersCloudServerScheduleStrategyConfigsResult',
    'CloudServersCloudServerSecretConfigResult',
    'CloudServersCloudServerServerAreaResult',
    'CloudServersCloudServerStorageResult',
    'CloudServersCloudServerStorageDataDiskResult',
    'CloudServersCloudServerStorageDataDiskListResult',
    'CloudServersCloudServerStorageSystemDiskResult',
    'InstanceTypesInstanceTypeConfigResult',
    'InstanceTypesInstanceTypeConfigStorageResult',
    'InstancesInstanceResult',
    'InstancesInstanceClusterResult',
    'InstancesInstanceGpuResult',
    'InstancesInstanceGpuGpusResult',
    'InstancesInstanceGpuGpusGpuSpecResult',
    'InstancesInstanceImageResult',
    'InstancesInstanceNetworkResult',
    'InstancesInstanceNetworkExternalInterfaceResult',
    'InstancesInstanceNetworkExternalInterfaceIpResult',
    'InstancesInstanceNetworkInternalInterfaceResult',
    'InstancesInstanceNetworkInternalInterfaceIpResult',
    'InstancesInstanceStorageResult',
    'InstancesInstanceStorageDataDiskResult',
    'InstancesInstanceStorageDataDiskListResult',
    'InstancesInstanceStorageSystemDiskResult',
    'VpcsVpcInstanceResult',
    'VpcsVpcInstanceClusterResult',
    'VpcsVpcInstanceResourceStatisticResult',
    'VpcsVpcInstanceSubNetResult',
]

@pulumi.output_type
class AvailableResourcesRegionResult(dict):
    def __init__(__self__, *,
                 area: 'outputs.AvailableResourcesRegionAreaResult',
                 city: 'outputs.AvailableResourcesRegionCityResult',
                 cluster: 'outputs.AvailableResourcesRegionClusterResult',
                 country: 'outputs.AvailableResourcesRegionCountryResult',
                 isp: 'outputs.AvailableResourcesRegionIspResult'):
        """
        :param 'AvailableResourcesRegionAreaArgs' area: The config of area.
        :param 'AvailableResourcesRegionCityArgs' city: The config of city.
        :param 'AvailableResourcesRegionClusterArgs' cluster: The config of cluster.
        :param 'AvailableResourcesRegionCountryArgs' country: The config of country.
        :param 'AvailableResourcesRegionIspArgs' isp: The config of isp.
        """
        pulumi.set(__self__, "area", area)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "isp", isp)

    @property
    @pulumi.getter
    def area(self) -> 'outputs.AvailableResourcesRegionAreaResult':
        """
        The config of area.
        """
        return pulumi.get(self, "area")

    @property
    @pulumi.getter
    def city(self) -> 'outputs.AvailableResourcesRegionCityResult':
        """
        The config of city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter
    def cluster(self) -> 'outputs.AvailableResourcesRegionClusterResult':
        """
        The config of cluster.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def country(self) -> 'outputs.AvailableResourcesRegionCountryResult':
        """
        The config of country.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def isp(self) -> 'outputs.AvailableResourcesRegionIspResult':
        """
        The config of isp.
        """
        return pulumi.get(self, "isp")


@pulumi.output_type
class AvailableResourcesRegionAreaResult(dict):
    def __init__(__self__, *,
                 en_name: str,
                 id: str,
                 name: str):
        """
        :param str en_name: The english name of region.
        :param str id: The id of region.
        :param str name: The name of region.
        """
        pulumi.set(__self__, "en_name", en_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="enName")
    def en_name(self) -> str:
        """
        The english name of region.
        """
        return pulumi.get(self, "en_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of region.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of region.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AvailableResourcesRegionCityResult(dict):
    def __init__(__self__, *,
                 en_name: str,
                 id: str,
                 name: str):
        """
        :param str en_name: The english name of region.
        :param str id: The id of region.
        :param str name: The name of region.
        """
        pulumi.set(__self__, "en_name", en_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="enName")
    def en_name(self) -> str:
        """
        The english name of region.
        """
        return pulumi.get(self, "en_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of region.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of region.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AvailableResourcesRegionClusterResult(dict):
    def __init__(__self__, *,
                 en_name: str,
                 id: str,
                 name: str):
        """
        :param str en_name: The english name of region.
        :param str id: The id of region.
        :param str name: The name of region.
        """
        pulumi.set(__self__, "en_name", en_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="enName")
    def en_name(self) -> str:
        """
        The english name of region.
        """
        return pulumi.get(self, "en_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of region.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of region.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AvailableResourcesRegionCountryResult(dict):
    def __init__(__self__, *,
                 en_name: str,
                 id: str,
                 name: str):
        """
        :param str en_name: The english name of region.
        :param str id: The id of region.
        :param str name: The name of region.
        """
        pulumi.set(__self__, "en_name", en_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="enName")
    def en_name(self) -> str:
        """
        The english name of region.
        """
        return pulumi.get(self, "en_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of region.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of region.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class AvailableResourcesRegionIspResult(dict):
    def __init__(__self__, *,
                 en_name: str,
                 id: str,
                 name: str):
        """
        :param str en_name: The english name of region.
        :param str id: The id of region.
        :param str name: The name of region.
        """
        pulumi.set(__self__, "en_name", en_name)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="enName")
    def en_name(self) -> str:
        """
        The english name of region.
        """
        return pulumi.get(self, "en_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The id of region.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of region.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class CloudServerBillingConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthBillingMethod":
            suggest = "bandwidth_billing_method"
        elif key == "computingBillingMethod":
            suggest = "computing_billing_method"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudServerBillingConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudServerBillingConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudServerBillingConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_billing_method: str,
                 computing_billing_method: str):
        """
        :param str bandwidth_billing_method: The method of bandwidth billing. The value can be `MonthlyP95` or `DailyPeak`.
        :param str computing_billing_method: The method of computing billing. The value can be `MonthlyPeak` or `DailyPeak`.
        """
        pulumi.set(__self__, "bandwidth_billing_method", bandwidth_billing_method)
        pulumi.set(__self__, "computing_billing_method", computing_billing_method)

    @property
    @pulumi.getter(name="bandwidthBillingMethod")
    def bandwidth_billing_method(self) -> str:
        """
        The method of bandwidth billing. The value can be `MonthlyP95` or `DailyPeak`.
        """
        return pulumi.get(self, "bandwidth_billing_method")

    @property
    @pulumi.getter(name="computingBillingMethod")
    def computing_billing_method(self) -> str:
        """
        The method of computing billing. The value can be `MonthlyPeak` or `DailyPeak`.
        """
        return pulumi.get(self, "computing_billing_method")


@pulumi.output_type
class CloudServerCustomData(dict):
    def __init__(__self__, *,
                 data: str):
        """
        :param str data: The custom data info.
        """
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The custom data info.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class CloudServerNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bandwidthPeak":
            suggest = "bandwidth_peak"
        elif key == "customExternalInterfaceName":
            suggest = "custom_external_interface_name"
        elif key == "customInternalInterfaceName":
            suggest = "custom_internal_interface_name"
        elif key == "enableIpv6":
            suggest = "enable_ipv6"
        elif key == "internalBandwidthPeak":
            suggest = "internal_bandwidth_peak"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudServerNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudServerNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudServerNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 bandwidth_peak: str,
                 custom_external_interface_name: Optional[str] = None,
                 custom_internal_interface_name: Optional[str] = None,
                 enable_ipv6: Optional[bool] = None,
                 internal_bandwidth_peak: Optional[str] = None):
        """
        :param str bandwidth_peak: The peak of bandwidth.
        :param str custom_external_interface_name: The name of custom external interface.
        :param str custom_internal_interface_name: The name of custom internal interface.
        :param bool enable_ipv6: Whether enable ipv6.
        :param str internal_bandwidth_peak: The internal peak of bandwidth.
        """
        pulumi.set(__self__, "bandwidth_peak", bandwidth_peak)
        if custom_external_interface_name is not None:
            pulumi.set(__self__, "custom_external_interface_name", custom_external_interface_name)
        if custom_internal_interface_name is not None:
            pulumi.set(__self__, "custom_internal_interface_name", custom_internal_interface_name)
        if enable_ipv6 is not None:
            pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        if internal_bandwidth_peak is not None:
            pulumi.set(__self__, "internal_bandwidth_peak", internal_bandwidth_peak)

    @property
    @pulumi.getter(name="bandwidthPeak")
    def bandwidth_peak(self) -> str:
        """
        The peak of bandwidth.
        """
        return pulumi.get(self, "bandwidth_peak")

    @property
    @pulumi.getter(name="customExternalInterfaceName")
    def custom_external_interface_name(self) -> Optional[str]:
        """
        The name of custom external interface.
        """
        return pulumi.get(self, "custom_external_interface_name")

    @property
    @pulumi.getter(name="customInternalInterfaceName")
    def custom_internal_interface_name(self) -> Optional[str]:
        """
        The name of custom internal interface.
        """
        return pulumi.get(self, "custom_internal_interface_name")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> Optional[bool]:
        """
        Whether enable ipv6.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter(name="internalBandwidthPeak")
    def internal_bandwidth_peak(self) -> Optional[str]:
        """
        The internal peak of bandwidth.
        """
        return pulumi.get(self, "internal_bandwidth_peak")


@pulumi.output_type
class CloudServerScheduleStrategy(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "networkStrategy":
            suggest = "network_strategy"
        elif key == "priceStrategy":
            suggest = "price_strategy"
        elif key == "scheduleStrategy":
            suggest = "schedule_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudServerScheduleStrategy. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudServerScheduleStrategy.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudServerScheduleStrategy.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 network_strategy: str,
                 price_strategy: str,
                 schedule_strategy: str):
        """
        :param str network_strategy: The network strategy.
        :param str price_strategy: The price strategy. The value can be `high_priority` or `low_priority`.
        :param str schedule_strategy: The type of schedule strategy. The value can be `dispersion` or `concentration`.
        """
        pulumi.set(__self__, "network_strategy", network_strategy)
        pulumi.set(__self__, "price_strategy", price_strategy)
        pulumi.set(__self__, "schedule_strategy", schedule_strategy)

    @property
    @pulumi.getter(name="networkStrategy")
    def network_strategy(self) -> str:
        """
        The network strategy.
        """
        return pulumi.get(self, "network_strategy")

    @property
    @pulumi.getter(name="priceStrategy")
    def price_strategy(self) -> str:
        """
        The price strategy. The value can be `high_priority` or `low_priority`.
        """
        return pulumi.get(self, "price_strategy")

    @property
    @pulumi.getter(name="scheduleStrategy")
    def schedule_strategy(self) -> str:
        """
        The type of schedule strategy. The value can be `dispersion` or `concentration`.
        """
        return pulumi.get(self, "schedule_strategy")


@pulumi.output_type
class CloudServerStorageConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "systemDisk":
            suggest = "system_disk"
        elif key == "dataDiskLists":
            suggest = "data_disk_lists"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudServerStorageConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudServerStorageConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudServerStorageConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 system_disk: 'outputs.CloudServerStorageConfigSystemDisk',
                 data_disk_lists: Optional[Sequence['outputs.CloudServerStorageConfigDataDiskList']] = None):
        """
        :param 'CloudServerStorageConfigSystemDiskArgs' system_disk: The disk info of system.
        :param Sequence['CloudServerStorageConfigDataDiskListArgs'] data_disk_lists: The disk list info of data.
        """
        pulumi.set(__self__, "system_disk", system_disk)
        if data_disk_lists is not None:
            pulumi.set(__self__, "data_disk_lists", data_disk_lists)

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> 'outputs.CloudServerStorageConfigSystemDisk':
        """
        The disk info of system.
        """
        return pulumi.get(self, "system_disk")

    @property
    @pulumi.getter(name="dataDiskLists")
    def data_disk_lists(self) -> Optional[Sequence['outputs.CloudServerStorageConfigDataDiskList']]:
        """
        The disk list info of data.
        """
        return pulumi.get(self, "data_disk_lists")


@pulumi.output_type
class CloudServerStorageConfigDataDiskList(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudServerStorageConfigDataDiskList. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudServerStorageConfigDataDiskList.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudServerStorageConfigDataDiskList.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity: str,
                 storage_type: str):
        """
        :param str capacity: The capacity of storage.
        :param str storage_type: The type of storage. The value can be `CloudBlockHDD` or `CloudBlockSSD`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def capacity(self) -> str:
        """
        The capacity of storage.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The type of storage. The value can be `CloudBlockHDD` or `CloudBlockSSD`.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class CloudServerStorageConfigSystemDisk(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageType":
            suggest = "storage_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CloudServerStorageConfigSystemDisk. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CloudServerStorageConfigSystemDisk.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CloudServerStorageConfigSystemDisk.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 capacity: str,
                 storage_type: str):
        """
        :param str capacity: The capacity of storage.
        :param str storage_type: The type of storage. The value can be `CloudBlockHDD` or `CloudBlockSSD`.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def capacity(self) -> str:
        """
        The capacity of storage.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The type of storage. The value can be `CloudBlockHDD` or `CloudBlockSSD`.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class CloudServersCloudServerResult(dict):
    def __init__(__self__, *,
                 billing_config: 'outputs.CloudServersCloudServerBillingConfigResult',
                 cloud_server_identity: str,
                 cpu: str,
                 create_time: int,
                 custom_data: 'outputs.CloudServersCloudServerCustomDataResult',
                 gpu: 'outputs.CloudServersCloudServerGpuResult',
                 id: str,
                 image: 'outputs.CloudServersCloudServerImageResult',
                 instance_count: int,
                 instance_statuses: Sequence['outputs.CloudServersCloudServerInstanceStatusResult'],
                 mem: str,
                 name: str,
                 network: 'outputs.CloudServersCloudServerNetworkResult',
                 schedule_strategy_configs: 'outputs.CloudServersCloudServerScheduleStrategyConfigsResult',
                 secret_config: 'outputs.CloudServersCloudServerSecretConfigResult',
                 server_area_count: int,
                 server_area_level: str,
                 server_areas: Sequence['outputs.CloudServersCloudServerServerAreaResult'],
                 spec: str,
                 spec_display: str,
                 spec_sum: Mapping[str, Any],
                 storage: 'outputs.CloudServersCloudServerStorageResult',
                 update_time: int):
        """
        :param 'CloudServersCloudServerBillingConfigArgs' billing_config: The config of billing.
        :param str cloud_server_identity: The Id of cloud server.
        :param str cpu: The cpu info of cloud server.
        :param int create_time: The create time info.
        :param 'CloudServersCloudServerCustomDataArgs' custom_data: The config of custom data.
        :param 'CloudServersCloudServerGpuArgs' gpu: The config of gpu.
        :param str id: The Id of cloud server.
        :param 'CloudServersCloudServerImageArgs' image: The config of image.
        :param int instance_count: The count of instance.
        :param Sequence['CloudServersCloudServerInstanceStatusArgs'] instance_statuses: The status of instances.
        :param str mem: The memory info of cloud server.
        :param str name: The name of cloud server.
        :param 'CloudServersCloudServerNetworkArgs' network: The config of network.
        :param 'CloudServersCloudServerScheduleStrategyConfigsArgs' schedule_strategy_configs: The config of schedule strategy.
        :param 'CloudServersCloudServerSecretConfigArgs' secret_config: The config of secret.
        :param int server_area_count: The server area count number.
        :param str server_area_level: The area level of cloud server.
        :param Sequence['CloudServersCloudServerServerAreaArgs'] server_areas: The server areas info.
        :param str spec: The spec info of cloud server.
        :param str spec_display: The Chinese spec info of cloud server.
        :param Mapping[str, Any] spec_sum: The spec summary of cloud server.
        :param 'CloudServersCloudServerStorageArgs' storage: The config of storage.
        :param int update_time: The update time info.
        """
        pulumi.set(__self__, "billing_config", billing_config)
        pulumi.set(__self__, "cloud_server_identity", cloud_server_identity)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "custom_data", custom_data)
        pulumi.set(__self__, "gpu", gpu)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "instance_statuses", instance_statuses)
        pulumi.set(__self__, "mem", mem)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "schedule_strategy_configs", schedule_strategy_configs)
        pulumi.set(__self__, "secret_config", secret_config)
        pulumi.set(__self__, "server_area_count", server_area_count)
        pulumi.set(__self__, "server_area_level", server_area_level)
        pulumi.set(__self__, "server_areas", server_areas)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "spec_display", spec_display)
        pulumi.set(__self__, "spec_sum", spec_sum)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "update_time", update_time)

    @property
    @pulumi.getter(name="billingConfig")
    def billing_config(self) -> 'outputs.CloudServersCloudServerBillingConfigResult':
        """
        The config of billing.
        """
        return pulumi.get(self, "billing_config")

    @property
    @pulumi.getter(name="cloudServerIdentity")
    def cloud_server_identity(self) -> str:
        """
        The Id of cloud server.
        """
        return pulumi.get(self, "cloud_server_identity")

    @property
    @pulumi.getter
    def cpu(self) -> str:
        """
        The cpu info of cloud server.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> int:
        """
        The create time info.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="customData")
    def custom_data(self) -> 'outputs.CloudServersCloudServerCustomDataResult':
        """
        The config of custom data.
        """
        return pulumi.get(self, "custom_data")

    @property
    @pulumi.getter
    def gpu(self) -> 'outputs.CloudServersCloudServerGpuResult':
        """
        The config of gpu.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Id of cloud server.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.CloudServersCloudServerImageResult':
        """
        The config of image.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The count of instance.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter(name="instanceStatuses")
    def instance_statuses(self) -> Sequence['outputs.CloudServersCloudServerInstanceStatusResult']:
        """
        The status of instances.
        """
        return pulumi.get(self, "instance_statuses")

    @property
    @pulumi.getter
    def mem(self) -> str:
        """
        The memory info of cloud server.
        """
        return pulumi.get(self, "mem")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of cloud server.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def network(self) -> 'outputs.CloudServersCloudServerNetworkResult':
        """
        The config of network.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter(name="scheduleStrategyConfigs")
    def schedule_strategy_configs(self) -> 'outputs.CloudServersCloudServerScheduleStrategyConfigsResult':
        """
        The config of schedule strategy.
        """
        return pulumi.get(self, "schedule_strategy_configs")

    @property
    @pulumi.getter(name="secretConfig")
    def secret_config(self) -> 'outputs.CloudServersCloudServerSecretConfigResult':
        """
        The config of secret.
        """
        return pulumi.get(self, "secret_config")

    @property
    @pulumi.getter(name="serverAreaCount")
    def server_area_count(self) -> int:
        """
        The server area count number.
        """
        return pulumi.get(self, "server_area_count")

    @property
    @pulumi.getter(name="serverAreaLevel")
    def server_area_level(self) -> str:
        """
        The area level of cloud server.
        """
        return pulumi.get(self, "server_area_level")

    @property
    @pulumi.getter(name="serverAreas")
    def server_areas(self) -> Sequence['outputs.CloudServersCloudServerServerAreaResult']:
        """
        The server areas info.
        """
        return pulumi.get(self, "server_areas")

    @property
    @pulumi.getter
    def spec(self) -> str:
        """
        The spec info of cloud server.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="specDisplay")
    def spec_display(self) -> str:
        """
        The Chinese spec info of cloud server.
        """
        return pulumi.get(self, "spec_display")

    @property
    @pulumi.getter(name="specSum")
    def spec_sum(self) -> Mapping[str, Any]:
        """
        The spec summary of cloud server.
        """
        return pulumi.get(self, "spec_sum")

    @property
    @pulumi.getter
    def storage(self) -> 'outputs.CloudServersCloudServerStorageResult':
        """
        The config of storage.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> int:
        """
        The update time info.
        """
        return pulumi.get(self, "update_time")


@pulumi.output_type
class CloudServersCloudServerBillingConfigResult(dict):
    def __init__(__self__, *,
                 bandwidth_billing_method: str,
                 computing_billing_method: str):
        """
        :param str bandwidth_billing_method: The bandwidth billing method.
        :param str computing_billing_method: The computing billing method.
        """
        pulumi.set(__self__, "bandwidth_billing_method", bandwidth_billing_method)
        pulumi.set(__self__, "computing_billing_method", computing_billing_method)

    @property
    @pulumi.getter(name="bandwidthBillingMethod")
    def bandwidth_billing_method(self) -> str:
        """
        The bandwidth billing method.
        """
        return pulumi.get(self, "bandwidth_billing_method")

    @property
    @pulumi.getter(name="computingBillingMethod")
    def computing_billing_method(self) -> str:
        """
        The computing billing method.
        """
        return pulumi.get(self, "computing_billing_method")


@pulumi.output_type
class CloudServersCloudServerCustomDataResult(dict):
    def __init__(__self__, *,
                 data: str):
        """
        :param str data: The data info.
        """
        pulumi.set(__self__, "data", data)

    @property
    @pulumi.getter
    def data(self) -> str:
        """
        The data info.
        """
        return pulumi.get(self, "data")


@pulumi.output_type
class CloudServersCloudServerGpuResult(dict):
    def __init__(__self__, *,
                 gpuses: Sequence['outputs.CloudServersCloudServerGpuGpusResult']):
        """
        :param Sequence['CloudServersCloudServerGpuGpusArgs'] gpuses: The list gpu info.
        """
        pulumi.set(__self__, "gpuses", gpuses)

    @property
    @pulumi.getter
    def gpuses(self) -> Sequence['outputs.CloudServersCloudServerGpuGpusResult']:
        """
        The list gpu info.
        """
        return pulumi.get(self, "gpuses")


@pulumi.output_type
class CloudServersCloudServerGpuGpusResult(dict):
    def __init__(__self__, *,
                 gpu_spec: 'outputs.CloudServersCloudServerGpuGpusGpuSpecResult',
                 num: int):
        """
        :param 'CloudServersCloudServerGpuGpusGpuSpecArgs' gpu_spec: The spec of gpu.
        :param int num: The number of gpu.
        """
        pulumi.set(__self__, "gpu_spec", gpu_spec)
        pulumi.set(__self__, "num", num)

    @property
    @pulumi.getter(name="gpuSpec")
    def gpu_spec(self) -> 'outputs.CloudServersCloudServerGpuGpusGpuSpecResult':
        """
        The spec of gpu.
        """
        return pulumi.get(self, "gpu_spec")

    @property
    @pulumi.getter
    def num(self) -> int:
        """
        The number of gpu.
        """
        return pulumi.get(self, "num")


@pulumi.output_type
class CloudServersCloudServerGpuGpusGpuSpecResult(dict):
    def __init__(__self__, *,
                 gpu_type: str):
        """
        :param str gpu_type: The type of gpu.
        """
        pulumi.set(__self__, "gpu_type", gpu_type)

    @property
    @pulumi.getter(name="gpuType")
    def gpu_type(self) -> str:
        """
        The type of gpu.
        """
        return pulumi.get(self, "gpu_type")


@pulumi.output_type
class CloudServersCloudServerImageResult(dict):
    def __init__(__self__, *,
                 image_identity: str,
                 image_name: str,
                 property: str,
                 system_arch: str,
                 system_bit: str,
                 system_type: str,
                 system_version: str):
        """
        :param str image_identity: The id of image.
        :param str image_name: The name of image.
        :param str property: The property of system.
        :param str system_arch: The arch of system.
        :param str system_bit: The bit of system.
        :param str system_type: The type of system.
        :param str system_version: The version of system.
        """
        pulumi.set(__self__, "image_identity", image_identity)
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "system_arch", system_arch)
        pulumi.set(__self__, "system_bit", system_bit)
        pulumi.set(__self__, "system_type", system_type)
        pulumi.set(__self__, "system_version", system_version)

    @property
    @pulumi.getter(name="imageIdentity")
    def image_identity(self) -> str:
        """
        The id of image.
        """
        return pulumi.get(self, "image_identity")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of image.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="systemArch")
    def system_arch(self) -> str:
        """
        The arch of system.
        """
        return pulumi.get(self, "system_arch")

    @property
    @pulumi.getter(name="systemBit")
    def system_bit(self) -> str:
        """
        The bit of system.
        """
        return pulumi.get(self, "system_bit")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> str:
        """
        The type of system.
        """
        return pulumi.get(self, "system_type")

    @property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> str:
        """
        The version of system.
        """
        return pulumi.get(self, "system_version")

    @property
    @pulumi.getter
    def property(self) -> str:
        """
        The property of system.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class CloudServersCloudServerInstanceStatusResult(dict):
    def __init__(__self__, *,
                 instance_count: int,
                 status: str):
        """
        :param int instance_count: The count of instance.
        :param str status: The status info.
        """
        pulumi.set(__self__, "instance_count", instance_count)
        pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="instanceCount")
    def instance_count(self) -> int:
        """
        The count of instance.
        """
        return pulumi.get(self, "instance_count")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status info.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class CloudServersCloudServerNetworkResult(dict):
    def __init__(__self__, *,
                 bandwidth_peak: str,
                 enable_ipv6: bool,
                 internal_bandwidth_peak: str):
        """
        :param str bandwidth_peak: The peak of bandwidth.
        :param bool enable_ipv6: Whether enable ipv6.
        :param str internal_bandwidth_peak: The internal peak of bandwidth.
        """
        pulumi.set(__self__, "bandwidth_peak", bandwidth_peak)
        pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        pulumi.set(__self__, "internal_bandwidth_peak", internal_bandwidth_peak)

    @property
    @pulumi.getter(name="bandwidthPeak")
    def bandwidth_peak(self) -> str:
        """
        The peak of bandwidth.
        """
        return pulumi.get(self, "bandwidth_peak")

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> bool:
        """
        Whether enable ipv6.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter(name="internalBandwidthPeak")
    def internal_bandwidth_peak(self) -> str:
        """
        The internal peak of bandwidth.
        """
        return pulumi.get(self, "internal_bandwidth_peak")


@pulumi.output_type
class CloudServersCloudServerScheduleStrategyConfigsResult(dict):
    def __init__(__self__, *,
                 price_strategy: str,
                 schedule_strategy: str):
        """
        :param str price_strategy: The price strategy.
        :param str schedule_strategy: The schedule strategy.
        """
        pulumi.set(__self__, "price_strategy", price_strategy)
        pulumi.set(__self__, "schedule_strategy", schedule_strategy)

    @property
    @pulumi.getter(name="priceStrategy")
    def price_strategy(self) -> str:
        """
        The price strategy.
        """
        return pulumi.get(self, "price_strategy")

    @property
    @pulumi.getter(name="scheduleStrategy")
    def schedule_strategy(self) -> str:
        """
        The schedule strategy.
        """
        return pulumi.get(self, "schedule_strategy")


@pulumi.output_type
class CloudServersCloudServerSecretConfigResult(dict):
    def __init__(__self__, *,
                 secret_data: str,
                 secret_type: int):
        """
        :param str secret_data: The data of secret.
        :param int secret_type: The type of secret.
        """
        pulumi.set(__self__, "secret_data", secret_data)
        pulumi.set(__self__, "secret_type", secret_type)

    @property
    @pulumi.getter(name="secretData")
    def secret_data(self) -> str:
        """
        The data of secret.
        """
        return pulumi.get(self, "secret_data")

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> int:
        """
        The type of secret.
        """
        return pulumi.get(self, "secret_type")


@pulumi.output_type
class CloudServersCloudServerServerAreaResult(dict):
    def __init__(__self__, *,
                 area: str,
                 instance_num: int,
                 isp: str):
        """
        :param str area: The area info.
        :param int instance_num: The number of instance.
        :param str isp: The isp info.
        """
        pulumi.set(__self__, "area", area)
        pulumi.set(__self__, "instance_num", instance_num)
        pulumi.set(__self__, "isp", isp)

    @property
    @pulumi.getter
    def area(self) -> str:
        """
        The area info.
        """
        return pulumi.get(self, "area")

    @property
    @pulumi.getter(name="instanceNum")
    def instance_num(self) -> int:
        """
        The number of instance.
        """
        return pulumi.get(self, "instance_num")

    @property
    @pulumi.getter
    def isp(self) -> str:
        """
        The isp info.
        """
        return pulumi.get(self, "isp")


@pulumi.output_type
class CloudServersCloudServerStorageResult(dict):
    def __init__(__self__, *,
                 data_disk: 'outputs.CloudServersCloudServerStorageDataDiskResult',
                 data_disk_lists: Sequence['outputs.CloudServersCloudServerStorageDataDiskListResult'],
                 system_disk: 'outputs.CloudServersCloudServerStorageSystemDiskResult'):
        """
        :param 'CloudServersCloudServerStorageDataDiskArgs' data_disk: The disk info of data.
        :param Sequence['CloudServersCloudServerStorageDataDiskListArgs'] data_disk_lists: The disk list info of data.
        :param 'CloudServersCloudServerStorageSystemDiskArgs' system_disk: The disk info of system.
        """
        pulumi.set(__self__, "data_disk", data_disk)
        pulumi.set(__self__, "data_disk_lists", data_disk_lists)
        pulumi.set(__self__, "system_disk", system_disk)

    @property
    @pulumi.getter(name="dataDisk")
    def data_disk(self) -> 'outputs.CloudServersCloudServerStorageDataDiskResult':
        """
        The disk info of data.
        """
        return pulumi.get(self, "data_disk")

    @property
    @pulumi.getter(name="dataDiskLists")
    def data_disk_lists(self) -> Sequence['outputs.CloudServersCloudServerStorageDataDiskListResult']:
        """
        The disk list info of data.
        """
        return pulumi.get(self, "data_disk_lists")

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> 'outputs.CloudServersCloudServerStorageSystemDiskResult':
        """
        The disk info of system.
        """
        return pulumi.get(self, "system_disk")


@pulumi.output_type
class CloudServersCloudServerStorageDataDiskResult(dict):
    def __init__(__self__, *,
                 capacity: str,
                 storage_type: str):
        """
        :param str capacity: The capacity of storage.
        :param str storage_type: The type of storage.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def capacity(self) -> str:
        """
        The capacity of storage.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The type of storage.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class CloudServersCloudServerStorageDataDiskListResult(dict):
    def __init__(__self__, *,
                 capacity: str,
                 storage_type: str):
        """
        :param str capacity: The capacity of storage.
        :param str storage_type: The type of storage.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def capacity(self) -> str:
        """
        The capacity of storage.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The type of storage.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class CloudServersCloudServerStorageSystemDiskResult(dict):
    def __init__(__self__, *,
                 capacity: str,
                 storage_type: str):
        """
        :param str capacity: The capacity of storage.
        :param str storage_type: The type of storage.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def capacity(self) -> str:
        """
        The capacity of storage.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The type of storage.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class InstanceTypesInstanceTypeConfigResult(dict):
    def __init__(__self__, *,
                 cpu: int,
                 gpu: int,
                 gpu_spec: str,
                 instance_type: str,
                 instance_type_family: str,
                 instance_type_family_name: str,
                 memory: int,
                 storages: Sequence['outputs.InstanceTypesInstanceTypeConfigStorageResult']):
        """
        :param int cpu: The cpu of instance type.
        :param int gpu: The gpu of instance type.
        :param str gpu_spec: The gpu spec of instance.
        :param str instance_type: The type of instance.
        :param str instance_type_family: The type family of instance.
        :param str instance_type_family_name: The name of instance type family.
        :param int memory: The memory of instance type.
        :param Sequence['InstanceTypesInstanceTypeConfigStorageArgs'] storages: The config of storage.
        """
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "gpu", gpu)
        pulumi.set(__self__, "gpu_spec", gpu_spec)
        pulumi.set(__self__, "instance_type", instance_type)
        pulumi.set(__self__, "instance_type_family", instance_type_family)
        pulumi.set(__self__, "instance_type_family_name", instance_type_family_name)
        pulumi.set(__self__, "memory", memory)
        pulumi.set(__self__, "storages", storages)

    @property
    @pulumi.getter
    def cpu(self) -> int:
        """
        The cpu of instance type.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter
    def gpu(self) -> int:
        """
        The gpu of instance type.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter(name="gpuSpec")
    def gpu_spec(self) -> str:
        """
        The gpu spec of instance.
        """
        return pulumi.get(self, "gpu_spec")

    @property
    @pulumi.getter(name="instanceType")
    def instance_type(self) -> str:
        """
        The type of instance.
        """
        return pulumi.get(self, "instance_type")

    @property
    @pulumi.getter(name="instanceTypeFamily")
    def instance_type_family(self) -> str:
        """
        The type family of instance.
        """
        return pulumi.get(self, "instance_type_family")

    @property
    @pulumi.getter(name="instanceTypeFamilyName")
    def instance_type_family_name(self) -> str:
        """
        The name of instance type family.
        """
        return pulumi.get(self, "instance_type_family_name")

    @property
    @pulumi.getter
    def memory(self) -> int:
        """
        The memory of instance type.
        """
        return pulumi.get(self, "memory")

    @property
    @pulumi.getter
    def storages(self) -> Sequence['outputs.InstanceTypesInstanceTypeConfigStorageResult']:
        """
        The config of storage.
        """
        return pulumi.get(self, "storages")


@pulumi.output_type
class InstanceTypesInstanceTypeConfigStorageResult(dict):
    def __init__(__self__, *,
                 local_storage_amount: int,
                 local_storage_capacity: int,
                 local_storage_category: str,
                 local_storage_unit: str):
        """
        :param int local_storage_amount: The amount of local storage.
        :param int local_storage_capacity: The capacity of local storage.
        :param str local_storage_category: The local storage category.
        :param str local_storage_unit: The unit of local storage.
        """
        pulumi.set(__self__, "local_storage_amount", local_storage_amount)
        pulumi.set(__self__, "local_storage_capacity", local_storage_capacity)
        pulumi.set(__self__, "local_storage_category", local_storage_category)
        pulumi.set(__self__, "local_storage_unit", local_storage_unit)

    @property
    @pulumi.getter(name="localStorageAmount")
    def local_storage_amount(self) -> int:
        """
        The amount of local storage.
        """
        return pulumi.get(self, "local_storage_amount")

    @property
    @pulumi.getter(name="localStorageCapacity")
    def local_storage_capacity(self) -> int:
        """
        The capacity of local storage.
        """
        return pulumi.get(self, "local_storage_capacity")

    @property
    @pulumi.getter(name="localStorageCategory")
    def local_storage_category(self) -> str:
        """
        The local storage category.
        """
        return pulumi.get(self, "local_storage_category")

    @property
    @pulumi.getter(name="localStorageUnit")
    def local_storage_unit(self) -> str:
        """
        The unit of local storage.
        """
        return pulumi.get(self, "local_storage_unit")


@pulumi.output_type
class InstancesInstanceResult(dict):
    def __init__(__self__, *,
                 cloud_server_identity: str,
                 cloud_server_name: str,
                 cluster: 'outputs.InstancesInstanceClusterResult',
                 cpu: str,
                 create_time: int,
                 creator: str,
                 delete_time: int,
                 end_time: int,
                 gpu: 'outputs.InstancesInstanceGpuResult',
                 id: str,
                 image: 'outputs.InstancesInstanceImageResult',
                 instance_identity: str,
                 instance_name: str,
                 mem: str,
                 network: 'outputs.InstancesInstanceNetworkResult',
                 spec: str,
                 spec_display: str,
                 start_time: int,
                 status: str,
                 storage: 'outputs.InstancesInstanceStorageResult',
                 subnet_cidr: str,
                 update_time: int,
                 vpc_identity: str):
        """
        :param str cloud_server_identity: The id of cloud server.
        :param str cloud_server_name: The name of cloud server.
        :param 'InstancesInstanceClusterArgs' cluster: The cluster info.
        :param str cpu: The cpu of instance.
        :param int create_time: The create time of instance.
        :param str creator: The creator of instance.
        :param int delete_time: The delete time of instance.
        :param int end_time: The end time of instance.
        :param 'InstancesInstanceGpuArgs' gpu: The config of gpu.
        :param str id: The Id of instance.
        :param 'InstancesInstanceImageArgs' image: The config of image.
        :param str instance_identity: The Id of instance.
        :param str instance_name: The name of instance.
        :param str mem: The memory of instance.
        :param 'InstancesInstanceNetworkArgs' network: The config of network.
        :param str spec: The spec of instance.
        :param str spec_display: The spec display of instance.
        :param int start_time: The start time of instance.
        :param str status: The status of instance.
        :param 'InstancesInstanceStorageArgs' storage: The config of storage.
        :param str subnet_cidr: The subnet cidr.
        :param int update_time: The update time of instance.
        :param str vpc_identity: The id of vpc.
        """
        pulumi.set(__self__, "cloud_server_identity", cloud_server_identity)
        pulumi.set(__self__, "cloud_server_name", cloud_server_name)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "cpu", cpu)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "creator", creator)
        pulumi.set(__self__, "delete_time", delete_time)
        pulumi.set(__self__, "end_time", end_time)
        pulumi.set(__self__, "gpu", gpu)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "instance_identity", instance_identity)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "mem", mem)
        pulumi.set(__self__, "network", network)
        pulumi.set(__self__, "spec", spec)
        pulumi.set(__self__, "spec_display", spec_display)
        pulumi.set(__self__, "start_time", start_time)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "storage", storage)
        pulumi.set(__self__, "subnet_cidr", subnet_cidr)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "vpc_identity", vpc_identity)

    @property
    @pulumi.getter(name="cloudServerIdentity")
    def cloud_server_identity(self) -> str:
        """
        The id of cloud server.
        """
        return pulumi.get(self, "cloud_server_identity")

    @property
    @pulumi.getter(name="cloudServerName")
    def cloud_server_name(self) -> str:
        """
        The name of cloud server.
        """
        return pulumi.get(self, "cloud_server_name")

    @property
    @pulumi.getter
    def cluster(self) -> 'outputs.InstancesInstanceClusterResult':
        """
        The cluster info.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter
    def cpu(self) -> str:
        """
        The cpu of instance.
        """
        return pulumi.get(self, "cpu")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> int:
        """
        The create time of instance.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> str:
        """
        The creator of instance.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="deleteTime")
    def delete_time(self) -> int:
        """
        The delete time of instance.
        """
        return pulumi.get(self, "delete_time")

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> int:
        """
        The end time of instance.
        """
        return pulumi.get(self, "end_time")

    @property
    @pulumi.getter
    def gpu(self) -> 'outputs.InstancesInstanceGpuResult':
        """
        The config of gpu.
        """
        return pulumi.get(self, "gpu")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The Id of instance.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def image(self) -> 'outputs.InstancesInstanceImageResult':
        """
        The config of image.
        """
        return pulumi.get(self, "image")

    @property
    @pulumi.getter(name="instanceIdentity")
    def instance_identity(self) -> str:
        """
        The Id of instance.
        """
        return pulumi.get(self, "instance_identity")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The name of instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter
    def mem(self) -> str:
        """
        The memory of instance.
        """
        return pulumi.get(self, "mem")

    @property
    @pulumi.getter
    def network(self) -> 'outputs.InstancesInstanceNetworkResult':
        """
        The config of network.
        """
        return pulumi.get(self, "network")

    @property
    @pulumi.getter
    def spec(self) -> str:
        """
        The spec of instance.
        """
        return pulumi.get(self, "spec")

    @property
    @pulumi.getter(name="specDisplay")
    def spec_display(self) -> str:
        """
        The spec display of instance.
        """
        return pulumi.get(self, "spec_display")

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> int:
        """
        The start time of instance.
        """
        return pulumi.get(self, "start_time")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of instance.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter
    def storage(self) -> 'outputs.InstancesInstanceStorageResult':
        """
        The config of storage.
        """
        return pulumi.get(self, "storage")

    @property
    @pulumi.getter(name="subnetCidr")
    def subnet_cidr(self) -> str:
        """
        The subnet cidr.
        """
        return pulumi.get(self, "subnet_cidr")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> int:
        """
        The update time of instance.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="vpcIdentity")
    def vpc_identity(self) -> str:
        """
        The id of vpc.
        """
        return pulumi.get(self, "vpc_identity")


@pulumi.output_type
class InstancesInstanceClusterResult(dict):
    def __init__(__self__, *,
                 alias: str,
                 city: str,
                 cluster_name: str,
                 country: str,
                 isp: str,
                 level: str,
                 province: str,
                 region: str):
        """
        :param str alias: The alias of cluster.
        :param str city: The city of cluster.
        :param str cluster_name: The name of cluster.
        :param str country: The country of cluster.
        :param str isp: The isp info.
        :param str level: The level of cluster.
        :param str province: The province of cluster.
        :param str region: The region of cluster.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        The alias of cluster.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        The city of cluster.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The name of cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def country(self) -> str:
        """
        The country of cluster.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def isp(self) -> str:
        """
        The isp info.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        The level of cluster.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def province(self) -> str:
        """
        The province of cluster.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of cluster.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class InstancesInstanceGpuResult(dict):
    def __init__(__self__, *,
                 gpuses: Sequence['outputs.InstancesInstanceGpuGpusResult']):
        """
        :param Sequence['InstancesInstanceGpuGpusArgs'] gpuses: The list gpu info.
        """
        pulumi.set(__self__, "gpuses", gpuses)

    @property
    @pulumi.getter
    def gpuses(self) -> Sequence['outputs.InstancesInstanceGpuGpusResult']:
        """
        The list gpu info.
        """
        return pulumi.get(self, "gpuses")


@pulumi.output_type
class InstancesInstanceGpuGpusResult(dict):
    def __init__(__self__, *,
                 gpu_spec: 'outputs.InstancesInstanceGpuGpusGpuSpecResult',
                 num: int):
        """
        :param 'InstancesInstanceGpuGpusGpuSpecArgs' gpu_spec: The spec of gpu.
        :param int num: The number of gpu.
        """
        pulumi.set(__self__, "gpu_spec", gpu_spec)
        pulumi.set(__self__, "num", num)

    @property
    @pulumi.getter(name="gpuSpec")
    def gpu_spec(self) -> 'outputs.InstancesInstanceGpuGpusGpuSpecResult':
        """
        The spec of gpu.
        """
        return pulumi.get(self, "gpu_spec")

    @property
    @pulumi.getter
    def num(self) -> int:
        """
        The number of gpu.
        """
        return pulumi.get(self, "num")


@pulumi.output_type
class InstancesInstanceGpuGpusGpuSpecResult(dict):
    def __init__(__self__, *,
                 gpu_type: str):
        """
        :param str gpu_type: The type of gpu.
        """
        pulumi.set(__self__, "gpu_type", gpu_type)

    @property
    @pulumi.getter(name="gpuType")
    def gpu_type(self) -> str:
        """
        The type of gpu.
        """
        return pulumi.get(self, "gpu_type")


@pulumi.output_type
class InstancesInstanceImageResult(dict):
    def __init__(__self__, *,
                 image_identity: str,
                 image_name: str,
                 property: str,
                 system_arch: str,
                 system_bit: str,
                 system_type: str,
                 system_version: str):
        """
        :param str image_identity: The id of image.
        :param str image_name: The name of image.
        :param str property: The property of system.
        :param str system_arch: The arch of system.
        :param str system_bit: The bit of system.
        :param str system_type: The type of system.
        :param str system_version: The version of system.
        """
        pulumi.set(__self__, "image_identity", image_identity)
        pulumi.set(__self__, "image_name", image_name)
        pulumi.set(__self__, "property", property)
        pulumi.set(__self__, "system_arch", system_arch)
        pulumi.set(__self__, "system_bit", system_bit)
        pulumi.set(__self__, "system_type", system_type)
        pulumi.set(__self__, "system_version", system_version)

    @property
    @pulumi.getter(name="imageIdentity")
    def image_identity(self) -> str:
        """
        The id of image.
        """
        return pulumi.get(self, "image_identity")

    @property
    @pulumi.getter(name="imageName")
    def image_name(self) -> str:
        """
        The name of image.
        """
        return pulumi.get(self, "image_name")

    @property
    @pulumi.getter(name="systemArch")
    def system_arch(self) -> str:
        """
        The arch of system.
        """
        return pulumi.get(self, "system_arch")

    @property
    @pulumi.getter(name="systemBit")
    def system_bit(self) -> str:
        """
        The bit of system.
        """
        return pulumi.get(self, "system_bit")

    @property
    @pulumi.getter(name="systemType")
    def system_type(self) -> str:
        """
        The type of system.
        """
        return pulumi.get(self, "system_type")

    @property
    @pulumi.getter(name="systemVersion")
    def system_version(self) -> str:
        """
        The version of system.
        """
        return pulumi.get(self, "system_version")

    @property
    @pulumi.getter
    def property(self) -> str:
        """
        The property of system.
        """
        return pulumi.get(self, "property")


@pulumi.output_type
class InstancesInstanceNetworkResult(dict):
    def __init__(__self__, *,
                 enable_ipv6: bool,
                 external_interface: 'outputs.InstancesInstanceNetworkExternalInterfaceResult',
                 internal_interface: 'outputs.InstancesInstanceNetworkInternalInterfaceResult',
                 vf_passthrough: bool):
        """
        :param bool enable_ipv6: Whether enable ipv6.
        :param 'InstancesInstanceNetworkExternalInterfaceArgs' external_interface: The external interface of network.
        :param 'InstancesInstanceNetworkInternalInterfaceArgs' internal_interface: The internal interface of network.
        :param bool vf_passthrough: The passthrough info.
        """
        pulumi.set(__self__, "enable_ipv6", enable_ipv6)
        pulumi.set(__self__, "external_interface", external_interface)
        pulumi.set(__self__, "internal_interface", internal_interface)
        pulumi.set(__self__, "vf_passthrough", vf_passthrough)

    @property
    @pulumi.getter(name="enableIpv6")
    def enable_ipv6(self) -> bool:
        """
        Whether enable ipv6.
        """
        return pulumi.get(self, "enable_ipv6")

    @property
    @pulumi.getter(name="externalInterface")
    def external_interface(self) -> 'outputs.InstancesInstanceNetworkExternalInterfaceResult':
        """
        The external interface of network.
        """
        return pulumi.get(self, "external_interface")

    @property
    @pulumi.getter(name="internalInterface")
    def internal_interface(self) -> 'outputs.InstancesInstanceNetworkInternalInterfaceResult':
        """
        The internal interface of network.
        """
        return pulumi.get(self, "internal_interface")

    @property
    @pulumi.getter(name="vfPassthrough")
    def vf_passthrough(self) -> bool:
        """
        The passthrough info.
        """
        return pulumi.get(self, "vf_passthrough")


@pulumi.output_type
class InstancesInstanceNetworkExternalInterfaceResult(dict):
    def __init__(__self__, *,
                 bandwidth_peak: str,
                 ip6_addr: str,
                 ip_addr: str,
                 ips: Sequence['outputs.InstancesInstanceNetworkExternalInterfaceIpResult'],
                 mac_addr: str,
                 mask: str,
                 mask6: str):
        """
        :param str bandwidth_peak: The peak of bandwidth.
        :param str ip6_addr: The ipv6 address.
        :param str ip_addr: The ip address.
        :param Sequence['InstancesInstanceNetworkExternalInterfaceIpArgs'] ips: The ips of network.
        :param str mac_addr: The mac address.
        :param str mask: The mask info.
        :param str mask6: The ipv6 mask info.
        """
        pulumi.set(__self__, "bandwidth_peak", bandwidth_peak)
        pulumi.set(__self__, "ip6_addr", ip6_addr)
        pulumi.set(__self__, "ip_addr", ip_addr)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "mac_addr", mac_addr)
        pulumi.set(__self__, "mask", mask)
        pulumi.set(__self__, "mask6", mask6)

    @property
    @pulumi.getter(name="bandwidthPeak")
    def bandwidth_peak(self) -> str:
        """
        The peak of bandwidth.
        """
        return pulumi.get(self, "bandwidth_peak")

    @property
    @pulumi.getter(name="ip6Addr")
    def ip6_addr(self) -> str:
        """
        The ipv6 address.
        """
        return pulumi.get(self, "ip6_addr")

    @property
    @pulumi.getter(name="ipAddr")
    def ip_addr(self) -> str:
        """
        The ip address.
        """
        return pulumi.get(self, "ip_addr")

    @property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.InstancesInstanceNetworkExternalInterfaceIpResult']:
        """
        The ips of network.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="macAddr")
    def mac_addr(self) -> str:
        """
        The mac address.
        """
        return pulumi.get(self, "mac_addr")

    @property
    @pulumi.getter
    def mask(self) -> str:
        """
        The mask info.
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter
    def mask6(self) -> str:
        """
        The ipv6 mask info.
        """
        return pulumi.get(self, "mask6")


@pulumi.output_type
class InstancesInstanceNetworkExternalInterfaceIpResult(dict):
    def __init__(__self__, *,
                 addr: str,
                 ip_version: str,
                 isp: str,
                 mask: str):
        """
        :param str addr: The ip address.
        :param str ip_version: The version of ip address.
        :param str isp: The isp info.
        :param str mask: The mask info.
        """
        pulumi.set(__self__, "addr", addr)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "mask", mask)

    @property
    @pulumi.getter
    def addr(self) -> str:
        """
        The ip address.
        """
        return pulumi.get(self, "addr")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> str:
        """
        The version of ip address.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def isp(self) -> str:
        """
        The isp info.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def mask(self) -> str:
        """
        The mask info.
        """
        return pulumi.get(self, "mask")


@pulumi.output_type
class InstancesInstanceNetworkInternalInterfaceResult(dict):
    def __init__(__self__, *,
                 bandwidth_peak: str,
                 ip6_addr: str,
                 ip_addr: str,
                 ips: Sequence['outputs.InstancesInstanceNetworkInternalInterfaceIpResult'],
                 mac_addr: str,
                 mask: str,
                 mask6: str):
        """
        :param str bandwidth_peak: The peak of bandwidth.
        :param str ip6_addr: The ipv6 address.
        :param str ip_addr: The ip address.
        :param Sequence['InstancesInstanceNetworkInternalInterfaceIpArgs'] ips: The ips of network.
        :param str mac_addr: The mac address.
        :param str mask: The mask info.
        :param str mask6: The ipv6 mask info.
        """
        pulumi.set(__self__, "bandwidth_peak", bandwidth_peak)
        pulumi.set(__self__, "ip6_addr", ip6_addr)
        pulumi.set(__self__, "ip_addr", ip_addr)
        pulumi.set(__self__, "ips", ips)
        pulumi.set(__self__, "mac_addr", mac_addr)
        pulumi.set(__self__, "mask", mask)
        pulumi.set(__self__, "mask6", mask6)

    @property
    @pulumi.getter(name="bandwidthPeak")
    def bandwidth_peak(self) -> str:
        """
        The peak of bandwidth.
        """
        return pulumi.get(self, "bandwidth_peak")

    @property
    @pulumi.getter(name="ip6Addr")
    def ip6_addr(self) -> str:
        """
        The ipv6 address.
        """
        return pulumi.get(self, "ip6_addr")

    @property
    @pulumi.getter(name="ipAddr")
    def ip_addr(self) -> str:
        """
        The ip address.
        """
        return pulumi.get(self, "ip_addr")

    @property
    @pulumi.getter
    def ips(self) -> Sequence['outputs.InstancesInstanceNetworkInternalInterfaceIpResult']:
        """
        The ips of network.
        """
        return pulumi.get(self, "ips")

    @property
    @pulumi.getter(name="macAddr")
    def mac_addr(self) -> str:
        """
        The mac address.
        """
        return pulumi.get(self, "mac_addr")

    @property
    @pulumi.getter
    def mask(self) -> str:
        """
        The mask info.
        """
        return pulumi.get(self, "mask")

    @property
    @pulumi.getter
    def mask6(self) -> str:
        """
        The ipv6 mask info.
        """
        return pulumi.get(self, "mask6")


@pulumi.output_type
class InstancesInstanceNetworkInternalInterfaceIpResult(dict):
    def __init__(__self__, *,
                 addr: str,
                 ip_version: str,
                 isp: str,
                 mask: str):
        """
        :param str addr: The ip address.
        :param str ip_version: The version of ip address.
        :param str isp: The isp info.
        :param str mask: The mask info.
        """
        pulumi.set(__self__, "addr", addr)
        pulumi.set(__self__, "ip_version", ip_version)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "mask", mask)

    @property
    @pulumi.getter
    def addr(self) -> str:
        """
        The ip address.
        """
        return pulumi.get(self, "addr")

    @property
    @pulumi.getter(name="ipVersion")
    def ip_version(self) -> str:
        """
        The version of ip address.
        """
        return pulumi.get(self, "ip_version")

    @property
    @pulumi.getter
    def isp(self) -> str:
        """
        The isp info.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def mask(self) -> str:
        """
        The mask info.
        """
        return pulumi.get(self, "mask")


@pulumi.output_type
class InstancesInstanceStorageResult(dict):
    def __init__(__self__, *,
                 data_disk: 'outputs.InstancesInstanceStorageDataDiskResult',
                 data_disk_lists: Sequence['outputs.InstancesInstanceStorageDataDiskListResult'],
                 system_disk: 'outputs.InstancesInstanceStorageSystemDiskResult'):
        """
        :param 'InstancesInstanceStorageDataDiskArgs' data_disk: The disk info of data.
        :param Sequence['InstancesInstanceStorageDataDiskListArgs'] data_disk_lists: The disk list info of data.
        :param 'InstancesInstanceStorageSystemDiskArgs' system_disk: The disk info of system.
        """
        pulumi.set(__self__, "data_disk", data_disk)
        pulumi.set(__self__, "data_disk_lists", data_disk_lists)
        pulumi.set(__self__, "system_disk", system_disk)

    @property
    @pulumi.getter(name="dataDisk")
    def data_disk(self) -> 'outputs.InstancesInstanceStorageDataDiskResult':
        """
        The disk info of data.
        """
        return pulumi.get(self, "data_disk")

    @property
    @pulumi.getter(name="dataDiskLists")
    def data_disk_lists(self) -> Sequence['outputs.InstancesInstanceStorageDataDiskListResult']:
        """
        The disk list info of data.
        """
        return pulumi.get(self, "data_disk_lists")

    @property
    @pulumi.getter(name="systemDisk")
    def system_disk(self) -> 'outputs.InstancesInstanceStorageSystemDiskResult':
        """
        The disk info of system.
        """
        return pulumi.get(self, "system_disk")


@pulumi.output_type
class InstancesInstanceStorageDataDiskResult(dict):
    def __init__(__self__, *,
                 capacity: str,
                 storage_type: str):
        """
        :param str capacity: The capacity of storage.
        :param str storage_type: The type of storage.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def capacity(self) -> str:
        """
        The capacity of storage.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The type of storage.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class InstancesInstanceStorageDataDiskListResult(dict):
    def __init__(__self__, *,
                 capacity: str,
                 storage_type: str):
        """
        :param str capacity: The capacity of storage.
        :param str storage_type: The type of storage.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def capacity(self) -> str:
        """
        The capacity of storage.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The type of storage.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class InstancesInstanceStorageSystemDiskResult(dict):
    def __init__(__self__, *,
                 capacity: str,
                 storage_type: str):
        """
        :param str capacity: The capacity of storage.
        :param str storage_type: The type of storage.
        """
        pulumi.set(__self__, "capacity", capacity)
        pulumi.set(__self__, "storage_type", storage_type)

    @property
    @pulumi.getter
    def capacity(self) -> str:
        """
        The capacity of storage.
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="storageType")
    def storage_type(self) -> str:
        """
        The type of storage.
        """
        return pulumi.get(self, "storage_type")


@pulumi.output_type
class VpcsVpcInstanceResult(dict):
    def __init__(__self__, *,
                 account_identity: int,
                 cluster: 'outputs.VpcsVpcInstanceClusterResult',
                 cluster_vpc_id: int,
                 create_time: int,
                 desc: str,
                 id: str,
                 is_default: bool,
                 resource_statistics: Sequence['outputs.VpcsVpcInstanceResourceStatisticResult'],
                 status: str,
                 sub_nets: Sequence['outputs.VpcsVpcInstanceSubNetResult'],
                 update_time: int,
                 user_identity: int,
                 vpc_identity: str,
                 vpc_name: str,
                 vpc_ns: str):
        """
        :param int account_identity: The account id.
        :param 'VpcsVpcInstanceClusterArgs' cluster: The cluster info.
        :param int cluster_vpc_id: The cluster vpc id.
        :param int create_time: The creation time.
        :param str desc: The description of VPC.
        :param str id: The ID of VPC.
        :param bool is_default: Is default vpc.
        :param Sequence['VpcsVpcInstanceResourceStatisticArgs'] resource_statistics: The resource statistic info.
        :param str status: The status of VPC.
        :param Sequence['VpcsVpcInstanceSubNetArgs'] sub_nets: The subnets info.
        :param int update_time: The update time of VPC.
        :param int user_identity: The id of user.
        :param str vpc_identity: The ID of VPC.
        :param str vpc_name: The name of VPC.
        :param str vpc_ns: The namespace of VPC.
        """
        pulumi.set(__self__, "account_identity", account_identity)
        pulumi.set(__self__, "cluster", cluster)
        pulumi.set(__self__, "cluster_vpc_id", cluster_vpc_id)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "desc", desc)
        pulumi.set(__self__, "id", id)
        pulumi.set(__self__, "is_default", is_default)
        pulumi.set(__self__, "resource_statistics", resource_statistics)
        pulumi.set(__self__, "status", status)
        pulumi.set(__self__, "sub_nets", sub_nets)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "user_identity", user_identity)
        pulumi.set(__self__, "vpc_identity", vpc_identity)
        pulumi.set(__self__, "vpc_name", vpc_name)
        pulumi.set(__self__, "vpc_ns", vpc_ns)

    @property
    @pulumi.getter(name="accountIdentity")
    def account_identity(self) -> int:
        """
        The account id.
        """
        return pulumi.get(self, "account_identity")

    @property
    @pulumi.getter
    def cluster(self) -> 'outputs.VpcsVpcInstanceClusterResult':
        """
        The cluster info.
        """
        return pulumi.get(self, "cluster")

    @property
    @pulumi.getter(name="clusterVpcId")
    def cluster_vpc_id(self) -> int:
        """
        The cluster vpc id.
        """
        return pulumi.get(self, "cluster_vpc_id")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> int:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def desc(self) -> str:
        """
        The description of VPC.
        """
        return pulumi.get(self, "desc")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ID of VPC.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Is default vpc.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="resourceStatistics")
    def resource_statistics(self) -> Sequence['outputs.VpcsVpcInstanceResourceStatisticResult']:
        """
        The resource statistic info.
        """
        return pulumi.get(self, "resource_statistics")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of VPC.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subNets")
    def sub_nets(self) -> Sequence['outputs.VpcsVpcInstanceSubNetResult']:
        """
        The subnets info.
        """
        return pulumi.get(self, "sub_nets")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> int:
        """
        The update time of VPC.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="userIdentity")
    def user_identity(self) -> int:
        """
        The id of user.
        """
        return pulumi.get(self, "user_identity")

    @property
    @pulumi.getter(name="vpcIdentity")
    def vpc_identity(self) -> str:
        """
        The ID of VPC.
        """
        return pulumi.get(self, "vpc_identity")

    @property
    @pulumi.getter(name="vpcName")
    def vpc_name(self) -> str:
        """
        The name of VPC.
        """
        return pulumi.get(self, "vpc_name")

    @property
    @pulumi.getter(name="vpcNs")
    def vpc_ns(self) -> str:
        """
        The namespace of VPC.
        """
        return pulumi.get(self, "vpc_ns")


@pulumi.output_type
class VpcsVpcInstanceClusterResult(dict):
    def __init__(__self__, *,
                 alias: str,
                 city: str,
                 cluster_name: str,
                 country: str,
                 isp: str,
                 level: str,
                 province: str,
                 region: str):
        """
        :param str alias: The alias of cluster.
        :param str city: The city of cluster.
        :param str cluster_name: The name of cluster.
        :param str country: The country of cluster.
        :param str isp: The isp of cluster.
        :param str level: The level of cluster.
        :param str province: The province of cluster.
        :param str region: The region of cluster.
        """
        pulumi.set(__self__, "alias", alias)
        pulumi.set(__self__, "city", city)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "country", country)
        pulumi.set(__self__, "isp", isp)
        pulumi.set(__self__, "level", level)
        pulumi.set(__self__, "province", province)
        pulumi.set(__self__, "region", region)

    @property
    @pulumi.getter
    def alias(self) -> str:
        """
        The alias of cluster.
        """
        return pulumi.get(self, "alias")

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        The city of cluster.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The name of cluster.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def country(self) -> str:
        """
        The country of cluster.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def isp(self) -> str:
        """
        The isp of cluster.
        """
        return pulumi.get(self, "isp")

    @property
    @pulumi.getter
    def level(self) -> str:
        """
        The level of cluster.
        """
        return pulumi.get(self, "level")

    @property
    @pulumi.getter
    def province(self) -> str:
        """
        The province of cluster.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        The region of cluster.
        """
        return pulumi.get(self, "region")


@pulumi.output_type
class VpcsVpcInstanceResourceStatisticResult(dict):
    def __init__(__self__, *,
                 veen_instance_count: int,
                 veew_lb_instance_count: int,
                 veew_sg_instance_count: int):
        """
        :param int veen_instance_count: The count of instance.
        :param int veew_lb_instance_count: The count of load balancers.
        :param int veew_sg_instance_count: The count of security groups.
        """
        pulumi.set(__self__, "veen_instance_count", veen_instance_count)
        pulumi.set(__self__, "veew_lb_instance_count", veew_lb_instance_count)
        pulumi.set(__self__, "veew_sg_instance_count", veew_sg_instance_count)

    @property
    @pulumi.getter(name="veenInstanceCount")
    def veen_instance_count(self) -> int:
        """
        The count of instance.
        """
        return pulumi.get(self, "veen_instance_count")

    @property
    @pulumi.getter(name="veewLbInstanceCount")
    def veew_lb_instance_count(self) -> int:
        """
        The count of load balancers.
        """
        return pulumi.get(self, "veew_lb_instance_count")

    @property
    @pulumi.getter(name="veewSgInstanceCount")
    def veew_sg_instance_count(self) -> int:
        """
        The count of security groups.
        """
        return pulumi.get(self, "veew_sg_instance_count")


@pulumi.output_type
class VpcsVpcInstanceSubNetResult(dict):
    def __init__(__self__, *,
                 account_identity: int,
                 cidr_ip: str,
                 cidr_mask: int,
                 create_time: int,
                 subnet_identity: str,
                 update_time: int,
                 user_identity: int):
        """
        :param int account_identity: The account id.
        :param str cidr_ip: The ip of cidr.
        :param int cidr_mask: The mask of cidr.
        :param int create_time: The creation time.
        :param str subnet_identity: The id of subnet.
        :param int update_time: The update time of VPC.
        :param int user_identity: The id of user.
        """
        pulumi.set(__self__, "account_identity", account_identity)
        pulumi.set(__self__, "cidr_ip", cidr_ip)
        pulumi.set(__self__, "cidr_mask", cidr_mask)
        pulumi.set(__self__, "create_time", create_time)
        pulumi.set(__self__, "subnet_identity", subnet_identity)
        pulumi.set(__self__, "update_time", update_time)
        pulumi.set(__self__, "user_identity", user_identity)

    @property
    @pulumi.getter(name="accountIdentity")
    def account_identity(self) -> int:
        """
        The account id.
        """
        return pulumi.get(self, "account_identity")

    @property
    @pulumi.getter(name="cidrIp")
    def cidr_ip(self) -> str:
        """
        The ip of cidr.
        """
        return pulumi.get(self, "cidr_ip")

    @property
    @pulumi.getter(name="cidrMask")
    def cidr_mask(self) -> int:
        """
        The mask of cidr.
        """
        return pulumi.get(self, "cidr_mask")

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> int:
        """
        The creation time.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter(name="subnetIdentity")
    def subnet_identity(self) -> str:
        """
        The id of subnet.
        """
        return pulumi.get(self, "subnet_identity")

    @property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> int:
        """
        The update time of VPC.
        """
        return pulumi.get(self, "update_time")

    @property
    @pulumi.getter(name="userIdentity")
    def user_identity(self) -> int:
        """
        The id of user.
        """
        return pulumi.get(self, "user_identity")


