# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'AddonsResult',
    'AwaitableAddonsResult',
    'addons',
    'addons_output',
]

@pulumi.output_type
class AddonsResult:
    """
    A collection of values returned by Addons.
    """
    def __init__(__self__, addons=None, cluster_ids=None, create_client_token=None, deploy_modes=None, deploy_node_types=None, id=None, name_regex=None, names=None, output_file=None, statuses=None, total_count=None, update_client_token=None):
        if addons and not isinstance(addons, list):
            raise TypeError("Expected argument 'addons' to be a list")
        pulumi.set(__self__, "addons", addons)
        if cluster_ids and not isinstance(cluster_ids, list):
            raise TypeError("Expected argument 'cluster_ids' to be a list")
        pulumi.set(__self__, "cluster_ids", cluster_ids)
        if create_client_token and not isinstance(create_client_token, str):
            raise TypeError("Expected argument 'create_client_token' to be a str")
        pulumi.set(__self__, "create_client_token", create_client_token)
        if deploy_modes and not isinstance(deploy_modes, list):
            raise TypeError("Expected argument 'deploy_modes' to be a list")
        pulumi.set(__self__, "deploy_modes", deploy_modes)
        if deploy_node_types and not isinstance(deploy_node_types, list):
            raise TypeError("Expected argument 'deploy_node_types' to be a list")
        pulumi.set(__self__, "deploy_node_types", deploy_node_types)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if names and not isinstance(names, list):
            raise TypeError("Expected argument 'names' to be a list")
        pulumi.set(__self__, "names", names)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if update_client_token and not isinstance(update_client_token, str):
            raise TypeError("Expected argument 'update_client_token' to be a str")
        pulumi.set(__self__, "update_client_token", update_client_token)

    @property
    @pulumi.getter
    def addons(self) -> Sequence['outputs.AddonsAddonResult']:
        """
        The collection of addon query.
        """
        return pulumi.get(self, "addons")

    @property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cluster_ids")

    @property
    @pulumi.getter(name="createClientToken")
    def create_client_token(self) -> Optional[str]:
        return pulumi.get(self, "create_client_token")

    @property
    @pulumi.getter(name="deployModes")
    def deploy_modes(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "deploy_modes")

    @property
    @pulumi.getter(name="deployNodeTypes")
    def deploy_node_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "deploy_node_types")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter
    def names(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "names")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.AddonsStatusResult']]:
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of addon query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="updateClientToken")
    def update_client_token(self) -> Optional[str]:
        return pulumi.get(self, "update_client_token")


class AwaitableAddonsResult(AddonsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return AddonsResult(
            addons=self.addons,
            cluster_ids=self.cluster_ids,
            create_client_token=self.create_client_token,
            deploy_modes=self.deploy_modes,
            deploy_node_types=self.deploy_node_types,
            id=self.id,
            name_regex=self.name_regex,
            names=self.names,
            output_file=self.output_file,
            statuses=self.statuses,
            total_count=self.total_count,
            update_client_token=self.update_client_token)


def addons(cluster_ids: Optional[Sequence[str]] = None,
           create_client_token: Optional[str] = None,
           deploy_modes: Optional[Sequence[str]] = None,
           deploy_node_types: Optional[Sequence[str]] = None,
           name_regex: Optional[str] = None,
           names: Optional[Sequence[str]] = None,
           output_file: Optional[str] = None,
           statuses: Optional[Sequence[pulumi.InputType['AddonsStatusArgs']]] = None,
           update_client_token: Optional[str] = None,
           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableAddonsResult:
    """
    Use this data source to query detailed information of vke addons
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vke.addons(cluster_ids=["cccctv1vqtofp49d96ujg"])
    ```


    :param Sequence[str] cluster_ids: The IDs of Cluster.
    :param str create_client_token: ClientToken when the addon is created successfully. ClientToken is a string that guarantees the idempotency of the request. This string is passed in by the caller.
    :param Sequence[str] deploy_modes: The deploy model, the value is `Managed` or `Unmanaged`.
    :param Sequence[str] deploy_node_types: The deploy node types, the value is `Node` or `VirtualNode`. Only effected when deploy_mode is `Unmanaged`.
    :param str name_regex: A Name Regex of addon.
    :param Sequence[str] names: The Names of addons.
    :param str output_file: File name where to save data source results.
    :param Sequence[pulumi.InputType['AddonsStatusArgs']] statuses: Array of addon states to filter.
    :param str update_client_token: The ClientToken when the last addon update succeeded. ClientToken is a string that guarantees the idempotency of the request. This string is passed in by the caller.
    """
    __args__ = dict()
    __args__['clusterIds'] = cluster_ids
    __args__['createClientToken'] = create_client_token
    __args__['deployModes'] = deploy_modes
    __args__['deployNodeTypes'] = deploy_node_types
    __args__['nameRegex'] = name_regex
    __args__['names'] = names
    __args__['outputFile'] = output_file
    __args__['statuses'] = statuses
    __args__['updateClientToken'] = update_client_token
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vke/addons:Addons', __args__, opts=opts, typ=AddonsResult).value

    return AwaitableAddonsResult(
        addons=pulumi.get(__ret__, 'addons'),
        cluster_ids=pulumi.get(__ret__, 'cluster_ids'),
        create_client_token=pulumi.get(__ret__, 'create_client_token'),
        deploy_modes=pulumi.get(__ret__, 'deploy_modes'),
        deploy_node_types=pulumi.get(__ret__, 'deploy_node_types'),
        id=pulumi.get(__ret__, 'id'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        names=pulumi.get(__ret__, 'names'),
        output_file=pulumi.get(__ret__, 'output_file'),
        statuses=pulumi.get(__ret__, 'statuses'),
        total_count=pulumi.get(__ret__, 'total_count'),
        update_client_token=pulumi.get(__ret__, 'update_client_token'))


@_utilities.lift_output_func(addons)
def addons_output(cluster_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                  create_client_token: Optional[pulumi.Input[Optional[str]]] = None,
                  deploy_modes: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                  deploy_node_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                  name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                  names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                  output_file: Optional[pulumi.Input[Optional[str]]] = None,
                  statuses: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['AddonsStatusArgs']]]]] = None,
                  update_client_token: Optional[pulumi.Input[Optional[str]]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[AddonsResult]:
    """
    Use this data source to query detailed information of vke addons
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vke.addons(cluster_ids=["cccctv1vqtofp49d96ujg"])
    ```


    :param Sequence[str] cluster_ids: The IDs of Cluster.
    :param str create_client_token: ClientToken when the addon is created successfully. ClientToken is a string that guarantees the idempotency of the request. This string is passed in by the caller.
    :param Sequence[str] deploy_modes: The deploy model, the value is `Managed` or `Unmanaged`.
    :param Sequence[str] deploy_node_types: The deploy node types, the value is `Node` or `VirtualNode`. Only effected when deploy_mode is `Unmanaged`.
    :param str name_regex: A Name Regex of addon.
    :param Sequence[str] names: The Names of addons.
    :param str output_file: File name where to save data source results.
    :param Sequence[pulumi.InputType['AddonsStatusArgs']] statuses: Array of addon states to filter.
    :param str update_client_token: The ClientToken when the last addon update succeeded. ClientToken is a string that guarantees the idempotency of the request. This string is passed in by the caller.
    """
    ...
