# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ClusterArgs', 'Cluster']

@pulumi.input_type
class ClusterArgs:
    def __init__(__self__, *,
                 cluster_config: pulumi.Input['ClusterClusterConfigArgs'],
                 pods_config: pulumi.Input['ClusterPodsConfigArgs'],
                 services_config: pulumi.Input['ClusterServicesConfigArgs'],
                 client_token: Optional[pulumi.Input[str]] = None,
                 delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input['ClusterLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]] = None):
        """
        The set of arguments for constructing a Cluster resource.
        :param pulumi.Input['ClusterClusterConfigArgs'] cluster_config: The config of the cluster.
        :param pulumi.Input['ClusterPodsConfigArgs'] pods_config: The config of the pods.
        :param pulumi.Input['ClusterServicesConfigArgs'] services_config: The config of the services.
        :param pulumi.Input[str] client_token: ClientToken is a case-sensitive string of no more than 64 ASCII characters passed in by the caller.
        :param pulumi.Input[bool] delete_protection_enabled: The delete protection of the cluster, the value is `true` or `false`.
        :param pulumi.Input[str] description: The description of the cluster.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes specified when creating a VKE cluster (specified to patch version), if not specified, the latest Kubernetes version supported by VKE is used by default, which is a 3-segment version format starting with a lowercase v, that is, KubernetesVersion with IsLatestVersion=True in the return value of ListSupportedVersions.
        :param pulumi.Input['ClusterLoggingConfigArgs'] logging_config: Cluster log configuration information.
        :param pulumi.Input[str] name: The name of the cluster.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]] tags: Tags.
        """
        pulumi.set(__self__, "cluster_config", cluster_config)
        pulumi.set(__self__, "pods_config", pods_config)
        pulumi.set(__self__, "services_config", services_config)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if delete_protection_enabled is not None:
            pulumi.set(__self__, "delete_protection_enabled", delete_protection_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> pulumi.Input['ClusterClusterConfigArgs']:
        """
        The config of the cluster.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: pulumi.Input['ClusterClusterConfigArgs']):
        pulumi.set(self, "cluster_config", value)

    @property
    @pulumi.getter(name="podsConfig")
    def pods_config(self) -> pulumi.Input['ClusterPodsConfigArgs']:
        """
        The config of the pods.
        """
        return pulumi.get(self, "pods_config")

    @pods_config.setter
    def pods_config(self, value: pulumi.Input['ClusterPodsConfigArgs']):
        pulumi.set(self, "pods_config", value)

    @property
    @pulumi.getter(name="servicesConfig")
    def services_config(self) -> pulumi.Input['ClusterServicesConfigArgs']:
        """
        The config of the services.
        """
        return pulumi.get(self, "services_config")

    @services_config.setter
    def services_config(self, value: pulumi.Input['ClusterServicesConfigArgs']):
        pulumi.set(self, "services_config", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[str]]:
        """
        ClientToken is a case-sensitive string of no more than 64 ASCII characters passed in by the caller.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="deleteProtectionEnabled")
    def delete_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The delete protection of the cluster, the value is `true` or `false`.
        """
        return pulumi.get(self, "delete_protection_enabled")

    @delete_protection_enabled.setter
    def delete_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_protection_enabled", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of Kubernetes specified when creating a VKE cluster (specified to patch version), if not specified, the latest Kubernetes version supported by VKE is used by default, which is a 3-segment version format starting with a lowercase v, that is, KubernetesVersion with IsLatestVersion=True in the return value of ListSupportedVersions.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['ClusterLoggingConfigArgs']]:
        """
        Cluster log configuration information.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['ClusterLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _ClusterState:
    def __init__(__self__, *,
                 client_token: Optional[pulumi.Input[str]] = None,
                 cluster_config: Optional[pulumi.Input['ClusterClusterConfigArgs']] = None,
                 delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 eip_allocation_id: Optional[pulumi.Input[str]] = None,
                 kubeconfig_private: Optional[pulumi.Input[str]] = None,
                 kubeconfig_public: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input['ClusterLoggingConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pods_config: Optional[pulumi.Input['ClusterPodsConfigArgs']] = None,
                 services_config: Optional[pulumi.Input['ClusterServicesConfigArgs']] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering Cluster resources.
        :param pulumi.Input[str] client_token: ClientToken is a case-sensitive string of no more than 64 ASCII characters passed in by the caller.
        :param pulumi.Input['ClusterClusterConfigArgs'] cluster_config: The config of the cluster.
        :param pulumi.Input[bool] delete_protection_enabled: The delete protection of the cluster, the value is `true` or `false`.
        :param pulumi.Input[str] description: The description of the cluster.
        :param pulumi.Input[str] eip_allocation_id: Eip allocation Id.
        :param pulumi.Input[str] kubeconfig_private: Kubeconfig data with private network access, returned in BASE64 encoding, it is suggested to use vke_kubeconfig instead.
        :param pulumi.Input[str] kubeconfig_public: Kubeconfig data with public network access, returned in BASE64 encoding, it is suggested to use vke_kubeconfig instead.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes specified when creating a VKE cluster (specified to patch version), if not specified, the latest Kubernetes version supported by VKE is used by default, which is a 3-segment version format starting with a lowercase v, that is, KubernetesVersion with IsLatestVersion=True in the return value of ListSupportedVersions.
        :param pulumi.Input['ClusterLoggingConfigArgs'] logging_config: Cluster log configuration information.
        :param pulumi.Input[str] name: The name of the cluster.
        :param pulumi.Input['ClusterPodsConfigArgs'] pods_config: The config of the pods.
        :param pulumi.Input['ClusterServicesConfigArgs'] services_config: The config of the services.
        :param pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]] tags: Tags.
        """
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if cluster_config is not None:
            pulumi.set(__self__, "cluster_config", cluster_config)
        if delete_protection_enabled is not None:
            pulumi.set(__self__, "delete_protection_enabled", delete_protection_enabled)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if eip_allocation_id is not None:
            pulumi.set(__self__, "eip_allocation_id", eip_allocation_id)
        if kubeconfig_private is not None:
            pulumi.set(__self__, "kubeconfig_private", kubeconfig_private)
        if kubeconfig_public is not None:
            pulumi.set(__self__, "kubeconfig_public", kubeconfig_public)
        if kubernetes_version is not None:
            pulumi.set(__self__, "kubernetes_version", kubernetes_version)
        if logging_config is not None:
            pulumi.set(__self__, "logging_config", logging_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if pods_config is not None:
            pulumi.set(__self__, "pods_config", pods_config)
        if services_config is not None:
            pulumi.set(__self__, "services_config", services_config)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[str]]:
        """
        ClientToken is a case-sensitive string of no more than 64 ASCII characters passed in by the caller.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> Optional[pulumi.Input['ClusterClusterConfigArgs']]:
        """
        The config of the cluster.
        """
        return pulumi.get(self, "cluster_config")

    @cluster_config.setter
    def cluster_config(self, value: Optional[pulumi.Input['ClusterClusterConfigArgs']]):
        pulumi.set(self, "cluster_config", value)

    @property
    @pulumi.getter(name="deleteProtectionEnabled")
    def delete_protection_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The delete protection of the cluster, the value is `true` or `false`.
        """
        return pulumi.get(self, "delete_protection_enabled")

    @delete_protection_enabled.setter
    def delete_protection_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "delete_protection_enabled", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="eipAllocationId")
    def eip_allocation_id(self) -> Optional[pulumi.Input[str]]:
        """
        Eip allocation Id.
        """
        return pulumi.get(self, "eip_allocation_id")

    @eip_allocation_id.setter
    def eip_allocation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eip_allocation_id", value)

    @property
    @pulumi.getter(name="kubeconfigPrivate")
    def kubeconfig_private(self) -> Optional[pulumi.Input[str]]:
        """
        Kubeconfig data with private network access, returned in BASE64 encoding, it is suggested to use vke_kubeconfig instead.
        """
        return pulumi.get(self, "kubeconfig_private")

    @kubeconfig_private.setter
    def kubeconfig_private(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubeconfig_private", value)

    @property
    @pulumi.getter(name="kubeconfigPublic")
    def kubeconfig_public(self) -> Optional[pulumi.Input[str]]:
        """
        Kubeconfig data with public network access, returned in BASE64 encoding, it is suggested to use vke_kubeconfig instead.
        """
        return pulumi.get(self, "kubeconfig_public")

    @kubeconfig_public.setter
    def kubeconfig_public(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubeconfig_public", value)

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of Kubernetes specified when creating a VKE cluster (specified to patch version), if not specified, the latest Kubernetes version supported by VKE is used by default, which is a 3-segment version format starting with a lowercase v, that is, KubernetesVersion with IsLatestVersion=True in the return value of ListSupportedVersions.
        """
        return pulumi.get(self, "kubernetes_version")

    @kubernetes_version.setter
    def kubernetes_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kubernetes_version", value)

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> Optional[pulumi.Input['ClusterLoggingConfigArgs']]:
        """
        Cluster log configuration information.
        """
        return pulumi.get(self, "logging_config")

    @logging_config.setter
    def logging_config(self, value: Optional[pulumi.Input['ClusterLoggingConfigArgs']]):
        pulumi.set(self, "logging_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="podsConfig")
    def pods_config(self) -> Optional[pulumi.Input['ClusterPodsConfigArgs']]:
        """
        The config of the pods.
        """
        return pulumi.get(self, "pods_config")

    @pods_config.setter
    def pods_config(self, value: Optional[pulumi.Input['ClusterPodsConfigArgs']]):
        pulumi.set(self, "pods_config", value)

    @property
    @pulumi.getter(name="servicesConfig")
    def services_config(self) -> Optional[pulumi.Input['ClusterServicesConfigArgs']]:
        """
        The config of the services.
        """
        return pulumi.get(self, "services_config")

    @services_config.setter
    def services_config(self, value: Optional[pulumi.Input['ClusterServicesConfigArgs']]):
        pulumi.set(self, "services_config", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ClusterTagArgs']]]]):
        pulumi.set(self, "tags", value)


class Cluster(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 cluster_config: Optional[pulumi.Input[pulumi.InputType['ClusterClusterConfigArgs']]] = None,
                 delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input[pulumi.InputType['ClusterLoggingConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pods_config: Optional[pulumi.Input[pulumi.InputType['ClusterPodsConfigArgs']]] = None,
                 services_config: Optional[pulumi.Input[pulumi.InputType['ClusterServicesConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterTagArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage vke cluster
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-project1",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-subnet-test-2",
            cidr_block="172.16.0.0/24",
            zone_id="cn-beijing-a",
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            vpc_id=foo_vpc.id,
            security_group_name="acc-test-security-group2")
        foo_instance = volcengine.ecs.Instance("fooInstance",
            image_id="image-ybqi99s7yq8rx7mnk44b",
            instance_type="ecs.g1ie.large",
            instance_name="acc-test-ecs-name2",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id])
        foo_cluster = volcengine.vke.Cluster("fooCluster",
            description="created by terraform",
            delete_protection_enabled=False,
            cluster_config=volcengine.vke.ClusterClusterConfigArgs(
                subnet_ids=[foo_subnet.id],
                api_server_public_access_enabled=True,
                api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                    public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                        billing_type="PostPaidByBandwidth",
                        bandwidth=1,
                    ),
                ),
                resource_public_access_default_enabled=True,
            ),
            pods_config=volcengine.vke.ClusterPodsConfigArgs(
                pod_network_mode="VpcCniShared",
                vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                    subnet_ids=[foo_subnet.id],
                ),
            ),
            services_config=volcengine.vke.ClusterServicesConfigArgs(
                service_cidrsv4s=["172.30.0.0/18"],
            ),
            tags=[volcengine.vke.ClusterTagArgs(
                key="tf-k1",
                value="tf-v1",
            )])
        ```

        ## Import

        VkeCluster can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vke/cluster:Cluster default cc9l74mvqtofjnoj5****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_token: ClientToken is a case-sensitive string of no more than 64 ASCII characters passed in by the caller.
        :param pulumi.Input[pulumi.InputType['ClusterClusterConfigArgs']] cluster_config: The config of the cluster.
        :param pulumi.Input[bool] delete_protection_enabled: The delete protection of the cluster, the value is `true` or `false`.
        :param pulumi.Input[str] description: The description of the cluster.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes specified when creating a VKE cluster (specified to patch version), if not specified, the latest Kubernetes version supported by VKE is used by default, which is a 3-segment version format starting with a lowercase v, that is, KubernetesVersion with IsLatestVersion=True in the return value of ListSupportedVersions.
        :param pulumi.Input[pulumi.InputType['ClusterLoggingConfigArgs']] logging_config: Cluster log configuration information.
        :param pulumi.Input[str] name: The name of the cluster.
        :param pulumi.Input[pulumi.InputType['ClusterPodsConfigArgs']] pods_config: The config of the pods.
        :param pulumi.Input[pulumi.InputType['ClusterServicesConfigArgs']] services_config: The config of the services.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterTagArgs']]]] tags: Tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ClusterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage vke cluster
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-project1",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-subnet-test-2",
            cidr_block="172.16.0.0/24",
            zone_id="cn-beijing-a",
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            vpc_id=foo_vpc.id,
            security_group_name="acc-test-security-group2")
        foo_instance = volcengine.ecs.Instance("fooInstance",
            image_id="image-ybqi99s7yq8rx7mnk44b",
            instance_type="ecs.g1ie.large",
            instance_name="acc-test-ecs-name2",
            password="93f0cb0614Aab12",
            instance_charge_type="PostPaid",
            system_volume_type="ESSD_PL0",
            system_volume_size=40,
            subnet_id=foo_subnet.id,
            security_group_ids=[foo_security_group.id])
        foo_cluster = volcengine.vke.Cluster("fooCluster",
            description="created by terraform",
            delete_protection_enabled=False,
            cluster_config=volcengine.vke.ClusterClusterConfigArgs(
                subnet_ids=[foo_subnet.id],
                api_server_public_access_enabled=True,
                api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                    public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                        billing_type="PostPaidByBandwidth",
                        bandwidth=1,
                    ),
                ),
                resource_public_access_default_enabled=True,
            ),
            pods_config=volcengine.vke.ClusterPodsConfigArgs(
                pod_network_mode="VpcCniShared",
                vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                    subnet_ids=[foo_subnet.id],
                ),
            ),
            services_config=volcengine.vke.ClusterServicesConfigArgs(
                service_cidrsv4s=["172.30.0.0/18"],
            ),
            tags=[volcengine.vke.ClusterTagArgs(
                key="tf-k1",
                value="tf-v1",
            )])
        ```

        ## Import

        VkeCluster can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vke/cluster:Cluster default cc9l74mvqtofjnoj5****
        ```

        :param str resource_name: The name of the resource.
        :param ClusterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ClusterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 cluster_config: Optional[pulumi.Input[pulumi.InputType['ClusterClusterConfigArgs']]] = None,
                 delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 kubernetes_version: Optional[pulumi.Input[str]] = None,
                 logging_config: Optional[pulumi.Input[pulumi.InputType['ClusterLoggingConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 pods_config: Optional[pulumi.Input[pulumi.InputType['ClusterPodsConfigArgs']]] = None,
                 services_config: Optional[pulumi.Input[pulumi.InputType['ClusterServicesConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ClusterArgs.__new__(ClusterArgs)

            __props__.__dict__["client_token"] = client_token
            if cluster_config is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_config'")
            __props__.__dict__["cluster_config"] = cluster_config
            __props__.__dict__["delete_protection_enabled"] = delete_protection_enabled
            __props__.__dict__["description"] = description
            __props__.__dict__["kubernetes_version"] = kubernetes_version
            __props__.__dict__["logging_config"] = logging_config
            __props__.__dict__["name"] = name
            if pods_config is None and not opts.urn:
                raise TypeError("Missing required property 'pods_config'")
            __props__.__dict__["pods_config"] = pods_config
            if services_config is None and not opts.urn:
                raise TypeError("Missing required property 'services_config'")
            __props__.__dict__["services_config"] = services_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["eip_allocation_id"] = None
            __props__.__dict__["kubeconfig_private"] = None
            __props__.__dict__["kubeconfig_public"] = None
        super(Cluster, __self__).__init__(
            'volcengine:vke/cluster:Cluster',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            client_token: Optional[pulumi.Input[str]] = None,
            cluster_config: Optional[pulumi.Input[pulumi.InputType['ClusterClusterConfigArgs']]] = None,
            delete_protection_enabled: Optional[pulumi.Input[bool]] = None,
            description: Optional[pulumi.Input[str]] = None,
            eip_allocation_id: Optional[pulumi.Input[str]] = None,
            kubeconfig_private: Optional[pulumi.Input[str]] = None,
            kubeconfig_public: Optional[pulumi.Input[str]] = None,
            kubernetes_version: Optional[pulumi.Input[str]] = None,
            logging_config: Optional[pulumi.Input[pulumi.InputType['ClusterLoggingConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            pods_config: Optional[pulumi.Input[pulumi.InputType['ClusterPodsConfigArgs']]] = None,
            services_config: Optional[pulumi.Input[pulumi.InputType['ClusterServicesConfigArgs']]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterTagArgs']]]]] = None) -> 'Cluster':
        """
        Get an existing Cluster resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] client_token: ClientToken is a case-sensitive string of no more than 64 ASCII characters passed in by the caller.
        :param pulumi.Input[pulumi.InputType['ClusterClusterConfigArgs']] cluster_config: The config of the cluster.
        :param pulumi.Input[bool] delete_protection_enabled: The delete protection of the cluster, the value is `true` or `false`.
        :param pulumi.Input[str] description: The description of the cluster.
        :param pulumi.Input[str] eip_allocation_id: Eip allocation Id.
        :param pulumi.Input[str] kubeconfig_private: Kubeconfig data with private network access, returned in BASE64 encoding, it is suggested to use vke_kubeconfig instead.
        :param pulumi.Input[str] kubeconfig_public: Kubeconfig data with public network access, returned in BASE64 encoding, it is suggested to use vke_kubeconfig instead.
        :param pulumi.Input[str] kubernetes_version: The version of Kubernetes specified when creating a VKE cluster (specified to patch version), if not specified, the latest Kubernetes version supported by VKE is used by default, which is a 3-segment version format starting with a lowercase v, that is, KubernetesVersion with IsLatestVersion=True in the return value of ListSupportedVersions.
        :param pulumi.Input[pulumi.InputType['ClusterLoggingConfigArgs']] logging_config: Cluster log configuration information.
        :param pulumi.Input[str] name: The name of the cluster.
        :param pulumi.Input[pulumi.InputType['ClusterPodsConfigArgs']] pods_config: The config of the pods.
        :param pulumi.Input[pulumi.InputType['ClusterServicesConfigArgs']] services_config: The config of the services.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ClusterTagArgs']]]] tags: Tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ClusterState.__new__(_ClusterState)

        __props__.__dict__["client_token"] = client_token
        __props__.__dict__["cluster_config"] = cluster_config
        __props__.__dict__["delete_protection_enabled"] = delete_protection_enabled
        __props__.__dict__["description"] = description
        __props__.__dict__["eip_allocation_id"] = eip_allocation_id
        __props__.__dict__["kubeconfig_private"] = kubeconfig_private
        __props__.__dict__["kubeconfig_public"] = kubeconfig_public
        __props__.__dict__["kubernetes_version"] = kubernetes_version
        __props__.__dict__["logging_config"] = logging_config
        __props__.__dict__["name"] = name
        __props__.__dict__["pods_config"] = pods_config
        __props__.__dict__["services_config"] = services_config
        __props__.__dict__["tags"] = tags
        return Cluster(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[Optional[str]]:
        """
        ClientToken is a case-sensitive string of no more than 64 ASCII characters passed in by the caller.
        """
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter(name="clusterConfig")
    def cluster_config(self) -> pulumi.Output['outputs.ClusterClusterConfig']:
        """
        The config of the cluster.
        """
        return pulumi.get(self, "cluster_config")

    @property
    @pulumi.getter(name="deleteProtectionEnabled")
    def delete_protection_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        The delete protection of the cluster, the value is `true` or `false`.
        """
        return pulumi.get(self, "delete_protection_enabled")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[str]]:
        """
        The description of the cluster.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="eipAllocationId")
    def eip_allocation_id(self) -> pulumi.Output[str]:
        """
        Eip allocation Id.
        """
        return pulumi.get(self, "eip_allocation_id")

    @property
    @pulumi.getter(name="kubeconfigPrivate")
    def kubeconfig_private(self) -> pulumi.Output[str]:
        """
        Kubeconfig data with private network access, returned in BASE64 encoding, it is suggested to use vke_kubeconfig instead.
        """
        return pulumi.get(self, "kubeconfig_private")

    @property
    @pulumi.getter(name="kubeconfigPublic")
    def kubeconfig_public(self) -> pulumi.Output[str]:
        """
        Kubeconfig data with public network access, returned in BASE64 encoding, it is suggested to use vke_kubeconfig instead.
        """
        return pulumi.get(self, "kubeconfig_public")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> pulumi.Output[str]:
        """
        The version of Kubernetes specified when creating a VKE cluster (specified to patch version), if not specified, the latest Kubernetes version supported by VKE is used by default, which is a 3-segment version format starting with a lowercase v, that is, KubernetesVersion with IsLatestVersion=True in the return value of ListSupportedVersions.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> pulumi.Output[Optional['outputs.ClusterLoggingConfig']]:
        """
        Cluster log configuration information.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="podsConfig")
    def pods_config(self) -> pulumi.Output['outputs.ClusterPodsConfig']:
        """
        The config of the pods.
        """
        return pulumi.get(self, "pods_config")

    @property
    @pulumi.getter(name="servicesConfig")
    def services_config(self) -> pulumi.Output['outputs.ClusterServicesConfig']:
        """
        The config of the services.
        """
        return pulumi.get(self, "services_config")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.ClusterTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

