# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'ClustersResult',
    'AwaitableClustersResult',
    'clusters',
    'clusters_output',
]

@pulumi.output_type
class ClustersResult:
    """
    A collection of values returned by Clusters.
    """
    def __init__(__self__, clusters=None, create_client_token=None, delete_protection_enabled=None, id=None, ids=None, name=None, name_regex=None, output_file=None, page_number=None, page_size=None, pods_config_pod_network_mode=None, statuses=None, tags=None, total_count=None, update_client_token=None):
        if clusters and not isinstance(clusters, list):
            raise TypeError("Expected argument 'clusters' to be a list")
        pulumi.set(__self__, "clusters", clusters)
        if create_client_token and not isinstance(create_client_token, str):
            raise TypeError("Expected argument 'create_client_token' to be a str")
        pulumi.set(__self__, "create_client_token", create_client_token)
        if delete_protection_enabled and not isinstance(delete_protection_enabled, bool):
            raise TypeError("Expected argument 'delete_protection_enabled' to be a bool")
        pulumi.set(__self__, "delete_protection_enabled", delete_protection_enabled)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if pods_config_pod_network_mode and not isinstance(pods_config_pod_network_mode, str):
            raise TypeError("Expected argument 'pods_config_pod_network_mode' to be a str")
        pulumi.set(__self__, "pods_config_pod_network_mode", pods_config_pod_network_mode)
        if statuses and not isinstance(statuses, list):
            raise TypeError("Expected argument 'statuses' to be a list")
        pulumi.set(__self__, "statuses", statuses)
        if tags and not isinstance(tags, list):
            raise TypeError("Expected argument 'tags' to be a list")
        pulumi.set(__self__, "tags", tags)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if update_client_token and not isinstance(update_client_token, str):
            raise TypeError("Expected argument 'update_client_token' to be a str")
        pulumi.set(__self__, "update_client_token", update_client_token)

    @property
    @pulumi.getter
    def clusters(self) -> Sequence['outputs.ClustersClusterResult']:
        """
        The collection of VkeCluster query.
        """
        return pulumi.get(self, "clusters")

    @property
    @pulumi.getter(name="createClientToken")
    def create_client_token(self) -> Optional[str]:
        return pulumi.get(self, "create_client_token")

    @property
    @pulumi.getter(name="deleteProtectionEnabled")
    def delete_protection_enabled(self) -> Optional[bool]:
        """
        The delete protection of the cluster, the value is `true` or `false`.
        """
        return pulumi.get(self, "delete_protection_enabled")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the cluster.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> int:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> int:
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter(name="podsConfigPodNetworkMode")
    def pods_config_pod_network_mode(self) -> Optional[str]:
        return pulumi.get(self, "pods_config_pod_network_mode")

    @property
    @pulumi.getter
    def statuses(self) -> Optional[Sequence['outputs.ClustersStatusResult']]:
        return pulumi.get(self, "statuses")

    @property
    @pulumi.getter
    def tags(self) -> Optional[Sequence['outputs.ClustersTagResult']]:
        """
        Tags of the Cluster.
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Cluster query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="updateClientToken")
    def update_client_token(self) -> Optional[str]:
        return pulumi.get(self, "update_client_token")


class AwaitableClustersResult(ClustersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return ClustersResult(
            clusters=self.clusters,
            create_client_token=self.create_client_token,
            delete_protection_enabled=self.delete_protection_enabled,
            id=self.id,
            ids=self.ids,
            name=self.name,
            name_regex=self.name_regex,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            pods_config_pod_network_mode=self.pods_config_pod_network_mode,
            statuses=self.statuses,
            tags=self.tags,
            total_count=self.total_count,
            update_client_token=self.update_client_token)


def clusters(create_client_token: Optional[str] = None,
             delete_protection_enabled: Optional[bool] = None,
             ids: Optional[Sequence[str]] = None,
             name: Optional[str] = None,
             name_regex: Optional[str] = None,
             output_file: Optional[str] = None,
             page_number: Optional[int] = None,
             page_size: Optional[int] = None,
             pods_config_pod_network_mode: Optional[str] = None,
             statuses: Optional[Sequence[pulumi.InputType['ClustersStatusArgs']]] = None,
             tags: Optional[Sequence[pulumi.InputType['ClustersTagArgs']]] = None,
             update_client_token: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableClustersResult:
    """
    Use this data source to query detailed information of vke clusters
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-project1",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-subnet-test-2",
        cidr_block="172.16.0.0/24",
        zone_id="cn-beijing-a",
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        vpc_id=foo_vpc.id,
        security_group_name="acc-test-security-group2")
    foo_instance = volcengine.ecs.Instance("fooInstance",
        image_id="image-ybqi99s7yq8rx7mnk44b",
        instance_type="ecs.g1ie.large",
        instance_name="acc-test-ecs-name2",
        password="93f0cb0614Aab12",
        instance_charge_type="PostPaid",
        system_volume_type="ESSD_PL0",
        system_volume_size=40,
        subnet_id=foo_subnet.id,
        security_group_ids=[foo_security_group.id])
    foo_cluster = volcengine.vke.Cluster("fooCluster",
        description="created by terraform",
        delete_protection_enabled=False,
        cluster_config=volcengine.vke.ClusterClusterConfigArgs(
            subnet_ids=[foo_subnet.id],
            api_server_public_access_enabled=True,
            api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                    billing_type="PostPaidByBandwidth",
                    bandwidth=1,
                ),
            ),
            resource_public_access_default_enabled=True,
        ),
        pods_config=volcengine.vke.ClusterPodsConfigArgs(
            pod_network_mode="VpcCniShared",
            vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                subnet_ids=[foo_subnet.id],
            ),
        ),
        services_config=volcengine.vke.ClusterServicesConfigArgs(
            service_cidrsv4s=["172.30.0.0/18"],
        ),
        tags=[volcengine.vke.ClusterTagArgs(
            key="tf-k1",
            value="tf-v1",
        )])
    foo_clusters = volcengine.vke.clusters_output(ids=[foo_cluster.id])
    ```


    :param str create_client_token: ClientToken when the cluster is created successfully. ClientToken is a string that guarantees the idempotency of the request. This string is passed in by the caller.
    :param bool delete_protection_enabled: The delete protection of the cluster, the value is `true` or `false`.
    :param Sequence[str] ids: A list of Cluster IDs.
    :param str name: The name of the cluster.
    :param str name_regex: A Name Regex of Cluster.
    :param str output_file: File name where to save data source results.
    :param int page_number: The page number of clusters query.
    :param int page_size: The page size of clusters query.
    :param str pods_config_pod_network_mode: The container network model of the cluster, the value is `Flannel` or `VpcCniShared`. Flannel: Flannel network model, an independent Underlay container network solution, combined with the global routing capability of VPC, to achieve a high-performance network experience for the cluster. VpcCniShared: VPC-CNI network model, an Underlay container network solution based on the ENI of the private network elastic network card, with high network communication performance.
    :param Sequence[pulumi.InputType['ClustersStatusArgs']] statuses: Array of cluster states to filter. (The elements of the array are logically ORed. A maximum of 15 state array elements can be filled at a time).
    :param Sequence[pulumi.InputType['ClustersTagArgs']] tags: Tags.
    :param str update_client_token: The ClientToken when the last cluster update succeeded. ClientToken is a string that guarantees the idempotency of the request. This string is passed in by the caller.
    """
    __args__ = dict()
    __args__['createClientToken'] = create_client_token
    __args__['deleteProtectionEnabled'] = delete_protection_enabled
    __args__['ids'] = ids
    __args__['name'] = name
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['podsConfigPodNetworkMode'] = pods_config_pod_network_mode
    __args__['statuses'] = statuses
    __args__['tags'] = tags
    __args__['updateClientToken'] = update_client_token
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vke/clusters:Clusters', __args__, opts=opts, typ=ClustersResult).value

    return AwaitableClustersResult(
        clusters=pulumi.get(__ret__, 'clusters'),
        create_client_token=pulumi.get(__ret__, 'create_client_token'),
        delete_protection_enabled=pulumi.get(__ret__, 'delete_protection_enabled'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        name=pulumi.get(__ret__, 'name'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        pods_config_pod_network_mode=pulumi.get(__ret__, 'pods_config_pod_network_mode'),
        statuses=pulumi.get(__ret__, 'statuses'),
        tags=pulumi.get(__ret__, 'tags'),
        total_count=pulumi.get(__ret__, 'total_count'),
        update_client_token=pulumi.get(__ret__, 'update_client_token'))


@_utilities.lift_output_func(clusters)
def clusters_output(create_client_token: Optional[pulumi.Input[Optional[str]]] = None,
                    delete_protection_enabled: Optional[pulumi.Input[Optional[bool]]] = None,
                    ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                    name: Optional[pulumi.Input[Optional[str]]] = None,
                    name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                    output_file: Optional[pulumi.Input[Optional[str]]] = None,
                    page_number: Optional[pulumi.Input[Optional[int]]] = None,
                    page_size: Optional[pulumi.Input[Optional[int]]] = None,
                    pods_config_pod_network_mode: Optional[pulumi.Input[Optional[str]]] = None,
                    statuses: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['ClustersStatusArgs']]]]] = None,
                    tags: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['ClustersTagArgs']]]]] = None,
                    update_client_token: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[ClustersResult]:
    """
    Use this data source to query detailed information of vke clusters
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-project1",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-subnet-test-2",
        cidr_block="172.16.0.0/24",
        zone_id="cn-beijing-a",
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        vpc_id=foo_vpc.id,
        security_group_name="acc-test-security-group2")
    foo_instance = volcengine.ecs.Instance("fooInstance",
        image_id="image-ybqi99s7yq8rx7mnk44b",
        instance_type="ecs.g1ie.large",
        instance_name="acc-test-ecs-name2",
        password="93f0cb0614Aab12",
        instance_charge_type="PostPaid",
        system_volume_type="ESSD_PL0",
        system_volume_size=40,
        subnet_id=foo_subnet.id,
        security_group_ids=[foo_security_group.id])
    foo_cluster = volcengine.vke.Cluster("fooCluster",
        description="created by terraform",
        delete_protection_enabled=False,
        cluster_config=volcengine.vke.ClusterClusterConfigArgs(
            subnet_ids=[foo_subnet.id],
            api_server_public_access_enabled=True,
            api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                    billing_type="PostPaidByBandwidth",
                    bandwidth=1,
                ),
            ),
            resource_public_access_default_enabled=True,
        ),
        pods_config=volcengine.vke.ClusterPodsConfigArgs(
            pod_network_mode="VpcCniShared",
            vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                subnet_ids=[foo_subnet.id],
            ),
        ),
        services_config=volcengine.vke.ClusterServicesConfigArgs(
            service_cidrsv4s=["172.30.0.0/18"],
        ),
        tags=[volcengine.vke.ClusterTagArgs(
            key="tf-k1",
            value="tf-v1",
        )])
    foo_clusters = volcengine.vke.clusters_output(ids=[foo_cluster.id])
    ```


    :param str create_client_token: ClientToken when the cluster is created successfully. ClientToken is a string that guarantees the idempotency of the request. This string is passed in by the caller.
    :param bool delete_protection_enabled: The delete protection of the cluster, the value is `true` or `false`.
    :param Sequence[str] ids: A list of Cluster IDs.
    :param str name: The name of the cluster.
    :param str name_regex: A Name Regex of Cluster.
    :param str output_file: File name where to save data source results.
    :param int page_number: The page number of clusters query.
    :param int page_size: The page size of clusters query.
    :param str pods_config_pod_network_mode: The container network model of the cluster, the value is `Flannel` or `VpcCniShared`. Flannel: Flannel network model, an independent Underlay container network solution, combined with the global routing capability of VPC, to achieve a high-performance network experience for the cluster. VpcCniShared: VPC-CNI network model, an Underlay container network solution based on the ENI of the private network elastic network card, with high network communication performance.
    :param Sequence[pulumi.InputType['ClustersStatusArgs']] statuses: Array of cluster states to filter. (The elements of the array are logically ORed. A maximum of 15 state array elements can be filled at a time).
    :param Sequence[pulumi.InputType['ClustersTagArgs']] tags: Tags.
    :param str update_client_token: The ClientToken when the last cluster update succeeded. ClientToken is a string that guarantees the idempotency of the request. This string is passed in by the caller.
    """
    ...
