# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['KubeconfigArgs', 'Kubeconfig']

@pulumi.input_type
class KubeconfigArgs:
    def __init__(__self__, *,
                 cluster_id: pulumi.Input[str],
                 type: pulumi.Input[str],
                 valid_duration: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a Kubeconfig resource.
        :param pulumi.Input[str] cluster_id: The cluster id of the Kubeconfig.
        :param pulumi.Input[str] type: The type of the Kubeconfig, the value of type should be Public or Private.
        :param pulumi.Input[int] valid_duration: The ValidDuration of the Kubeconfig, the range of the ValidDuration is 1 hour to 43800 hour.
        """
        pulumi.set(__self__, "cluster_id", cluster_id)
        pulumi.set(__self__, "type", type)
        if valid_duration is not None:
            pulumi.set(__self__, "valid_duration", valid_duration)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Input[str]:
        """
        The cluster id of the Kubeconfig.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        The type of the Kubeconfig, the value of type should be Public or Private.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="validDuration")
    def valid_duration(self) -> Optional[pulumi.Input[int]]:
        """
        The ValidDuration of the Kubeconfig, the range of the ValidDuration is 1 hour to 43800 hour.
        """
        return pulumi.get(self, "valid_duration")

    @valid_duration.setter
    def valid_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "valid_duration", value)


@pulumi.input_type
class _KubeconfigState:
    def __init__(__self__, *,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 valid_duration: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering Kubeconfig resources.
        :param pulumi.Input[str] cluster_id: The cluster id of the Kubeconfig.
        :param pulumi.Input[str] type: The type of the Kubeconfig, the value of type should be Public or Private.
        :param pulumi.Input[int] valid_duration: The ValidDuration of the Kubeconfig, the range of the ValidDuration is 1 hour to 43800 hour.
        """
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if type is not None:
            pulumi.set(__self__, "type", type)
        if valid_duration is not None:
            pulumi.set(__self__, "valid_duration", valid_duration)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster id of the Kubeconfig.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of the Kubeconfig, the value of type should be Public or Private.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="validDuration")
    def valid_duration(self) -> Optional[pulumi.Input[int]]:
        """
        The ValidDuration of the Kubeconfig, the range of the ValidDuration is 1 hour to 43800 hour.
        """
        return pulumi.get(self, "valid_duration")

    @valid_duration.setter
    def valid_duration(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "valid_duration", value)


class Kubeconfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 valid_duration: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Provides a resource to manage vke kubeconfig
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_cluster = volcengine.vke.Cluster("fooCluster",
            description="created by terraform",
            delete_protection_enabled=False,
            cluster_config=volcengine.vke.ClusterClusterConfigArgs(
                subnet_ids=[foo_subnet.id],
                api_server_public_access_enabled=True,
                api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                    public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                        billing_type="PostPaidByBandwidth",
                        bandwidth=1,
                    ),
                ),
                resource_public_access_default_enabled=True,
            ),
            pods_config=volcengine.vke.ClusterPodsConfigArgs(
                pod_network_mode="VpcCniShared",
                vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                    subnet_ids=[foo_subnet.id],
                ),
            ),
            services_config=volcengine.vke.ClusterServicesConfigArgs(
                service_cidrsv4s=["172.30.0.0/18"],
            ),
            tags=[volcengine.vke.ClusterTagArgs(
                key="tf-k1",
                value="tf-v1",
            )])
        foo_kubeconfig = volcengine.vke.Kubeconfig("fooKubeconfig",
            cluster_id=foo_cluster.id,
            type="Private",
            valid_duration=2)
        ```

        ## Import

        VkeKubeconfig can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vke/kubeconfig:Kubeconfig default kce8simvqtofl0l6u4qd0
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The cluster id of the Kubeconfig.
        :param pulumi.Input[str] type: The type of the Kubeconfig, the value of type should be Public or Private.
        :param pulumi.Input[int] valid_duration: The ValidDuration of the Kubeconfig, the range of the ValidDuration is 1 hour to 43800 hour.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: KubeconfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage vke kubeconfig
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_cluster = volcengine.vke.Cluster("fooCluster",
            description="created by terraform",
            delete_protection_enabled=False,
            cluster_config=volcengine.vke.ClusterClusterConfigArgs(
                subnet_ids=[foo_subnet.id],
                api_server_public_access_enabled=True,
                api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                    public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                        billing_type="PostPaidByBandwidth",
                        bandwidth=1,
                    ),
                ),
                resource_public_access_default_enabled=True,
            ),
            pods_config=volcengine.vke.ClusterPodsConfigArgs(
                pod_network_mode="VpcCniShared",
                vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                    subnet_ids=[foo_subnet.id],
                ),
            ),
            services_config=volcengine.vke.ClusterServicesConfigArgs(
                service_cidrsv4s=["172.30.0.0/18"],
            ),
            tags=[volcengine.vke.ClusterTagArgs(
                key="tf-k1",
                value="tf-v1",
            )])
        foo_kubeconfig = volcengine.vke.Kubeconfig("fooKubeconfig",
            cluster_id=foo_cluster.id,
            type="Private",
            valid_duration=2)
        ```

        ## Import

        VkeKubeconfig can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vke/kubeconfig:Kubeconfig default kce8simvqtofl0l6u4qd0
        ```

        :param str resource_name: The name of the resource.
        :param KubeconfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(KubeconfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 valid_duration: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = KubeconfigArgs.__new__(KubeconfigArgs)

            if cluster_id is None and not opts.urn:
                raise TypeError("Missing required property 'cluster_id'")
            __props__.__dict__["cluster_id"] = cluster_id
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            __props__.__dict__["valid_duration"] = valid_duration
        super(Kubeconfig, __self__).__init__(
            'volcengine:vke/kubeconfig:Kubeconfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            valid_duration: Optional[pulumi.Input[int]] = None) -> 'Kubeconfig':
        """
        Get an existing Kubeconfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] cluster_id: The cluster id of the Kubeconfig.
        :param pulumi.Input[str] type: The type of the Kubeconfig, the value of type should be Public or Private.
        :param pulumi.Input[int] valid_duration: The ValidDuration of the Kubeconfig, the range of the ValidDuration is 1 hour to 43800 hour.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _KubeconfigState.__new__(_KubeconfigState)

        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["type"] = type
        __props__.__dict__["valid_duration"] = valid_duration
        return Kubeconfig(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[str]:
        """
        The cluster id of the Kubeconfig.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        The type of the Kubeconfig, the value of type should be Public or Private.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="validDuration")
    def valid_duration(self) -> pulumi.Output[Optional[int]]:
        """
        The ValidDuration of the Kubeconfig, the range of the ValidDuration is 1 hour to 43800 hour.
        """
        return pulumi.get(self, "valid_duration")

