# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'KubeconfigsResult',
    'AwaitableKubeconfigsResult',
    'kubeconfigs',
    'kubeconfigs_output',
]

@pulumi.output_type
class KubeconfigsResult:
    """
    A collection of values returned by Kubeconfigs.
    """
    def __init__(__self__, cluster_ids=None, id=None, ids=None, kubeconfigs=None, name_regex=None, output_file=None, page_number=None, page_size=None, total_count=None, types=None):
        if cluster_ids and not isinstance(cluster_ids, list):
            raise TypeError("Expected argument 'cluster_ids' to be a list")
        pulumi.set(__self__, "cluster_ids", cluster_ids)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ids and not isinstance(ids, list):
            raise TypeError("Expected argument 'ids' to be a list")
        pulumi.set(__self__, "ids", ids)
        if kubeconfigs and not isinstance(kubeconfigs, list):
            raise TypeError("Expected argument 'kubeconfigs' to be a list")
        pulumi.set(__self__, "kubeconfigs", kubeconfigs)
        if name_regex and not isinstance(name_regex, str):
            raise TypeError("Expected argument 'name_regex' to be a str")
        pulumi.set(__self__, "name_regex", name_regex)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if page_number and not isinstance(page_number, int):
            raise TypeError("Expected argument 'page_number' to be a int")
        pulumi.set(__self__, "page_number", page_number)
        if page_size and not isinstance(page_size, int):
            raise TypeError("Expected argument 'page_size' to be a int")
        pulumi.set(__self__, "page_size", page_size)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if types and not isinstance(types, list):
            raise TypeError("Expected argument 'types' to be a list")
        pulumi.set(__self__, "types", types)

    @property
    @pulumi.getter(name="clusterIds")
    def cluster_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "cluster_ids")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "ids")

    @property
    @pulumi.getter
    def kubeconfigs(self) -> Sequence['outputs.KubeconfigsKubeconfigResult']:
        """
        The collection of VkeKubeconfig query.
        """
        return pulumi.get(self, "kubeconfigs")

    @property
    @pulumi.getter(name="nameRegex")
    def name_regex(self) -> Optional[str]:
        return pulumi.get(self, "name_regex")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="pageNumber")
    def page_number(self) -> int:
        return pulumi.get(self, "page_number")

    @property
    @pulumi.getter(name="pageSize")
    def page_size(self) -> int:
        return pulumi.get(self, "page_size")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of Kubeconfig query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter
    def types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "types")


class AwaitableKubeconfigsResult(KubeconfigsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return KubeconfigsResult(
            cluster_ids=self.cluster_ids,
            id=self.id,
            ids=self.ids,
            kubeconfigs=self.kubeconfigs,
            name_regex=self.name_regex,
            output_file=self.output_file,
            page_number=self.page_number,
            page_size=self.page_size,
            total_count=self.total_count,
            types=self.types)


def kubeconfigs(cluster_ids: Optional[Sequence[str]] = None,
                ids: Optional[Sequence[str]] = None,
                name_regex: Optional[str] = None,
                output_file: Optional[str] = None,
                page_number: Optional[int] = None,
                page_size: Optional[int] = None,
                types: Optional[Sequence[str]] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableKubeconfigsResult:
    """
    Use this data source to query detailed information of vke kubeconfigs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        security_group_name="acc-test-security-group",
        vpc_id=foo_vpc.id)
    foo_cluster = volcengine.vke.Cluster("fooCluster",
        description="created by terraform",
        delete_protection_enabled=False,
        cluster_config=volcengine.vke.ClusterClusterConfigArgs(
            subnet_ids=[foo_subnet.id],
            api_server_public_access_enabled=True,
            api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                    billing_type="PostPaidByBandwidth",
                    bandwidth=1,
                ),
            ),
            resource_public_access_default_enabled=True,
        ),
        pods_config=volcengine.vke.ClusterPodsConfigArgs(
            pod_network_mode="VpcCniShared",
            vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                subnet_ids=[foo_subnet.id],
            ),
        ),
        services_config=volcengine.vke.ClusterServicesConfigArgs(
            service_cidrsv4s=["172.30.0.0/18"],
        ),
        tags=[volcengine.vke.ClusterTagArgs(
            key="tf-k1",
            value="tf-v1",
        )])
    foo1 = volcengine.vke.Kubeconfig("foo1",
        cluster_id=foo_cluster.id,
        type="Private",
        valid_duration=2)
    foo2 = volcengine.vke.Kubeconfig("foo2",
        cluster_id=foo_cluster.id,
        type="Public",
        valid_duration=2)
    foo_kubeconfigs = volcengine.vke.kubeconfigs_output(ids=[
        foo1.id,
        foo2.id,
    ])
    ```


    :param Sequence[str] cluster_ids: A list of Cluster IDs.
    :param Sequence[str] ids: A list of Kubeconfig IDs.
    :param str name_regex: A Name Regex of Kubeconfig.
    :param str output_file: File name where to save data source results.
    :param int page_number: The page number of Kubeconfigs query.
    :param int page_size: The page size of Kubeconfigs query.
    :param Sequence[str] types: The type of Kubeconfigs query.
    """
    __args__ = dict()
    __args__['clusterIds'] = cluster_ids
    __args__['ids'] = ids
    __args__['nameRegex'] = name_regex
    __args__['outputFile'] = output_file
    __args__['pageNumber'] = page_number
    __args__['pageSize'] = page_size
    __args__['types'] = types
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vke/kubeconfigs:Kubeconfigs', __args__, opts=opts, typ=KubeconfigsResult).value

    return AwaitableKubeconfigsResult(
        cluster_ids=pulumi.get(__ret__, 'cluster_ids'),
        id=pulumi.get(__ret__, 'id'),
        ids=pulumi.get(__ret__, 'ids'),
        kubeconfigs=pulumi.get(__ret__, 'kubeconfigs'),
        name_regex=pulumi.get(__ret__, 'name_regex'),
        output_file=pulumi.get(__ret__, 'output_file'),
        page_number=pulumi.get(__ret__, 'page_number'),
        page_size=pulumi.get(__ret__, 'page_size'),
        total_count=pulumi.get(__ret__, 'total_count'),
        types=pulumi.get(__ret__, 'types'))


@_utilities.lift_output_func(kubeconfigs)
def kubeconfigs_output(cluster_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       name_regex: Optional[pulumi.Input[Optional[str]]] = None,
                       output_file: Optional[pulumi.Input[Optional[str]]] = None,
                       page_number: Optional[pulumi.Input[Optional[int]]] = None,
                       page_size: Optional[pulumi.Input[Optional[int]]] = None,
                       types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[KubeconfigsResult]:
    """
    Use this data source to query detailed information of vke kubeconfigs
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    foo_zones = volcengine.ecs.zones()
    foo_vpc = volcengine.vpc.Vpc("fooVpc",
        vpc_name="acc-test-vpc",
        cidr_block="172.16.0.0/16")
    foo_subnet = volcengine.vpc.Subnet("fooSubnet",
        subnet_name="acc-test-subnet",
        cidr_block="172.16.0.0/24",
        zone_id=foo_zones.zones[0].id,
        vpc_id=foo_vpc.id)
    foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
        security_group_name="acc-test-security-group",
        vpc_id=foo_vpc.id)
    foo_cluster = volcengine.vke.Cluster("fooCluster",
        description="created by terraform",
        delete_protection_enabled=False,
        cluster_config=volcengine.vke.ClusterClusterConfigArgs(
            subnet_ids=[foo_subnet.id],
            api_server_public_access_enabled=True,
            api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                    billing_type="PostPaidByBandwidth",
                    bandwidth=1,
                ),
            ),
            resource_public_access_default_enabled=True,
        ),
        pods_config=volcengine.vke.ClusterPodsConfigArgs(
            pod_network_mode="VpcCniShared",
            vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                subnet_ids=[foo_subnet.id],
            ),
        ),
        services_config=volcengine.vke.ClusterServicesConfigArgs(
            service_cidrsv4s=["172.30.0.0/18"],
        ),
        tags=[volcengine.vke.ClusterTagArgs(
            key="tf-k1",
            value="tf-v1",
        )])
    foo1 = volcengine.vke.Kubeconfig("foo1",
        cluster_id=foo_cluster.id,
        type="Private",
        valid_duration=2)
    foo2 = volcengine.vke.Kubeconfig("foo2",
        cluster_id=foo_cluster.id,
        type="Public",
        valid_duration=2)
    foo_kubeconfigs = volcengine.vke.kubeconfigs_output(ids=[
        foo1.id,
        foo2.id,
    ])
    ```


    :param Sequence[str] cluster_ids: A list of Cluster IDs.
    :param Sequence[str] ids: A list of Kubeconfig IDs.
    :param str name_regex: A Name Regex of Kubeconfig.
    :param str output_file: File name where to save data source results.
    :param int page_number: The page number of Kubeconfigs query.
    :param int page_size: The page size of Kubeconfigs query.
    :param Sequence[str] types: The type of Kubeconfigs query.
    """
    ...
