# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['NodePoolArgs', 'NodePool']

@pulumi.input_type
class NodePoolArgs:
    def __init__(__self__, *,
                 kubernetes_config: pulumi.Input['NodePoolKubernetesConfigArgs'],
                 node_config: pulumi.Input['NodePoolNodeConfigArgs'],
                 auto_scaling: Optional[pulumi.Input['NodePoolAutoScalingArgs']] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTagArgs']]]] = None):
        """
        The set of arguments for constructing a NodePool resource.
        :param pulumi.Input['NodePoolKubernetesConfigArgs'] kubernetes_config: The KubernetesConfig of NodeConfig.
        :param pulumi.Input['NodePoolNodeConfigArgs'] node_config: The Config of NodePool.
        :param pulumi.Input['NodePoolAutoScalingArgs'] auto_scaling: The node pool elastic scaling configuration information.
        :param pulumi.Input[str] client_token: The ClientToken of NodePool.
        :param pulumi.Input[str] cluster_id: The ClusterId of NodePool.
        :param pulumi.Input[str] name: The Name of NodePool.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTagArgs']]] tags: Tags.
        """
        pulumi.set(__self__, "kubernetes_config", kubernetes_config)
        pulumi.set(__self__, "node_config", node_config)
        if auto_scaling is not None:
            pulumi.set(__self__, "auto_scaling", auto_scaling)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="kubernetesConfig")
    def kubernetes_config(self) -> pulumi.Input['NodePoolKubernetesConfigArgs']:
        """
        The KubernetesConfig of NodeConfig.
        """
        return pulumi.get(self, "kubernetes_config")

    @kubernetes_config.setter
    def kubernetes_config(self, value: pulumi.Input['NodePoolKubernetesConfigArgs']):
        pulumi.set(self, "kubernetes_config", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Input['NodePoolNodeConfigArgs']:
        """
        The Config of NodePool.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: pulumi.Input['NodePoolNodeConfigArgs']):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="autoScaling")
    def auto_scaling(self) -> Optional[pulumi.Input['NodePoolAutoScalingArgs']]:
        """
        The node pool elastic scaling configuration information.
        """
        return pulumi.get(self, "auto_scaling")

    @auto_scaling.setter
    def auto_scaling(self, value: Optional[pulumi.Input['NodePoolAutoScalingArgs']]):
        pulumi.set(self, "auto_scaling", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[str]]:
        """
        The ClientToken of NodePool.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ClusterId of NodePool.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of NodePool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTagArgs']]]]):
        pulumi.set(self, "tags", value)


@pulumi.input_type
class _NodePoolState:
    def __init__(__self__, *,
                 auto_scaling: Optional[pulumi.Input['NodePoolAutoScalingArgs']] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 kubernetes_config: Optional[pulumi.Input['NodePoolKubernetesConfigArgs']] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input['NodePoolNodeConfigArgs']] = None,
                 node_statistics: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeStatisticArgs']]]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTagArgs']]]] = None):
        """
        Input properties used for looking up and filtering NodePool resources.
        :param pulumi.Input['NodePoolAutoScalingArgs'] auto_scaling: The node pool elastic scaling configuration information.
        :param pulumi.Input[str] client_token: The ClientToken of NodePool.
        :param pulumi.Input[str] cluster_id: The ClusterId of NodePool.
        :param pulumi.Input['NodePoolKubernetesConfigArgs'] kubernetes_config: The KubernetesConfig of NodeConfig.
        :param pulumi.Input[str] name: The Name of NodePool.
        :param pulumi.Input['NodePoolNodeConfigArgs'] node_config: The Config of NodePool.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolNodeStatisticArgs']]] node_statistics: The NodeStatistics of NodeConfig.
        :param pulumi.Input[Sequence[pulumi.Input['NodePoolTagArgs']]] tags: Tags.
        """
        if auto_scaling is not None:
            pulumi.set(__self__, "auto_scaling", auto_scaling)
        if client_token is not None:
            pulumi.set(__self__, "client_token", client_token)
        if cluster_id is not None:
            pulumi.set(__self__, "cluster_id", cluster_id)
        if kubernetes_config is not None:
            pulumi.set(__self__, "kubernetes_config", kubernetes_config)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if node_config is not None:
            pulumi.set(__self__, "node_config", node_config)
        if node_statistics is not None:
            pulumi.set(__self__, "node_statistics", node_statistics)
        if tags is not None:
            pulumi.set(__self__, "tags", tags)

    @property
    @pulumi.getter(name="autoScaling")
    def auto_scaling(self) -> Optional[pulumi.Input['NodePoolAutoScalingArgs']]:
        """
        The node pool elastic scaling configuration information.
        """
        return pulumi.get(self, "auto_scaling")

    @auto_scaling.setter
    def auto_scaling(self, value: Optional[pulumi.Input['NodePoolAutoScalingArgs']]):
        pulumi.set(self, "auto_scaling", value)

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> Optional[pulumi.Input[str]]:
        """
        The ClientToken of NodePool.
        """
        return pulumi.get(self, "client_token")

    @client_token.setter
    def client_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "client_token", value)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The ClusterId of NodePool.
        """
        return pulumi.get(self, "cluster_id")

    @cluster_id.setter
    def cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_id", value)

    @property
    @pulumi.getter(name="kubernetesConfig")
    def kubernetes_config(self) -> Optional[pulumi.Input['NodePoolKubernetesConfigArgs']]:
        """
        The KubernetesConfig of NodeConfig.
        """
        return pulumi.get(self, "kubernetes_config")

    @kubernetes_config.setter
    def kubernetes_config(self, value: Optional[pulumi.Input['NodePoolKubernetesConfigArgs']]):
        pulumi.set(self, "kubernetes_config", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The Name of NodePool.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> Optional[pulumi.Input['NodePoolNodeConfigArgs']]:
        """
        The Config of NodePool.
        """
        return pulumi.get(self, "node_config")

    @node_config.setter
    def node_config(self, value: Optional[pulumi.Input['NodePoolNodeConfigArgs']]):
        pulumi.set(self, "node_config", value)

    @property
    @pulumi.getter(name="nodeStatistics")
    def node_statistics(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeStatisticArgs']]]]:
        """
        The NodeStatistics of NodeConfig.
        """
        return pulumi.get(self, "node_statistics")

    @node_statistics.setter
    def node_statistics(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolNodeStatisticArgs']]]]):
        pulumi.set(self, "node_statistics", value)

    @property
    @pulumi.getter
    def tags(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTagArgs']]]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

    @tags.setter
    def tags(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NodePoolTagArgs']]]]):
        pulumi.set(self, "tags", value)


class NodePool(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling: Optional[pulumi.Input[pulumi.InputType['NodePoolAutoScalingArgs']]] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 kubernetes_config: Optional[pulumi.Input[pulumi.InputType['NodePoolKubernetesConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTagArgs']]]]] = None,
                 __props__=None):
        """
        Provides a resource to manage vke node pool
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(name_regex="veLinux 1.0 CentOS兼容版 64位")
        foo_cluster = volcengine.vke.Cluster("fooCluster",
            description="created by terraform",
            delete_protection_enabled=False,
            cluster_config=volcengine.vke.ClusterClusterConfigArgs(
                subnet_ids=[foo_subnet.id],
                api_server_public_access_enabled=True,
                api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                    public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                        billing_type="PostPaidByBandwidth",
                        bandwidth=1,
                    ),
                ),
                resource_public_access_default_enabled=True,
            ),
            pods_config=volcengine.vke.ClusterPodsConfigArgs(
                pod_network_mode="VpcCniShared",
                vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                    subnet_ids=[foo_subnet.id],
                ),
            ),
            services_config=volcengine.vke.ClusterServicesConfigArgs(
                service_cidrsv4s=["172.30.0.0/18"],
            ),
            tags=[volcengine.vke.ClusterTagArgs(
                key="tf-k1",
                value="tf-v1",
            )])
        foo_node_pool = volcengine.vke.NodePool("fooNodePool",
            cluster_id=foo_cluster.id,
            auto_scaling=volcengine.vke.NodePoolAutoScalingArgs(
                enabled=True,
                min_replicas=0,
                max_replicas=5,
                desired_replicas=0,
                priority=5,
                subnet_policy="ZoneBalance",
            ),
            node_config=volcengine.vke.NodePoolNodeConfigArgs(
                instance_type_ids=["ecs.g1ie.xlarge"],
                subnet_ids=[foo_subnet.id],
                image_id=[image.image_id for image in foo_images.images if image.image_name == "veLinux 1.0 CentOS兼容版 64位"][0],
                system_volume=volcengine.vke.NodePoolNodeConfigSystemVolumeArgs(
                    type="ESSD_PL0",
                    size=80,
                ),
                data_volumes=[
                    volcengine.vke.NodePoolNodeConfigDataVolumeArgs(
                        type="ESSD_PL0",
                        size=80,
                        mount_point="/tf1",
                    ),
                    volcengine.vke.NodePoolNodeConfigDataVolumeArgs(
                        type="ESSD_PL0",
                        size=60,
                        mount_point="/tf2",
                    ),
                ],
                initialize_script="ZWNobyBoZWxsbyB0ZXJyYWZvcm0h",
                security=volcengine.vke.NodePoolNodeConfigSecurityArgs(
                    login=volcengine.vke.NodePoolNodeConfigSecurityLoginArgs(
                        password="UHdkMTIzNDU2",
                    ),
                    security_strategies=["Hids"],
                    security_group_ids=[foo_security_group.id],
                ),
                additional_container_storage_enabled=False,
                instance_charge_type="PostPaid",
                name_prefix="acc-test",
                ecs_tags=[volcengine.vke.NodePoolNodeConfigEcsTagArgs(
                    key="ecs_k1",
                    value="ecs_v1",
                )],
            ),
            kubernetes_config=volcengine.vke.NodePoolKubernetesConfigArgs(
                labels=[volcengine.vke.NodePoolKubernetesConfigLabelArgs(
                    key="label1",
                    value="value1",
                )],
                taints=[volcengine.vke.NodePoolKubernetesConfigTaintArgs(
                    key="taint-key/node-type",
                    value="taint-value",
                    effect="NoSchedule",
                )],
                cordon=True,
            ),
            tags=[volcengine.vke.NodePoolTagArgs(
                key="node-pool-k1",
                value="node-pool-v1",
            )])
        ```

        ## Import

        NodePool can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vke/nodePool:NodePool default pcabe57vqtofgrbln3dp0
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['NodePoolAutoScalingArgs']] auto_scaling: The node pool elastic scaling configuration information.
        :param pulumi.Input[str] client_token: The ClientToken of NodePool.
        :param pulumi.Input[str] cluster_id: The ClusterId of NodePool.
        :param pulumi.Input[pulumi.InputType['NodePoolKubernetesConfigArgs']] kubernetes_config: The KubernetesConfig of NodeConfig.
        :param pulumi.Input[str] name: The Name of NodePool.
        :param pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']] node_config: The Config of NodePool.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTagArgs']]]] tags: Tags.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: NodePoolArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage vke node pool
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_security_group = volcengine.vpc.SecurityGroup("fooSecurityGroup",
            security_group_name="acc-test-security-group",
            vpc_id=foo_vpc.id)
        foo_images = volcengine.ecs.images(name_regex="veLinux 1.0 CentOS兼容版 64位")
        foo_cluster = volcengine.vke.Cluster("fooCluster",
            description="created by terraform",
            delete_protection_enabled=False,
            cluster_config=volcengine.vke.ClusterClusterConfigArgs(
                subnet_ids=[foo_subnet.id],
                api_server_public_access_enabled=True,
                api_server_public_access_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigArgs(
                    public_access_network_config=volcengine.vke.ClusterClusterConfigApiServerPublicAccessConfigPublicAccessNetworkConfigArgs(
                        billing_type="PostPaidByBandwidth",
                        bandwidth=1,
                    ),
                ),
                resource_public_access_default_enabled=True,
            ),
            pods_config=volcengine.vke.ClusterPodsConfigArgs(
                pod_network_mode="VpcCniShared",
                vpc_cni_config=volcengine.vke.ClusterPodsConfigVpcCniConfigArgs(
                    subnet_ids=[foo_subnet.id],
                ),
            ),
            services_config=volcengine.vke.ClusterServicesConfigArgs(
                service_cidrsv4s=["172.30.0.0/18"],
            ),
            tags=[volcengine.vke.ClusterTagArgs(
                key="tf-k1",
                value="tf-v1",
            )])
        foo_node_pool = volcengine.vke.NodePool("fooNodePool",
            cluster_id=foo_cluster.id,
            auto_scaling=volcengine.vke.NodePoolAutoScalingArgs(
                enabled=True,
                min_replicas=0,
                max_replicas=5,
                desired_replicas=0,
                priority=5,
                subnet_policy="ZoneBalance",
            ),
            node_config=volcengine.vke.NodePoolNodeConfigArgs(
                instance_type_ids=["ecs.g1ie.xlarge"],
                subnet_ids=[foo_subnet.id],
                image_id=[image.image_id for image in foo_images.images if image.image_name == "veLinux 1.0 CentOS兼容版 64位"][0],
                system_volume=volcengine.vke.NodePoolNodeConfigSystemVolumeArgs(
                    type="ESSD_PL0",
                    size=80,
                ),
                data_volumes=[
                    volcengine.vke.NodePoolNodeConfigDataVolumeArgs(
                        type="ESSD_PL0",
                        size=80,
                        mount_point="/tf1",
                    ),
                    volcengine.vke.NodePoolNodeConfigDataVolumeArgs(
                        type="ESSD_PL0",
                        size=60,
                        mount_point="/tf2",
                    ),
                ],
                initialize_script="ZWNobyBoZWxsbyB0ZXJyYWZvcm0h",
                security=volcengine.vke.NodePoolNodeConfigSecurityArgs(
                    login=volcengine.vke.NodePoolNodeConfigSecurityLoginArgs(
                        password="UHdkMTIzNDU2",
                    ),
                    security_strategies=["Hids"],
                    security_group_ids=[foo_security_group.id],
                ),
                additional_container_storage_enabled=False,
                instance_charge_type="PostPaid",
                name_prefix="acc-test",
                ecs_tags=[volcengine.vke.NodePoolNodeConfigEcsTagArgs(
                    key="ecs_k1",
                    value="ecs_v1",
                )],
            ),
            kubernetes_config=volcengine.vke.NodePoolKubernetesConfigArgs(
                labels=[volcengine.vke.NodePoolKubernetesConfigLabelArgs(
                    key="label1",
                    value="value1",
                )],
                taints=[volcengine.vke.NodePoolKubernetesConfigTaintArgs(
                    key="taint-key/node-type",
                    value="taint-value",
                    effect="NoSchedule",
                )],
                cordon=True,
            ),
            tags=[volcengine.vke.NodePoolTagArgs(
                key="node-pool-k1",
                value="node-pool-v1",
            )])
        ```

        ## Import

        NodePool can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vke/nodePool:NodePool default pcabe57vqtofgrbln3dp0
        ```

        :param str resource_name: The name of the resource.
        :param NodePoolArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(NodePoolArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 auto_scaling: Optional[pulumi.Input[pulumi.InputType['NodePoolAutoScalingArgs']]] = None,
                 client_token: Optional[pulumi.Input[str]] = None,
                 cluster_id: Optional[pulumi.Input[str]] = None,
                 kubernetes_config: Optional[pulumi.Input[pulumi.InputType['NodePoolKubernetesConfigArgs']]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 node_config: Optional[pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']]] = None,
                 tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTagArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = NodePoolArgs.__new__(NodePoolArgs)

            __props__.__dict__["auto_scaling"] = auto_scaling
            __props__.__dict__["client_token"] = client_token
            __props__.__dict__["cluster_id"] = cluster_id
            if kubernetes_config is None and not opts.urn:
                raise TypeError("Missing required property 'kubernetes_config'")
            __props__.__dict__["kubernetes_config"] = kubernetes_config
            __props__.__dict__["name"] = name
            if node_config is None and not opts.urn:
                raise TypeError("Missing required property 'node_config'")
            __props__.__dict__["node_config"] = node_config
            __props__.__dict__["tags"] = tags
            __props__.__dict__["node_statistics"] = None
        super(NodePool, __self__).__init__(
            'volcengine:vke/nodePool:NodePool',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            auto_scaling: Optional[pulumi.Input[pulumi.InputType['NodePoolAutoScalingArgs']]] = None,
            client_token: Optional[pulumi.Input[str]] = None,
            cluster_id: Optional[pulumi.Input[str]] = None,
            kubernetes_config: Optional[pulumi.Input[pulumi.InputType['NodePoolKubernetesConfigArgs']]] = None,
            name: Optional[pulumi.Input[str]] = None,
            node_config: Optional[pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']]] = None,
            node_statistics: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolNodeStatisticArgs']]]]] = None,
            tags: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTagArgs']]]]] = None) -> 'NodePool':
        """
        Get an existing NodePool resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['NodePoolAutoScalingArgs']] auto_scaling: The node pool elastic scaling configuration information.
        :param pulumi.Input[str] client_token: The ClientToken of NodePool.
        :param pulumi.Input[str] cluster_id: The ClusterId of NodePool.
        :param pulumi.Input[pulumi.InputType['NodePoolKubernetesConfigArgs']] kubernetes_config: The KubernetesConfig of NodeConfig.
        :param pulumi.Input[str] name: The Name of NodePool.
        :param pulumi.Input[pulumi.InputType['NodePoolNodeConfigArgs']] node_config: The Config of NodePool.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolNodeStatisticArgs']]]] node_statistics: The NodeStatistics of NodeConfig.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['NodePoolTagArgs']]]] tags: Tags.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _NodePoolState.__new__(_NodePoolState)

        __props__.__dict__["auto_scaling"] = auto_scaling
        __props__.__dict__["client_token"] = client_token
        __props__.__dict__["cluster_id"] = cluster_id
        __props__.__dict__["kubernetes_config"] = kubernetes_config
        __props__.__dict__["name"] = name
        __props__.__dict__["node_config"] = node_config
        __props__.__dict__["node_statistics"] = node_statistics
        __props__.__dict__["tags"] = tags
        return NodePool(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="autoScaling")
    def auto_scaling(self) -> pulumi.Output['outputs.NodePoolAutoScaling']:
        """
        The node pool elastic scaling configuration information.
        """
        return pulumi.get(self, "auto_scaling")

    @property
    @pulumi.getter(name="clientToken")
    def client_token(self) -> pulumi.Output[Optional[str]]:
        """
        The ClientToken of NodePool.
        """
        return pulumi.get(self, "client_token")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> pulumi.Output[Optional[str]]:
        """
        The ClusterId of NodePool.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="kubernetesConfig")
    def kubernetes_config(self) -> pulumi.Output['outputs.NodePoolKubernetesConfig']:
        """
        The KubernetesConfig of NodeConfig.
        """
        return pulumi.get(self, "kubernetes_config")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The Name of NodePool.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfig")
    def node_config(self) -> pulumi.Output['outputs.NodePoolNodeConfig']:
        """
        The Config of NodePool.
        """
        return pulumi.get(self, "node_config")

    @property
    @pulumi.getter(name="nodeStatistics")
    def node_statistics(self) -> pulumi.Output[Sequence['outputs.NodePoolNodeStatistic']]:
        """
        The NodeStatistics of NodeConfig.
        """
        return pulumi.get(self, "node_statistics")

    @property
    @pulumi.getter
    def tags(self) -> pulumi.Output[Optional[Sequence['outputs.NodePoolTag']]]:
        """
        Tags.
        """
        return pulumi.get(self, "tags")

