# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'SupportResourceTypesResult',
    'AwaitableSupportResourceTypesResult',
    'support_resource_types',
    'support_resource_types_output',
]

@pulumi.output_type
class SupportResourceTypesResult:
    """
    A collection of values returned by SupportResourceTypes.
    """
    def __init__(__self__, id=None, output_file=None, resource_types=None, resources=None, total_count=None, zone_ids=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if output_file and not isinstance(output_file, str):
            raise TypeError("Expected argument 'output_file' to be a str")
        pulumi.set(__self__, "output_file", output_file)
        if resource_types and not isinstance(resource_types, list):
            raise TypeError("Expected argument 'resource_types' to be a list")
        pulumi.set(__self__, "resource_types", resource_types)
        if resources and not isinstance(resources, list):
            raise TypeError("Expected argument 'resources' to be a list")
        pulumi.set(__self__, "resources", resources)
        if total_count and not isinstance(total_count, int):
            raise TypeError("Expected argument 'total_count' to be a int")
        pulumi.set(__self__, "total_count", total_count)
        if zone_ids and not isinstance(zone_ids, list):
            raise TypeError("Expected argument 'zone_ids' to be a list")
        pulumi.set(__self__, "zone_ids", zone_ids)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="outputFile")
    def output_file(self) -> Optional[str]:
        return pulumi.get(self, "output_file")

    @property
    @pulumi.getter(name="resourceTypes")
    def resource_types(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "resource_types")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.SupportResourceTypesResourceResult']:
        """
        The collection of query.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter(name="totalCount")
    def total_count(self) -> int:
        """
        The total count of query.
        """
        return pulumi.get(self, "total_count")

    @property
    @pulumi.getter(name="zoneIds")
    def zone_ids(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "zone_ids")


class AwaitableSupportResourceTypesResult(SupportResourceTypesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return SupportResourceTypesResult(
            id=self.id,
            output_file=self.output_file,
            resource_types=self.resource_types,
            resources=self.resources,
            total_count=self.total_count,
            zone_ids=self.zone_ids)


def support_resource_types(output_file: Optional[str] = None,
                           resource_types: Optional[Sequence[str]] = None,
                           zone_ids: Optional[Sequence[str]] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableSupportResourceTypesResult:
    """
    Use this data source to query detailed information of vke support resource types
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vke.support_resource_types()
    ```


    :param str output_file: File name where to save data source results.
    :param Sequence[str] resource_types: A list of resource types. Support Ecs or Zone.
    :param Sequence[str] zone_ids: A list of zone ids. If no parameter value, all available regions is returned.
    """
    __args__ = dict()
    __args__['outputFile'] = output_file
    __args__['resourceTypes'] = resource_types
    __args__['zoneIds'] = zone_ids
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('volcengine:vke/supportResourceTypes:SupportResourceTypes', __args__, opts=opts, typ=SupportResourceTypesResult).value

    return AwaitableSupportResourceTypesResult(
        id=pulumi.get(__ret__, 'id'),
        output_file=pulumi.get(__ret__, 'output_file'),
        resource_types=pulumi.get(__ret__, 'resource_types'),
        resources=pulumi.get(__ret__, 'resources'),
        total_count=pulumi.get(__ret__, 'total_count'),
        zone_ids=pulumi.get(__ret__, 'zone_ids'))


@_utilities.lift_output_func(support_resource_types)
def support_resource_types_output(output_file: Optional[pulumi.Input[Optional[str]]] = None,
                                  resource_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                  zone_ids: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                  opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[SupportResourceTypesResult]:
    """
    Use this data source to query detailed information of vke support resource types
    ## Example Usage

    ```python
    import pulumi
    import pulumi_volcengine as volcengine

    default = volcengine.vke.support_resource_types()
    ```


    :param str output_file: File name where to save data source results.
    :param Sequence[str] resource_types: A list of resource types. Support Ecs or Zone.
    :param Sequence[str] zone_ids: A list of zone ids. If no parameter value, all available regions is returned.
    """
    ...
