# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['HaVipArgs', 'HaVip']

@pulumi.input_type
class HaVipArgs:
    def __init__(__self__, *,
                 subnet_id: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None,
                 ha_vip_name: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a HaVip resource.
        :param pulumi.Input[str] subnet_id: The subnet id of the Ha Vip.
        :param pulumi.Input[str] description: The description of the Ha Vip.
        :param pulumi.Input[str] ha_vip_name: The name of the Ha Vip.
        :param pulumi.Input[str] ip_address: The ip address of the Ha Vip.
        """
        pulumi.set(__self__, "subnet_id", subnet_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ha_vip_name is not None:
            pulumi.set(__self__, "ha_vip_name", ha_vip_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Input[str]:
        """
        The subnet id of the Ha Vip.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Ha Vip.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="haVipName")
    def ha_vip_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Ha Vip.
        """
        return pulumi.get(self, "ha_vip_name")

    @ha_vip_name.setter
    def ha_vip_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vip_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of the Ha Vip.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)


@pulumi.input_type
class _HaVipState:
    def __init__(__self__, *,
                 associated_eip_address: Optional[pulumi.Input[str]] = None,
                 associated_eip_id: Optional[pulumi.Input[str]] = None,
                 associated_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 associated_instance_type: Optional[pulumi.Input[str]] = None,
                 created_at: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ha_vip_name: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 master_instance_id: Optional[pulumi.Input[str]] = None,
                 project_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 updated_at: Optional[pulumi.Input[str]] = None,
                 vpc_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering HaVip resources.
        :param pulumi.Input[str] associated_eip_address: The associated eip address of the Ha Vip.
        :param pulumi.Input[str] associated_eip_id: The associated eip id of the Ha Vip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] associated_instance_ids: The associated instance ids of the Ha Vip.
        :param pulumi.Input[str] associated_instance_type: The associated instance type of the Ha Vip.
        :param pulumi.Input[str] created_at: The create time of the Ha Vip.
        :param pulumi.Input[str] description: The description of the Ha Vip.
        :param pulumi.Input[str] ha_vip_name: The name of the Ha Vip.
        :param pulumi.Input[str] ip_address: The ip address of the Ha Vip.
        :param pulumi.Input[str] master_instance_id: The master instance id of the Ha Vip.
        :param pulumi.Input[str] project_name: The project name of the Ha Vip.
        :param pulumi.Input[str] status: The status of the Ha Vip.
        :param pulumi.Input[str] subnet_id: The subnet id of the Ha Vip.
        :param pulumi.Input[str] updated_at: The update time of the Ha Vip.
        :param pulumi.Input[str] vpc_id: The vpc id of the Ha Vip.
        """
        if associated_eip_address is not None:
            pulumi.set(__self__, "associated_eip_address", associated_eip_address)
        if associated_eip_id is not None:
            pulumi.set(__self__, "associated_eip_id", associated_eip_id)
        if associated_instance_ids is not None:
            pulumi.set(__self__, "associated_instance_ids", associated_instance_ids)
        if associated_instance_type is not None:
            pulumi.set(__self__, "associated_instance_type", associated_instance_type)
        if created_at is not None:
            pulumi.set(__self__, "created_at", created_at)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if ha_vip_name is not None:
            pulumi.set(__self__, "ha_vip_name", ha_vip_name)
        if ip_address is not None:
            pulumi.set(__self__, "ip_address", ip_address)
        if master_instance_id is not None:
            pulumi.set(__self__, "master_instance_id", master_instance_id)
        if project_name is not None:
            pulumi.set(__self__, "project_name", project_name)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if updated_at is not None:
            pulumi.set(__self__, "updated_at", updated_at)
        if vpc_id is not None:
            pulumi.set(__self__, "vpc_id", vpc_id)

    @property
    @pulumi.getter(name="associatedEipAddress")
    def associated_eip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The associated eip address of the Ha Vip.
        """
        return pulumi.get(self, "associated_eip_address")

    @associated_eip_address.setter
    def associated_eip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "associated_eip_address", value)

    @property
    @pulumi.getter(name="associatedEipId")
    def associated_eip_id(self) -> Optional[pulumi.Input[str]]:
        """
        The associated eip id of the Ha Vip.
        """
        return pulumi.get(self, "associated_eip_id")

    @associated_eip_id.setter
    def associated_eip_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "associated_eip_id", value)

    @property
    @pulumi.getter(name="associatedInstanceIds")
    def associated_instance_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The associated instance ids of the Ha Vip.
        """
        return pulumi.get(self, "associated_instance_ids")

    @associated_instance_ids.setter
    def associated_instance_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "associated_instance_ids", value)

    @property
    @pulumi.getter(name="associatedInstanceType")
    def associated_instance_type(self) -> Optional[pulumi.Input[str]]:
        """
        The associated instance type of the Ha Vip.
        """
        return pulumi.get(self, "associated_instance_type")

    @associated_instance_type.setter
    def associated_instance_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "associated_instance_type", value)

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> Optional[pulumi.Input[str]]:
        """
        The create time of the Ha Vip.
        """
        return pulumi.get(self, "created_at")

    @created_at.setter
    def created_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_at", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of the Ha Vip.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="haVipName")
    def ha_vip_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Ha Vip.
        """
        return pulumi.get(self, "ha_vip_name")

    @ha_vip_name.setter
    def ha_vip_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ha_vip_name", value)

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> Optional[pulumi.Input[str]]:
        """
        The ip address of the Ha Vip.
        """
        return pulumi.get(self, "ip_address")

    @ip_address.setter
    def ip_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ip_address", value)

    @property
    @pulumi.getter(name="masterInstanceId")
    def master_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        The master instance id of the Ha Vip.
        """
        return pulumi.get(self, "master_instance_id")

    @master_instance_id.setter
    def master_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "master_instance_id", value)

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> Optional[pulumi.Input[str]]:
        """
        The project name of the Ha Vip.
        """
        return pulumi.get(self, "project_name")

    @project_name.setter
    def project_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        The status of the Ha Vip.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The subnet id of the Ha Vip.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> Optional[pulumi.Input[str]]:
        """
        The update time of the Ha Vip.
        """
        return pulumi.get(self, "updated_at")

    @updated_at.setter
    def updated_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "updated_at", value)

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> Optional[pulumi.Input[str]]:
        """
        The vpc id of the Ha Vip.
        """
        return pulumi.get(self, "vpc_id")

    @vpc_id.setter
    def vpc_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vpc_id", value)


class HaVip(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ha_vip_name: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        Provides a resource to manage ha vip
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_ha_vip = volcengine.vpc.HaVip("fooHaVip",
            ha_vip_name="acc-test-ha-vip",
            description="acc-test",
            subnet_id=foo_subnet.id)
        #  ip_address = "172.16.0.5"
        foo_address = volcengine.eip.Address("fooAddress", billing_type="PostPaidByTraffic")
        foo_associate = volcengine.eip.Associate("fooAssociate",
            allocation_id=foo_address.id,
            instance_id=foo_ha_vip.id,
            instance_type="HaVip")
        ```

        ## Import

        HaVip can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/haVip:HaVip default havip-2byzv8icq1b7k2dx0eegb****
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] description: The description of the Ha Vip.
        :param pulumi.Input[str] ha_vip_name: The name of the Ha Vip.
        :param pulumi.Input[str] ip_address: The ip address of the Ha Vip.
        :param pulumi.Input[str] subnet_id: The subnet id of the Ha Vip.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: HaVipArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Provides a resource to manage ha vip
        ## Example Usage

        ```python
        import pulumi
        import pulumi_volcengine as volcengine

        foo_zones = volcengine.ecs.zones()
        foo_vpc = volcengine.vpc.Vpc("fooVpc",
            vpc_name="acc-test-vpc",
            cidr_block="172.16.0.0/16")
        foo_subnet = volcengine.vpc.Subnet("fooSubnet",
            subnet_name="acc-test-subnet",
            cidr_block="172.16.0.0/24",
            zone_id=foo_zones.zones[0].id,
            vpc_id=foo_vpc.id)
        foo_ha_vip = volcengine.vpc.HaVip("fooHaVip",
            ha_vip_name="acc-test-ha-vip",
            description="acc-test",
            subnet_id=foo_subnet.id)
        #  ip_address = "172.16.0.5"
        foo_address = volcengine.eip.Address("fooAddress", billing_type="PostPaidByTraffic")
        foo_associate = volcengine.eip.Associate("fooAssociate",
            allocation_id=foo_address.id,
            instance_id=foo_ha_vip.id,
            instance_type="HaVip")
        ```

        ## Import

        HaVip can be imported using the id, e.g.

        ```sh
         $ pulumi import volcengine:vpc/haVip:HaVip default havip-2byzv8icq1b7k2dx0eegb****
        ```

        :param str resource_name: The name of the resource.
        :param HaVipArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(HaVipArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 ha_vip_name: Optional[pulumi.Input[str]] = None,
                 ip_address: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = HaVipArgs.__new__(HaVipArgs)

            __props__.__dict__["description"] = description
            __props__.__dict__["ha_vip_name"] = ha_vip_name
            __props__.__dict__["ip_address"] = ip_address
            if subnet_id is None and not opts.urn:
                raise TypeError("Missing required property 'subnet_id'")
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["associated_eip_address"] = None
            __props__.__dict__["associated_eip_id"] = None
            __props__.__dict__["associated_instance_ids"] = None
            __props__.__dict__["associated_instance_type"] = None
            __props__.__dict__["created_at"] = None
            __props__.__dict__["master_instance_id"] = None
            __props__.__dict__["project_name"] = None
            __props__.__dict__["status"] = None
            __props__.__dict__["updated_at"] = None
            __props__.__dict__["vpc_id"] = None
        super(HaVip, __self__).__init__(
            'volcengine:vpc/haVip:HaVip',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            associated_eip_address: Optional[pulumi.Input[str]] = None,
            associated_eip_id: Optional[pulumi.Input[str]] = None,
            associated_instance_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            associated_instance_type: Optional[pulumi.Input[str]] = None,
            created_at: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            ha_vip_name: Optional[pulumi.Input[str]] = None,
            ip_address: Optional[pulumi.Input[str]] = None,
            master_instance_id: Optional[pulumi.Input[str]] = None,
            project_name: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            updated_at: Optional[pulumi.Input[str]] = None,
            vpc_id: Optional[pulumi.Input[str]] = None) -> 'HaVip':
        """
        Get an existing HaVip resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] associated_eip_address: The associated eip address of the Ha Vip.
        :param pulumi.Input[str] associated_eip_id: The associated eip id of the Ha Vip.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] associated_instance_ids: The associated instance ids of the Ha Vip.
        :param pulumi.Input[str] associated_instance_type: The associated instance type of the Ha Vip.
        :param pulumi.Input[str] created_at: The create time of the Ha Vip.
        :param pulumi.Input[str] description: The description of the Ha Vip.
        :param pulumi.Input[str] ha_vip_name: The name of the Ha Vip.
        :param pulumi.Input[str] ip_address: The ip address of the Ha Vip.
        :param pulumi.Input[str] master_instance_id: The master instance id of the Ha Vip.
        :param pulumi.Input[str] project_name: The project name of the Ha Vip.
        :param pulumi.Input[str] status: The status of the Ha Vip.
        :param pulumi.Input[str] subnet_id: The subnet id of the Ha Vip.
        :param pulumi.Input[str] updated_at: The update time of the Ha Vip.
        :param pulumi.Input[str] vpc_id: The vpc id of the Ha Vip.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _HaVipState.__new__(_HaVipState)

        __props__.__dict__["associated_eip_address"] = associated_eip_address
        __props__.__dict__["associated_eip_id"] = associated_eip_id
        __props__.__dict__["associated_instance_ids"] = associated_instance_ids
        __props__.__dict__["associated_instance_type"] = associated_instance_type
        __props__.__dict__["created_at"] = created_at
        __props__.__dict__["description"] = description
        __props__.__dict__["ha_vip_name"] = ha_vip_name
        __props__.__dict__["ip_address"] = ip_address
        __props__.__dict__["master_instance_id"] = master_instance_id
        __props__.__dict__["project_name"] = project_name
        __props__.__dict__["status"] = status
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["updated_at"] = updated_at
        __props__.__dict__["vpc_id"] = vpc_id
        return HaVip(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="associatedEipAddress")
    def associated_eip_address(self) -> pulumi.Output[str]:
        """
        The associated eip address of the Ha Vip.
        """
        return pulumi.get(self, "associated_eip_address")

    @property
    @pulumi.getter(name="associatedEipId")
    def associated_eip_id(self) -> pulumi.Output[str]:
        """
        The associated eip id of the Ha Vip.
        """
        return pulumi.get(self, "associated_eip_id")

    @property
    @pulumi.getter(name="associatedInstanceIds")
    def associated_instance_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The associated instance ids of the Ha Vip.
        """
        return pulumi.get(self, "associated_instance_ids")

    @property
    @pulumi.getter(name="associatedInstanceType")
    def associated_instance_type(self) -> pulumi.Output[str]:
        """
        The associated instance type of the Ha Vip.
        """
        return pulumi.get(self, "associated_instance_type")

    @property
    @pulumi.getter(name="createdAt")
    def created_at(self) -> pulumi.Output[str]:
        """
        The create time of the Ha Vip.
        """
        return pulumi.get(self, "created_at")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        The description of the Ha Vip.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="haVipName")
    def ha_vip_name(self) -> pulumi.Output[str]:
        """
        The name of the Ha Vip.
        """
        return pulumi.get(self, "ha_vip_name")

    @property
    @pulumi.getter(name="ipAddress")
    def ip_address(self) -> pulumi.Output[str]:
        """
        The ip address of the Ha Vip.
        """
        return pulumi.get(self, "ip_address")

    @property
    @pulumi.getter(name="masterInstanceId")
    def master_instance_id(self) -> pulumi.Output[str]:
        """
        The master instance id of the Ha Vip.
        """
        return pulumi.get(self, "master_instance_id")

    @property
    @pulumi.getter(name="projectName")
    def project_name(self) -> pulumi.Output[str]:
        """
        The project name of the Ha Vip.
        """
        return pulumi.get(self, "project_name")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        The status of the Ha Vip.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The subnet id of the Ha Vip.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="updatedAt")
    def updated_at(self) -> pulumi.Output[str]:
        """
        The update time of the Ha Vip.
        """
        return pulumi.get(self, "updated_at")

    @property
    @pulumi.getter(name="vpcId")
    def vpc_id(self) -> pulumi.Output[str]:
        """
        The vpc id of the Ha Vip.
        """
        return pulumi.get(self, "vpc_id")

